
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .secure_value_type import TypeSecureValueType
    from ...gadgets.byteutils import Reader


class SecureValueErrorData(TLObject, family='TypeSecureValueError'):
    """
    Represents an issue in one of the data fields that was provided by the user. The error is considered resolved when the field's value changes.
    """

    _id = 0XE8A40BD9
    _group_id = 0X96147C5D

    def __init__(
        self,
        type: 'TypeSecureValueType',
        data_hash: bytes,
        field: str,
        text: str
    ):

        """
        Represents an issue in one of the data fields that was provided by the user. The error is considered resolved when the field's value changes.

        Args:
            type ('TypeSecureValueType'): The section of the user's Telegram Passport which has the error, one of [secureValueTypePersonalDetails](https://core.telegram.org/constructor/secureValueTypePersonalDetails), [secureValueTypePassport](https://core.telegram.org/constructor/secureValueTypePassport), [secureValueTypeDriverLicense](https://core.telegram.org/constructor/secureValueTypeDriverLicense), [secureValueTypeIdentityCard](https://core.telegram.org/constructor/secureValueTypeIdentityCard), [secureValueTypeInternalPassport](https://core.telegram.org/constructor/secureValueTypeInternalPassport), [secureValueTypeAddress](https://core.telegram.org/constructor/secureValueTypeAddress)
            data_hash (bytes): Data hash
            field (str): Name of the data field which has the error
            text (str): Error message
        """

        self.type = type
        self.data_hash = data_hash
        self.field = field
        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd9\x0b\xa4\xe8' if boxed else b'') as writer:
            writer.object(
                self.type,
                group_id=0X24ADF799
            )
            writer.bytes(self.data_hash)
            writer.string(self.field)
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.object(
            group_id=0X24ADF799
        )

        data_hash_ = reader.bytes()
        field_ = reader.string()
        text_ = reader.string()

        return cls(
            type=type_,
            data_hash=data_hash_,
            field=field_,
            text=text_
        )

class SecureValueErrorFrontSide(TLObject, family='TypeSecureValueError'):
    """
    Represents an issue with the front side of a document. The error is considered resolved when the file with the front side of the document changes.
    """

    _id = 0XBE3DFA
    _group_id = 0X96147C5D

    def __init__(
        self,
        type: 'TypeSecureValueType',
        file_hash: bytes,
        text: str
    ):

        """
        Represents an issue with the front side of a document. The error is considered resolved when the file with the front side of the document changes.

        Args:
            type ('TypeSecureValueType'): One of [secureValueTypePassport](https://core.telegram.org/constructor/secureValueTypePassport), [secureValueTypeDriverLicense](https://core.telegram.org/constructor/secureValueTypeDriverLicense), [secureValueTypeIdentityCard](https://core.telegram.org/constructor/secureValueTypeIdentityCard), [secureValueTypeInternalPassport](https://core.telegram.org/constructor/secureValueTypeInternalPassport)
            file_hash (bytes): File hash
            text (str): Error message
        """

        self.type = type
        self.file_hash = file_hash
        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfa=\xbe\x00' if boxed else b'') as writer:
            writer.object(
                self.type,
                group_id=0X24ADF799
            )
            writer.bytes(self.file_hash)
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.object(
            group_id=0X24ADF799
        )

        file_hash_ = reader.bytes()
        text_ = reader.string()

        return cls(
            type=type_,
            file_hash=file_hash_,
            text=text_
        )

class SecureValueErrorReverseSide(TLObject, family='TypeSecureValueError'):
    """
    Represents an issue with the reverse side of a document. The error is considered resolved when the file with reverse side of the document changes.
    """

    _id = 0X868A2AA5
    _group_id = 0X96147C5D

    def __init__(
        self,
        type: 'TypeSecureValueType',
        file_hash: bytes,
        text: str
    ):

        """
        Represents an issue with the reverse side of a document. The error is considered resolved when the file with reverse side of the document changes.

        Args:
            type ('TypeSecureValueType'): One of [secureValueTypeDriverLicense](https://core.telegram.org/constructor/secureValueTypeDriverLicense), [secureValueTypeIdentityCard](https://core.telegram.org/constructor/secureValueTypeIdentityCard)
            file_hash (bytes): File hash
            text (str): Error message
        """

        self.type = type
        self.file_hash = file_hash
        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa5*\x8a\x86' if boxed else b'') as writer:
            writer.object(
                self.type,
                group_id=0X24ADF799
            )
            writer.bytes(self.file_hash)
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.object(
            group_id=0X24ADF799
        )

        file_hash_ = reader.bytes()
        text_ = reader.string()

        return cls(
            type=type_,
            file_hash=file_hash_,
            text=text_
        )

class SecureValueErrorSelfie(TLObject, family='TypeSecureValueError'):
    """
    Represents an issue with the selfie with a document. The error is considered resolved when the file with the selfie changes.
    """

    _id = 0XE537CED6
    _group_id = 0X96147C5D

    def __init__(
        self,
        type: 'TypeSecureValueType',
        file_hash: bytes,
        text: str
    ):

        """
        Represents an issue with the selfie with a document. The error is considered resolved when the file with the selfie changes.

        Args:
            type ('TypeSecureValueType'): One of [secureValueTypePassport](https://core.telegram.org/constructor/secureValueTypePassport), [secureValueTypeDriverLicense](https://core.telegram.org/constructor/secureValueTypeDriverLicense), [secureValueTypeIdentityCard](https://core.telegram.org/constructor/secureValueTypeIdentityCard), [secureValueTypeInternalPassport](https://core.telegram.org/constructor/secureValueTypeInternalPassport)
            file_hash (bytes): File hash
            text (str): Error message
        """

        self.type = type
        self.file_hash = file_hash
        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd6\xce7\xe5' if boxed else b'') as writer:
            writer.object(
                self.type,
                group_id=0X24ADF799
            )
            writer.bytes(self.file_hash)
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.object(
            group_id=0X24ADF799
        )

        file_hash_ = reader.bytes()
        text_ = reader.string()

        return cls(
            type=type_,
            file_hash=file_hash_,
            text=text_
        )

class SecureValueErrorFile(TLObject, family='TypeSecureValueError'):
    """
    Represents an issue with a document scan. The error is considered resolved when the file with the document scan changes.
    """

    _id = 0X7A700873
    _group_id = 0X96147C5D

    def __init__(
        self,
        type: 'TypeSecureValueType',
        file_hash: bytes,
        text: str
    ):

        """
        Represents an issue with a document scan. The error is considered resolved when the file with the document scan changes.

        Args:
            type ('TypeSecureValueType'): One of [secureValueTypeUtilityBill](https://core.telegram.org/constructor/secureValueTypeUtilityBill), [secureValueTypeBankStatement](https://core.telegram.org/constructor/secureValueTypeBankStatement), [secureValueTypeRentalAgreement](https://core.telegram.org/constructor/secureValueTypeRentalAgreement), [secureValueTypePassportRegistration](https://core.telegram.org/constructor/secureValueTypePassportRegistration), [secureValueTypeTemporaryRegistration](https://core.telegram.org/constructor/secureValueTypeTemporaryRegistration)
            file_hash (bytes): File hash
            text (str): Error message
        """

        self.type = type
        self.file_hash = file_hash
        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b's\x08pz' if boxed else b'') as writer:
            writer.object(
                self.type,
                group_id=0X24ADF799
            )
            writer.bytes(self.file_hash)
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.object(
            group_id=0X24ADF799
        )

        file_hash_ = reader.bytes()
        text_ = reader.string()

        return cls(
            type=type_,
            file_hash=file_hash_,
            text=text_
        )

class SecureValueErrorFiles(TLObject, family='TypeSecureValueError'):
    """
    Represents an issue with a list of scans. The error is considered resolved when the list of files containing the scans changes.
    """

    _id = 0X666220E9
    _group_id = 0X96147C5D

    def __init__(
        self,
        type: 'TypeSecureValueType',
        file_hash: List[bytes],
        text: str
    ):

        """
        Represents an issue with a list of scans. The error is considered resolved when the list of files containing the scans changes.

        Args:
            type ('TypeSecureValueType'): One of [secureValueTypeUtilityBill](https://core.telegram.org/constructor/secureValueTypeUtilityBill), [secureValueTypeBankStatement](https://core.telegram.org/constructor/secureValueTypeBankStatement), [secureValueTypeRentalAgreement](https://core.telegram.org/constructor/secureValueTypeRentalAgreement), [secureValueTypePassportRegistration](https://core.telegram.org/constructor/secureValueTypePassportRegistration), [secureValueTypeTemporaryRegistration](https://core.telegram.org/constructor/secureValueTypeTemporaryRegistration)
            file_hash (List[bytes]): File hash
            text (str): Error message
        """

        self.type = type
        self.file_hash = file_hash
        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xe9 bf' if boxed else b'') as writer:
            writer.object(
                self.type,
                group_id=0X24ADF799
            )
            writer.vector(
                self.file_hash,
                writer.bytes
            )
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.object(
            group_id=0X24ADF799
        )

        file_hash_ = reader.vector(
            reader.bytes
        )

        text_ = reader.string()

        return cls(
            type=type_,
            file_hash=file_hash_,
            text=text_
        )

class SecureValueError(TLObject, family='TypeSecureValueError'):
    """
    Secure value error
    """

    _id = 0X869D758F
    _group_id = 0X96147C5D

    def __init__(
        self,
        type: 'TypeSecureValueType',
        hash: bytes,
        text: str
    ):

        """
        Secure value error

        Args:
            type ('TypeSecureValueType'): Type of element which has the issue
            hash (bytes): Hash
            text (str): Error message
        """

        self.type = type
        self.hash = hash
        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8fu\x9d\x86' if boxed else b'') as writer:
            writer.object(
                self.type,
                group_id=0X24ADF799
            )
            writer.bytes(self.hash)
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.object(
            group_id=0X24ADF799
        )

        hash_ = reader.bytes()
        text_ = reader.string()

        return cls(
            type=type_,
            hash=hash_,
            text=text_
        )

class SecureValueErrorTranslationFile(TLObject, family='TypeSecureValueError'):
    """
    Represents an issue with one of the files that constitute the translation of a document. The error is considered resolved when the file changes.
    """

    _id = 0XA1144770
    _group_id = 0X96147C5D

    def __init__(
        self,
        type: 'TypeSecureValueType',
        file_hash: bytes,
        text: str
    ):

        """
        Represents an issue with one of the files that constitute the translation of a document. The error is considered resolved when the file changes.

        Args:
            type ('TypeSecureValueType'): One of [secureValueTypePersonalDetails](https://core.telegram.org/constructor/secureValueTypePersonalDetails), [secureValueTypePassport](https://core.telegram.org/constructor/secureValueTypePassport), [secureValueTypeDriverLicense](https://core.telegram.org/constructor/secureValueTypeDriverLicense), [secureValueTypeIdentityCard](https://core.telegram.org/constructor/secureValueTypeIdentityCard), [secureValueTypeInternalPassport](https://core.telegram.org/constructor/secureValueTypeInternalPassport), [secureValueTypeUtilityBill](https://core.telegram.org/constructor/secureValueTypeUtilityBill), [secureValueTypeBankStatement](https://core.telegram.org/constructor/secureValueTypeBankStatement), [secureValueTypeRentalAgreement](https://core.telegram.org/constructor/secureValueTypeRentalAgreement), [secureValueTypePassportRegistration](https://core.telegram.org/constructor/secureValueTypePassportRegistration), [secureValueTypeTemporaryRegistration](https://core.telegram.org/constructor/secureValueTypeTemporaryRegistration)
            file_hash (bytes): File hash
            text (str): Error message
        """

        self.type = type
        self.file_hash = file_hash
        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'pG\x14\xa1' if boxed else b'') as writer:
            writer.object(
                self.type,
                group_id=0X24ADF799
            )
            writer.bytes(self.file_hash)
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.object(
            group_id=0X24ADF799
        )

        file_hash_ = reader.bytes()
        text_ = reader.string()

        return cls(
            type=type_,
            file_hash=file_hash_,
            text=text_
        )

class SecureValueErrorTranslationFiles(TLObject, family='TypeSecureValueError'):
    """
    Represents an issue with the translated version of a document. The error is considered resolved when a file with the document translation changes.
    """

    _id = 0X34636DD8
    _group_id = 0X96147C5D

    def __init__(
        self,
        type: 'TypeSecureValueType',
        file_hash: List[bytes],
        text: str
    ):

        """
        Represents an issue with the translated version of a document. The error is considered resolved when a file with the document translation changes.

        Args:
            type ('TypeSecureValueType'): One of [secureValueTypePersonalDetails](https://core.telegram.org/constructor/secureValueTypePersonalDetails), [secureValueTypePassport](https://core.telegram.org/constructor/secureValueTypePassport), [secureValueTypeDriverLicense](https://core.telegram.org/constructor/secureValueTypeDriverLicense), [secureValueTypeIdentityCard](https://core.telegram.org/constructor/secureValueTypeIdentityCard), [secureValueTypeInternalPassport](https://core.telegram.org/constructor/secureValueTypeInternalPassport), [secureValueTypeUtilityBill](https://core.telegram.org/constructor/secureValueTypeUtilityBill), [secureValueTypeBankStatement](https://core.telegram.org/constructor/secureValueTypeBankStatement), [secureValueTypeRentalAgreement](https://core.telegram.org/constructor/secureValueTypeRentalAgreement), [secureValueTypePassportRegistration](https://core.telegram.org/constructor/secureValueTypePassportRegistration), [secureValueTypeTemporaryRegistration](https://core.telegram.org/constructor/secureValueTypeTemporaryRegistration)
            file_hash (List[bytes]): Hash
            text (str): Error message
        """

        self.type = type
        self.file_hash = file_hash
        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd8mc4' if boxed else b'') as writer:
            writer.object(
                self.type,
                group_id=0X24ADF799
            )
            writer.vector(
                self.file_hash,
                writer.bytes
            )
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        type_ = reader.object(
            group_id=0X24ADF799
        )

        file_hash_ = reader.vector(
            reader.bytes
        )

        text_ = reader.string()

        return cls(
            type=type_,
            file_hash=file_hash_,
            text=text_
        )

TypeSecureValueError = Union[
    SecureValueErrorData,
    SecureValueErrorFrontSide,
    SecureValueErrorReverseSide,
    SecureValueErrorSelfie,
    SecureValueErrorFile,
    SecureValueErrorFiles,
    SecureValueError,
    SecureValueErrorTranslationFile,
    SecureValueErrorTranslationFiles
]