
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class Status(TLObject, family='TypeSmsjobsStatus'):
    """
    Status
    """

    _id = 0X2AEE9191
    _group_id = 0X5E8DD84A

    def __init__(
        self,
        recent_sent: int,
        recent_since: int,
        recent_remains: int,
        total_sent: int,
        total_since: int,
        terms_url: str,
        allow_international: bool = False,
        last_gift_slug: Optional[str] = None
    ):

        """
        Status

        Args:
            recent_sent (int): Recently sent
            recent_since (int): Since
            recent_remains (int): Remaining
            total_sent (int): Total sent
            total_since (int): Total since
            terms_url (str): Terms of service URL
            allow_international (bool, optional): Allow international numbers
            last_gift_slug (Optional[str], optional): Last gift deep link
        """

        self.recent_sent = recent_sent
        self.recent_since = recent_since
        self.recent_remains = recent_remains
        self.total_sent = total_sent
        self.total_since = total_since
        self.terms_url = terms_url
        self.allow_international = allow_international
        self.last_gift_slug = last_gift_slug

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x91\x91\xee*' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.allow_international, 0)
                writer.int(self.recent_sent)
                writer.int(self.recent_since)
                writer.int(self.recent_remains)
                writer.int(self.total_sent)
                writer.int(self.total_since)

                if flags(self.last_gift_slug, 1):
                    writer.string(self.last_gift_slug)
                writer.string(self.terms_url)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        recent_sent_ = reader.int()
        recent_since_ = reader.int()
        recent_remains_ = reader.int()
        total_sent_ = reader.int()
        total_since_ = reader.int()
        last_gift_slug_ = (
            reader.string()
            if flags(1) else None
        )

        terms_url_ = reader.string()

        return cls(
            recent_sent=recent_sent_,
            recent_since=recent_since_,
            recent_remains=recent_remains_,
            total_sent=total_sent_,
            total_since=total_since_,
            terms_url=terms_url_,
            allow_international=flags(0),
            last_gift_slug=last_gift_slug_
        )

TypeSmsjobsStatus = Status