
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .document import TypeDocument
    from .stars_amount import TypeStarsAmount
    from ...gadgets.byteutils import Reader
    from .star_gift_attribute import TypeStarGiftAttribute


class StarGift(TLObject, family='TypeStarGift'):
    """
    Represents a [star gift, see here](https://core.telegram.org/api/gifts) for more info.
    """

    _id = 0X80AC53C3
    _group_id = 0X87440C7B

    def __init__(
        self,
        id: int,
        sticker: 'TypeDocument',
        stars: int,
        convert_stars: int,
        limited: bool = False,
        sold_out: bool = False,
        birthday: bool = False,
        require_premium: bool = False,
        limited_per_user: bool = False,
        availability_remains: Optional[int] = None,
        availability_total: Optional[int] = None,
        availability_resale: Optional[int] = None,
        first_sale_date: Optional[int] = None,
        last_sale_date: Optional[int] = None,
        upgrade_stars: Optional[int] = None,
        resell_min_stars: Optional[int] = None,
        title: Optional[str] = None,
        released_by: Optional['TypePeer'] = None,
        per_user_total: Optional[int] = None,
        per_user_remains: Optional[int] = None,
        locked_until_date: Optional[int] = None
    ):

        """
        Represents a [star gift, see here](https://core.telegram.org/api/gifts) for more info.

        Args:
            id (int): Identifier of the gift
            sticker ('TypeDocument'): [Sticker](https://core.telegram.org/api/stickers) that represents the gift.
            stars (int): Price of the gift in [Telegram Stars](https://core.telegram.org/api/stars).
            convert_stars (int): The receiver of this gift may convert it to this many Telegram Stars, instead of displaying it on their profile page. convert_stars will be equal to stars only if the gift was bought using recently bought Telegram Stars, otherwise it will be less than stars.
            limited (bool, optional): Whether this is a limited-supply gift.
            sold_out (bool, optional): Whether this gift sold out and cannot be bought anymore.
            birthday (bool, optional): Whether this is a birthday-themed gift
            require_premium (bool, optional): ...
            limited_per_user (bool, optional): ...
            availability_remains (Optional[int], optional): For limited-supply gifts: the remaining number of gifts that may be bought.
            availability_total (Optional[int], optional): For limited-supply gifts: the total number of gifts that was available in the initial supply.
            availability_resale (Optional[int], optional): ...
            first_sale_date (Optional[int], optional): For sold out gifts only: when was the gift first bought.
            last_sale_date (Optional[int], optional): For sold out gifts only: when was the gift last bought.
            upgrade_stars (Optional[int], optional): ...
            resell_min_stars (Optional[int], optional): ...
            title (Optional[str], optional): ...
            released_by (Optional['TypePeer'], optional): ...
            per_user_total (Optional[int], optional): ...
            per_user_remains (Optional[int], optional): ...
            locked_until_date (Optional[int], optional): ...
        """

        self.id = id
        self.sticker = sticker
        self.stars = stars
        self.convert_stars = convert_stars
        self.limited = limited
        self.sold_out = sold_out
        self.birthday = birthday
        self.require_premium = require_premium
        self.limited_per_user = limited_per_user
        self.availability_remains = availability_remains
        self.availability_total = availability_total
        self.availability_resale = availability_resale
        self.first_sale_date = first_sale_date
        self.last_sale_date = last_sale_date
        self.upgrade_stars = upgrade_stars
        self.resell_min_stars = resell_min_stars
        self.title = title
        self.released_by = released_by
        self.per_user_total = per_user_total
        self.per_user_remains = per_user_remains
        self.locked_until_date = locked_until_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc3S\xac\x80' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.limited, 0)
                flags(self.sold_out, 1)
                flags(self.birthday, 2)
                flags(self.require_premium, 7)
                flags(self.limited_per_user, 8)
                writer.long(self.id)
                writer.object(
                    self.sticker,
                    group_id=0X6547BD50
                )
                writer.long(self.stars)

                if flags(self.availability_remains, 0):
                    writer.int(self.availability_remains)

                if flags(self.availability_total, 0):
                    writer.int(self.availability_total)

                if flags(self.availability_resale, 4):
                    writer.long(self.availability_resale)
                writer.long(self.convert_stars)

                if flags(self.first_sale_date, 1):
                    writer.int(self.first_sale_date)

                if flags(self.last_sale_date, 1):
                    writer.int(self.last_sale_date)

                if flags(self.upgrade_stars, 3):
                    writer.long(self.upgrade_stars)

                if flags(self.resell_min_stars, 4):
                    writer.long(self.resell_min_stars)

                if flags(self.title, 5):
                    writer.string(self.title)

                if flags(self.released_by, 6):
                    writer.object(
                        self.released_by,
                        group_id=0XB4DECBCA
                    )

                if flags(self.per_user_total, 8):
                    writer.int(self.per_user_total)

                if flags(self.per_user_remains, 8):
                    writer.int(self.per_user_remains)

                if flags(self.locked_until_date, 9):
                    writer.int(self.locked_until_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        sticker_ = reader.object(
            group_id=0X6547BD50
        )

        stars_ = reader.long()
        availability_remains_ = (
            reader.int()
            if flags(0) else None
        )

        availability_total_ = (
            reader.int()
            if flags(0) else None
        )

        availability_resale_ = (
            reader.long()
            if flags(4) else None
        )

        convert_stars_ = reader.long()
        first_sale_date_ = (
            reader.int()
            if flags(1) else None
        )

        last_sale_date_ = (
            reader.int()
            if flags(1) else None
        )

        upgrade_stars_ = (
            reader.long()
            if flags(3) else None
        )

        resell_min_stars_ = (
            reader.long()
            if flags(4) else None
        )

        title_ = (
            reader.string()
            if flags(5) else None
        )

        released_by_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(6) else None
        )

        per_user_total_ = (
            reader.int()
            if flags(8) else None
        )

        per_user_remains_ = (
            reader.int()
            if flags(8) else None
        )

        locked_until_date_ = (
            reader.int()
            if flags(9) else None
        )

        return cls(
            id=id_,
            sticker=sticker_,
            stars=stars_,
            convert_stars=convert_stars_,
            limited=flags(0),
            sold_out=flags(1),
            birthday=flags(2),
            require_premium=flags(7),
            limited_per_user=flags(8),
            availability_remains=availability_remains_,
            availability_total=availability_total_,
            availability_resale=availability_resale_,
            first_sale_date=first_sale_date_,
            last_sale_date=last_sale_date_,
            upgrade_stars=upgrade_stars_,
            resell_min_stars=resell_min_stars_,
            title=title_,
            released_by=released_by_,
            per_user_total=per_user_total_,
            per_user_remains=per_user_remains_,
            locked_until_date=locked_until_date_
        )

class StarGiftUnique(TLObject, family='TypeStarGift'):
    _id = 0X1BEFE865
    _group_id = 0X87440C7B

    def __init__(
        self,
        id: int,
        gift_id: int,
        title: str,
        slug: str,
        num: int,
        attributes: List['TypeStarGiftAttribute'],
        availability_issued: int,
        availability_total: int,
        require_premium: bool = False,
        resale_ton_only: bool = False,
        theme_available: bool = False,
        owner_id: Optional['TypePeer'] = None,
        owner_name: Optional[str] = None,
        owner_address: Optional[str] = None,
        gift_address: Optional[str] = None,
        resell_amount: Optional[List['TypeStarsAmount']] = None,
        released_by: Optional['TypePeer'] = None,
        value_amount: Optional[int] = None,
        value_currency: Optional[str] = None,
        theme_peer: Optional['TypePeer'] = None
    ):

        self.id = id
        self.gift_id = gift_id
        self.title = title
        self.slug = slug
        self.num = num
        self.attributes = attributes
        self.availability_issued = availability_issued
        self.availability_total = availability_total
        self.require_premium = require_premium
        self.resale_ton_only = resale_ton_only
        self.theme_available = theme_available
        self.owner_id = owner_id
        self.owner_name = owner_name
        self.owner_address = owner_address
        self.gift_address = gift_address
        self.resell_amount = resell_amount
        self.released_by = released_by
        self.value_amount = value_amount
        self.value_currency = value_currency
        self.theme_peer = theme_peer

    def to_bytes(self, boxed: bool=True):
        with Writer(b'e\xe8\xef\x1b' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.require_premium, 6)
                flags(self.resale_ton_only, 7)
                flags(self.theme_available, 9)
                writer.long(self.id)
                writer.long(self.gift_id)
                writer.string(self.title)
                writer.string(self.slug)
                writer.int(self.num)

                if flags(self.owner_id, 0):
                    writer.object(
                        self.owner_id,
                        group_id=0XB4DECBCA
                    )

                if flags(self.owner_name, 1):
                    writer.string(self.owner_name)

                if flags(self.owner_address, 2):
                    writer.string(self.owner_address)
                writer.vector(
                    self.attributes,
                    lambda value: writer.object(
                        value,
                        group_id=0XEE235015
                    )
                )
                writer.int(self.availability_issued)
                writer.int(self.availability_total)

                if flags(self.gift_address, 3):
                    writer.string(self.gift_address)

                if flags(self.resell_amount, 4):
                    writer.vector(
                        self.resell_amount,
                        lambda value: writer.object(
                            value,
                            group_id=0XC3D62A83
                        )
                    )

                if flags(self.released_by, 5):
                    writer.object(
                        self.released_by,
                        group_id=0XB4DECBCA
                    )

                if flags(self.value_amount, 8):
                    writer.long(self.value_amount)

                if flags(self.value_currency, 8):
                    writer.string(self.value_currency)

                if flags(self.theme_peer, 10):
                    writer.object(
                        self.theme_peer,
                        group_id=0XB4DECBCA
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        gift_id_ = reader.long()
        title_ = reader.string()
        slug_ = reader.string()
        num_ = reader.int()
        owner_id_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(0) else None
        )

        owner_name_ = (
            reader.string()
            if flags(1) else None
        )

        owner_address_ = (
            reader.string()
            if flags(2) else None
        )

        attributes_ = reader.vector(
            lambda: reader.object(
                group_id=0XEE235015
            )
        )

        availability_issued_ = reader.int()
        availability_total_ = reader.int()
        gift_address_ = (
            reader.string()
            if flags(3) else None
        )

        resell_amount_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0XC3D62A83
                )
            )
            if flags(4) else None
        )

        released_by_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(5) else None
        )

        value_amount_ = (
            reader.long()
            if flags(8) else None
        )

        value_currency_ = (
            reader.string()
            if flags(8) else None
        )

        theme_peer_ = (
            reader.object(
                group_id=0XB4DECBCA
            )
            if flags(10) else None
        )

        return cls(
            id=id_,
            gift_id=gift_id_,
            title=title_,
            slug=slug_,
            num=num_,
            attributes=attributes_,
            availability_issued=availability_issued_,
            availability_total=availability_total_,
            require_premium=flags(6),
            resale_ton_only=flags(7),
            theme_available=flags(9),
            owner_id=owner_id_,
            owner_name=owner_name_,
            owner_address=owner_address_,
            gift_address=gift_address_,
            resell_amount=resell_amount_,
            released_by=released_by_,
            value_amount=value_amount_,
            value_currency=value_currency_,
            theme_peer=theme_peer_
        )

TypeStarGift = Union[
    StarGift,
    StarGiftUnique
]