
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class StarsGiveawayWinnersOption(TLObject, family='TypeStarsGiveawayWinnersOption'):
    """
    Allowed options for the number of giveaway winners.
    """

    _id = 0X54236209
    _group_id = 0X77E66F9C

    def __init__(
        self,
        users: int,
        per_user_stars: int,
        default: bool = False
    ):

        """
        Allowed options for the number of giveaway winners.

        Args:
            users (int): The number of users that will be randomly chosen as winners.
            per_user_stars (int): The number of [Telegram Stars](https://core.telegram.org/api/stars) each winner will receive.
            default (bool, optional): If set, this option must be pre-selected by default in the option list.
        """

        self.users = users
        self.per_user_stars = per_user_stars
        self.default = default

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\tb#T' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.default, 0)
                writer.int(self.users)
                writer.long(self.per_user_stars)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        users_ = reader.int()
        per_user_stars_ = reader.long()

        return cls(
            users=users_,
            per_user_stars=per_user_stars_,
            default=flags(0)
        )

TypeStarsGiveawayWinnersOption = StarsGiveawayWinnersOption