
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .stars_amount import TypeStarsAmount
    from ...gadgets.byteutils import Reader


class StarsRevenueStatus(TLObject, family='TypeStarsRevenueStatus'):
    """
    Describes [Telegram Star revenue balances](https://core.telegram.org/api/stars).
    """

    _id = 0XFEBE5491
    _group_id = 0XC576A749

    def __init__(
        self,
        current_balance: 'TypeStarsAmount',
        available_balance: 'TypeStarsAmount',
        overall_revenue: 'TypeStarsAmount',
        withdrawal_enabled: bool = False,
        next_withdrawal_at: Optional[int] = None
    ):

        """
        Describes [Telegram Star revenue balances](https://core.telegram.org/api/stars).

        Args:
            current_balance ('TypeStarsAmount'): Amount of not-yet-withdrawn Telegram Stars.
            available_balance ('TypeStarsAmount'): Amount of withdrawable Telegram Stars.
            overall_revenue ('TypeStarsAmount'): Total amount of earned Telegram Stars.
            withdrawal_enabled (bool, optional): If set, the user may [withdraw](https://core.telegram.org/api/stars#withdrawing-stars) up to available_balance stars.
            next_withdrawal_at (Optional[int], optional): Unixtime indicating when will withdrawal be available to the user. If not set, withdrawal can be started now.
        """

        self.current_balance = current_balance
        self.available_balance = available_balance
        self.overall_revenue = overall_revenue
        self.withdrawal_enabled = withdrawal_enabled
        self.next_withdrawal_at = next_withdrawal_at

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x91T\xbe\xfe' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.withdrawal_enabled, 0)
                writer.object(
                    self.current_balance,
                    group_id=0XC3D62A83
                )
                writer.object(
                    self.available_balance,
                    group_id=0XC3D62A83
                )
                writer.object(
                    self.overall_revenue,
                    group_id=0XC3D62A83
                )

                if flags(self.next_withdrawal_at, 1):
                    writer.int(self.next_withdrawal_at)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        current_balance_ = reader.object(
            group_id=0XC3D62A83
        )

        available_balance_ = reader.object(
            group_id=0XC3D62A83
        )

        overall_revenue_ = reader.object(
            group_id=0XC3D62A83
        )

        next_withdrawal_at_ = (
            reader.int()
            if flags(1) else None
        )

        return cls(
            current_balance=current_balance_,
            available_balance=available_balance_,
            overall_revenue=overall_revenue_,
            withdrawal_enabled=flags(0),
            next_withdrawal_at=next_withdrawal_at_
        )

TypeStarsRevenueStatus = StarsRevenueStatus