
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class CdnFileReuploadNeeded(TLObject, family='TypeUploadCdnFile'):
    """
    The file was cleared from the temporary RAM cache of the [CDN](https://core.telegram.org/cdn) and has to be re-uploaded.
    """

    _id = 0XEEA8E46E
    _group_id = 0X64D66450

    def __init__(
        self,
        request_token: bytes
    ):

        """
        The file was cleared from the temporary RAM cache of the [CDN](https://core.telegram.org/cdn) and has to be re-uploaded.

        Args:
            request_token (bytes): Request token (see [CDN](https://core.telegram.org/cdn))
        """

        self.request_token = request_token

    def to_bytes(self, boxed: bool=True):
        with Writer(b'n\xe4\xa8\xee' if boxed else b'') as writer:
            writer.bytes(self.request_token)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        request_token_ = reader.bytes()

        return cls(
            request_token=request_token_
        )

class CdnFile(TLObject, family='TypeUploadCdnFile'):
    """
    Represent a chunk of a [CDN](https://core.telegram.org/cdn) file.
    """

    _id = 0XA99FCA4F
    _group_id = 0X64D66450

    def __init__(
        self,
        bytes: bytes
    ):

        """
        Represent a chunk of a [CDN](https://core.telegram.org/cdn) file.

        Args:
            bytes (bytes): The data
        """

        self.bytes = bytes

    def to_bytes(self, boxed: bool=True):
        with Writer(b'O\xca\x9f\xa9' if boxed else b'') as writer:
            writer.bytes(self.bytes)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        bytes_ = reader.bytes()

        return cls(
            bytes=bytes_
        )

TypeUploadCdnFile = Union[
    CdnFileReuploadNeeded,
    CdnFile
]