
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, List, TYPE_CHECKING, Union
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .page import TypePage
    from .photo import TypePhoto
    from .document import TypeDocument
    from .web_page_attribute import TypeWebPageAttribute
    from ...gadgets.byteutils import Reader


class WebPageEmpty(TLObject, family='TypeWebPage'):
    """
    No preview is available for the webpage
    """

    _id = 0X211A1788
    _group_id = 0X9D177ED

    def __init__(
        self,
        id: int,
        url: Optional[str] = None
    ):

        """
        No preview is available for the webpage

        Args:
            id (int): Preview ID
            url (Optional[str], optional): URL of the webpage.
        """

        self.id = id
        self.url = url

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x88\x17\x1a!' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.id)

                if flags(self.url, 0):
                    writer.string(self.url)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        url_ = (
            reader.string()
            if flags(0) else None
        )

        return cls(
            id=id_,
            url=url_
        )

class WebPagePending(TLObject, family='TypeWebPage'):
    """
    A preview of the webpage is currently being generated
    """

    _id = 0XB0D13E47
    _group_id = 0X9D177ED

    def __init__(
        self,
        id: int,
        date: int,
        url: Optional[str] = None
    ):

        """
        A preview of the webpage is currently being generated

        Args:
            id (int): ID of preview
            date (int): When was the processing started
            url (Optional[str], optional): URL of the webpage
        """

        self.id = id
        self.date = date
        self.url = url

    def to_bytes(self, boxed: bool=True):
        with Writer(b'G>\xd1\xb0' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.long(self.id)

                if flags(self.url, 0):
                    writer.string(self.url)
                writer.int(self.date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        url_ = (
            reader.string()
            if flags(0) else None
        )

        date_ = reader.int()

        return cls(
            id=id_,
            date=date_,
            url=url_
        )

class WebPage(TLObject, family='TypeWebPage'):
    """
    Webpage preview
    """

    _id = 0XE89C45B2
    _group_id = 0X9D177ED

    def __init__(
        self,
        id: int,
        url: str,
        display_url: str,
        hash: int,
        has_large_media: bool = False,
        video_cover_photo: bool = False,
        type: Optional[str] = None,
        site_name: Optional[str] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        photo: Optional['TypePhoto'] = None,
        embed_url: Optional[str] = None,
        embed_type: Optional[str] = None,
        embed_width: Optional[int] = None,
        embed_height: Optional[int] = None,
        duration: Optional[int] = None,
        author: Optional[str] = None,
        document: Optional['TypeDocument'] = None,
        cached_page: Optional['TypePage'] = None,
        attributes: Optional[List['TypeWebPageAttribute']] = None
    ):

        """
        Webpage preview

        Args:
            id (int): Preview ID
            url (str): URL of previewed webpage
            display_url (str): Webpage URL to be displayed to the user
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            has_large_media (bool, optional): Whether the size of the media in the preview can be changed.
            video_cover_photo (bool, optional): ...
            type (Optional[str], optional): Type of the web page. One of the following: - video - gif - photo - document - profile - telegram_background - telegram_theme - telegram_story - telegram_channel - telegram_channel_request - telegram_megagroup - telegram_chat - telegram_megagroup_request - telegram_chat_request - telegram_album - telegram_message - telegram_bot - telegram_voicechat - telegram_livestream - telegram_user - telegram_botapp - telegram_channel_boost - telegram_group_boost - telegram_giftcode - telegram_stickerset
            site_name (Optional[str], optional): Short name of the site (e.g., Google Docs, App Store)
            title (Optional[str], optional): Title of the content
            description (Optional[str], optional): Content description
            photo (Optional['TypePhoto'], optional): Image representing the content
            embed_url (Optional[str], optional): URL to show in the embedded preview
            embed_type (Optional[str], optional): MIME type of the embedded preview, (e.g., text/html or video/mp4)
            embed_width (Optional[int], optional): Width of the embedded preview
            embed_height (Optional[int], optional): Height of the embedded preview
            duration (Optional[int], optional): Duration of the content, in seconds
            author (Optional[str], optional): Author of the content
            document (Optional['TypeDocument'], optional): Preview of the content as a media file
            cached_page (Optional['TypePage'], optional): Page contents in [instant view](https://instantview.telegram.org) format
            attributes (Optional[List['TypeWebPageAttribute']], optional): Webpage attributes
        """

        self.id = id
        self.url = url
        self.display_url = display_url
        self.hash = hash
        self.has_large_media = has_large_media
        self.video_cover_photo = video_cover_photo
        self.type = type
        self.site_name = site_name
        self.title = title
        self.description = description
        self.photo = photo
        self.embed_url = embed_url
        self.embed_type = embed_type
        self.embed_width = embed_width
        self.embed_height = embed_height
        self.duration = duration
        self.author = author
        self.document = document
        self.cached_page = cached_page
        self.attributes = attributes

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb2E\x9c\xe8' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.has_large_media, 13)
                flags(self.video_cover_photo, 14)
                writer.long(self.id)
                writer.string(self.url)
                writer.string(self.display_url)
                writer.int(self.hash)

                if flags(self.type, 0):
                    writer.string(self.type)

                if flags(self.site_name, 1):
                    writer.string(self.site_name)

                if flags(self.title, 2):
                    writer.string(self.title)

                if flags(self.description, 3):
                    writer.string(self.description)

                if flags(self.photo, 4):
                    writer.object(
                        self.photo,
                        group_id=0XDDAD9CAC
                    )

                if flags(self.embed_url, 5):
                    writer.string(self.embed_url)

                if flags(self.embed_type, 5):
                    writer.string(self.embed_type)

                if flags(self.embed_width, 6):
                    writer.int(self.embed_width)

                if flags(self.embed_height, 6):
                    writer.int(self.embed_height)

                if flags(self.duration, 7):
                    writer.int(self.duration)

                if flags(self.author, 8):
                    writer.string(self.author)

                if flags(self.document, 9):
                    writer.object(
                        self.document,
                        group_id=0X6547BD50
                    )

                if flags(self.cached_page, 10):
                    writer.object(
                        self.cached_page,
                        group_id=0X2328453
                    )

                if flags(self.attributes, 12):
                    writer.vector(
                        self.attributes,
                        lambda value: writer.object(
                            value,
                            group_id=0X3FDCCA54
                        )
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        url_ = reader.string()
        display_url_ = reader.string()
        hash_ = reader.int()
        type_ = (
            reader.string()
            if flags(0) else None
        )

        site_name_ = (
            reader.string()
            if flags(1) else None
        )

        title_ = (
            reader.string()
            if flags(2) else None
        )

        description_ = (
            reader.string()
            if flags(3) else None
        )

        photo_ = (
            reader.object(
                group_id=0XDDAD9CAC
            )
            if flags(4) else None
        )

        embed_url_ = (
            reader.string()
            if flags(5) else None
        )

        embed_type_ = (
            reader.string()
            if flags(5) else None
        )

        embed_width_ = (
            reader.int()
            if flags(6) else None
        )

        embed_height_ = (
            reader.int()
            if flags(6) else None
        )

        duration_ = (
            reader.int()
            if flags(7) else None
        )

        author_ = (
            reader.string()
            if flags(8) else None
        )

        document_ = (
            reader.object(
                group_id=0X6547BD50
            )
            if flags(9) else None
        )

        cached_page_ = (
            reader.object(
                group_id=0X2328453
            )
            if flags(10) else None
        )

        attributes_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3FDCCA54
                )
            )
            if flags(12) else None
        )

        return cls(
            id=id_,
            url=url_,
            display_url=display_url_,
            hash=hash_,
            has_large_media=flags(13),
            video_cover_photo=flags(14),
            type=type_,
            site_name=site_name_,
            title=title_,
            description=description_,
            photo=photo_,
            embed_url=embed_url_,
            embed_type=embed_type_,
            embed_width=embed_width_,
            embed_height=embed_height_,
            duration=duration_,
            author=author_,
            document=document_,
            cached_page=cached_page_,
            attributes=attributes_
        )

class WebPageNotModified(TLObject, family='TypeWebPage'):
    """
    The preview of the webpage hasn't changed
    """

    _id = 0X7311CA11
    _group_id = 0X9D177ED

    def __init__(
        self,
        cached_page_views: Optional[int] = None
    ):

        """
        The preview of the webpage hasn't changed

        Args:
            cached_page_views (Optional[int], optional): Page view count
        """

        self.cached_page_views = cached_page_views

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x11\xca\x11s' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.cached_page_views, 0):
                    writer.int(self.cached_page_views)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        cached_page_views_ = (
            reader.int()
            if flags(0) else None
        )

        return cls(
            cached_page_views=cached_page_views_
        )

TypeWebPage = Union[
    WebPageEmpty,
    WebPagePending,
    WebPage,
    WebPageNotModified
]