/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceCertificateBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/app_service_certificate_binding#certificate_id AppServiceCertificateBinding#certificate_id}
    */
    readonly certificateId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/app_service_certificate_binding#hostname_binding_id AppServiceCertificateBinding#hostname_binding_id}
    */
    readonly hostnameBindingId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/app_service_certificate_binding#id AppServiceCertificateBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/app_service_certificate_binding#ssl_state AppServiceCertificateBinding#ssl_state}
    */
    readonly sslState: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/app_service_certificate_binding#timeouts AppServiceCertificateBinding#timeouts}
    */
    readonly timeouts?: AppServiceCertificateBindingTimeouts;
}
export interface AppServiceCertificateBindingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/app_service_certificate_binding#create AppServiceCertificateBinding#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/app_service_certificate_binding#delete AppServiceCertificateBinding#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/app_service_certificate_binding#read AppServiceCertificateBinding#read}
    */
    readonly read?: string;
}
export declare function appServiceCertificateBindingTimeoutsToTerraform(struct?: AppServiceCertificateBindingTimeouts | cdktf.IResolvable): any;
export declare function appServiceCertificateBindingTimeoutsToHclTerraform(struct?: AppServiceCertificateBindingTimeouts | cdktf.IResolvable): any;
export declare class AppServiceCertificateBindingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceCertificateBindingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceCertificateBindingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/app_service_certificate_binding azurerm_app_service_certificate_binding}
*/
export declare class AppServiceCertificateBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_certificate_binding";
    /**
    * Generates CDKTF code for importing a AppServiceCertificateBinding resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AppServiceCertificateBinding to import
    * @param importFromId The id of the existing AppServiceCertificateBinding that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/app_service_certificate_binding#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AppServiceCertificateBinding to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/app_service_certificate_binding azurerm_app_service_certificate_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceCertificateBindingConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceCertificateBindingConfig);
    get appServiceName(): string;
    private _certificateId?;
    get certificateId(): string;
    set certificateId(value: string);
    get certificateIdInput(): string | undefined;
    get hostname(): string;
    private _hostnameBindingId?;
    get hostnameBindingId(): string;
    set hostnameBindingId(value: string);
    get hostnameBindingIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _sslState?;
    get sslState(): string;
    set sslState(value: string);
    get sslStateInput(): string | undefined;
    get thumbprint(): string;
    private _timeouts;
    get timeouts(): AppServiceCertificateBindingTimeoutsOutputReference;
    putTimeouts(value: AppServiceCertificateBindingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppServiceCertificateBindingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
