/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationInsightsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#application_type ApplicationInsights#application_type}
    */
    readonly applicationType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#daily_data_cap_in_gb ApplicationInsights#daily_data_cap_in_gb}
    */
    readonly dailyDataCapInGb?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#daily_data_cap_notifications_disabled ApplicationInsights#daily_data_cap_notifications_disabled}
    */
    readonly dailyDataCapNotificationsDisabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#disable_ip_masking ApplicationInsights#disable_ip_masking}
    */
    readonly disableIpMasking?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#force_customer_storage_for_profiler ApplicationInsights#force_customer_storage_for_profiler}
    */
    readonly forceCustomerStorageForProfiler?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#id ApplicationInsights#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#internet_ingestion_enabled ApplicationInsights#internet_ingestion_enabled}
    */
    readonly internetIngestionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#internet_query_enabled ApplicationInsights#internet_query_enabled}
    */
    readonly internetQueryEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#local_authentication_disabled ApplicationInsights#local_authentication_disabled}
    */
    readonly localAuthenticationDisabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#location ApplicationInsights#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#name ApplicationInsights#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#resource_group_name ApplicationInsights#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#retention_in_days ApplicationInsights#retention_in_days}
    */
    readonly retentionInDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#sampling_percentage ApplicationInsights#sampling_percentage}
    */
    readonly samplingPercentage?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#tags ApplicationInsights#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#workspace_id ApplicationInsights#workspace_id}
    */
    readonly workspaceId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#timeouts ApplicationInsights#timeouts}
    */
    readonly timeouts?: ApplicationInsightsTimeouts;
}
export interface ApplicationInsightsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#create ApplicationInsights#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#delete ApplicationInsights#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#read ApplicationInsights#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#update ApplicationInsights#update}
    */
    readonly update?: string;
}
export declare function applicationInsightsTimeoutsToTerraform(struct?: ApplicationInsightsTimeouts | cdktf.IResolvable): any;
export declare function applicationInsightsTimeoutsToHclTerraform(struct?: ApplicationInsightsTimeouts | cdktf.IResolvable): any;
export declare class ApplicationInsightsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationInsightsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationInsightsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights azurerm_application_insights}
*/
export declare class ApplicationInsights extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_application_insights";
    /**
    * Generates CDKTF code for importing a ApplicationInsights resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApplicationInsights to import
    * @param importFromId The id of the existing ApplicationInsights that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApplicationInsights to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/application_insights azurerm_application_insights} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationInsightsConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationInsightsConfig);
    get appId(): string;
    private _applicationType?;
    get applicationType(): string;
    set applicationType(value: string);
    get applicationTypeInput(): string | undefined;
    get connectionString(): string;
    private _dailyDataCapInGb?;
    get dailyDataCapInGb(): number;
    set dailyDataCapInGb(value: number);
    resetDailyDataCapInGb(): void;
    get dailyDataCapInGbInput(): number | undefined;
    private _dailyDataCapNotificationsDisabled?;
    get dailyDataCapNotificationsDisabled(): boolean | cdktf.IResolvable;
    set dailyDataCapNotificationsDisabled(value: boolean | cdktf.IResolvable);
    resetDailyDataCapNotificationsDisabled(): void;
    get dailyDataCapNotificationsDisabledInput(): boolean | cdktf.IResolvable | undefined;
    private _disableIpMasking?;
    get disableIpMasking(): boolean | cdktf.IResolvable;
    set disableIpMasking(value: boolean | cdktf.IResolvable);
    resetDisableIpMasking(): void;
    get disableIpMaskingInput(): boolean | cdktf.IResolvable | undefined;
    private _forceCustomerStorageForProfiler?;
    get forceCustomerStorageForProfiler(): boolean | cdktf.IResolvable;
    set forceCustomerStorageForProfiler(value: boolean | cdktf.IResolvable);
    resetForceCustomerStorageForProfiler(): void;
    get forceCustomerStorageForProfilerInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get instrumentationKey(): string;
    private _internetIngestionEnabled?;
    get internetIngestionEnabled(): boolean | cdktf.IResolvable;
    set internetIngestionEnabled(value: boolean | cdktf.IResolvable);
    resetInternetIngestionEnabled(): void;
    get internetIngestionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _internetQueryEnabled?;
    get internetQueryEnabled(): boolean | cdktf.IResolvable;
    set internetQueryEnabled(value: boolean | cdktf.IResolvable);
    resetInternetQueryEnabled(): void;
    get internetQueryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _localAuthenticationDisabled?;
    get localAuthenticationDisabled(): boolean | cdktf.IResolvable;
    set localAuthenticationDisabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthenticationDisabled(): void;
    get localAuthenticationDisabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    resetRetentionInDays(): void;
    get retentionInDaysInput(): number | undefined;
    private _samplingPercentage?;
    get samplingPercentage(): number;
    set samplingPercentage(value: number);
    resetSamplingPercentage(): void;
    get samplingPercentageInput(): number | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    resetWorkspaceId(): void;
    get workspaceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApplicationInsightsTimeoutsOutputReference;
    putTimeouts(value: ApplicationInsightsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApplicationInsightsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
