/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutomationAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#id AutomationAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#local_authentication_enabled AutomationAccount#local_authentication_enabled}
    */
    readonly localAuthenticationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#location AutomationAccount#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#name AutomationAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#public_network_access_enabled AutomationAccount#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#resource_group_name AutomationAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#sku_name AutomationAccount#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#tags AutomationAccount#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#encryption AutomationAccount#encryption}
    */
    readonly encryption?: AutomationAccountEncryption[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#identity AutomationAccount#identity}
    */
    readonly identity?: AutomationAccountIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#timeouts AutomationAccount#timeouts}
    */
    readonly timeouts?: AutomationAccountTimeouts;
}
export interface AutomationAccountPrivateEndpointConnection {
}
export declare function automationAccountPrivateEndpointConnectionToTerraform(struct?: AutomationAccountPrivateEndpointConnection): any;
export declare function automationAccountPrivateEndpointConnectionToHclTerraform(struct?: AutomationAccountPrivateEndpointConnection): any;
export declare class AutomationAccountPrivateEndpointConnectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AutomationAccountPrivateEndpointConnection | undefined;
    set internalValue(value: AutomationAccountPrivateEndpointConnection | undefined);
    get id(): string;
    get name(): string;
}
export declare class AutomationAccountPrivateEndpointConnectionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AutomationAccountPrivateEndpointConnectionOutputReference;
}
export interface AutomationAccountEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#key_source AutomationAccount#key_source}
    */
    readonly keySource?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#key_vault_key_id AutomationAccount#key_vault_key_id}
    */
    readonly keyVaultKeyId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#user_assigned_identity_id AutomationAccount#user_assigned_identity_id}
    */
    readonly userAssignedIdentityId?: string;
}
export declare function automationAccountEncryptionToTerraform(struct?: AutomationAccountEncryption | cdktf.IResolvable): any;
export declare function automationAccountEncryptionToHclTerraform(struct?: AutomationAccountEncryption | cdktf.IResolvable): any;
export declare class AutomationAccountEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AutomationAccountEncryption | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationAccountEncryption | cdktf.IResolvable | undefined);
    private _keySource?;
    get keySource(): string;
    set keySource(value: string);
    resetKeySource(): void;
    get keySourceInput(): string | undefined;
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    get keyVaultKeyIdInput(): string | undefined;
    private _userAssignedIdentityId?;
    get userAssignedIdentityId(): string;
    set userAssignedIdentityId(value: string);
    resetUserAssignedIdentityId(): void;
    get userAssignedIdentityIdInput(): string | undefined;
}
export declare class AutomationAccountEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AutomationAccountEncryption[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AutomationAccountEncryptionOutputReference;
}
export interface AutomationAccountIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#identity_ids AutomationAccount#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#type AutomationAccount#type}
    */
    readonly type: string;
}
export declare function automationAccountIdentityToTerraform(struct?: AutomationAccountIdentityOutputReference | AutomationAccountIdentity): any;
export declare function automationAccountIdentityToHclTerraform(struct?: AutomationAccountIdentityOutputReference | AutomationAccountIdentity): any;
export declare class AutomationAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationAccountIdentity | undefined;
    set internalValue(value: AutomationAccountIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface AutomationAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#create AutomationAccount#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#delete AutomationAccount#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#read AutomationAccount#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#update AutomationAccount#update}
    */
    readonly update?: string;
}
export declare function automationAccountTimeoutsToTerraform(struct?: AutomationAccountTimeouts | cdktf.IResolvable): any;
export declare function automationAccountTimeoutsToHclTerraform(struct?: AutomationAccountTimeouts | cdktf.IResolvable): any;
export declare class AutomationAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationAccountTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account azurerm_automation_account}
*/
export declare class AutomationAccount extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_automation_account";
    /**
    * Generates CDKTF code for importing a AutomationAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AutomationAccount to import
    * @param importFromId The id of the existing AutomationAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AutomationAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/automation_account azurerm_automation_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutomationAccountConfig
    */
    constructor(scope: Construct, id: string, config: AutomationAccountConfig);
    get dscPrimaryAccessKey(): string;
    get dscSecondaryAccessKey(): string;
    get dscServerEndpoint(): string;
    get hybridServiceUrl(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _localAuthenticationEnabled?;
    get localAuthenticationEnabled(): boolean | cdktf.IResolvable;
    set localAuthenticationEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthenticationEnabled(): void;
    get localAuthenticationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privateEndpointConnection;
    get privateEndpointConnection(): AutomationAccountPrivateEndpointConnectionList;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _encryption;
    get encryption(): AutomationAccountEncryptionList;
    putEncryption(value: AutomationAccountEncryption[] | cdktf.IResolvable): void;
    resetEncryption(): void;
    get encryptionInput(): cdktf.IResolvable | AutomationAccountEncryption[] | undefined;
    private _identity;
    get identity(): AutomationAccountIdentityOutputReference;
    putIdentity(value: AutomationAccountIdentity): void;
    resetIdentity(): void;
    get identityInput(): AutomationAccountIdentity | undefined;
    private _timeouts;
    get timeouts(): AutomationAccountTimeoutsOutputReference;
    putTimeouts(value: AutomationAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AutomationAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
