/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CdnFrontdoorFirewallPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#custom_block_response_body CdnFrontdoorFirewallPolicy#custom_block_response_body}
    */
    readonly customBlockResponseBody?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#custom_block_response_status_code CdnFrontdoorFirewallPolicy#custom_block_response_status_code}
    */
    readonly customBlockResponseStatusCode?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#enabled CdnFrontdoorFirewallPolicy#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#id CdnFrontdoorFirewallPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#mode CdnFrontdoorFirewallPolicy#mode}
    */
    readonly mode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#name CdnFrontdoorFirewallPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#redirect_url CdnFrontdoorFirewallPolicy#redirect_url}
    */
    readonly redirectUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#request_body_check_enabled CdnFrontdoorFirewallPolicy#request_body_check_enabled}
    */
    readonly requestBodyCheckEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#resource_group_name CdnFrontdoorFirewallPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#sku_name CdnFrontdoorFirewallPolicy#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#tags CdnFrontdoorFirewallPolicy#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * custom_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#custom_rule CdnFrontdoorFirewallPolicy#custom_rule}
    */
    readonly customRule?: CdnFrontdoorFirewallPolicyCustomRule[] | cdktf.IResolvable;
    /**
    * managed_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#managed_rule CdnFrontdoorFirewallPolicy#managed_rule}
    */
    readonly managedRule?: CdnFrontdoorFirewallPolicyManagedRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#timeouts CdnFrontdoorFirewallPolicy#timeouts}
    */
    readonly timeouts?: CdnFrontdoorFirewallPolicyTimeouts;
}
export interface CdnFrontdoorFirewallPolicyCustomRuleMatchCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#match_values CdnFrontdoorFirewallPolicy#match_values}
    */
    readonly matchValues: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#match_variable CdnFrontdoorFirewallPolicy#match_variable}
    */
    readonly matchVariable: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#negation_condition CdnFrontdoorFirewallPolicy#negation_condition}
    */
    readonly negationCondition?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#operator CdnFrontdoorFirewallPolicy#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#selector CdnFrontdoorFirewallPolicy#selector}
    */
    readonly selector?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#transforms CdnFrontdoorFirewallPolicy#transforms}
    */
    readonly transforms?: string[];
}
export declare function cdnFrontdoorFirewallPolicyCustomRuleMatchConditionToTerraform(struct?: CdnFrontdoorFirewallPolicyCustomRuleMatchCondition | cdktf.IResolvable): any;
export declare function cdnFrontdoorFirewallPolicyCustomRuleMatchConditionToHclTerraform(struct?: CdnFrontdoorFirewallPolicyCustomRuleMatchCondition | cdktf.IResolvable): any;
export declare class CdnFrontdoorFirewallPolicyCustomRuleMatchConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorFirewallPolicyCustomRuleMatchCondition | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorFirewallPolicyCustomRuleMatchCondition | cdktf.IResolvable | undefined);
    private _matchValues?;
    get matchValues(): string[];
    set matchValues(value: string[]);
    get matchValuesInput(): string[] | undefined;
    private _matchVariable?;
    get matchVariable(): string;
    set matchVariable(value: string);
    get matchVariableInput(): string | undefined;
    private _negationCondition?;
    get negationCondition(): boolean | cdktf.IResolvable;
    set negationCondition(value: boolean | cdktf.IResolvable);
    resetNegationCondition(): void;
    get negationConditionInput(): boolean | cdktf.IResolvable | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    resetSelector(): void;
    get selectorInput(): string | undefined;
    private _transforms?;
    get transforms(): string[];
    set transforms(value: string[]);
    resetTransforms(): void;
    get transformsInput(): string[] | undefined;
}
export declare class CdnFrontdoorFirewallPolicyCustomRuleMatchConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorFirewallPolicyCustomRuleMatchCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorFirewallPolicyCustomRuleMatchConditionOutputReference;
}
export interface CdnFrontdoorFirewallPolicyCustomRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#action CdnFrontdoorFirewallPolicy#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#enabled CdnFrontdoorFirewallPolicy#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#name CdnFrontdoorFirewallPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#priority CdnFrontdoorFirewallPolicy#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#rate_limit_duration_in_minutes CdnFrontdoorFirewallPolicy#rate_limit_duration_in_minutes}
    */
    readonly rateLimitDurationInMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#rate_limit_threshold CdnFrontdoorFirewallPolicy#rate_limit_threshold}
    */
    readonly rateLimitThreshold?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#type CdnFrontdoorFirewallPolicy#type}
    */
    readonly type: string;
    /**
    * match_condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#match_condition CdnFrontdoorFirewallPolicy#match_condition}
    */
    readonly matchCondition?: CdnFrontdoorFirewallPolicyCustomRuleMatchCondition[] | cdktf.IResolvable;
}
export declare function cdnFrontdoorFirewallPolicyCustomRuleToTerraform(struct?: CdnFrontdoorFirewallPolicyCustomRule | cdktf.IResolvable): any;
export declare function cdnFrontdoorFirewallPolicyCustomRuleToHclTerraform(struct?: CdnFrontdoorFirewallPolicyCustomRule | cdktf.IResolvable): any;
export declare class CdnFrontdoorFirewallPolicyCustomRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorFirewallPolicyCustomRule | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorFirewallPolicyCustomRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _rateLimitDurationInMinutes?;
    get rateLimitDurationInMinutes(): number;
    set rateLimitDurationInMinutes(value: number);
    resetRateLimitDurationInMinutes(): void;
    get rateLimitDurationInMinutesInput(): number | undefined;
    private _rateLimitThreshold?;
    get rateLimitThreshold(): number;
    set rateLimitThreshold(value: number);
    resetRateLimitThreshold(): void;
    get rateLimitThresholdInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _matchCondition;
    get matchCondition(): CdnFrontdoorFirewallPolicyCustomRuleMatchConditionList;
    putMatchCondition(value: CdnFrontdoorFirewallPolicyCustomRuleMatchCondition[] | cdktf.IResolvable): void;
    resetMatchCondition(): void;
    get matchConditionInput(): cdktf.IResolvable | CdnFrontdoorFirewallPolicyCustomRuleMatchCondition[] | undefined;
}
export declare class CdnFrontdoorFirewallPolicyCustomRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorFirewallPolicyCustomRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorFirewallPolicyCustomRuleOutputReference;
}
export interface CdnFrontdoorFirewallPolicyManagedRuleExclusion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#match_variable CdnFrontdoorFirewallPolicy#match_variable}
    */
    readonly matchVariable: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#operator CdnFrontdoorFirewallPolicy#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#selector CdnFrontdoorFirewallPolicy#selector}
    */
    readonly selector: string;
}
export declare function cdnFrontdoorFirewallPolicyManagedRuleExclusionToTerraform(struct?: CdnFrontdoorFirewallPolicyManagedRuleExclusion | cdktf.IResolvable): any;
export declare function cdnFrontdoorFirewallPolicyManagedRuleExclusionToHclTerraform(struct?: CdnFrontdoorFirewallPolicyManagedRuleExclusion | cdktf.IResolvable): any;
export declare class CdnFrontdoorFirewallPolicyManagedRuleExclusionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorFirewallPolicyManagedRuleExclusion | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorFirewallPolicyManagedRuleExclusion | cdktf.IResolvable | undefined);
    private _matchVariable?;
    get matchVariable(): string;
    set matchVariable(value: string);
    get matchVariableInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    get selectorInput(): string | undefined;
}
export declare class CdnFrontdoorFirewallPolicyManagedRuleExclusionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorFirewallPolicyManagedRuleExclusion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorFirewallPolicyManagedRuleExclusionOutputReference;
}
export interface CdnFrontdoorFirewallPolicyManagedRuleOverrideExclusion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#match_variable CdnFrontdoorFirewallPolicy#match_variable}
    */
    readonly matchVariable: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#operator CdnFrontdoorFirewallPolicy#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#selector CdnFrontdoorFirewallPolicy#selector}
    */
    readonly selector: string;
}
export declare function cdnFrontdoorFirewallPolicyManagedRuleOverrideExclusionToTerraform(struct?: CdnFrontdoorFirewallPolicyManagedRuleOverrideExclusion | cdktf.IResolvable): any;
export declare function cdnFrontdoorFirewallPolicyManagedRuleOverrideExclusionToHclTerraform(struct?: CdnFrontdoorFirewallPolicyManagedRuleOverrideExclusion | cdktf.IResolvable): any;
export declare class CdnFrontdoorFirewallPolicyManagedRuleOverrideExclusionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorFirewallPolicyManagedRuleOverrideExclusion | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorFirewallPolicyManagedRuleOverrideExclusion | cdktf.IResolvable | undefined);
    private _matchVariable?;
    get matchVariable(): string;
    set matchVariable(value: string);
    get matchVariableInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    get selectorInput(): string | undefined;
}
export declare class CdnFrontdoorFirewallPolicyManagedRuleOverrideExclusionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorFirewallPolicyManagedRuleOverrideExclusion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorFirewallPolicyManagedRuleOverrideExclusionOutputReference;
}
export interface CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#match_variable CdnFrontdoorFirewallPolicy#match_variable}
    */
    readonly matchVariable: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#operator CdnFrontdoorFirewallPolicy#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#selector CdnFrontdoorFirewallPolicy#selector}
    */
    readonly selector: string;
}
export declare function cdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusionToTerraform(struct?: CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion | cdktf.IResolvable): any;
export declare function cdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusionToHclTerraform(struct?: CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion | cdktf.IResolvable): any;
export declare class CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion | cdktf.IResolvable | undefined);
    private _matchVariable?;
    get matchVariable(): string;
    set matchVariable(value: string);
    get matchVariableInput(): string | undefined;
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _selector?;
    get selector(): string;
    set selector(value: string);
    get selectorInput(): string | undefined;
}
export declare class CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusionOutputReference;
}
export interface CdnFrontdoorFirewallPolicyManagedRuleOverrideRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#action CdnFrontdoorFirewallPolicy#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#enabled CdnFrontdoorFirewallPolicy#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#rule_id CdnFrontdoorFirewallPolicy#rule_id}
    */
    readonly ruleId: string;
    /**
    * exclusion block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#exclusion CdnFrontdoorFirewallPolicy#exclusion}
    */
    readonly exclusion?: CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion[] | cdktf.IResolvable;
}
export declare function cdnFrontdoorFirewallPolicyManagedRuleOverrideRuleToTerraform(struct?: CdnFrontdoorFirewallPolicyManagedRuleOverrideRule | cdktf.IResolvable): any;
export declare function cdnFrontdoorFirewallPolicyManagedRuleOverrideRuleToHclTerraform(struct?: CdnFrontdoorFirewallPolicyManagedRuleOverrideRule | cdktf.IResolvable): any;
export declare class CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorFirewallPolicyManagedRuleOverrideRule | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorFirewallPolicyManagedRuleOverrideRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ruleId?;
    get ruleId(): string;
    set ruleId(value: string);
    get ruleIdInput(): string | undefined;
    private _exclusion;
    get exclusion(): CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusionList;
    putExclusion(value: CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion[] | cdktf.IResolvable): void;
    resetExclusion(): void;
    get exclusionInput(): cdktf.IResolvable | CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion[] | undefined;
}
export declare class CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorFirewallPolicyManagedRuleOverrideRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleOutputReference;
}
export interface CdnFrontdoorFirewallPolicyManagedRuleOverride {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#rule_group_name CdnFrontdoorFirewallPolicy#rule_group_name}
    */
    readonly ruleGroupName: string;
    /**
    * exclusion block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#exclusion CdnFrontdoorFirewallPolicy#exclusion}
    */
    readonly exclusion?: CdnFrontdoorFirewallPolicyManagedRuleOverrideExclusion[] | cdktf.IResolvable;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#rule CdnFrontdoorFirewallPolicy#rule}
    */
    readonly rule?: CdnFrontdoorFirewallPolicyManagedRuleOverrideRule[] | cdktf.IResolvable;
}
export declare function cdnFrontdoorFirewallPolicyManagedRuleOverrideToTerraform(struct?: CdnFrontdoorFirewallPolicyManagedRuleOverride | cdktf.IResolvable): any;
export declare function cdnFrontdoorFirewallPolicyManagedRuleOverrideToHclTerraform(struct?: CdnFrontdoorFirewallPolicyManagedRuleOverride | cdktf.IResolvable): any;
export declare class CdnFrontdoorFirewallPolicyManagedRuleOverrideOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorFirewallPolicyManagedRuleOverride | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorFirewallPolicyManagedRuleOverride | cdktf.IResolvable | undefined);
    private _ruleGroupName?;
    get ruleGroupName(): string;
    set ruleGroupName(value: string);
    get ruleGroupNameInput(): string | undefined;
    private _exclusion;
    get exclusion(): CdnFrontdoorFirewallPolicyManagedRuleOverrideExclusionList;
    putExclusion(value: CdnFrontdoorFirewallPolicyManagedRuleOverrideExclusion[] | cdktf.IResolvable): void;
    resetExclusion(): void;
    get exclusionInput(): cdktf.IResolvable | CdnFrontdoorFirewallPolicyManagedRuleOverrideExclusion[] | undefined;
    private _rule;
    get rule(): CdnFrontdoorFirewallPolicyManagedRuleOverrideRuleList;
    putRule(value: CdnFrontdoorFirewallPolicyManagedRuleOverrideRule[] | cdktf.IResolvable): void;
    resetRule(): void;
    get ruleInput(): cdktf.IResolvable | CdnFrontdoorFirewallPolicyManagedRuleOverrideRule[] | undefined;
}
export declare class CdnFrontdoorFirewallPolicyManagedRuleOverrideList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorFirewallPolicyManagedRuleOverride[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorFirewallPolicyManagedRuleOverrideOutputReference;
}
export interface CdnFrontdoorFirewallPolicyManagedRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#action CdnFrontdoorFirewallPolicy#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#type CdnFrontdoorFirewallPolicy#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#version CdnFrontdoorFirewallPolicy#version}
    */
    readonly version: string;
    /**
    * exclusion block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#exclusion CdnFrontdoorFirewallPolicy#exclusion}
    */
    readonly exclusion?: CdnFrontdoorFirewallPolicyManagedRuleExclusion[] | cdktf.IResolvable;
    /**
    * override block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#override CdnFrontdoorFirewallPolicy#override}
    */
    readonly override?: CdnFrontdoorFirewallPolicyManagedRuleOverride[] | cdktf.IResolvable;
}
export declare function cdnFrontdoorFirewallPolicyManagedRuleToTerraform(struct?: CdnFrontdoorFirewallPolicyManagedRule | cdktf.IResolvable): any;
export declare function cdnFrontdoorFirewallPolicyManagedRuleToHclTerraform(struct?: CdnFrontdoorFirewallPolicyManagedRule | cdktf.IResolvable): any;
export declare class CdnFrontdoorFirewallPolicyManagedRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CdnFrontdoorFirewallPolicyManagedRule | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorFirewallPolicyManagedRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _exclusion;
    get exclusion(): CdnFrontdoorFirewallPolicyManagedRuleExclusionList;
    putExclusion(value: CdnFrontdoorFirewallPolicyManagedRuleExclusion[] | cdktf.IResolvable): void;
    resetExclusion(): void;
    get exclusionInput(): cdktf.IResolvable | CdnFrontdoorFirewallPolicyManagedRuleExclusion[] | undefined;
    private _override;
    get override(): CdnFrontdoorFirewallPolicyManagedRuleOverrideList;
    putOverride(value: CdnFrontdoorFirewallPolicyManagedRuleOverride[] | cdktf.IResolvable): void;
    resetOverride(): void;
    get overrideInput(): cdktf.IResolvable | CdnFrontdoorFirewallPolicyManagedRuleOverride[] | undefined;
}
export declare class CdnFrontdoorFirewallPolicyManagedRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CdnFrontdoorFirewallPolicyManagedRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CdnFrontdoorFirewallPolicyManagedRuleOutputReference;
}
export interface CdnFrontdoorFirewallPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#create CdnFrontdoorFirewallPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#delete CdnFrontdoorFirewallPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#read CdnFrontdoorFirewallPolicy#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#update CdnFrontdoorFirewallPolicy#update}
    */
    readonly update?: string;
}
export declare function cdnFrontdoorFirewallPolicyTimeoutsToTerraform(struct?: CdnFrontdoorFirewallPolicyTimeouts | cdktf.IResolvable): any;
export declare function cdnFrontdoorFirewallPolicyTimeoutsToHclTerraform(struct?: CdnFrontdoorFirewallPolicyTimeouts | cdktf.IResolvable): any;
export declare class CdnFrontdoorFirewallPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorFirewallPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorFirewallPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy azurerm_cdn_frontdoor_firewall_policy}
*/
export declare class CdnFrontdoorFirewallPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cdn_frontdoor_firewall_policy";
    /**
    * Generates CDKTF code for importing a CdnFrontdoorFirewallPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CdnFrontdoorFirewallPolicy to import
    * @param importFromId The id of the existing CdnFrontdoorFirewallPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CdnFrontdoorFirewallPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cdn_frontdoor_firewall_policy azurerm_cdn_frontdoor_firewall_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CdnFrontdoorFirewallPolicyConfig
    */
    constructor(scope: Construct, id: string, config: CdnFrontdoorFirewallPolicyConfig);
    private _customBlockResponseBody?;
    get customBlockResponseBody(): string;
    set customBlockResponseBody(value: string);
    resetCustomBlockResponseBody(): void;
    get customBlockResponseBodyInput(): string | undefined;
    private _customBlockResponseStatusCode?;
    get customBlockResponseStatusCode(): number;
    set customBlockResponseStatusCode(value: number);
    resetCustomBlockResponseStatusCode(): void;
    get customBlockResponseStatusCodeInput(): number | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get frontendEndpointIds(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _redirectUrl?;
    get redirectUrl(): string;
    set redirectUrl(value: string);
    resetRedirectUrl(): void;
    get redirectUrlInput(): string | undefined;
    private _requestBodyCheckEnabled?;
    get requestBodyCheckEnabled(): boolean | cdktf.IResolvable;
    set requestBodyCheckEnabled(value: boolean | cdktf.IResolvable);
    resetRequestBodyCheckEnabled(): void;
    get requestBodyCheckEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _customRule;
    get customRule(): CdnFrontdoorFirewallPolicyCustomRuleList;
    putCustomRule(value: CdnFrontdoorFirewallPolicyCustomRule[] | cdktf.IResolvable): void;
    resetCustomRule(): void;
    get customRuleInput(): cdktf.IResolvable | CdnFrontdoorFirewallPolicyCustomRule[] | undefined;
    private _managedRule;
    get managedRule(): CdnFrontdoorFirewallPolicyManagedRuleList;
    putManagedRule(value: CdnFrontdoorFirewallPolicyManagedRule[] | cdktf.IResolvable): void;
    resetManagedRule(): void;
    get managedRuleInput(): cdktf.IResolvable | CdnFrontdoorFirewallPolicyManagedRule[] | undefined;
    private _timeouts;
    get timeouts(): CdnFrontdoorFirewallPolicyTimeoutsOutputReference;
    putTimeouts(value: CdnFrontdoorFirewallPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CdnFrontdoorFirewallPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
