/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CostManagementScheduledActionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#day_of_month CostManagementScheduledAction#day_of_month}
    */
    readonly dayOfMonth?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#days_of_week CostManagementScheduledAction#days_of_week}
    */
    readonly daysOfWeek?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#display_name CostManagementScheduledAction#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#email_address_sender CostManagementScheduledAction#email_address_sender}
    */
    readonly emailAddressSender: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#email_addresses CostManagementScheduledAction#email_addresses}
    */
    readonly emailAddresses: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#email_subject CostManagementScheduledAction#email_subject}
    */
    readonly emailSubject: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#end_date CostManagementScheduledAction#end_date}
    */
    readonly endDate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#frequency CostManagementScheduledAction#frequency}
    */
    readonly frequency: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#hour_of_day CostManagementScheduledAction#hour_of_day}
    */
    readonly hourOfDay?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#id CostManagementScheduledAction#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#message CostManagementScheduledAction#message}
    */
    readonly message?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#name CostManagementScheduledAction#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#start_date CostManagementScheduledAction#start_date}
    */
    readonly startDate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#view_id CostManagementScheduledAction#view_id}
    */
    readonly viewId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#weeks_of_month CostManagementScheduledAction#weeks_of_month}
    */
    readonly weeksOfMonth?: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#timeouts CostManagementScheduledAction#timeouts}
    */
    readonly timeouts?: CostManagementScheduledActionTimeouts;
}
export interface CostManagementScheduledActionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#create CostManagementScheduledAction#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#delete CostManagementScheduledAction#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#read CostManagementScheduledAction#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#update CostManagementScheduledAction#update}
    */
    readonly update?: string;
}
export declare function costManagementScheduledActionTimeoutsToTerraform(struct?: CostManagementScheduledActionTimeouts | cdktf.IResolvable): any;
export declare function costManagementScheduledActionTimeoutsToHclTerraform(struct?: CostManagementScheduledActionTimeouts | cdktf.IResolvable): any;
export declare class CostManagementScheduledActionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CostManagementScheduledActionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CostManagementScheduledActionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action azurerm_cost_management_scheduled_action}
*/
export declare class CostManagementScheduledAction extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cost_management_scheduled_action";
    /**
    * Generates CDKTF code for importing a CostManagementScheduledAction resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CostManagementScheduledAction to import
    * @param importFromId The id of the existing CostManagementScheduledAction that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CostManagementScheduledAction to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/cost_management_scheduled_action azurerm_cost_management_scheduled_action} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CostManagementScheduledActionConfig
    */
    constructor(scope: Construct, id: string, config: CostManagementScheduledActionConfig);
    private _dayOfMonth?;
    get dayOfMonth(): number;
    set dayOfMonth(value: number);
    resetDayOfMonth(): void;
    get dayOfMonthInput(): number | undefined;
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    resetDaysOfWeek(): void;
    get daysOfWeekInput(): string[] | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _emailAddressSender?;
    get emailAddressSender(): string;
    set emailAddressSender(value: string);
    get emailAddressSenderInput(): string | undefined;
    private _emailAddresses?;
    get emailAddresses(): string[];
    set emailAddresses(value: string[]);
    get emailAddressesInput(): string[] | undefined;
    private _emailSubject?;
    get emailSubject(): string;
    set emailSubject(value: string);
    get emailSubjectInput(): string | undefined;
    private _endDate?;
    get endDate(): string;
    set endDate(value: string);
    get endDateInput(): string | undefined;
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    get frequencyInput(): string | undefined;
    private _hourOfDay?;
    get hourOfDay(): number;
    set hourOfDay(value: number);
    resetHourOfDay(): void;
    get hourOfDayInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _message?;
    get message(): string;
    set message(value: string);
    resetMessage(): void;
    get messageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _startDate?;
    get startDate(): string;
    set startDate(value: string);
    get startDateInput(): string | undefined;
    private _viewId?;
    get viewId(): string;
    set viewId(value: string);
    get viewIdInput(): string | undefined;
    private _weeksOfMonth?;
    get weeksOfMonth(): string[];
    set weeksOfMonth(value: string[]);
    resetWeeksOfMonth(): void;
    get weeksOfMonthInput(): string[] | undefined;
    private _timeouts;
    get timeouts(): CostManagementScheduledActionTimeoutsOutputReference;
    putTimeouts(value: CostManagementScheduledActionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CostManagementScheduledActionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
