/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_configuration#id DataAzurermAppConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_configuration#name DataAzurermAppConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_configuration#resource_group_name DataAzurermAppConfiguration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_configuration#timeouts DataAzurermAppConfiguration#timeouts}
    */
    readonly timeouts?: DataAzurermAppConfigurationTimeouts;
}
export interface DataAzurermAppConfigurationEncryption {
}
export declare function dataAzurermAppConfigurationEncryptionToTerraform(struct?: DataAzurermAppConfigurationEncryption): any;
export declare function dataAzurermAppConfigurationEncryptionToHclTerraform(struct?: DataAzurermAppConfigurationEncryption): any;
export declare class DataAzurermAppConfigurationEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppConfigurationEncryption | undefined;
    set internalValue(value: DataAzurermAppConfigurationEncryption | undefined);
    get identityClientId(): string;
    get keyVaultKeyIdentifier(): string;
}
export declare class DataAzurermAppConfigurationEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppConfigurationEncryptionOutputReference;
}
export interface DataAzurermAppConfigurationIdentity {
}
export declare function dataAzurermAppConfigurationIdentityToTerraform(struct?: DataAzurermAppConfigurationIdentity): any;
export declare function dataAzurermAppConfigurationIdentityToHclTerraform(struct?: DataAzurermAppConfigurationIdentity): any;
export declare class DataAzurermAppConfigurationIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppConfigurationIdentity | undefined;
    set internalValue(value: DataAzurermAppConfigurationIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermAppConfigurationIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppConfigurationIdentityOutputReference;
}
export interface DataAzurermAppConfigurationPrimaryReadKey {
}
export declare function dataAzurermAppConfigurationPrimaryReadKeyToTerraform(struct?: DataAzurermAppConfigurationPrimaryReadKey): any;
export declare function dataAzurermAppConfigurationPrimaryReadKeyToHclTerraform(struct?: DataAzurermAppConfigurationPrimaryReadKey): any;
export declare class DataAzurermAppConfigurationPrimaryReadKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppConfigurationPrimaryReadKey | undefined;
    set internalValue(value: DataAzurermAppConfigurationPrimaryReadKey | undefined);
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class DataAzurermAppConfigurationPrimaryReadKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppConfigurationPrimaryReadKeyOutputReference;
}
export interface DataAzurermAppConfigurationPrimaryWriteKey {
}
export declare function dataAzurermAppConfigurationPrimaryWriteKeyToTerraform(struct?: DataAzurermAppConfigurationPrimaryWriteKey): any;
export declare function dataAzurermAppConfigurationPrimaryWriteKeyToHclTerraform(struct?: DataAzurermAppConfigurationPrimaryWriteKey): any;
export declare class DataAzurermAppConfigurationPrimaryWriteKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppConfigurationPrimaryWriteKey | undefined;
    set internalValue(value: DataAzurermAppConfigurationPrimaryWriteKey | undefined);
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class DataAzurermAppConfigurationPrimaryWriteKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppConfigurationPrimaryWriteKeyOutputReference;
}
export interface DataAzurermAppConfigurationReplica {
}
export declare function dataAzurermAppConfigurationReplicaToTerraform(struct?: DataAzurermAppConfigurationReplica): any;
export declare function dataAzurermAppConfigurationReplicaToHclTerraform(struct?: DataAzurermAppConfigurationReplica): any;
export declare class DataAzurermAppConfigurationReplicaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppConfigurationReplica | undefined;
    set internalValue(value: DataAzurermAppConfigurationReplica | undefined);
    get endpoint(): string;
    get id(): string;
    get location(): string;
    get name(): string;
}
export declare class DataAzurermAppConfigurationReplicaList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppConfigurationReplicaOutputReference;
}
export interface DataAzurermAppConfigurationSecondaryReadKey {
}
export declare function dataAzurermAppConfigurationSecondaryReadKeyToTerraform(struct?: DataAzurermAppConfigurationSecondaryReadKey): any;
export declare function dataAzurermAppConfigurationSecondaryReadKeyToHclTerraform(struct?: DataAzurermAppConfigurationSecondaryReadKey): any;
export declare class DataAzurermAppConfigurationSecondaryReadKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppConfigurationSecondaryReadKey | undefined;
    set internalValue(value: DataAzurermAppConfigurationSecondaryReadKey | undefined);
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class DataAzurermAppConfigurationSecondaryReadKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppConfigurationSecondaryReadKeyOutputReference;
}
export interface DataAzurermAppConfigurationSecondaryWriteKey {
}
export declare function dataAzurermAppConfigurationSecondaryWriteKeyToTerraform(struct?: DataAzurermAppConfigurationSecondaryWriteKey): any;
export declare function dataAzurermAppConfigurationSecondaryWriteKeyToHclTerraform(struct?: DataAzurermAppConfigurationSecondaryWriteKey): any;
export declare class DataAzurermAppConfigurationSecondaryWriteKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppConfigurationSecondaryWriteKey | undefined;
    set internalValue(value: DataAzurermAppConfigurationSecondaryWriteKey | undefined);
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class DataAzurermAppConfigurationSecondaryWriteKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppConfigurationSecondaryWriteKeyOutputReference;
}
export interface DataAzurermAppConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_configuration#read DataAzurermAppConfiguration#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppConfigurationTimeoutsToTerraform(struct?: DataAzurermAppConfigurationTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermAppConfigurationTimeoutsToHclTerraform(struct?: DataAzurermAppConfigurationTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermAppConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermAppConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_configuration azurerm_app_configuration}
*/
export declare class DataAzurermAppConfiguration extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_app_configuration";
    /**
    * Generates CDKTF code for importing a DataAzurermAppConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermAppConfiguration to import
    * @param importFromId The id of the existing DataAzurermAppConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermAppConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_configuration azurerm_app_configuration} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppConfigurationConfig);
    private _encryption;
    get encryption(): DataAzurermAppConfigurationEncryptionList;
    get endpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermAppConfigurationIdentityList;
    get localAuthEnabled(): cdktf.IResolvable;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primaryReadKey;
    get primaryReadKey(): DataAzurermAppConfigurationPrimaryReadKeyList;
    private _primaryWriteKey;
    get primaryWriteKey(): DataAzurermAppConfigurationPrimaryWriteKeyList;
    get publicNetworkAccess(): string;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    get purgeProtectionEnabled(): cdktf.IResolvable;
    private _replica;
    get replica(): DataAzurermAppConfigurationReplicaList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _secondaryReadKey;
    get secondaryReadKey(): DataAzurermAppConfigurationSecondaryReadKeyList;
    private _secondaryWriteKey;
    get secondaryWriteKey(): DataAzurermAppConfigurationSecondaryWriteKeyList;
    get sku(): string;
    get softDeleteRetentionDays(): number;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermAppConfigurationTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermAppConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
