/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppServicePlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_service_plan#id DataAzurermAppServicePlan#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_service_plan#name DataAzurermAppServicePlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_service_plan#resource_group_name DataAzurermAppServicePlan#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_service_plan#timeouts DataAzurermAppServicePlan#timeouts}
    */
    readonly timeouts?: DataAzurermAppServicePlanTimeouts;
}
export interface DataAzurermAppServicePlanSku {
}
export declare function dataAzurermAppServicePlanSkuToTerraform(struct?: DataAzurermAppServicePlanSku): any;
export declare function dataAzurermAppServicePlanSkuToHclTerraform(struct?: DataAzurermAppServicePlanSku): any;
export declare class DataAzurermAppServicePlanSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppServicePlanSku | undefined;
    set internalValue(value: DataAzurermAppServicePlanSku | undefined);
    get capacity(): number;
    get size(): string;
    get tier(): string;
}
export declare class DataAzurermAppServicePlanSkuList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppServicePlanSkuOutputReference;
}
export interface DataAzurermAppServicePlanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_service_plan#read DataAzurermAppServicePlan#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppServicePlanTimeoutsToTerraform(struct?: DataAzurermAppServicePlanTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermAppServicePlanTimeoutsToHclTerraform(struct?: DataAzurermAppServicePlanTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppServicePlanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermAppServicePlanTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermAppServicePlanTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_service_plan azurerm_app_service_plan}
*/
export declare class DataAzurermAppServicePlan extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_app_service_plan";
    /**
    * Generates CDKTF code for importing a DataAzurermAppServicePlan resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermAppServicePlan to import
    * @param importFromId The id of the existing DataAzurermAppServicePlan that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_service_plan#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermAppServicePlan to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/app_service_plan azurerm_app_service_plan} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppServicePlanConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppServicePlanConfig);
    get appServiceEnvironmentId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get isXenon(): cdktf.IResolvable;
    get kind(): string;
    get location(): string;
    get maximumElasticWorkerCount(): number;
    get maximumNumberOfWorkers(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get perSiteScaling(): cdktf.IResolvable;
    get reserved(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku;
    get sku(): DataAzurermAppServicePlanSkuList;
    private _tags;
    get tags(): cdktf.StringMap;
    get zoneRedundant(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermAppServicePlanTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppServicePlanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermAppServicePlanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
