/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermContainerRegistryScopeMapConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/container_registry_scope_map#container_registry_name DataAzurermContainerRegistryScopeMap#container_registry_name}
    */
    readonly containerRegistryName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/container_registry_scope_map#id DataAzurermContainerRegistryScopeMap#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/container_registry_scope_map#name DataAzurermContainerRegistryScopeMap#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/container_registry_scope_map#resource_group_name DataAzurermContainerRegistryScopeMap#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/container_registry_scope_map#timeouts DataAzurermContainerRegistryScopeMap#timeouts}
    */
    readonly timeouts?: DataAzurermContainerRegistryScopeMapTimeouts;
}
export interface DataAzurermContainerRegistryScopeMapTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/container_registry_scope_map#read DataAzurermContainerRegistryScopeMap#read}
    */
    readonly read?: string;
}
export declare function dataAzurermContainerRegistryScopeMapTimeoutsToTerraform(struct?: DataAzurermContainerRegistryScopeMapTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermContainerRegistryScopeMapTimeoutsToHclTerraform(struct?: DataAzurermContainerRegistryScopeMapTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermContainerRegistryScopeMapTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermContainerRegistryScopeMapTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermContainerRegistryScopeMapTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/container_registry_scope_map azurerm_container_registry_scope_map}
*/
export declare class DataAzurermContainerRegistryScopeMap extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_container_registry_scope_map";
    /**
    * Generates CDKTF code for importing a DataAzurermContainerRegistryScopeMap resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermContainerRegistryScopeMap to import
    * @param importFromId The id of the existing DataAzurermContainerRegistryScopeMap that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/container_registry_scope_map#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermContainerRegistryScopeMap to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/container_registry_scope_map azurerm_container_registry_scope_map} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermContainerRegistryScopeMapConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermContainerRegistryScopeMapConfig);
    get actions(): string[];
    private _containerRegistryName?;
    get containerRegistryName(): string;
    set containerRegistryName(value: string);
    get containerRegistryNameInput(): string | undefined;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermContainerRegistryScopeMapTimeoutsOutputReference;
    putTimeouts(value: DataAzurermContainerRegistryScopeMapTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermContainerRegistryScopeMapTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
