/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataShareConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/data_share#account_id DataAzurermDataShare#account_id}
    */
    readonly accountId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/data_share#id DataAzurermDataShare#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/data_share#name DataAzurermDataShare#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/data_share#timeouts DataAzurermDataShare#timeouts}
    */
    readonly timeouts?: DataAzurermDataShareTimeouts;
}
export interface DataAzurermDataShareSnapshotSchedule {
}
export declare function dataAzurermDataShareSnapshotScheduleToTerraform(struct?: DataAzurermDataShareSnapshotSchedule): any;
export declare function dataAzurermDataShareSnapshotScheduleToHclTerraform(struct?: DataAzurermDataShareSnapshotSchedule): any;
export declare class DataAzurermDataShareSnapshotScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermDataShareSnapshotSchedule | undefined;
    set internalValue(value: DataAzurermDataShareSnapshotSchedule | undefined);
    get name(): string;
    get recurrence(): string;
    get startTime(): string;
}
export declare class DataAzurermDataShareSnapshotScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermDataShareSnapshotScheduleOutputReference;
}
export interface DataAzurermDataShareTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/data_share#read DataAzurermDataShare#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataShareTimeoutsToTerraform(struct?: DataAzurermDataShareTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDataShareTimeoutsToHclTerraform(struct?: DataAzurermDataShareTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataShareTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDataShareTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDataShareTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/data_share azurerm_data_share}
*/
export declare class DataAzurermDataShare extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_data_share";
    /**
    * Generates CDKTF code for importing a DataAzurermDataShare resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDataShare to import
    * @param importFromId The id of the existing DataAzurermDataShare that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/data_share#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDataShare to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/data_share azurerm_data_share} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataShareConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kind(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _snapshotSchedule;
    get snapshotSchedule(): DataAzurermDataShareSnapshotScheduleList;
    get terms(): string;
    private _timeouts;
    get timeouts(): DataAzurermDataShareTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataShareTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDataShareTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
