/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKeyVaultCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/key_vault_certificate#id DataAzurermKeyVaultCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/key_vault_certificate#key_vault_id DataAzurermKeyVaultCertificate#key_vault_id}
    */
    readonly keyVaultId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/key_vault_certificate#name DataAzurermKeyVaultCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/key_vault_certificate#version DataAzurermKeyVaultCertificate#version}
    */
    readonly version?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/key_vault_certificate#timeouts DataAzurermKeyVaultCertificate#timeouts}
    */
    readonly timeouts?: DataAzurermKeyVaultCertificateTimeouts;
}
export interface DataAzurermKeyVaultCertificateCertificatePolicyIssuerParameters {
}
export declare function dataAzurermKeyVaultCertificateCertificatePolicyIssuerParametersToTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicyIssuerParameters): any;
export declare function dataAzurermKeyVaultCertificateCertificatePolicyIssuerParametersToHclTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicyIssuerParameters): any;
export declare class DataAzurermKeyVaultCertificateCertificatePolicyIssuerParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKeyVaultCertificateCertificatePolicyIssuerParameters | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateCertificatePolicyIssuerParameters | undefined);
    get name(): string;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyIssuerParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKeyVaultCertificateCertificatePolicyIssuerParametersOutputReference;
}
export interface DataAzurermKeyVaultCertificateCertificatePolicyKeyProperties {
}
export declare function dataAzurermKeyVaultCertificateCertificatePolicyKeyPropertiesToTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicyKeyProperties): any;
export declare function dataAzurermKeyVaultCertificateCertificatePolicyKeyPropertiesToHclTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicyKeyProperties): any;
export declare class DataAzurermKeyVaultCertificateCertificatePolicyKeyPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKeyVaultCertificateCertificatePolicyKeyProperties | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateCertificatePolicyKeyProperties | undefined);
    get curve(): string;
    get exportable(): cdktf.IResolvable;
    get keySize(): number;
    get keyType(): string;
    get reuseKey(): cdktf.IResolvable;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyKeyPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKeyVaultCertificateCertificatePolicyKeyPropertiesOutputReference;
}
export interface DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionAction {
}
export declare function dataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionActionToTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionAction): any;
export declare function dataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionActionToHclTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionAction): any;
export declare class DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionAction | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionAction | undefined);
    get actionType(): string;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionActionOutputReference;
}
export interface DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionTrigger {
}
export declare function dataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionTriggerToTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionTrigger): any;
export declare function dataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionTriggerToHclTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionTrigger): any;
export declare class DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionTrigger | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionTrigger | undefined);
    get daysBeforeExpiry(): number;
    get lifetimePercentage(): number;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionTriggerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionTriggerOutputReference;
}
export interface DataAzurermKeyVaultCertificateCertificatePolicyLifetimeAction {
}
export declare function dataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionToTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicyLifetimeAction): any;
export declare function dataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionToHclTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicyLifetimeAction): any;
export declare class DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKeyVaultCertificateCertificatePolicyLifetimeAction | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateCertificatePolicyLifetimeAction | undefined);
    private _action;
    get action(): DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionActionList;
    private _trigger;
    get trigger(): DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionTriggerList;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionOutputReference;
}
export interface DataAzurermKeyVaultCertificateCertificatePolicySecretProperties {
}
export declare function dataAzurermKeyVaultCertificateCertificatePolicySecretPropertiesToTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicySecretProperties): any;
export declare function dataAzurermKeyVaultCertificateCertificatePolicySecretPropertiesToHclTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicySecretProperties): any;
export declare class DataAzurermKeyVaultCertificateCertificatePolicySecretPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKeyVaultCertificateCertificatePolicySecretProperties | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateCertificatePolicySecretProperties | undefined);
    get contentType(): string;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicySecretPropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKeyVaultCertificateCertificatePolicySecretPropertiesOutputReference;
}
export interface DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames {
}
export declare function dataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesToTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames): any;
export declare function dataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesToHclTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames): any;
export declare class DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNames | undefined);
    get dnsNames(): string[];
    get emails(): string[];
    get upns(): string[];
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesOutputReference;
}
export interface DataAzurermKeyVaultCertificateCertificatePolicyX509CertificateProperties {
}
export declare function dataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesToTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicyX509CertificateProperties): any;
export declare function dataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesToHclTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicyX509CertificateProperties): any;
export declare class DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKeyVaultCertificateCertificatePolicyX509CertificateProperties | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateCertificatePolicyX509CertificateProperties | undefined);
    get extendedKeyUsage(): string[];
    get keyUsage(): string[];
    get subject(): string;
    private _subjectAlternativeNames;
    get subjectAlternativeNames(): DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesSubjectAlternativeNamesList;
    get validityInMonths(): number;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesOutputReference;
}
export interface DataAzurermKeyVaultCertificateCertificatePolicy {
}
export declare function dataAzurermKeyVaultCertificateCertificatePolicyToTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicy): any;
export declare function dataAzurermKeyVaultCertificateCertificatePolicyToHclTerraform(struct?: DataAzurermKeyVaultCertificateCertificatePolicy): any;
export declare class DataAzurermKeyVaultCertificateCertificatePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKeyVaultCertificateCertificatePolicy | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateCertificatePolicy | undefined);
    private _issuerParameters;
    get issuerParameters(): DataAzurermKeyVaultCertificateCertificatePolicyIssuerParametersList;
    private _keyProperties;
    get keyProperties(): DataAzurermKeyVaultCertificateCertificatePolicyKeyPropertiesList;
    private _lifetimeAction;
    get lifetimeAction(): DataAzurermKeyVaultCertificateCertificatePolicyLifetimeActionList;
    private _secretProperties;
    get secretProperties(): DataAzurermKeyVaultCertificateCertificatePolicySecretPropertiesList;
    private _x509CertificateProperties;
    get x509CertificateProperties(): DataAzurermKeyVaultCertificateCertificatePolicyX509CertificatePropertiesList;
}
export declare class DataAzurermKeyVaultCertificateCertificatePolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKeyVaultCertificateCertificatePolicyOutputReference;
}
export interface DataAzurermKeyVaultCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/key_vault_certificate#read DataAzurermKeyVaultCertificate#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultCertificateTimeoutsToTerraform(struct?: DataAzurermKeyVaultCertificateTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermKeyVaultCertificateTimeoutsToHclTerraform(struct?: DataAzurermKeyVaultCertificateTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKeyVaultCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKeyVaultCertificateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermKeyVaultCertificateTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/key_vault_certificate azurerm_key_vault_certificate}
*/
export declare class DataAzurermKeyVaultCertificate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_key_vault_certificate";
    /**
    * Generates CDKTF code for importing a DataAzurermKeyVaultCertificate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermKeyVaultCertificate to import
    * @param importFromId The id of the existing DataAzurermKeyVaultCertificate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/key_vault_certificate#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermKeyVaultCertificate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/key_vault_certificate azurerm_key_vault_certificate} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKeyVaultCertificateConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultCertificateConfig);
    get certificateData(): string;
    get certificateDataBase64(): string;
    private _certificatePolicy;
    get certificatePolicy(): DataAzurermKeyVaultCertificateCertificatePolicyList;
    get expires(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get notBefore(): string;
    get resourceManagerId(): string;
    get resourceManagerVersionlessId(): string;
    get secretId(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get thumbprint(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    get versionlessId(): string;
    get versionlessSecretId(): string;
    private _timeouts;
    get timeouts(): DataAzurermKeyVaultCertificateTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKeyVaultCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermKeyVaultCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
