/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKustoClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/kusto_cluster#id DataAzurermKustoCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/kusto_cluster#name DataAzurermKustoCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/kusto_cluster#resource_group_name DataAzurermKustoCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/kusto_cluster#timeouts DataAzurermKustoCluster#timeouts}
    */
    readonly timeouts?: DataAzurermKustoClusterTimeouts;
}
export interface DataAzurermKustoClusterIdentity {
}
export declare function dataAzurermKustoClusterIdentityToTerraform(struct?: DataAzurermKustoClusterIdentity): any;
export declare function dataAzurermKustoClusterIdentityToHclTerraform(struct?: DataAzurermKustoClusterIdentity): any;
export declare class DataAzurermKustoClusterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermKustoClusterIdentity | undefined;
    set internalValue(value: DataAzurermKustoClusterIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermKustoClusterIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermKustoClusterIdentityOutputReference;
}
export interface DataAzurermKustoClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/kusto_cluster#read DataAzurermKustoCluster#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKustoClusterTimeoutsToTerraform(struct?: DataAzurermKustoClusterTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermKustoClusterTimeoutsToHclTerraform(struct?: DataAzurermKustoClusterTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKustoClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKustoClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermKustoClusterTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/kusto_cluster azurerm_kusto_cluster}
*/
export declare class DataAzurermKustoCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_kusto_cluster";
    /**
    * Generates CDKTF code for importing a DataAzurermKustoCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermKustoCluster to import
    * @param importFromId The id of the existing DataAzurermKustoCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/kusto_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermKustoCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/kusto_cluster azurerm_kusto_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKustoClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKustoClusterConfig);
    get dataIngestionUri(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermKustoClusterIdentityList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get uri(): string;
    private _timeouts;
    get timeouts(): DataAzurermKustoClusterTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKustoClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermKustoClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
