/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLinuxWebAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/linux_web_app#id DataAzurermLinuxWebApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/linux_web_app#name DataAzurermLinuxWebApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/linux_web_app#resource_group_name DataAzurermLinuxWebApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/linux_web_app#timeouts DataAzurermLinuxWebApp#timeouts}
    */
    readonly timeouts?: DataAzurermLinuxWebAppTimeouts;
}
export interface DataAzurermLinuxWebAppAuthSettingsActiveDirectory {
}
export declare function dataAzurermLinuxWebAppAuthSettingsActiveDirectoryToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsActiveDirectory): any;
export declare function dataAzurermLinuxWebAppAuthSettingsActiveDirectoryToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsActiveDirectory): any;
export declare class DataAzurermLinuxWebAppAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsActiveDirectory | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsActiveDirectory | undefined);
    get allowedAudiences(): string[];
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
}
export declare class DataAzurermLinuxWebAppAuthSettingsActiveDirectoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsActiveDirectoryOutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsFacebook {
}
export declare function dataAzurermLinuxWebAppAuthSettingsFacebookToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsFacebook): any;
export declare function dataAzurermLinuxWebAppAuthSettingsFacebookToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsFacebook): any;
export declare class DataAzurermLinuxWebAppAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsFacebook | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsFacebook | undefined);
    get appId(): string;
    get appSecret(): string;
    get appSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermLinuxWebAppAuthSettingsFacebookList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsFacebookOutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsGithub {
}
export declare function dataAzurermLinuxWebAppAuthSettingsGithubToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsGithub): any;
export declare function dataAzurermLinuxWebAppAuthSettingsGithubToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsGithub): any;
export declare class DataAzurermLinuxWebAppAuthSettingsGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsGithub | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsGithub | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermLinuxWebAppAuthSettingsGithubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsGithubOutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsGoogle {
}
export declare function dataAzurermLinuxWebAppAuthSettingsGoogleToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsGoogle): any;
export declare function dataAzurermLinuxWebAppAuthSettingsGoogleToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsGoogle): any;
export declare class DataAzurermLinuxWebAppAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsGoogle | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsGoogle | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermLinuxWebAppAuthSettingsGoogleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsGoogleOutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsMicrosoft {
}
export declare function dataAzurermLinuxWebAppAuthSettingsMicrosoftToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsMicrosoft): any;
export declare function dataAzurermLinuxWebAppAuthSettingsMicrosoftToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsMicrosoft): any;
export declare class DataAzurermLinuxWebAppAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsMicrosoft | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsMicrosoft | undefined);
    get clientId(): string;
    get clientSecret(): string;
    get clientSecretSettingName(): string;
    get oauthScopes(): string[];
}
export declare class DataAzurermLinuxWebAppAuthSettingsMicrosoftList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsMicrosoftOutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsTwitter {
}
export declare function dataAzurermLinuxWebAppAuthSettingsTwitterToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsTwitter): any;
export declare function dataAzurermLinuxWebAppAuthSettingsTwitterToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsTwitter): any;
export declare class DataAzurermLinuxWebAppAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsTwitter | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsTwitter | undefined);
    get consumerKey(): string;
    get consumerSecret(): string;
    get consumerSecretSettingName(): string;
}
export declare class DataAzurermLinuxWebAppAuthSettingsTwitterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsTwitterOutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettings {
}
export declare function dataAzurermLinuxWebAppAuthSettingsToTerraform(struct?: DataAzurermLinuxWebAppAuthSettings): any;
export declare function dataAzurermLinuxWebAppAuthSettingsToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettings): any;
export declare class DataAzurermLinuxWebAppAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettings | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettings | undefined);
    private _activeDirectory;
    get activeDirectory(): DataAzurermLinuxWebAppAuthSettingsActiveDirectoryList;
    private _additionalLoginParameters;
    get additionalLoginParameters(): cdktf.StringMap;
    get allowedExternalRedirectUrls(): string[];
    get defaultProvider(): string;
    get enabled(): cdktf.IResolvable;
    private _facebook;
    get facebook(): DataAzurermLinuxWebAppAuthSettingsFacebookList;
    private _github;
    get github(): DataAzurermLinuxWebAppAuthSettingsGithubList;
    private _google;
    get google(): DataAzurermLinuxWebAppAuthSettingsGoogleList;
    get issuer(): string;
    private _microsoft;
    get microsoft(): DataAzurermLinuxWebAppAuthSettingsMicrosoftList;
    get runtimeVersion(): string;
    get tokenRefreshExtensionHours(): number;
    get tokenStoreEnabled(): cdktf.IResolvable;
    private _twitter;
    get twitter(): DataAzurermLinuxWebAppAuthSettingsTwitterList;
    get unauthenticatedClientAction(): string;
}
export declare class DataAzurermLinuxWebAppAuthSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsOutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsV2ActiveDirectoryV2 {
}
export declare function dataAzurermLinuxWebAppAuthSettingsV2ActiveDirectoryV2ToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2ActiveDirectoryV2): any;
export declare function dataAzurermLinuxWebAppAuthSettingsV2ActiveDirectoryV2ToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2ActiveDirectoryV2): any;
export declare class DataAzurermLinuxWebAppAuthSettingsV2ActiveDirectoryV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsV2ActiveDirectoryV2 | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsV2ActiveDirectoryV2 | undefined);
    get allowedApplications(): string[];
    get allowedAudiences(): string[];
    get allowedGroups(): string[];
    get allowedIdentities(): string[];
    get clientId(): string;
    get clientSecretCertificateThumbprint(): string;
    get clientSecretSettingName(): string;
    get jwtAllowedClientApplications(): string[];
    get jwtAllowedGroups(): string[];
    private _loginParameters;
    get loginParameters(): cdktf.StringMap;
    get tenantAuthEndpoint(): string;
    get wwwAuthenticationDisabled(): cdktf.IResolvable;
}
export declare class DataAzurermLinuxWebAppAuthSettingsV2ActiveDirectoryV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsV2ActiveDirectoryV2OutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsV2AppleV2 {
}
export declare function dataAzurermLinuxWebAppAuthSettingsV2AppleV2ToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2AppleV2): any;
export declare function dataAzurermLinuxWebAppAuthSettingsV2AppleV2ToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2AppleV2): any;
export declare class DataAzurermLinuxWebAppAuthSettingsV2AppleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsV2AppleV2 | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsV2AppleV2 | undefined);
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermLinuxWebAppAuthSettingsV2AppleV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsV2AppleV2OutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsV2AzureStaticWebAppV2 {
}
export declare function dataAzurermLinuxWebAppAuthSettingsV2AzureStaticWebAppV2ToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2AzureStaticWebAppV2): any;
export declare function dataAzurermLinuxWebAppAuthSettingsV2AzureStaticWebAppV2ToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2AzureStaticWebAppV2): any;
export declare class DataAzurermLinuxWebAppAuthSettingsV2AzureStaticWebAppV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsV2AzureStaticWebAppV2 | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsV2AzureStaticWebAppV2 | undefined);
    get clientId(): string;
}
export declare class DataAzurermLinuxWebAppAuthSettingsV2AzureStaticWebAppV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsV2AzureStaticWebAppV2OutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsV2CustomOidcV2 {
}
export declare function dataAzurermLinuxWebAppAuthSettingsV2CustomOidcV2ToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2CustomOidcV2): any;
export declare function dataAzurermLinuxWebAppAuthSettingsV2CustomOidcV2ToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2CustomOidcV2): any;
export declare class DataAzurermLinuxWebAppAuthSettingsV2CustomOidcV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsV2CustomOidcV2 | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsV2CustomOidcV2 | undefined);
    get authorisationEndpoint(): string;
    get certificationUri(): string;
    get clientCredentialMethod(): string;
    get clientId(): string;
    get clientSecretSettingName(): string;
    get issuerEndpoint(): string;
    get name(): string;
    get nameClaimType(): string;
    get openidConfigurationEndpoint(): string;
    get scopes(): string[];
    get tokenEndpoint(): string;
}
export declare class DataAzurermLinuxWebAppAuthSettingsV2CustomOidcV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsV2CustomOidcV2OutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsV2FacebookV2 {
}
export declare function dataAzurermLinuxWebAppAuthSettingsV2FacebookV2ToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2FacebookV2): any;
export declare function dataAzurermLinuxWebAppAuthSettingsV2FacebookV2ToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2FacebookV2): any;
export declare class DataAzurermLinuxWebAppAuthSettingsV2FacebookV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsV2FacebookV2 | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsV2FacebookV2 | undefined);
    get appId(): string;
    get appSecretSettingName(): string;
    get graphApiVersion(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermLinuxWebAppAuthSettingsV2FacebookV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsV2FacebookV2OutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsV2GithubV2 {
}
export declare function dataAzurermLinuxWebAppAuthSettingsV2GithubV2ToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2GithubV2): any;
export declare function dataAzurermLinuxWebAppAuthSettingsV2GithubV2ToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2GithubV2): any;
export declare class DataAzurermLinuxWebAppAuthSettingsV2GithubV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsV2GithubV2 | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsV2GithubV2 | undefined);
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermLinuxWebAppAuthSettingsV2GithubV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsV2GithubV2OutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsV2GoogleV2 {
}
export declare function dataAzurermLinuxWebAppAuthSettingsV2GoogleV2ToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2GoogleV2): any;
export declare function dataAzurermLinuxWebAppAuthSettingsV2GoogleV2ToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2GoogleV2): any;
export declare class DataAzurermLinuxWebAppAuthSettingsV2GoogleV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsV2GoogleV2 | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsV2GoogleV2 | undefined);
    get allowedAudiences(): string[];
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermLinuxWebAppAuthSettingsV2GoogleV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsV2GoogleV2OutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsV2Login {
}
export declare function dataAzurermLinuxWebAppAuthSettingsV2LoginToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2Login): any;
export declare function dataAzurermLinuxWebAppAuthSettingsV2LoginToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2Login): any;
export declare class DataAzurermLinuxWebAppAuthSettingsV2LoginOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsV2Login | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsV2Login | undefined);
    get allowedExternalRedirectUrls(): string[];
    get cookieExpirationConvention(): string;
    get cookieExpirationTime(): string;
    get logoutEndpoint(): string;
    get nonceExpirationTime(): string;
    get preserveUrlFragmentsForLogins(): cdktf.IResolvable;
    get tokenRefreshExtensionTime(): number;
    get tokenStoreEnabled(): cdktf.IResolvable;
    get tokenStorePath(): string;
    get tokenStoreSasSettingName(): string;
    get validateNonce(): cdktf.IResolvable;
}
export declare class DataAzurermLinuxWebAppAuthSettingsV2LoginList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsV2LoginOutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsV2MicrosoftV2 {
}
export declare function dataAzurermLinuxWebAppAuthSettingsV2MicrosoftV2ToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2MicrosoftV2): any;
export declare function dataAzurermLinuxWebAppAuthSettingsV2MicrosoftV2ToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2MicrosoftV2): any;
export declare class DataAzurermLinuxWebAppAuthSettingsV2MicrosoftV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsV2MicrosoftV2 | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsV2MicrosoftV2 | undefined);
    get allowedAudiences(): string[];
    get clientId(): string;
    get clientSecretSettingName(): string;
    get loginScopes(): string[];
}
export declare class DataAzurermLinuxWebAppAuthSettingsV2MicrosoftV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsV2MicrosoftV2OutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsV2TwitterV2 {
}
export declare function dataAzurermLinuxWebAppAuthSettingsV2TwitterV2ToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2TwitterV2): any;
export declare function dataAzurermLinuxWebAppAuthSettingsV2TwitterV2ToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2TwitterV2): any;
export declare class DataAzurermLinuxWebAppAuthSettingsV2TwitterV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsV2TwitterV2 | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsV2TwitterV2 | undefined);
    get consumerKey(): string;
    get consumerSecretSettingName(): string;
}
export declare class DataAzurermLinuxWebAppAuthSettingsV2TwitterV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsV2TwitterV2OutputReference;
}
export interface DataAzurermLinuxWebAppAuthSettingsV2 {
}
export declare function dataAzurermLinuxWebAppAuthSettingsV2ToTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2): any;
export declare function dataAzurermLinuxWebAppAuthSettingsV2ToHclTerraform(struct?: DataAzurermLinuxWebAppAuthSettingsV2): any;
export declare class DataAzurermLinuxWebAppAuthSettingsV2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppAuthSettingsV2 | undefined;
    set internalValue(value: DataAzurermLinuxWebAppAuthSettingsV2 | undefined);
    private _activeDirectoryV2;
    get activeDirectoryV2(): DataAzurermLinuxWebAppAuthSettingsV2ActiveDirectoryV2List;
    private _appleV2;
    get appleV2(): DataAzurermLinuxWebAppAuthSettingsV2AppleV2List;
    get authEnabled(): cdktf.IResolvable;
    private _azureStaticWebAppV2;
    get azureStaticWebAppV2(): DataAzurermLinuxWebAppAuthSettingsV2AzureStaticWebAppV2List;
    get configFilePath(): string;
    private _customOidcV2;
    get customOidcV2(): DataAzurermLinuxWebAppAuthSettingsV2CustomOidcV2List;
    get defaultProvider(): string;
    get excludedPaths(): string[];
    private _facebookV2;
    get facebookV2(): DataAzurermLinuxWebAppAuthSettingsV2FacebookV2List;
    get forwardProxyConvention(): string;
    get forwardProxyCustomHostHeaderName(): string;
    get forwardProxyCustomSchemeHeaderName(): string;
    private _githubV2;
    get githubV2(): DataAzurermLinuxWebAppAuthSettingsV2GithubV2List;
    private _googleV2;
    get googleV2(): DataAzurermLinuxWebAppAuthSettingsV2GoogleV2List;
    get httpRouteApiPrefix(): string;
    private _login;
    get login(): DataAzurermLinuxWebAppAuthSettingsV2LoginList;
    private _microsoftV2;
    get microsoftV2(): DataAzurermLinuxWebAppAuthSettingsV2MicrosoftV2List;
    get requireAuthentication(): cdktf.IResolvable;
    get requireHttps(): cdktf.IResolvable;
    get runtimeVersion(): string;
    private _twitterV2;
    get twitterV2(): DataAzurermLinuxWebAppAuthSettingsV2TwitterV2List;
    get unauthenticatedAction(): string;
}
export declare class DataAzurermLinuxWebAppAuthSettingsV2List extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppAuthSettingsV2OutputReference;
}
export interface DataAzurermLinuxWebAppBackupSchedule {
}
export declare function dataAzurermLinuxWebAppBackupScheduleToTerraform(struct?: DataAzurermLinuxWebAppBackupSchedule): any;
export declare function dataAzurermLinuxWebAppBackupScheduleToHclTerraform(struct?: DataAzurermLinuxWebAppBackupSchedule): any;
export declare class DataAzurermLinuxWebAppBackupScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppBackupSchedule | undefined;
    set internalValue(value: DataAzurermLinuxWebAppBackupSchedule | undefined);
    get frequencyInterval(): number;
    get frequencyUnit(): string;
    get keepAtLeastOneBackup(): cdktf.IResolvable;
    get lastExecutionTime(): string;
    get retentionPeriodDays(): number;
    get startTime(): string;
}
export declare class DataAzurermLinuxWebAppBackupScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppBackupScheduleOutputReference;
}
export interface DataAzurermLinuxWebAppBackup {
}
export declare function dataAzurermLinuxWebAppBackupToTerraform(struct?: DataAzurermLinuxWebAppBackup): any;
export declare function dataAzurermLinuxWebAppBackupToHclTerraform(struct?: DataAzurermLinuxWebAppBackup): any;
export declare class DataAzurermLinuxWebAppBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppBackup | undefined;
    set internalValue(value: DataAzurermLinuxWebAppBackup | undefined);
    get enabled(): cdktf.IResolvable;
    get name(): string;
    private _schedule;
    get schedule(): DataAzurermLinuxWebAppBackupScheduleList;
    get storageAccountUrl(): string;
}
export declare class DataAzurermLinuxWebAppBackupList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppBackupOutputReference;
}
export interface DataAzurermLinuxWebAppConnectionString {
}
export declare function dataAzurermLinuxWebAppConnectionStringToTerraform(struct?: DataAzurermLinuxWebAppConnectionString): any;
export declare function dataAzurermLinuxWebAppConnectionStringToHclTerraform(struct?: DataAzurermLinuxWebAppConnectionString): any;
export declare class DataAzurermLinuxWebAppConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppConnectionString | undefined;
    set internalValue(value: DataAzurermLinuxWebAppConnectionString | undefined);
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class DataAzurermLinuxWebAppConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppConnectionStringOutputReference;
}
export interface DataAzurermLinuxWebAppIdentity {
}
export declare function dataAzurermLinuxWebAppIdentityToTerraform(struct?: DataAzurermLinuxWebAppIdentity): any;
export declare function dataAzurermLinuxWebAppIdentityToHclTerraform(struct?: DataAzurermLinuxWebAppIdentity): any;
export declare class DataAzurermLinuxWebAppIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppIdentity | undefined;
    set internalValue(value: DataAzurermLinuxWebAppIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermLinuxWebAppIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppIdentityOutputReference;
}
export interface DataAzurermLinuxWebAppLogsApplicationLogsAzureBlobStorage {
}
export declare function dataAzurermLinuxWebAppLogsApplicationLogsAzureBlobStorageToTerraform(struct?: DataAzurermLinuxWebAppLogsApplicationLogsAzureBlobStorage): any;
export declare function dataAzurermLinuxWebAppLogsApplicationLogsAzureBlobStorageToHclTerraform(struct?: DataAzurermLinuxWebAppLogsApplicationLogsAzureBlobStorage): any;
export declare class DataAzurermLinuxWebAppLogsApplicationLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppLogsApplicationLogsAzureBlobStorage | undefined;
    set internalValue(value: DataAzurermLinuxWebAppLogsApplicationLogsAzureBlobStorage | undefined);
    get level(): string;
    get retentionInDays(): number;
    get sasUrl(): string;
}
export declare class DataAzurermLinuxWebAppLogsApplicationLogsAzureBlobStorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppLogsApplicationLogsAzureBlobStorageOutputReference;
}
export interface DataAzurermLinuxWebAppLogsApplicationLogs {
}
export declare function dataAzurermLinuxWebAppLogsApplicationLogsToTerraform(struct?: DataAzurermLinuxWebAppLogsApplicationLogs): any;
export declare function dataAzurermLinuxWebAppLogsApplicationLogsToHclTerraform(struct?: DataAzurermLinuxWebAppLogsApplicationLogs): any;
export declare class DataAzurermLinuxWebAppLogsApplicationLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppLogsApplicationLogs | undefined;
    set internalValue(value: DataAzurermLinuxWebAppLogsApplicationLogs | undefined);
    private _azureBlobStorage;
    get azureBlobStorage(): DataAzurermLinuxWebAppLogsApplicationLogsAzureBlobStorageList;
    get fileSystemLevel(): string;
}
export declare class DataAzurermLinuxWebAppLogsApplicationLogsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppLogsApplicationLogsOutputReference;
}
export interface DataAzurermLinuxWebAppLogsHttpLogsAzureBlobStorage {
}
export declare function dataAzurermLinuxWebAppLogsHttpLogsAzureBlobStorageToTerraform(struct?: DataAzurermLinuxWebAppLogsHttpLogsAzureBlobStorage): any;
export declare function dataAzurermLinuxWebAppLogsHttpLogsAzureBlobStorageToHclTerraform(struct?: DataAzurermLinuxWebAppLogsHttpLogsAzureBlobStorage): any;
export declare class DataAzurermLinuxWebAppLogsHttpLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppLogsHttpLogsAzureBlobStorage | undefined;
    set internalValue(value: DataAzurermLinuxWebAppLogsHttpLogsAzureBlobStorage | undefined);
    get retentionInDays(): number;
    get sasUrl(): string;
}
export declare class DataAzurermLinuxWebAppLogsHttpLogsAzureBlobStorageList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppLogsHttpLogsAzureBlobStorageOutputReference;
}
export interface DataAzurermLinuxWebAppLogsHttpLogsFileSystem {
}
export declare function dataAzurermLinuxWebAppLogsHttpLogsFileSystemToTerraform(struct?: DataAzurermLinuxWebAppLogsHttpLogsFileSystem): any;
export declare function dataAzurermLinuxWebAppLogsHttpLogsFileSystemToHclTerraform(struct?: DataAzurermLinuxWebAppLogsHttpLogsFileSystem): any;
export declare class DataAzurermLinuxWebAppLogsHttpLogsFileSystemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppLogsHttpLogsFileSystem | undefined;
    set internalValue(value: DataAzurermLinuxWebAppLogsHttpLogsFileSystem | undefined);
    get retentionInDays(): number;
    get retentionInMb(): number;
}
export declare class DataAzurermLinuxWebAppLogsHttpLogsFileSystemList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppLogsHttpLogsFileSystemOutputReference;
}
export interface DataAzurermLinuxWebAppLogsHttpLogs {
}
export declare function dataAzurermLinuxWebAppLogsHttpLogsToTerraform(struct?: DataAzurermLinuxWebAppLogsHttpLogs): any;
export declare function dataAzurermLinuxWebAppLogsHttpLogsToHclTerraform(struct?: DataAzurermLinuxWebAppLogsHttpLogs): any;
export declare class DataAzurermLinuxWebAppLogsHttpLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppLogsHttpLogs | undefined;
    set internalValue(value: DataAzurermLinuxWebAppLogsHttpLogs | undefined);
    private _azureBlobStorage;
    get azureBlobStorage(): DataAzurermLinuxWebAppLogsHttpLogsAzureBlobStorageList;
    private _fileSystem;
    get fileSystem(): DataAzurermLinuxWebAppLogsHttpLogsFileSystemList;
}
export declare class DataAzurermLinuxWebAppLogsHttpLogsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppLogsHttpLogsOutputReference;
}
export interface DataAzurermLinuxWebAppLogs {
}
export declare function dataAzurermLinuxWebAppLogsToTerraform(struct?: DataAzurermLinuxWebAppLogs): any;
export declare function dataAzurermLinuxWebAppLogsToHclTerraform(struct?: DataAzurermLinuxWebAppLogs): any;
export declare class DataAzurermLinuxWebAppLogsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppLogs | undefined;
    set internalValue(value: DataAzurermLinuxWebAppLogs | undefined);
    private _applicationLogs;
    get applicationLogs(): DataAzurermLinuxWebAppLogsApplicationLogsList;
    get detailedErrorMessages(): cdktf.IResolvable;
    get failedRequestTracing(): cdktf.IResolvable;
    private _httpLogs;
    get httpLogs(): DataAzurermLinuxWebAppLogsHttpLogsList;
}
export declare class DataAzurermLinuxWebAppLogsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppLogsOutputReference;
}
export interface DataAzurermLinuxWebAppSiteConfigApplicationStack {
}
export declare function dataAzurermLinuxWebAppSiteConfigApplicationStackToTerraform(struct?: DataAzurermLinuxWebAppSiteConfigApplicationStack): any;
export declare function dataAzurermLinuxWebAppSiteConfigApplicationStackToHclTerraform(struct?: DataAzurermLinuxWebAppSiteConfigApplicationStack): any;
export declare class DataAzurermLinuxWebAppSiteConfigApplicationStackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppSiteConfigApplicationStack | undefined;
    set internalValue(value: DataAzurermLinuxWebAppSiteConfigApplicationStack | undefined);
    get dockerImage(): string;
    get dockerImageName(): string;
    get dockerImageTag(): string;
    get dockerRegistryPassword(): string;
    get dockerRegistryUrl(): string;
    get dockerRegistryUsername(): string;
    get dotnetVersion(): string;
    get goVersion(): string;
    get javaServer(): string;
    get javaServerVersion(): string;
    get javaVersion(): string;
    get nodeVersion(): string;
    get phpVersion(): string;
    get pythonVersion(): string;
    get rubyVersion(): string;
}
export declare class DataAzurermLinuxWebAppSiteConfigApplicationStackList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppSiteConfigApplicationStackOutputReference;
}
export interface DataAzurermLinuxWebAppSiteConfigAutoHealSettingAction {
}
export declare function dataAzurermLinuxWebAppSiteConfigAutoHealSettingActionToTerraform(struct?: DataAzurermLinuxWebAppSiteConfigAutoHealSettingAction): any;
export declare function dataAzurermLinuxWebAppSiteConfigAutoHealSettingActionToHclTerraform(struct?: DataAzurermLinuxWebAppSiteConfigAutoHealSettingAction): any;
export declare class DataAzurermLinuxWebAppSiteConfigAutoHealSettingActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppSiteConfigAutoHealSettingAction | undefined;
    set internalValue(value: DataAzurermLinuxWebAppSiteConfigAutoHealSettingAction | undefined);
    get actionType(): string;
    get minimumProcessExecutionTime(): string;
}
export declare class DataAzurermLinuxWebAppSiteConfigAutoHealSettingActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppSiteConfigAutoHealSettingActionOutputReference;
}
export interface DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerRequests {
}
export declare function dataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerRequestsToTerraform(struct?: DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerRequests): any;
export declare function dataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerRequestsToHclTerraform(struct?: DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerRequests): any;
export declare class DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerRequestsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerRequests | undefined;
    set internalValue(value: DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerRequests | undefined);
    get count(): number;
    get interval(): string;
}
export declare class DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerRequestsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerRequestsOutputReference;
}
export interface DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequest {
}
export declare function dataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequestToTerraform(struct?: DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequest): any;
export declare function dataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequestToHclTerraform(struct?: DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequest): any;
export declare class DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequest | undefined;
    set internalValue(value: DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequest | undefined);
    get count(): number;
    get interval(): string;
    get path(): string;
    get timeTaken(): string;
}
export declare class DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequestList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequestOutputReference;
}
export interface DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerStatusCode {
}
export declare function dataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerStatusCodeToTerraform(struct?: DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerStatusCode): any;
export declare function dataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerStatusCodeToHclTerraform(struct?: DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerStatusCode): any;
export declare class DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerStatusCodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerStatusCode | undefined;
    set internalValue(value: DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerStatusCode | undefined);
    get count(): number;
    get interval(): string;
    get path(): string;
    get statusCodeRange(): string;
    get subStatus(): number;
    get win32StatusCode(): number;
}
export declare class DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerStatusCodeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerStatusCodeOutputReference;
}
export interface DataAzurermLinuxWebAppSiteConfigAutoHealSettingTrigger {
}
export declare function dataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerToTerraform(struct?: DataAzurermLinuxWebAppSiteConfigAutoHealSettingTrigger): any;
export declare function dataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerToHclTerraform(struct?: DataAzurermLinuxWebAppSiteConfigAutoHealSettingTrigger): any;
export declare class DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppSiteConfigAutoHealSettingTrigger | undefined;
    set internalValue(value: DataAzurermLinuxWebAppSiteConfigAutoHealSettingTrigger | undefined);
    private _requests;
    get requests(): DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerRequestsList;
    private _slowRequest;
    get slowRequest(): DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerSlowRequestList;
    private _statusCode;
    get statusCode(): DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerStatusCodeList;
}
export declare class DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerOutputReference;
}
export interface DataAzurermLinuxWebAppSiteConfigAutoHealSetting {
}
export declare function dataAzurermLinuxWebAppSiteConfigAutoHealSettingToTerraform(struct?: DataAzurermLinuxWebAppSiteConfigAutoHealSetting): any;
export declare function dataAzurermLinuxWebAppSiteConfigAutoHealSettingToHclTerraform(struct?: DataAzurermLinuxWebAppSiteConfigAutoHealSetting): any;
export declare class DataAzurermLinuxWebAppSiteConfigAutoHealSettingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppSiteConfigAutoHealSetting | undefined;
    set internalValue(value: DataAzurermLinuxWebAppSiteConfigAutoHealSetting | undefined);
    private _action;
    get action(): DataAzurermLinuxWebAppSiteConfigAutoHealSettingActionList;
    private _trigger;
    get trigger(): DataAzurermLinuxWebAppSiteConfigAutoHealSettingTriggerList;
}
export declare class DataAzurermLinuxWebAppSiteConfigAutoHealSettingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppSiteConfigAutoHealSettingOutputReference;
}
export interface DataAzurermLinuxWebAppSiteConfigCors {
}
export declare function dataAzurermLinuxWebAppSiteConfigCorsToTerraform(struct?: DataAzurermLinuxWebAppSiteConfigCors): any;
export declare function dataAzurermLinuxWebAppSiteConfigCorsToHclTerraform(struct?: DataAzurermLinuxWebAppSiteConfigCors): any;
export declare class DataAzurermLinuxWebAppSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppSiteConfigCors | undefined;
    set internalValue(value: DataAzurermLinuxWebAppSiteConfigCors | undefined);
    get allowedOrigins(): string[];
    get supportCredentials(): cdktf.IResolvable;
}
export declare class DataAzurermLinuxWebAppSiteConfigCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppSiteConfigCorsOutputReference;
}
export interface DataAzurermLinuxWebAppSiteConfigIpRestrictionHeaders {
}
export declare function dataAzurermLinuxWebAppSiteConfigIpRestrictionHeadersToTerraform(struct?: DataAzurermLinuxWebAppSiteConfigIpRestrictionHeaders): any;
export declare function dataAzurermLinuxWebAppSiteConfigIpRestrictionHeadersToHclTerraform(struct?: DataAzurermLinuxWebAppSiteConfigIpRestrictionHeaders): any;
export declare class DataAzurermLinuxWebAppSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppSiteConfigIpRestrictionHeaders | undefined;
    set internalValue(value: DataAzurermLinuxWebAppSiteConfigIpRestrictionHeaders | undefined);
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermLinuxWebAppSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppSiteConfigIpRestrictionHeadersOutputReference;
}
export interface DataAzurermLinuxWebAppSiteConfigIpRestriction {
}
export declare function dataAzurermLinuxWebAppSiteConfigIpRestrictionToTerraform(struct?: DataAzurermLinuxWebAppSiteConfigIpRestriction): any;
export declare function dataAzurermLinuxWebAppSiteConfigIpRestrictionToHclTerraform(struct?: DataAzurermLinuxWebAppSiteConfigIpRestriction): any;
export declare class DataAzurermLinuxWebAppSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppSiteConfigIpRestriction | undefined;
    set internalValue(value: DataAzurermLinuxWebAppSiteConfigIpRestriction | undefined);
    get action(): string;
    get description(): string;
    private _headers;
    get headers(): DataAzurermLinuxWebAppSiteConfigIpRestrictionHeadersList;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermLinuxWebAppSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppSiteConfigIpRestrictionOutputReference;
}
export interface DataAzurermLinuxWebAppSiteConfigScmIpRestrictionHeaders {
}
export declare function dataAzurermLinuxWebAppSiteConfigScmIpRestrictionHeadersToTerraform(struct?: DataAzurermLinuxWebAppSiteConfigScmIpRestrictionHeaders): any;
export declare function dataAzurermLinuxWebAppSiteConfigScmIpRestrictionHeadersToHclTerraform(struct?: DataAzurermLinuxWebAppSiteConfigScmIpRestrictionHeaders): any;
export declare class DataAzurermLinuxWebAppSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppSiteConfigScmIpRestrictionHeaders | undefined;
    set internalValue(value: DataAzurermLinuxWebAppSiteConfigScmIpRestrictionHeaders | undefined);
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermLinuxWebAppSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface DataAzurermLinuxWebAppSiteConfigScmIpRestriction {
}
export declare function dataAzurermLinuxWebAppSiteConfigScmIpRestrictionToTerraform(struct?: DataAzurermLinuxWebAppSiteConfigScmIpRestriction): any;
export declare function dataAzurermLinuxWebAppSiteConfigScmIpRestrictionToHclTerraform(struct?: DataAzurermLinuxWebAppSiteConfigScmIpRestriction): any;
export declare class DataAzurermLinuxWebAppSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppSiteConfigScmIpRestriction | undefined;
    set internalValue(value: DataAzurermLinuxWebAppSiteConfigScmIpRestriction | undefined);
    get action(): string;
    get description(): string;
    private _headers;
    get headers(): DataAzurermLinuxWebAppSiteConfigScmIpRestrictionHeadersList;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermLinuxWebAppSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppSiteConfigScmIpRestrictionOutputReference;
}
export interface DataAzurermLinuxWebAppSiteConfig {
}
export declare function dataAzurermLinuxWebAppSiteConfigToTerraform(struct?: DataAzurermLinuxWebAppSiteConfig): any;
export declare function dataAzurermLinuxWebAppSiteConfigToHclTerraform(struct?: DataAzurermLinuxWebAppSiteConfig): any;
export declare class DataAzurermLinuxWebAppSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppSiteConfig | undefined;
    set internalValue(value: DataAzurermLinuxWebAppSiteConfig | undefined);
    get alwaysOn(): cdktf.IResolvable;
    get apiDefinitionUrl(): string;
    get apiManagementApiId(): string;
    get appCommandLine(): string;
    private _applicationStack;
    get applicationStack(): DataAzurermLinuxWebAppSiteConfigApplicationStackList;
    get autoHealEnabled(): cdktf.IResolvable;
    private _autoHealSetting;
    get autoHealSetting(): DataAzurermLinuxWebAppSiteConfigAutoHealSettingList;
    get containerRegistryManagedIdentityClientId(): string;
    get containerRegistryUseManagedIdentity(): cdktf.IResolvable;
    private _cors;
    get cors(): DataAzurermLinuxWebAppSiteConfigCorsList;
    get defaultDocuments(): string[];
    get detailedErrorLoggingEnabled(): cdktf.IResolvable;
    get ftpsState(): string;
    get healthCheckEvictionTimeInMin(): number;
    get healthCheckPath(): string;
    get http2Enabled(): cdktf.IResolvable;
    private _ipRestriction;
    get ipRestriction(): DataAzurermLinuxWebAppSiteConfigIpRestrictionList;
    get ipRestrictionDefaultAction(): string;
    get linuxFxVersion(): string;
    get loadBalancingMode(): string;
    get localMysqlEnabled(): cdktf.IResolvable;
    get managedPipelineMode(): string;
    get minimumTlsVersion(): string;
    get remoteDebuggingEnabled(): cdktf.IResolvable;
    get remoteDebuggingVersion(): string;
    private _scmIpRestriction;
    get scmIpRestriction(): DataAzurermLinuxWebAppSiteConfigScmIpRestrictionList;
    get scmIpRestrictionDefaultAction(): string;
    get scmMinimumTlsVersion(): string;
    get scmType(): string;
    get scmUseMainIpRestriction(): cdktf.IResolvable;
    get use32BitWorker(): cdktf.IResolvable;
    get vnetRouteAllEnabled(): cdktf.IResolvable;
    get websocketsEnabled(): cdktf.IResolvable;
    get workerCount(): number;
}
export declare class DataAzurermLinuxWebAppSiteConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppSiteConfigOutputReference;
}
export interface DataAzurermLinuxWebAppSiteCredential {
}
export declare function dataAzurermLinuxWebAppSiteCredentialToTerraform(struct?: DataAzurermLinuxWebAppSiteCredential): any;
export declare function dataAzurermLinuxWebAppSiteCredentialToHclTerraform(struct?: DataAzurermLinuxWebAppSiteCredential): any;
export declare class DataAzurermLinuxWebAppSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppSiteCredential | undefined;
    set internalValue(value: DataAzurermLinuxWebAppSiteCredential | undefined);
    get name(): string;
    get password(): string;
}
export declare class DataAzurermLinuxWebAppSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppSiteCredentialOutputReference;
}
export interface DataAzurermLinuxWebAppStickySettings {
}
export declare function dataAzurermLinuxWebAppStickySettingsToTerraform(struct?: DataAzurermLinuxWebAppStickySettings): any;
export declare function dataAzurermLinuxWebAppStickySettingsToHclTerraform(struct?: DataAzurermLinuxWebAppStickySettings): any;
export declare class DataAzurermLinuxWebAppStickySettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppStickySettings | undefined;
    set internalValue(value: DataAzurermLinuxWebAppStickySettings | undefined);
    get appSettingNames(): string[];
    get connectionStringNames(): string[];
}
export declare class DataAzurermLinuxWebAppStickySettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppStickySettingsOutputReference;
}
export interface DataAzurermLinuxWebAppStorageAccount {
}
export declare function dataAzurermLinuxWebAppStorageAccountToTerraform(struct?: DataAzurermLinuxWebAppStorageAccount): any;
export declare function dataAzurermLinuxWebAppStorageAccountToHclTerraform(struct?: DataAzurermLinuxWebAppStorageAccount): any;
export declare class DataAzurermLinuxWebAppStorageAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLinuxWebAppStorageAccount | undefined;
    set internalValue(value: DataAzurermLinuxWebAppStorageAccount | undefined);
    get accessKey(): string;
    get accountName(): string;
    get mountPath(): string;
    get name(): string;
    get shareName(): string;
    get type(): string;
}
export declare class DataAzurermLinuxWebAppStorageAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLinuxWebAppStorageAccountOutputReference;
}
export interface DataAzurermLinuxWebAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/linux_web_app#read DataAzurermLinuxWebApp#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLinuxWebAppTimeoutsToTerraform(struct?: DataAzurermLinuxWebAppTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermLinuxWebAppTimeoutsToHclTerraform(struct?: DataAzurermLinuxWebAppTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLinuxWebAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermLinuxWebAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermLinuxWebAppTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/linux_web_app azurerm_linux_web_app}
*/
export declare class DataAzurermLinuxWebApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_linux_web_app";
    /**
    * Generates CDKTF code for importing a DataAzurermLinuxWebApp resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermLinuxWebApp to import
    * @param importFromId The id of the existing DataAzurermLinuxWebApp that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/linux_web_app#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermLinuxWebApp to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/linux_web_app azurerm_linux_web_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLinuxWebAppConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLinuxWebAppConfig);
    private _appMetadata;
    get appMetadata(): cdktf.StringMap;
    private _appSettings;
    get appSettings(): cdktf.StringMap;
    private _authSettings;
    get authSettings(): DataAzurermLinuxWebAppAuthSettingsList;
    private _authSettingsV2;
    get authSettingsV2(): DataAzurermLinuxWebAppAuthSettingsV2List;
    get availability(): string;
    private _backup;
    get backup(): DataAzurermLinuxWebAppBackupList;
    get clientAffinityEnabled(): cdktf.IResolvable;
    get clientCertificateEnabled(): cdktf.IResolvable;
    get clientCertificateExclusionPaths(): string;
    get clientCertificateMode(): string;
    private _connectionString;
    get connectionString(): DataAzurermLinuxWebAppConnectionStringList;
    get customDomainVerificationId(): string;
    get defaultHostname(): string;
    get enabled(): cdktf.IResolvable;
    get ftpPublishBasicAuthenticationEnabled(): cdktf.IResolvable;
    get hostingEnvironmentId(): string;
    get httpsOnly(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermLinuxWebAppIdentityList;
    get keyVaultReferenceIdentityId(): string;
    get kind(): string;
    get location(): string;
    private _logs;
    get logs(): DataAzurermLinuxWebAppLogsList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddressList(): string[];
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddressList(): string[];
    get possibleOutboundIpAddresses(): string;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get servicePlanId(): string;
    private _siteConfig;
    get siteConfig(): DataAzurermLinuxWebAppSiteConfigList;
    private _siteCredential;
    get siteCredential(): DataAzurermLinuxWebAppSiteCredentialList;
    private _stickySettings;
    get stickySettings(): DataAzurermLinuxWebAppStickySettingsList;
    private _storageAccount;
    get storageAccount(): DataAzurermLinuxWebAppStorageAccountList;
    private _tags;
    get tags(): cdktf.StringMap;
    get usage(): string;
    get virtualNetworkSubnetId(): string;
    get webdeployPublishBasicAuthenticationEnabled(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermLinuxWebAppTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLinuxWebAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermLinuxWebAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
