/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermRoleDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/role_definition#id DataAzurermRoleDefinition#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/role_definition#name DataAzurermRoleDefinition#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/role_definition#role_definition_id DataAzurermRoleDefinition#role_definition_id}
    */
    readonly roleDefinitionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/role_definition#scope DataAzurermRoleDefinition#scope}
    */
    readonly scope?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/role_definition#timeouts DataAzurermRoleDefinition#timeouts}
    */
    readonly timeouts?: DataAzurermRoleDefinitionTimeouts;
}
export interface DataAzurermRoleDefinitionPermissions {
}
export declare function dataAzurermRoleDefinitionPermissionsToTerraform(struct?: DataAzurermRoleDefinitionPermissions): any;
export declare function dataAzurermRoleDefinitionPermissionsToHclTerraform(struct?: DataAzurermRoleDefinitionPermissions): any;
export declare class DataAzurermRoleDefinitionPermissionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermRoleDefinitionPermissions | undefined;
    set internalValue(value: DataAzurermRoleDefinitionPermissions | undefined);
    get actions(): string[];
    get condition(): string;
    get conditionVersion(): string;
    get dataActions(): string[];
    get notActions(): string[];
    get notDataActions(): string[];
}
export declare class DataAzurermRoleDefinitionPermissionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermRoleDefinitionPermissionsOutputReference;
}
export interface DataAzurermRoleDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/role_definition#read DataAzurermRoleDefinition#read}
    */
    readonly read?: string;
}
export declare function dataAzurermRoleDefinitionTimeoutsToTerraform(struct?: DataAzurermRoleDefinitionTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermRoleDefinitionTimeoutsToHclTerraform(struct?: DataAzurermRoleDefinitionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermRoleDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermRoleDefinitionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermRoleDefinitionTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/role_definition azurerm_role_definition}
*/
export declare class DataAzurermRoleDefinition extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_role_definition";
    /**
    * Generates CDKTF code for importing a DataAzurermRoleDefinition resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermRoleDefinition to import
    * @param importFromId The id of the existing DataAzurermRoleDefinition that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/role_definition#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermRoleDefinition to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/role_definition azurerm_role_definition} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermRoleDefinitionConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermRoleDefinitionConfig);
    get assignableScopes(): string[];
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _permissions;
    get permissions(): DataAzurermRoleDefinitionPermissionsList;
    private _roleDefinitionId?;
    get roleDefinitionId(): string;
    set roleDefinitionId(value: string);
    resetRoleDefinitionId(): void;
    get roleDefinitionIdInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    get type(): string;
    private _timeouts;
    get timeouts(): DataAzurermRoleDefinitionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermRoleDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermRoleDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
