/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSharedImageVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/shared_image_versions#gallery_name DataAzurermSharedImageVersions#gallery_name}
    */
    readonly galleryName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/shared_image_versions#id DataAzurermSharedImageVersions#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/shared_image_versions#image_name DataAzurermSharedImageVersions#image_name}
    */
    readonly imageName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/shared_image_versions#resource_group_name DataAzurermSharedImageVersions#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/shared_image_versions#tags_filter DataAzurermSharedImageVersions#tags_filter}
    */
    readonly tagsFilter?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/shared_image_versions#timeouts DataAzurermSharedImageVersions#timeouts}
    */
    readonly timeouts?: DataAzurermSharedImageVersionsTimeouts;
}
export interface DataAzurermSharedImageVersionsImagesTargetRegion {
}
export declare function dataAzurermSharedImageVersionsImagesTargetRegionToTerraform(struct?: DataAzurermSharedImageVersionsImagesTargetRegion): any;
export declare function dataAzurermSharedImageVersionsImagesTargetRegionToHclTerraform(struct?: DataAzurermSharedImageVersionsImagesTargetRegion): any;
export declare class DataAzurermSharedImageVersionsImagesTargetRegionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSharedImageVersionsImagesTargetRegion | undefined;
    set internalValue(value: DataAzurermSharedImageVersionsImagesTargetRegion | undefined);
    get name(): string;
    get regionalReplicaCount(): number;
    get storageAccountType(): string;
}
export declare class DataAzurermSharedImageVersionsImagesTargetRegionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSharedImageVersionsImagesTargetRegionOutputReference;
}
export interface DataAzurermSharedImageVersionsImages {
}
export declare function dataAzurermSharedImageVersionsImagesToTerraform(struct?: DataAzurermSharedImageVersionsImages): any;
export declare function dataAzurermSharedImageVersionsImagesToHclTerraform(struct?: DataAzurermSharedImageVersionsImages): any;
export declare class DataAzurermSharedImageVersionsImagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSharedImageVersionsImages | undefined;
    set internalValue(value: DataAzurermSharedImageVersionsImages | undefined);
    get excludeFromLatest(): cdktf.IResolvable;
    get id(): string;
    get location(): string;
    get managedImageId(): string;
    get name(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _targetRegion;
    get targetRegion(): DataAzurermSharedImageVersionsImagesTargetRegionList;
}
export declare class DataAzurermSharedImageVersionsImagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSharedImageVersionsImagesOutputReference;
}
export interface DataAzurermSharedImageVersionsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/shared_image_versions#read DataAzurermSharedImageVersions#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSharedImageVersionsTimeoutsToTerraform(struct?: DataAzurermSharedImageVersionsTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermSharedImageVersionsTimeoutsToHclTerraform(struct?: DataAzurermSharedImageVersionsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSharedImageVersionsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSharedImageVersionsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSharedImageVersionsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/shared_image_versions azurerm_shared_image_versions}
*/
export declare class DataAzurermSharedImageVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_shared_image_versions";
    /**
    * Generates CDKTF code for importing a DataAzurermSharedImageVersions resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSharedImageVersions to import
    * @param importFromId The id of the existing DataAzurermSharedImageVersions that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/shared_image_versions#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSharedImageVersions to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/shared_image_versions azurerm_shared_image_versions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSharedImageVersionsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSharedImageVersionsConfig);
    private _galleryName?;
    get galleryName(): string;
    set galleryName(value: string);
    get galleryNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    get imageNameInput(): string | undefined;
    private _images;
    get images(): DataAzurermSharedImageVersionsImagesList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tagsFilter?;
    get tagsFilter(): {
        [key: string]: string;
    };
    set tagsFilter(value: {
        [key: string]: string;
    });
    resetTagsFilter(): void;
    get tagsFilterInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataAzurermSharedImageVersionsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSharedImageVersionsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSharedImageVersionsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
