/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/storage_account#id DataAzurermStorageAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/storage_account#min_tls_version DataAzurermStorageAccount#min_tls_version}
    */
    readonly minTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/storage_account#name DataAzurermStorageAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/storage_account#resource_group_name DataAzurermStorageAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/storage_account#timeouts DataAzurermStorageAccount#timeouts}
    */
    readonly timeouts?: DataAzurermStorageAccountTimeouts;
}
export interface DataAzurermStorageAccountAzureFilesAuthenticationActiveDirectory {
}
export declare function dataAzurermStorageAccountAzureFilesAuthenticationActiveDirectoryToTerraform(struct?: DataAzurermStorageAccountAzureFilesAuthenticationActiveDirectory): any;
export declare function dataAzurermStorageAccountAzureFilesAuthenticationActiveDirectoryToHclTerraform(struct?: DataAzurermStorageAccountAzureFilesAuthenticationActiveDirectory): any;
export declare class DataAzurermStorageAccountAzureFilesAuthenticationActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageAccountAzureFilesAuthenticationActiveDirectory | undefined;
    set internalValue(value: DataAzurermStorageAccountAzureFilesAuthenticationActiveDirectory | undefined);
    get domainGuid(): string;
    get domainName(): string;
    get domainSid(): string;
    get forestName(): string;
    get netbiosDomainName(): string;
    get storageSid(): string;
}
export declare class DataAzurermStorageAccountAzureFilesAuthenticationActiveDirectoryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageAccountAzureFilesAuthenticationActiveDirectoryOutputReference;
}
export interface DataAzurermStorageAccountAzureFilesAuthentication {
}
export declare function dataAzurermStorageAccountAzureFilesAuthenticationToTerraform(struct?: DataAzurermStorageAccountAzureFilesAuthentication): any;
export declare function dataAzurermStorageAccountAzureFilesAuthenticationToHclTerraform(struct?: DataAzurermStorageAccountAzureFilesAuthentication): any;
export declare class DataAzurermStorageAccountAzureFilesAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageAccountAzureFilesAuthentication | undefined;
    set internalValue(value: DataAzurermStorageAccountAzureFilesAuthentication | undefined);
    private _activeDirectory;
    get activeDirectory(): DataAzurermStorageAccountAzureFilesAuthenticationActiveDirectoryList;
    get directoryType(): string;
}
export declare class DataAzurermStorageAccountAzureFilesAuthenticationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageAccountAzureFilesAuthenticationOutputReference;
}
export interface DataAzurermStorageAccountCustomDomain {
}
export declare function dataAzurermStorageAccountCustomDomainToTerraform(struct?: DataAzurermStorageAccountCustomDomain): any;
export declare function dataAzurermStorageAccountCustomDomainToHclTerraform(struct?: DataAzurermStorageAccountCustomDomain): any;
export declare class DataAzurermStorageAccountCustomDomainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageAccountCustomDomain | undefined;
    set internalValue(value: DataAzurermStorageAccountCustomDomain | undefined);
    get name(): string;
}
export declare class DataAzurermStorageAccountCustomDomainList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageAccountCustomDomainOutputReference;
}
export interface DataAzurermStorageAccountIdentity {
}
export declare function dataAzurermStorageAccountIdentityToTerraform(struct?: DataAzurermStorageAccountIdentity): any;
export declare function dataAzurermStorageAccountIdentityToHclTerraform(struct?: DataAzurermStorageAccountIdentity): any;
export declare class DataAzurermStorageAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageAccountIdentity | undefined;
    set internalValue(value: DataAzurermStorageAccountIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermStorageAccountIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageAccountIdentityOutputReference;
}
export interface DataAzurermStorageAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/storage_account#read DataAzurermStorageAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageAccountTimeoutsToTerraform(struct?: DataAzurermStorageAccountTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermStorageAccountTimeoutsToHclTerraform(struct?: DataAzurermStorageAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStorageAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermStorageAccountTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/storage_account azurerm_storage_account}
*/
export declare class DataAzurermStorageAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_storage_account";
    /**
    * Generates CDKTF code for importing a DataAzurermStorageAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermStorageAccount to import
    * @param importFromId The id of the existing DataAzurermStorageAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/storage_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermStorageAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/data-sources/storage_account azurerm_storage_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageAccountConfig);
    get accessTier(): string;
    get accountKind(): string;
    get accountReplicationType(): string;
    get accountTier(): string;
    get allowNestedItemsToBePublic(): cdktf.IResolvable;
    private _azureFilesAuthentication;
    get azureFilesAuthentication(): DataAzurermStorageAccountAzureFilesAuthenticationList;
    private _customDomain;
    get customDomain(): DataAzurermStorageAccountCustomDomainList;
    get enableHttpsTrafficOnly(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermStorageAccountIdentityList;
    get infrastructureEncryptionEnabled(): cdktf.IResolvable;
    get isHnsEnabled(): cdktf.IResolvable;
    get location(): string;
    private _minTlsVersion?;
    get minTlsVersion(): string;
    set minTlsVersion(value: string);
    resetMinTlsVersion(): void;
    get minTlsVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nfsv3Enabled(): cdktf.IResolvable;
    get primaryAccessKey(): string;
    get primaryBlobConnectionString(): string;
    get primaryBlobEndpoint(): string;
    get primaryBlobHost(): string;
    get primaryBlobInternetEndpoint(): string;
    get primaryBlobInternetHost(): string;
    get primaryBlobMicrosoftEndpoint(): string;
    get primaryBlobMicrosoftHost(): string;
    get primaryConnectionString(): string;
    get primaryDfsEndpoint(): string;
    get primaryDfsHost(): string;
    get primaryDfsInternetEndpoint(): string;
    get primaryDfsInternetHost(): string;
    get primaryDfsMicrosoftEndpoint(): string;
    get primaryDfsMicrosoftHost(): string;
    get primaryFileEndpoint(): string;
    get primaryFileHost(): string;
    get primaryFileInternetEndpoint(): string;
    get primaryFileInternetHost(): string;
    get primaryFileMicrosoftEndpoint(): string;
    get primaryFileMicrosoftHost(): string;
    get primaryLocation(): string;
    get primaryQueueEndpoint(): string;
    get primaryQueueHost(): string;
    get primaryQueueMicrosoftEndpoint(): string;
    get primaryQueueMicrosoftHost(): string;
    get primaryTableEndpoint(): string;
    get primaryTableHost(): string;
    get primaryTableMicrosoftEndpoint(): string;
    get primaryTableMicrosoftHost(): string;
    get primaryWebEndpoint(): string;
    get primaryWebHost(): string;
    get primaryWebInternetEndpoint(): string;
    get primaryWebInternetHost(): string;
    get primaryWebMicrosoftEndpoint(): string;
    get primaryWebMicrosoftHost(): string;
    get queueEncryptionKeyType(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get secondaryBlobConnectionString(): string;
    get secondaryBlobEndpoint(): string;
    get secondaryBlobHost(): string;
    get secondaryBlobInternetEndpoint(): string;
    get secondaryBlobInternetHost(): string;
    get secondaryBlobMicrosoftEndpoint(): string;
    get secondaryBlobMicrosoftHost(): string;
    get secondaryConnectionString(): string;
    get secondaryDfsEndpoint(): string;
    get secondaryDfsHost(): string;
    get secondaryDfsInternetEndpoint(): string;
    get secondaryDfsInternetHost(): string;
    get secondaryDfsMicrosoftEndpoint(): string;
    get secondaryDfsMicrosoftHost(): string;
    get secondaryFileEndpoint(): string;
    get secondaryFileHost(): string;
    get secondaryFileInternetEndpoint(): string;
    get secondaryFileInternetHost(): string;
    get secondaryFileMicrosoftEndpoint(): string;
    get secondaryFileMicrosoftHost(): string;
    get secondaryLocation(): string;
    get secondaryQueueEndpoint(): string;
    get secondaryQueueHost(): string;
    get secondaryQueueMicrosoftEndpoint(): string;
    get secondaryQueueMicrosoftHost(): string;
    get secondaryTableEndpoint(): string;
    get secondaryTableHost(): string;
    get secondaryTableMicrosoftEndpoint(): string;
    get secondaryTableMicrosoftHost(): string;
    get secondaryWebEndpoint(): string;
    get secondaryWebHost(): string;
    get secondaryWebInternetEndpoint(): string;
    get secondaryWebInternetHost(): string;
    get secondaryWebMicrosoftEndpoint(): string;
    get secondaryWebMicrosoftHost(): string;
    get tableEncryptionKeyType(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermStorageAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermStorageAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
