/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabricksAccessConnectorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector#id DatabricksAccessConnector#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector#location DatabricksAccessConnector#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector#name DatabricksAccessConnector#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector#resource_group_name DatabricksAccessConnector#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector#tags DatabricksAccessConnector#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector#identity DatabricksAccessConnector#identity}
    */
    readonly identity?: DatabricksAccessConnectorIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector#timeouts DatabricksAccessConnector#timeouts}
    */
    readonly timeouts?: DatabricksAccessConnectorTimeouts;
}
export interface DatabricksAccessConnectorIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector#identity_ids DatabricksAccessConnector#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector#type DatabricksAccessConnector#type}
    */
    readonly type: string;
}
export declare function databricksAccessConnectorIdentityToTerraform(struct?: DatabricksAccessConnectorIdentityOutputReference | DatabricksAccessConnectorIdentity): any;
export declare function databricksAccessConnectorIdentityToHclTerraform(struct?: DatabricksAccessConnectorIdentityOutputReference | DatabricksAccessConnectorIdentity): any;
export declare class DatabricksAccessConnectorIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabricksAccessConnectorIdentity | undefined;
    set internalValue(value: DatabricksAccessConnectorIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface DatabricksAccessConnectorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector#create DatabricksAccessConnector#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector#delete DatabricksAccessConnector#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector#read DatabricksAccessConnector#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector#update DatabricksAccessConnector#update}
    */
    readonly update?: string;
}
export declare function databricksAccessConnectorTimeoutsToTerraform(struct?: DatabricksAccessConnectorTimeouts | cdktf.IResolvable): any;
export declare function databricksAccessConnectorTimeoutsToHclTerraform(struct?: DatabricksAccessConnectorTimeouts | cdktf.IResolvable): any;
export declare class DatabricksAccessConnectorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabricksAccessConnectorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DatabricksAccessConnectorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector azurerm_databricks_access_connector}
*/
export declare class DatabricksAccessConnector extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_databricks_access_connector";
    /**
    * Generates CDKTF code for importing a DatabricksAccessConnector resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DatabricksAccessConnector to import
    * @param importFromId The id of the existing DatabricksAccessConnector that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DatabricksAccessConnector to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/databricks_access_connector azurerm_databricks_access_connector} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabricksAccessConnectorConfig
    */
    constructor(scope: Construct, id: string, config: DatabricksAccessConnectorConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): DatabricksAccessConnectorIdentityOutputReference;
    putIdentity(value: DatabricksAccessConnectorIdentity): void;
    resetIdentity(): void;
    get identityInput(): DatabricksAccessConnectorIdentity | undefined;
    private _timeouts;
    get timeouts(): DatabricksAccessConnectorTimeoutsOutputReference;
    putTimeouts(value: DatabricksAccessConnectorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DatabricksAccessConnectorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
