/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DiskPoolIscsiTargetLunConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/disk_pool_iscsi_target_lun#disk_pool_managed_disk_attachment_id DiskPoolIscsiTargetLun#disk_pool_managed_disk_attachment_id}
    */
    readonly diskPoolManagedDiskAttachmentId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/disk_pool_iscsi_target_lun#id DiskPoolIscsiTargetLun#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/disk_pool_iscsi_target_lun#iscsi_target_id DiskPoolIscsiTargetLun#iscsi_target_id}
    */
    readonly iscsiTargetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/disk_pool_iscsi_target_lun#name DiskPoolIscsiTargetLun#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/disk_pool_iscsi_target_lun#timeouts DiskPoolIscsiTargetLun#timeouts}
    */
    readonly timeouts?: DiskPoolIscsiTargetLunTimeouts;
}
export interface DiskPoolIscsiTargetLunTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/disk_pool_iscsi_target_lun#create DiskPoolIscsiTargetLun#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/disk_pool_iscsi_target_lun#delete DiskPoolIscsiTargetLun#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/disk_pool_iscsi_target_lun#read DiskPoolIscsiTargetLun#read}
    */
    readonly read?: string;
}
export declare function diskPoolIscsiTargetLunTimeoutsToTerraform(struct?: DiskPoolIscsiTargetLunTimeouts | cdktf.IResolvable): any;
export declare function diskPoolIscsiTargetLunTimeoutsToHclTerraform(struct?: DiskPoolIscsiTargetLunTimeouts | cdktf.IResolvable): any;
export declare class DiskPoolIscsiTargetLunTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DiskPoolIscsiTargetLunTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DiskPoolIscsiTargetLunTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/disk_pool_iscsi_target_lun azurerm_disk_pool_iscsi_target_lun}
*/
export declare class DiskPoolIscsiTargetLun extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_disk_pool_iscsi_target_lun";
    /**
    * Generates CDKTF code for importing a DiskPoolIscsiTargetLun resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DiskPoolIscsiTargetLun to import
    * @param importFromId The id of the existing DiskPoolIscsiTargetLun that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/disk_pool_iscsi_target_lun#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DiskPoolIscsiTargetLun to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/disk_pool_iscsi_target_lun azurerm_disk_pool_iscsi_target_lun} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DiskPoolIscsiTargetLunConfig
    */
    constructor(scope: Construct, id: string, config: DiskPoolIscsiTargetLunConfig);
    private _diskPoolManagedDiskAttachmentId?;
    get diskPoolManagedDiskAttachmentId(): string;
    set diskPoolManagedDiskAttachmentId(value: string);
    get diskPoolManagedDiskAttachmentIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _iscsiTargetId?;
    get iscsiTargetId(): string;
    set iscsiTargetId(value: string);
    get iscsiTargetIdInput(): string | undefined;
    get lun(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DiskPoolIscsiTargetLunTimeoutsOutputReference;
    putTimeouts(value: DiskPoolIscsiTargetLunTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DiskPoolIscsiTargetLunTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
