/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EventgridSystemTopicConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#id EventgridSystemTopic#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#location EventgridSystemTopic#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#name EventgridSystemTopic#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#resource_group_name EventgridSystemTopic#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#source_arm_resource_id EventgridSystemTopic#source_arm_resource_id}
    */
    readonly sourceArmResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#tags EventgridSystemTopic#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#topic_type EventgridSystemTopic#topic_type}
    */
    readonly topicType: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#identity EventgridSystemTopic#identity}
    */
    readonly identity?: EventgridSystemTopicIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#timeouts EventgridSystemTopic#timeouts}
    */
    readonly timeouts?: EventgridSystemTopicTimeouts;
}
export interface EventgridSystemTopicIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#identity_ids EventgridSystemTopic#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#type EventgridSystemTopic#type}
    */
    readonly type: string;
}
export declare function eventgridSystemTopicIdentityToTerraform(struct?: EventgridSystemTopicIdentityOutputReference | EventgridSystemTopicIdentity): any;
export declare function eventgridSystemTopicIdentityToHclTerraform(struct?: EventgridSystemTopicIdentityOutputReference | EventgridSystemTopicIdentity): any;
export declare class EventgridSystemTopicIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventgridSystemTopicIdentity | undefined;
    set internalValue(value: EventgridSystemTopicIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface EventgridSystemTopicTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#create EventgridSystemTopic#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#delete EventgridSystemTopic#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#read EventgridSystemTopic#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#update EventgridSystemTopic#update}
    */
    readonly update?: string;
}
export declare function eventgridSystemTopicTimeoutsToTerraform(struct?: EventgridSystemTopicTimeouts | cdktf.IResolvable): any;
export declare function eventgridSystemTopicTimeoutsToHclTerraform(struct?: EventgridSystemTopicTimeouts | cdktf.IResolvable): any;
export declare class EventgridSystemTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): EventgridSystemTopicTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: EventgridSystemTopicTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic azurerm_eventgrid_system_topic}
*/
export declare class EventgridSystemTopic extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_eventgrid_system_topic";
    /**
    * Generates CDKTF code for importing a EventgridSystemTopic resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the EventgridSystemTopic to import
    * @param importFromId The id of the existing EventgridSystemTopic that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the EventgridSystemTopic to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/eventgrid_system_topic azurerm_eventgrid_system_topic} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EventgridSystemTopicConfig
    */
    constructor(scope: Construct, id: string, config: EventgridSystemTopicConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get metricArmResourceId(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sourceArmResourceId?;
    get sourceArmResourceId(): string;
    set sourceArmResourceId(value: string);
    get sourceArmResourceIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _topicType?;
    get topicType(): string;
    set topicType(value: string);
    get topicTypeInput(): string | undefined;
    private _identity;
    get identity(): EventgridSystemTopicIdentityOutputReference;
    putIdentity(value: EventgridSystemTopicIdentity): void;
    resetIdentity(): void;
    get identityInput(): EventgridSystemTopicIdentity | undefined;
    private _timeouts;
    get timeouts(): EventgridSystemTopicTimeoutsOutputReference;
    putTimeouts(value: EventgridSystemTopicTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | EventgridSystemTopicTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
