/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FunctionAppConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#client_type FunctionAppConnection#client_type}
    */
    readonly clientType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#function_app_id FunctionAppConnection#function_app_id}
    */
    readonly functionAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#id FunctionAppConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#name FunctionAppConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#target_resource_id FunctionAppConnection#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#vnet_solution FunctionAppConnection#vnet_solution}
    */
    readonly vnetSolution?: string;
    /**
    * authentication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#authentication FunctionAppConnection#authentication}
    */
    readonly authentication: FunctionAppConnectionAuthentication;
    /**
    * secret_store block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#secret_store FunctionAppConnection#secret_store}
    */
    readonly secretStore?: FunctionAppConnectionSecretStore;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#timeouts FunctionAppConnection#timeouts}
    */
    readonly timeouts?: FunctionAppConnectionTimeouts;
}
export interface FunctionAppConnectionAuthentication {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#certificate FunctionAppConnection#certificate}
    */
    readonly certificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#client_id FunctionAppConnection#client_id}
    */
    readonly clientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#name FunctionAppConnection#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#principal_id FunctionAppConnection#principal_id}
    */
    readonly principalId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#secret FunctionAppConnection#secret}
    */
    readonly secret?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#subscription_id FunctionAppConnection#subscription_id}
    */
    readonly subscriptionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#type FunctionAppConnection#type}
    */
    readonly type: string;
}
export declare function functionAppConnectionAuthenticationToTerraform(struct?: FunctionAppConnectionAuthenticationOutputReference | FunctionAppConnectionAuthentication): any;
export declare function functionAppConnectionAuthenticationToHclTerraform(struct?: FunctionAppConnectionAuthenticationOutputReference | FunctionAppConnectionAuthentication): any;
export declare class FunctionAppConnectionAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppConnectionAuthentication | undefined;
    set internalValue(value: FunctionAppConnectionAuthentication | undefined);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _principalId?;
    get principalId(): string;
    set principalId(value: string);
    resetPrincipalId(): void;
    get principalIdInput(): string | undefined;
    private _secret?;
    get secret(): string;
    set secret(value: string);
    resetSecret(): void;
    get secretInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    resetSubscriptionId(): void;
    get subscriptionIdInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface FunctionAppConnectionSecretStore {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#key_vault_id FunctionAppConnection#key_vault_id}
    */
    readonly keyVaultId: string;
}
export declare function functionAppConnectionSecretStoreToTerraform(struct?: FunctionAppConnectionSecretStoreOutputReference | FunctionAppConnectionSecretStore): any;
export declare function functionAppConnectionSecretStoreToHclTerraform(struct?: FunctionAppConnectionSecretStoreOutputReference | FunctionAppConnectionSecretStore): any;
export declare class FunctionAppConnectionSecretStoreOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppConnectionSecretStore | undefined;
    set internalValue(value: FunctionAppConnectionSecretStore | undefined);
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    get keyVaultIdInput(): string | undefined;
}
export interface FunctionAppConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#create FunctionAppConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#delete FunctionAppConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#read FunctionAppConnection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#update FunctionAppConnection#update}
    */
    readonly update?: string;
}
export declare function functionAppConnectionTimeoutsToTerraform(struct?: FunctionAppConnectionTimeouts | cdktf.IResolvable): any;
export declare function functionAppConnectionTimeoutsToHclTerraform(struct?: FunctionAppConnectionTimeouts | cdktf.IResolvable): any;
export declare class FunctionAppConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionAppConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection azurerm_function_app_connection}
*/
export declare class FunctionAppConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_function_app_connection";
    /**
    * Generates CDKTF code for importing a FunctionAppConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the FunctionAppConnection to import
    * @param importFromId The id of the existing FunctionAppConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the FunctionAppConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_connection azurerm_function_app_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FunctionAppConnectionConfig
    */
    constructor(scope: Construct, id: string, config: FunctionAppConnectionConfig);
    private _clientType?;
    get clientType(): string;
    set clientType(value: string);
    resetClientType(): void;
    get clientTypeInput(): string | undefined;
    private _functionAppId?;
    get functionAppId(): string;
    set functionAppId(value: string);
    get functionAppIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _vnetSolution?;
    get vnetSolution(): string;
    set vnetSolution(value: string);
    resetVnetSolution(): void;
    get vnetSolutionInput(): string | undefined;
    private _authentication;
    get authentication(): FunctionAppConnectionAuthenticationOutputReference;
    putAuthentication(value: FunctionAppConnectionAuthentication): void;
    get authenticationInput(): FunctionAppConnectionAuthentication | undefined;
    private _secretStore;
    get secretStore(): FunctionAppConnectionSecretStoreOutputReference;
    putSecretStore(value: FunctionAppConnectionSecretStore): void;
    resetSecretStore(): void;
    get secretStoreInput(): FunctionAppConnectionSecretStore | undefined;
    private _timeouts;
    get timeouts(): FunctionAppConnectionTimeoutsOutputReference;
    putTimeouts(value: FunctionAppConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FunctionAppConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
