/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FunctionAppSlotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#app_service_plan_id FunctionAppSlot#app_service_plan_id}
    */
    readonly appServicePlanId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#app_settings FunctionAppSlot#app_settings}
    */
    readonly appSettings?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#daily_memory_time_quota FunctionAppSlot#daily_memory_time_quota}
    */
    readonly dailyMemoryTimeQuota?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#enable_builtin_logging FunctionAppSlot#enable_builtin_logging}
    */
    readonly enableBuiltinLogging?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#enabled FunctionAppSlot#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#function_app_name FunctionAppSlot#function_app_name}
    */
    readonly functionAppName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#https_only FunctionAppSlot#https_only}
    */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#id FunctionAppSlot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#location FunctionAppSlot#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#name FunctionAppSlot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#os_type FunctionAppSlot#os_type}
    */
    readonly osType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#resource_group_name FunctionAppSlot#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#storage_account_access_key FunctionAppSlot#storage_account_access_key}
    */
    readonly storageAccountAccessKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#storage_account_name FunctionAppSlot#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#tags FunctionAppSlot#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#version FunctionAppSlot#version}
    */
    readonly version?: string;
    /**
    * auth_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#auth_settings FunctionAppSlot#auth_settings}
    */
    readonly authSettings?: FunctionAppSlotAuthSettings;
    /**
    * connection_string block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#connection_string FunctionAppSlot#connection_string}
    */
    readonly connectionString?: FunctionAppSlotConnectionString[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#identity FunctionAppSlot#identity}
    */
    readonly identity?: FunctionAppSlotIdentity;
    /**
    * site_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#site_config FunctionAppSlot#site_config}
    */
    readonly siteConfig?: FunctionAppSlotSiteConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#timeouts FunctionAppSlot#timeouts}
    */
    readonly timeouts?: FunctionAppSlotTimeouts;
}
export interface FunctionAppSlotSiteCredential {
}
export declare function functionAppSlotSiteCredentialToTerraform(struct?: FunctionAppSlotSiteCredential): any;
export declare function functionAppSlotSiteCredentialToHclTerraform(struct?: FunctionAppSlotSiteCredential): any;
export declare class FunctionAppSlotSiteCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionAppSlotSiteCredential | undefined;
    set internalValue(value: FunctionAppSlotSiteCredential | undefined);
    get password(): string;
    get username(): string;
}
export declare class FunctionAppSlotSiteCredentialList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionAppSlotSiteCredentialOutputReference;
}
export interface FunctionAppSlotAuthSettingsActiveDirectory {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#allowed_audiences FunctionAppSlot#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#client_id FunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#client_secret FunctionAppSlot#client_secret}
    */
    readonly clientSecret?: string;
}
export declare function functionAppSlotAuthSettingsActiveDirectoryToTerraform(struct?: FunctionAppSlotAuthSettingsActiveDirectoryOutputReference | FunctionAppSlotAuthSettingsActiveDirectory): any;
export declare function functionAppSlotAuthSettingsActiveDirectoryToHclTerraform(struct?: FunctionAppSlotAuthSettingsActiveDirectoryOutputReference | FunctionAppSlotAuthSettingsActiveDirectory): any;
export declare class FunctionAppSlotAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppSlotAuthSettingsActiveDirectory | undefined;
    set internalValue(value: FunctionAppSlotAuthSettingsActiveDirectory | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
}
export interface FunctionAppSlotAuthSettingsFacebook {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#app_id FunctionAppSlot#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#app_secret FunctionAppSlot#app_secret}
    */
    readonly appSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#oauth_scopes FunctionAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function functionAppSlotAuthSettingsFacebookToTerraform(struct?: FunctionAppSlotAuthSettingsFacebookOutputReference | FunctionAppSlotAuthSettingsFacebook): any;
export declare function functionAppSlotAuthSettingsFacebookToHclTerraform(struct?: FunctionAppSlotAuthSettingsFacebookOutputReference | FunctionAppSlotAuthSettingsFacebook): any;
export declare class FunctionAppSlotAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppSlotAuthSettingsFacebook | undefined;
    set internalValue(value: FunctionAppSlotAuthSettingsFacebook | undefined);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecret?;
    get appSecret(): string;
    set appSecret(value: string);
    get appSecretInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface FunctionAppSlotAuthSettingsGoogle {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#client_id FunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#client_secret FunctionAppSlot#client_secret}
    */
    readonly clientSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#oauth_scopes FunctionAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function functionAppSlotAuthSettingsGoogleToTerraform(struct?: FunctionAppSlotAuthSettingsGoogleOutputReference | FunctionAppSlotAuthSettingsGoogle): any;
export declare function functionAppSlotAuthSettingsGoogleToHclTerraform(struct?: FunctionAppSlotAuthSettingsGoogleOutputReference | FunctionAppSlotAuthSettingsGoogle): any;
export declare class FunctionAppSlotAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppSlotAuthSettingsGoogle | undefined;
    set internalValue(value: FunctionAppSlotAuthSettingsGoogle | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface FunctionAppSlotAuthSettingsMicrosoft {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#client_id FunctionAppSlot#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#client_secret FunctionAppSlot#client_secret}
    */
    readonly clientSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#oauth_scopes FunctionAppSlot#oauth_scopes}
    */
    readonly oauthScopes?: string[];
}
export declare function functionAppSlotAuthSettingsMicrosoftToTerraform(struct?: FunctionAppSlotAuthSettingsMicrosoftOutputReference | FunctionAppSlotAuthSettingsMicrosoft): any;
export declare function functionAppSlotAuthSettingsMicrosoftToHclTerraform(struct?: FunctionAppSlotAuthSettingsMicrosoftOutputReference | FunctionAppSlotAuthSettingsMicrosoft): any;
export declare class FunctionAppSlotAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppSlotAuthSettingsMicrosoft | undefined;
    set internalValue(value: FunctionAppSlotAuthSettingsMicrosoft | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    resetOauthScopes(): void;
    get oauthScopesInput(): string[] | undefined;
}
export interface FunctionAppSlotAuthSettingsTwitter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#consumer_key FunctionAppSlot#consumer_key}
    */
    readonly consumerKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#consumer_secret FunctionAppSlot#consumer_secret}
    */
    readonly consumerSecret: string;
}
export declare function functionAppSlotAuthSettingsTwitterToTerraform(struct?: FunctionAppSlotAuthSettingsTwitterOutputReference | FunctionAppSlotAuthSettingsTwitter): any;
export declare function functionAppSlotAuthSettingsTwitterToHclTerraform(struct?: FunctionAppSlotAuthSettingsTwitterOutputReference | FunctionAppSlotAuthSettingsTwitter): any;
export declare class FunctionAppSlotAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppSlotAuthSettingsTwitter | undefined;
    set internalValue(value: FunctionAppSlotAuthSettingsTwitter | undefined);
    private _consumerKey?;
    get consumerKey(): string;
    set consumerKey(value: string);
    get consumerKeyInput(): string | undefined;
    private _consumerSecret?;
    get consumerSecret(): string;
    set consumerSecret(value: string);
    get consumerSecretInput(): string | undefined;
}
export interface FunctionAppSlotAuthSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#additional_login_params FunctionAppSlot#additional_login_params}
    */
    readonly additionalLoginParams?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#allowed_external_redirect_urls FunctionAppSlot#allowed_external_redirect_urls}
    */
    readonly allowedExternalRedirectUrls?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#default_provider FunctionAppSlot#default_provider}
    */
    readonly defaultProvider?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#enabled FunctionAppSlot#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#issuer FunctionAppSlot#issuer}
    */
    readonly issuer?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#runtime_version FunctionAppSlot#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#token_refresh_extension_hours FunctionAppSlot#token_refresh_extension_hours}
    */
    readonly tokenRefreshExtensionHours?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#token_store_enabled FunctionAppSlot#token_store_enabled}
    */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#unauthenticated_client_action FunctionAppSlot#unauthenticated_client_action}
    */
    readonly unauthenticatedClientAction?: string;
    /**
    * active_directory block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#active_directory FunctionAppSlot#active_directory}
    */
    readonly activeDirectory?: FunctionAppSlotAuthSettingsActiveDirectory;
    /**
    * facebook block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#facebook FunctionAppSlot#facebook}
    */
    readonly facebook?: FunctionAppSlotAuthSettingsFacebook;
    /**
    * google block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#google FunctionAppSlot#google}
    */
    readonly google?: FunctionAppSlotAuthSettingsGoogle;
    /**
    * microsoft block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#microsoft FunctionAppSlot#microsoft}
    */
    readonly microsoft?: FunctionAppSlotAuthSettingsMicrosoft;
    /**
    * twitter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#twitter FunctionAppSlot#twitter}
    */
    readonly twitter?: FunctionAppSlotAuthSettingsTwitter;
}
export declare function functionAppSlotAuthSettingsToTerraform(struct?: FunctionAppSlotAuthSettingsOutputReference | FunctionAppSlotAuthSettings): any;
export declare function functionAppSlotAuthSettingsToHclTerraform(struct?: FunctionAppSlotAuthSettingsOutputReference | FunctionAppSlotAuthSettings): any;
export declare class FunctionAppSlotAuthSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppSlotAuthSettings | undefined;
    set internalValue(value: FunctionAppSlotAuthSettings | undefined);
    private _additionalLoginParams?;
    get additionalLoginParams(): {
        [key: string]: string;
    };
    set additionalLoginParams(value: {
        [key: string]: string;
    });
    resetAdditionalLoginParams(): void;
    get additionalLoginParamsInput(): {
        [key: string]: string;
    } | undefined;
    private _allowedExternalRedirectUrls?;
    get allowedExternalRedirectUrls(): string[];
    set allowedExternalRedirectUrls(value: string[]);
    resetAllowedExternalRedirectUrls(): void;
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _defaultProvider?;
    get defaultProvider(): string;
    set defaultProvider(value: string);
    resetDefaultProvider(): void;
    get defaultProviderInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _tokenRefreshExtensionHours?;
    get tokenRefreshExtensionHours(): number;
    set tokenRefreshExtensionHours(value: number);
    resetTokenRefreshExtensionHours(): void;
    get tokenRefreshExtensionHoursInput(): number | undefined;
    private _tokenStoreEnabled?;
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    resetTokenStoreEnabled(): void;
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _unauthenticatedClientAction?;
    get unauthenticatedClientAction(): string;
    set unauthenticatedClientAction(value: string);
    resetUnauthenticatedClientAction(): void;
    get unauthenticatedClientActionInput(): string | undefined;
    private _activeDirectory;
    get activeDirectory(): FunctionAppSlotAuthSettingsActiveDirectoryOutputReference;
    putActiveDirectory(value: FunctionAppSlotAuthSettingsActiveDirectory): void;
    resetActiveDirectory(): void;
    get activeDirectoryInput(): FunctionAppSlotAuthSettingsActiveDirectory | undefined;
    private _facebook;
    get facebook(): FunctionAppSlotAuthSettingsFacebookOutputReference;
    putFacebook(value: FunctionAppSlotAuthSettingsFacebook): void;
    resetFacebook(): void;
    get facebookInput(): FunctionAppSlotAuthSettingsFacebook | undefined;
    private _google;
    get google(): FunctionAppSlotAuthSettingsGoogleOutputReference;
    putGoogle(value: FunctionAppSlotAuthSettingsGoogle): void;
    resetGoogle(): void;
    get googleInput(): FunctionAppSlotAuthSettingsGoogle | undefined;
    private _microsoft;
    get microsoft(): FunctionAppSlotAuthSettingsMicrosoftOutputReference;
    putMicrosoft(value: FunctionAppSlotAuthSettingsMicrosoft): void;
    resetMicrosoft(): void;
    get microsoftInput(): FunctionAppSlotAuthSettingsMicrosoft | undefined;
    private _twitter;
    get twitter(): FunctionAppSlotAuthSettingsTwitterOutputReference;
    putTwitter(value: FunctionAppSlotAuthSettingsTwitter): void;
    resetTwitter(): void;
    get twitterInput(): FunctionAppSlotAuthSettingsTwitter | undefined;
}
export interface FunctionAppSlotConnectionString {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#name FunctionAppSlot#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#type FunctionAppSlot#type}
    */
    readonly type: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#value FunctionAppSlot#value}
    */
    readonly value: string;
}
export declare function functionAppSlotConnectionStringToTerraform(struct?: FunctionAppSlotConnectionString | cdktf.IResolvable): any;
export declare function functionAppSlotConnectionStringToHclTerraform(struct?: FunctionAppSlotConnectionString | cdktf.IResolvable): any;
export declare class FunctionAppSlotConnectionStringOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionAppSlotConnectionString | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionAppSlotConnectionString | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class FunctionAppSlotConnectionStringList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FunctionAppSlotConnectionString[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionAppSlotConnectionStringOutputReference;
}
export interface FunctionAppSlotIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#identity_ids FunctionAppSlot#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#type FunctionAppSlot#type}
    */
    readonly type: string;
}
export declare function functionAppSlotIdentityToTerraform(struct?: FunctionAppSlotIdentityOutputReference | FunctionAppSlotIdentity): any;
export declare function functionAppSlotIdentityToHclTerraform(struct?: FunctionAppSlotIdentityOutputReference | FunctionAppSlotIdentity): any;
export declare class FunctionAppSlotIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppSlotIdentity | undefined;
    set internalValue(value: FunctionAppSlotIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface FunctionAppSlotSiteConfigIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#x_azure_fdid FunctionAppSlot#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#x_fd_health_probe FunctionAppSlot#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#x_forwarded_for FunctionAppSlot#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#x_forwarded_host FunctionAppSlot#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function functionAppSlotSiteConfigIpRestrictionHeadersToTerraform(struct?: FunctionAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
export declare function functionAppSlotSiteConfigIpRestrictionHeadersToHclTerraform(struct?: FunctionAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class FunctionAppSlotSiteConfigIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionAppSlotSiteConfigIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class FunctionAppSlotSiteConfigIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FunctionAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionAppSlotSiteConfigIpRestrictionHeadersOutputReference;
}
export interface FunctionAppSlotSiteConfigIpRestriction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#action FunctionAppSlot#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#headers FunctionAppSlot#headers}
    */
    readonly headers?: FunctionAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#ip_address FunctionAppSlot#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#name FunctionAppSlot#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#priority FunctionAppSlot#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#service_tag FunctionAppSlot#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#virtual_network_subnet_id FunctionAppSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function functionAppSlotSiteConfigIpRestrictionToTerraform(struct?: FunctionAppSlotSiteConfigIpRestriction | cdktf.IResolvable): any;
export declare function functionAppSlotSiteConfigIpRestrictionToHclTerraform(struct?: FunctionAppSlotSiteConfigIpRestriction | cdktf.IResolvable): any;
export declare class FunctionAppSlotSiteConfigIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionAppSlotSiteConfigIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionAppSlotSiteConfigIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _headers;
    get headers(): FunctionAppSlotSiteConfigIpRestrictionHeadersList;
    putHeaders(value: FunctionAppSlotSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | FunctionAppSlotSiteConfigIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class FunctionAppSlotSiteConfigIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FunctionAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionAppSlotSiteConfigIpRestrictionOutputReference;
}
export interface FunctionAppSlotSiteConfigScmIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#x_azure_fdid FunctionAppSlot#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#x_fd_health_probe FunctionAppSlot#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#x_forwarded_for FunctionAppSlot#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#x_forwarded_host FunctionAppSlot#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function functionAppSlotSiteConfigScmIpRestrictionHeadersToTerraform(struct?: FunctionAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable): any;
export declare function functionAppSlotSiteConfigScmIpRestrictionHeadersToHclTerraform(struct?: FunctionAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable): any;
export declare class FunctionAppSlotSiteConfigScmIpRestrictionHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionAppSlotSiteConfigScmIpRestrictionHeaders | cdktf.IResolvable | undefined);
    private _xAzureFdid?;
    get xAzureFdid(): string[];
    set xAzureFdid(value: string[]);
    resetXAzureFdid(): void;
    get xAzureFdidInput(): string[] | undefined;
    private _xFdHealthProbe?;
    get xFdHealthProbe(): string[];
    set xFdHealthProbe(value: string[]);
    resetXFdHealthProbe(): void;
    get xFdHealthProbeInput(): string[] | undefined;
    private _xForwardedFor?;
    get xForwardedFor(): string[];
    set xForwardedFor(value: string[]);
    resetXForwardedFor(): void;
    get xForwardedForInput(): string[] | undefined;
    private _xForwardedHost?;
    get xForwardedHost(): string[];
    set xForwardedHost(value: string[]);
    resetXForwardedHost(): void;
    get xForwardedHostInput(): string[] | undefined;
}
export declare class FunctionAppSlotSiteConfigScmIpRestrictionHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FunctionAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionAppSlotSiteConfigScmIpRestrictionHeadersOutputReference;
}
export interface FunctionAppSlotSiteConfigScmIpRestriction {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#action FunctionAppSlot#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#headers FunctionAppSlot#headers}
    */
    readonly headers?: FunctionAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#ip_address FunctionAppSlot#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#name FunctionAppSlot#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#priority FunctionAppSlot#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#service_tag FunctionAppSlot#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#virtual_network_subnet_id FunctionAppSlot#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function functionAppSlotSiteConfigScmIpRestrictionToTerraform(struct?: FunctionAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable): any;
export declare function functionAppSlotSiteConfigScmIpRestrictionToHclTerraform(struct?: FunctionAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable): any;
export declare class FunctionAppSlotSiteConfigScmIpRestrictionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FunctionAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionAppSlotSiteConfigScmIpRestriction | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _headers;
    get headers(): FunctionAppSlotSiteConfigScmIpRestrictionHeadersList;
    putHeaders(value: FunctionAppSlotSiteConfigScmIpRestrictionHeaders[] | cdktf.IResolvable): void;
    resetHeaders(): void;
    get headersInput(): cdktf.IResolvable | FunctionAppSlotSiteConfigScmIpRestrictionHeaders[] | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _serviceTag?;
    get serviceTag(): string;
    set serviceTag(value: string);
    resetServiceTag(): void;
    get serviceTagInput(): string | undefined;
    private _virtualNetworkSubnetId?;
    get virtualNetworkSubnetId(): string;
    set virtualNetworkSubnetId(value: string);
    resetVirtualNetworkSubnetId(): void;
    get virtualNetworkSubnetIdInput(): string | undefined;
}
export declare class FunctionAppSlotSiteConfigScmIpRestrictionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FunctionAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FunctionAppSlotSiteConfigScmIpRestrictionOutputReference;
}
export interface FunctionAppSlotSiteConfigCors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#allowed_origins FunctionAppSlot#allowed_origins}
    */
    readonly allowedOrigins: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#support_credentials FunctionAppSlot#support_credentials}
    */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function functionAppSlotSiteConfigCorsToTerraform(struct?: FunctionAppSlotSiteConfigCorsOutputReference | FunctionAppSlotSiteConfigCors): any;
export declare function functionAppSlotSiteConfigCorsToHclTerraform(struct?: FunctionAppSlotSiteConfigCorsOutputReference | FunctionAppSlotSiteConfigCors): any;
export declare class FunctionAppSlotSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppSlotSiteConfigCors | undefined;
    set internalValue(value: FunctionAppSlotSiteConfigCors | undefined);
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    get supportCredentials(): boolean | cdktf.IResolvable;
    set supportCredentials(value: boolean | cdktf.IResolvable);
    resetSupportCredentials(): void;
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface FunctionAppSlotSiteConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#always_on FunctionAppSlot#always_on}
    */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#app_scale_limit FunctionAppSlot#app_scale_limit}
    */
    readonly appScaleLimit?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#auto_swap_slot_name FunctionAppSlot#auto_swap_slot_name}
    */
    readonly autoSwapSlotName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#dotnet_framework_version FunctionAppSlot#dotnet_framework_version}
    */
    readonly dotnetFrameworkVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#elastic_instance_minimum FunctionAppSlot#elastic_instance_minimum}
    */
    readonly elasticInstanceMinimum?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#ftps_state FunctionAppSlot#ftps_state}
    */
    readonly ftpsState?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#health_check_path FunctionAppSlot#health_check_path}
    */
    readonly healthCheckPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#http2_enabled FunctionAppSlot#http2_enabled}
    */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#ip_restriction FunctionAppSlot#ip_restriction}
    */
    readonly ipRestriction?: FunctionAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#java_version FunctionAppSlot#java_version}
    */
    readonly javaVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#linux_fx_version FunctionAppSlot#linux_fx_version}
    */
    readonly linuxFxVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#min_tls_version FunctionAppSlot#min_tls_version}
    */
    readonly minTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#pre_warmed_instance_count FunctionAppSlot#pre_warmed_instance_count}
    */
    readonly preWarmedInstanceCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#runtime_scale_monitoring_enabled FunctionAppSlot#runtime_scale_monitoring_enabled}
    */
    readonly runtimeScaleMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#scm_ip_restriction FunctionAppSlot#scm_ip_restriction}
    */
    readonly scmIpRestriction?: FunctionAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#scm_type FunctionAppSlot#scm_type}
    */
    readonly scmType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#scm_use_main_ip_restriction FunctionAppSlot#scm_use_main_ip_restriction}
    */
    readonly scmUseMainIpRestriction?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#use_32_bit_worker_process FunctionAppSlot#use_32_bit_worker_process}
    */
    readonly use32BitWorkerProcess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#vnet_route_all_enabled FunctionAppSlot#vnet_route_all_enabled}
    */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#websockets_enabled FunctionAppSlot#websockets_enabled}
    */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#cors FunctionAppSlot#cors}
    */
    readonly cors?: FunctionAppSlotSiteConfigCors;
}
export declare function functionAppSlotSiteConfigToTerraform(struct?: FunctionAppSlotSiteConfigOutputReference | FunctionAppSlotSiteConfig): any;
export declare function functionAppSlotSiteConfigToHclTerraform(struct?: FunctionAppSlotSiteConfigOutputReference | FunctionAppSlotSiteConfig): any;
export declare class FunctionAppSlotSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppSlotSiteConfig | undefined;
    set internalValue(value: FunctionAppSlotSiteConfig | undefined);
    private _alwaysOn?;
    get alwaysOn(): boolean | cdktf.IResolvable;
    set alwaysOn(value: boolean | cdktf.IResolvable);
    resetAlwaysOn(): void;
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _appScaleLimit?;
    get appScaleLimit(): number;
    set appScaleLimit(value: number);
    resetAppScaleLimit(): void;
    get appScaleLimitInput(): number | undefined;
    private _autoSwapSlotName?;
    get autoSwapSlotName(): string;
    set autoSwapSlotName(value: string);
    resetAutoSwapSlotName(): void;
    get autoSwapSlotNameInput(): string | undefined;
    private _dotnetFrameworkVersion?;
    get dotnetFrameworkVersion(): string;
    set dotnetFrameworkVersion(value: string);
    resetDotnetFrameworkVersion(): void;
    get dotnetFrameworkVersionInput(): string | undefined;
    private _elasticInstanceMinimum?;
    get elasticInstanceMinimum(): number;
    set elasticInstanceMinimum(value: number);
    resetElasticInstanceMinimum(): void;
    get elasticInstanceMinimumInput(): number | undefined;
    private _ftpsState?;
    get ftpsState(): string;
    set ftpsState(value: string);
    resetFtpsState(): void;
    get ftpsStateInput(): string | undefined;
    private _healthCheckPath?;
    get healthCheckPath(): string;
    set healthCheckPath(value: string);
    resetHealthCheckPath(): void;
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    get http2Enabled(): boolean | cdktf.IResolvable;
    set http2Enabled(value: boolean | cdktf.IResolvable);
    resetHttp2Enabled(): void;
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipRestriction;
    get ipRestriction(): FunctionAppSlotSiteConfigIpRestrictionList;
    putIpRestriction(value: FunctionAppSlotSiteConfigIpRestriction[] | cdktf.IResolvable): void;
    resetIpRestriction(): void;
    get ipRestrictionInput(): cdktf.IResolvable | FunctionAppSlotSiteConfigIpRestriction[] | undefined;
    private _javaVersion?;
    get javaVersion(): string;
    set javaVersion(value: string);
    resetJavaVersion(): void;
    get javaVersionInput(): string | undefined;
    private _linuxFxVersion?;
    get linuxFxVersion(): string;
    set linuxFxVersion(value: string);
    resetLinuxFxVersion(): void;
    get linuxFxVersionInput(): string | undefined;
    private _minTlsVersion?;
    get minTlsVersion(): string;
    set minTlsVersion(value: string);
    resetMinTlsVersion(): void;
    get minTlsVersionInput(): string | undefined;
    private _preWarmedInstanceCount?;
    get preWarmedInstanceCount(): number;
    set preWarmedInstanceCount(value: number);
    resetPreWarmedInstanceCount(): void;
    get preWarmedInstanceCountInput(): number | undefined;
    private _runtimeScaleMonitoringEnabled?;
    get runtimeScaleMonitoringEnabled(): boolean | cdktf.IResolvable;
    set runtimeScaleMonitoringEnabled(value: boolean | cdktf.IResolvable);
    resetRuntimeScaleMonitoringEnabled(): void;
    get runtimeScaleMonitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _scmIpRestriction;
    get scmIpRestriction(): FunctionAppSlotSiteConfigScmIpRestrictionList;
    putScmIpRestriction(value: FunctionAppSlotSiteConfigScmIpRestriction[] | cdktf.IResolvable): void;
    resetScmIpRestriction(): void;
    get scmIpRestrictionInput(): cdktf.IResolvable | FunctionAppSlotSiteConfigScmIpRestriction[] | undefined;
    private _scmType?;
    get scmType(): string;
    set scmType(value: string);
    resetScmType(): void;
    get scmTypeInput(): string | undefined;
    private _scmUseMainIpRestriction?;
    get scmUseMainIpRestriction(): boolean | cdktf.IResolvable;
    set scmUseMainIpRestriction(value: boolean | cdktf.IResolvable);
    resetScmUseMainIpRestriction(): void;
    get scmUseMainIpRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorkerProcess?;
    get use32BitWorkerProcess(): boolean | cdktf.IResolvable;
    set use32BitWorkerProcess(value: boolean | cdktf.IResolvable);
    resetUse32BitWorkerProcess(): void;
    get use32BitWorkerProcessInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    resetVnetRouteAllEnabled(): void;
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    resetWebsocketsEnabled(): void;
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cors;
    get cors(): FunctionAppSlotSiteConfigCorsOutputReference;
    putCors(value: FunctionAppSlotSiteConfigCors): void;
    resetCors(): void;
    get corsInput(): FunctionAppSlotSiteConfigCors | undefined;
}
export interface FunctionAppSlotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#create FunctionAppSlot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#delete FunctionAppSlot#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#read FunctionAppSlot#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#update FunctionAppSlot#update}
    */
    readonly update?: string;
}
export declare function functionAppSlotTimeoutsToTerraform(struct?: FunctionAppSlotTimeouts | cdktf.IResolvable): any;
export declare function functionAppSlotTimeoutsToHclTerraform(struct?: FunctionAppSlotTimeouts | cdktf.IResolvable): any;
export declare class FunctionAppSlotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FunctionAppSlotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FunctionAppSlotTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot azurerm_function_app_slot}
*/
export declare class FunctionAppSlot extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_function_app_slot";
    /**
    * Generates CDKTF code for importing a FunctionAppSlot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the FunctionAppSlot to import
    * @param importFromId The id of the existing FunctionAppSlot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the FunctionAppSlot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/function_app_slot azurerm_function_app_slot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FunctionAppSlotConfig
    */
    constructor(scope: Construct, id: string, config: FunctionAppSlotConfig);
    private _appServicePlanId?;
    get appServicePlanId(): string;
    set appServicePlanId(value: string);
    get appServicePlanIdInput(): string | undefined;
    private _appSettings?;
    get appSettings(): {
        [key: string]: string;
    };
    set appSettings(value: {
        [key: string]: string;
    });
    resetAppSettings(): void;
    get appSettingsInput(): {
        [key: string]: string;
    } | undefined;
    private _dailyMemoryTimeQuota?;
    get dailyMemoryTimeQuota(): number;
    set dailyMemoryTimeQuota(value: number);
    resetDailyMemoryTimeQuota(): void;
    get dailyMemoryTimeQuotaInput(): number | undefined;
    get defaultHostname(): string;
    private _enableBuiltinLogging?;
    get enableBuiltinLogging(): boolean | cdktf.IResolvable;
    set enableBuiltinLogging(value: boolean | cdktf.IResolvable);
    resetEnableBuiltinLogging(): void;
    get enableBuiltinLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _functionAppName?;
    get functionAppName(): string;
    set functionAppName(value: string);
    get functionAppNameInput(): string | undefined;
    private _httpsOnly?;
    get httpsOnly(): boolean | cdktf.IResolvable;
    set httpsOnly(value: boolean | cdktf.IResolvable);
    resetHttpsOnly(): void;
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get kind(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    resetOsType(): void;
    get osTypeInput(): string | undefined;
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _siteCredential;
    get siteCredential(): FunctionAppSlotSiteCredentialList;
    private _storageAccountAccessKey?;
    get storageAccountAccessKey(): string;
    set storageAccountAccessKey(value: string);
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _authSettings;
    get authSettings(): FunctionAppSlotAuthSettingsOutputReference;
    putAuthSettings(value: FunctionAppSlotAuthSettings): void;
    resetAuthSettings(): void;
    get authSettingsInput(): FunctionAppSlotAuthSettings | undefined;
    private _connectionString;
    get connectionString(): FunctionAppSlotConnectionStringList;
    putConnectionString(value: FunctionAppSlotConnectionString[] | cdktf.IResolvable): void;
    resetConnectionString(): void;
    get connectionStringInput(): cdktf.IResolvable | FunctionAppSlotConnectionString[] | undefined;
    private _identity;
    get identity(): FunctionAppSlotIdentityOutputReference;
    putIdentity(value: FunctionAppSlotIdentity): void;
    resetIdentity(): void;
    get identityInput(): FunctionAppSlotIdentity | undefined;
    private _siteConfig;
    get siteConfig(): FunctionAppSlotSiteConfigOutputReference;
    putSiteConfig(value: FunctionAppSlotSiteConfig): void;
    resetSiteConfig(): void;
    get siteConfigInput(): FunctionAppSlotSiteConfig | undefined;
    private _timeouts;
    get timeouts(): FunctionAppSlotTimeoutsOutputReference;
    putTimeouts(value: FunctionAppSlotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FunctionAppSlotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
