/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LocalNetworkGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#address_space LocalNetworkGateway#address_space}
    */
    readonly addressSpace?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#gateway_address LocalNetworkGateway#gateway_address}
    */
    readonly gatewayAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#gateway_fqdn LocalNetworkGateway#gateway_fqdn}
    */
    readonly gatewayFqdn?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#id LocalNetworkGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#location LocalNetworkGateway#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#name LocalNetworkGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#resource_group_name LocalNetworkGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#tags LocalNetworkGateway#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * bgp_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#bgp_settings LocalNetworkGateway#bgp_settings}
    */
    readonly bgpSettings?: LocalNetworkGatewayBgpSettings;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#timeouts LocalNetworkGateway#timeouts}
    */
    readonly timeouts?: LocalNetworkGatewayTimeouts;
}
export interface LocalNetworkGatewayBgpSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#asn LocalNetworkGateway#asn}
    */
    readonly asn: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#bgp_peering_address LocalNetworkGateway#bgp_peering_address}
    */
    readonly bgpPeeringAddress: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#peer_weight LocalNetworkGateway#peer_weight}
    */
    readonly peerWeight?: number;
}
export declare function localNetworkGatewayBgpSettingsToTerraform(struct?: LocalNetworkGatewayBgpSettingsOutputReference | LocalNetworkGatewayBgpSettings): any;
export declare function localNetworkGatewayBgpSettingsToHclTerraform(struct?: LocalNetworkGatewayBgpSettingsOutputReference | LocalNetworkGatewayBgpSettings): any;
export declare class LocalNetworkGatewayBgpSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LocalNetworkGatewayBgpSettings | undefined;
    set internalValue(value: LocalNetworkGatewayBgpSettings | undefined);
    private _asn?;
    get asn(): number;
    set asn(value: number);
    get asnInput(): number | undefined;
    private _bgpPeeringAddress?;
    get bgpPeeringAddress(): string;
    set bgpPeeringAddress(value: string);
    get bgpPeeringAddressInput(): string | undefined;
    private _peerWeight?;
    get peerWeight(): number;
    set peerWeight(value: number);
    resetPeerWeight(): void;
    get peerWeightInput(): number | undefined;
}
export interface LocalNetworkGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#create LocalNetworkGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#delete LocalNetworkGateway#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#read LocalNetworkGateway#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#update LocalNetworkGateway#update}
    */
    readonly update?: string;
}
export declare function localNetworkGatewayTimeoutsToTerraform(struct?: LocalNetworkGatewayTimeouts | cdktf.IResolvable): any;
export declare function localNetworkGatewayTimeoutsToHclTerraform(struct?: LocalNetworkGatewayTimeouts | cdktf.IResolvable): any;
export declare class LocalNetworkGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LocalNetworkGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LocalNetworkGatewayTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway azurerm_local_network_gateway}
*/
export declare class LocalNetworkGateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_local_network_gateway";
    /**
    * Generates CDKTF code for importing a LocalNetworkGateway resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LocalNetworkGateway to import
    * @param importFromId The id of the existing LocalNetworkGateway that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LocalNetworkGateway to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/local_network_gateway azurerm_local_network_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LocalNetworkGatewayConfig
    */
    constructor(scope: Construct, id: string, config: LocalNetworkGatewayConfig);
    private _addressSpace?;
    get addressSpace(): string[];
    set addressSpace(value: string[]);
    resetAddressSpace(): void;
    get addressSpaceInput(): string[] | undefined;
    private _gatewayAddress?;
    get gatewayAddress(): string;
    set gatewayAddress(value: string);
    resetGatewayAddress(): void;
    get gatewayAddressInput(): string | undefined;
    private _gatewayFqdn?;
    get gatewayFqdn(): string;
    set gatewayFqdn(value: string);
    resetGatewayFqdn(): void;
    get gatewayFqdnInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _bgpSettings;
    get bgpSettings(): LocalNetworkGatewayBgpSettingsOutputReference;
    putBgpSettings(value: LocalNetworkGatewayBgpSettings): void;
    resetBgpSettings(): void;
    get bgpSettingsInput(): LocalNetworkGatewayBgpSettings | undefined;
    private _timeouts;
    get timeouts(): LocalNetworkGatewayTimeoutsOutputReference;
    putTimeouts(value: LocalNetworkGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LocalNetworkGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
