/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MachineLearningSynapseSparkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#description MachineLearningSynapseSpark#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#id MachineLearningSynapseSpark#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#local_auth_enabled MachineLearningSynapseSpark#local_auth_enabled}
    */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#location MachineLearningSynapseSpark#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#machine_learning_workspace_id MachineLearningSynapseSpark#machine_learning_workspace_id}
    */
    readonly machineLearningWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#name MachineLearningSynapseSpark#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#synapse_spark_pool_id MachineLearningSynapseSpark#synapse_spark_pool_id}
    */
    readonly synapseSparkPoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#tags MachineLearningSynapseSpark#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#identity MachineLearningSynapseSpark#identity}
    */
    readonly identity?: MachineLearningSynapseSparkIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#timeouts MachineLearningSynapseSpark#timeouts}
    */
    readonly timeouts?: MachineLearningSynapseSparkTimeouts;
}
export interface MachineLearningSynapseSparkIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#identity_ids MachineLearningSynapseSpark#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#type MachineLearningSynapseSpark#type}
    */
    readonly type: string;
}
export declare function machineLearningSynapseSparkIdentityToTerraform(struct?: MachineLearningSynapseSparkIdentityOutputReference | MachineLearningSynapseSparkIdentity): any;
export declare function machineLearningSynapseSparkIdentityToHclTerraform(struct?: MachineLearningSynapseSparkIdentityOutputReference | MachineLearningSynapseSparkIdentity): any;
export declare class MachineLearningSynapseSparkIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningSynapseSparkIdentity | undefined;
    set internalValue(value: MachineLearningSynapseSparkIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MachineLearningSynapseSparkTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#create MachineLearningSynapseSpark#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#delete MachineLearningSynapseSpark#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#read MachineLearningSynapseSpark#read}
    */
    readonly read?: string;
}
export declare function machineLearningSynapseSparkTimeoutsToTerraform(struct?: MachineLearningSynapseSparkTimeouts | cdktf.IResolvable): any;
export declare function machineLearningSynapseSparkTimeoutsToHclTerraform(struct?: MachineLearningSynapseSparkTimeouts | cdktf.IResolvable): any;
export declare class MachineLearningSynapseSparkTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MachineLearningSynapseSparkTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MachineLearningSynapseSparkTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark azurerm_machine_learning_synapse_spark}
*/
export declare class MachineLearningSynapseSpark extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_machine_learning_synapse_spark";
    /**
    * Generates CDKTF code for importing a MachineLearningSynapseSpark resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MachineLearningSynapseSpark to import
    * @param importFromId The id of the existing MachineLearningSynapseSpark that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MachineLearningSynapseSpark to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/machine_learning_synapse_spark azurerm_machine_learning_synapse_spark} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MachineLearningSynapseSparkConfig
    */
    constructor(scope: Construct, id: string, config: MachineLearningSynapseSparkConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _localAuthEnabled?;
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthEnabled(): void;
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _machineLearningWorkspaceId?;
    get machineLearningWorkspaceId(): string;
    set machineLearningWorkspaceId(value: string);
    get machineLearningWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _synapseSparkPoolId?;
    get synapseSparkPoolId(): string;
    set synapseSparkPoolId(value: string);
    get synapseSparkPoolIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): MachineLearningSynapseSparkIdentityOutputReference;
    putIdentity(value: MachineLearningSynapseSparkIdentity): void;
    resetIdentity(): void;
    get identityInput(): MachineLearningSynapseSparkIdentity | undefined;
    private _timeouts;
    get timeouts(): MachineLearningSynapseSparkTimeoutsOutputReference;
    putTimeouts(value: MachineLearningSynapseSparkTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MachineLearningSynapseSparkTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
