/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MediaLiveEventOutputConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#archive_window_duration MediaLiveEventOutput#archive_window_duration}
    */
    readonly archiveWindowDuration: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#asset_name MediaLiveEventOutput#asset_name}
    */
    readonly assetName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#description MediaLiveEventOutput#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#hls_fragments_per_ts_segment MediaLiveEventOutput#hls_fragments_per_ts_segment}
    */
    readonly hlsFragmentsPerTsSegment?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#id MediaLiveEventOutput#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#live_event_id MediaLiveEventOutput#live_event_id}
    */
    readonly liveEventId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#manifest_name MediaLiveEventOutput#manifest_name}
    */
    readonly manifestName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#name MediaLiveEventOutput#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#output_snap_time_in_seconds MediaLiveEventOutput#output_snap_time_in_seconds}
    */
    readonly outputSnapTimeInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#rewind_window_duration MediaLiveEventOutput#rewind_window_duration}
    */
    readonly rewindWindowDuration?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#timeouts MediaLiveEventOutput#timeouts}
    */
    readonly timeouts?: MediaLiveEventOutputTimeouts;
}
export interface MediaLiveEventOutputTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#create MediaLiveEventOutput#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#delete MediaLiveEventOutput#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#read MediaLiveEventOutput#read}
    */
    readonly read?: string;
}
export declare function mediaLiveEventOutputTimeoutsToTerraform(struct?: MediaLiveEventOutputTimeouts | cdktf.IResolvable): any;
export declare function mediaLiveEventOutputTimeoutsToHclTerraform(struct?: MediaLiveEventOutputTimeouts | cdktf.IResolvable): any;
export declare class MediaLiveEventOutputTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaLiveEventOutputTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MediaLiveEventOutputTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output azurerm_media_live_event_output}
*/
export declare class MediaLiveEventOutput extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_media_live_event_output";
    /**
    * Generates CDKTF code for importing a MediaLiveEventOutput resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MediaLiveEventOutput to import
    * @param importFromId The id of the existing MediaLiveEventOutput that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MediaLiveEventOutput to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/media_live_event_output azurerm_media_live_event_output} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MediaLiveEventOutputConfig
    */
    constructor(scope: Construct, id: string, config: MediaLiveEventOutputConfig);
    private _archiveWindowDuration?;
    get archiveWindowDuration(): string;
    set archiveWindowDuration(value: string);
    get archiveWindowDurationInput(): string | undefined;
    private _assetName?;
    get assetName(): string;
    set assetName(value: string);
    get assetNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hlsFragmentsPerTsSegment?;
    get hlsFragmentsPerTsSegment(): number;
    set hlsFragmentsPerTsSegment(value: number);
    resetHlsFragmentsPerTsSegment(): void;
    get hlsFragmentsPerTsSegmentInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _liveEventId?;
    get liveEventId(): string;
    set liveEventId(value: string);
    get liveEventIdInput(): string | undefined;
    private _manifestName?;
    get manifestName(): string;
    set manifestName(value: string);
    resetManifestName(): void;
    get manifestNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _outputSnapTimeInSeconds?;
    get outputSnapTimeInSeconds(): number;
    set outputSnapTimeInSeconds(value: number);
    resetOutputSnapTimeInSeconds(): void;
    get outputSnapTimeInSecondsInput(): number | undefined;
    private _rewindWindowDuration?;
    get rewindWindowDuration(): string;
    set rewindWindowDuration(value: string);
    resetRewindWindowDuration(): void;
    get rewindWindowDurationInput(): string | undefined;
    private _timeouts;
    get timeouts(): MediaLiveEventOutputTimeoutsOutputReference;
    putTimeouts(value: MediaLiveEventOutputTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MediaLiveEventOutputTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
