/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkManagerAdminRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#action NetworkManagerAdminRule#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#admin_rule_collection_id NetworkManagerAdminRule#admin_rule_collection_id}
    */
    readonly adminRuleCollectionId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#description NetworkManagerAdminRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#destination_port_ranges NetworkManagerAdminRule#destination_port_ranges}
    */
    readonly destinationPortRanges?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#direction NetworkManagerAdminRule#direction}
    */
    readonly direction: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#id NetworkManagerAdminRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#name NetworkManagerAdminRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#priority NetworkManagerAdminRule#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#protocol NetworkManagerAdminRule#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#source_port_ranges NetworkManagerAdminRule#source_port_ranges}
    */
    readonly sourcePortRanges?: string[];
    /**
    * destination block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#destination NetworkManagerAdminRule#destination}
    */
    readonly destination?: NetworkManagerAdminRuleDestination[] | cdktf.IResolvable;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#source NetworkManagerAdminRule#source}
    */
    readonly source?: NetworkManagerAdminRuleSource[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#timeouts NetworkManagerAdminRule#timeouts}
    */
    readonly timeouts?: NetworkManagerAdminRuleTimeouts;
}
export interface NetworkManagerAdminRuleDestination {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#address_prefix NetworkManagerAdminRule#address_prefix}
    */
    readonly addressPrefix: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#address_prefix_type NetworkManagerAdminRule#address_prefix_type}
    */
    readonly addressPrefixType: string;
}
export declare function networkManagerAdminRuleDestinationToTerraform(struct?: NetworkManagerAdminRuleDestination | cdktf.IResolvable): any;
export declare function networkManagerAdminRuleDestinationToHclTerraform(struct?: NetworkManagerAdminRuleDestination | cdktf.IResolvable): any;
export declare class NetworkManagerAdminRuleDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetworkManagerAdminRuleDestination | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkManagerAdminRuleDestination | cdktf.IResolvable | undefined);
    private _addressPrefix?;
    get addressPrefix(): string;
    set addressPrefix(value: string);
    get addressPrefixInput(): string | undefined;
    private _addressPrefixType?;
    get addressPrefixType(): string;
    set addressPrefixType(value: string);
    get addressPrefixTypeInput(): string | undefined;
}
export declare class NetworkManagerAdminRuleDestinationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NetworkManagerAdminRuleDestination[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetworkManagerAdminRuleDestinationOutputReference;
}
export interface NetworkManagerAdminRuleSource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#address_prefix NetworkManagerAdminRule#address_prefix}
    */
    readonly addressPrefix: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#address_prefix_type NetworkManagerAdminRule#address_prefix_type}
    */
    readonly addressPrefixType: string;
}
export declare function networkManagerAdminRuleSourceToTerraform(struct?: NetworkManagerAdminRuleSource | cdktf.IResolvable): any;
export declare function networkManagerAdminRuleSourceToHclTerraform(struct?: NetworkManagerAdminRuleSource | cdktf.IResolvable): any;
export declare class NetworkManagerAdminRuleSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetworkManagerAdminRuleSource | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkManagerAdminRuleSource | cdktf.IResolvable | undefined);
    private _addressPrefix?;
    get addressPrefix(): string;
    set addressPrefix(value: string);
    get addressPrefixInput(): string | undefined;
    private _addressPrefixType?;
    get addressPrefixType(): string;
    set addressPrefixType(value: string);
    get addressPrefixTypeInput(): string | undefined;
}
export declare class NetworkManagerAdminRuleSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NetworkManagerAdminRuleSource[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetworkManagerAdminRuleSourceOutputReference;
}
export interface NetworkManagerAdminRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#create NetworkManagerAdminRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#delete NetworkManagerAdminRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#read NetworkManagerAdminRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#update NetworkManagerAdminRule#update}
    */
    readonly update?: string;
}
export declare function networkManagerAdminRuleTimeoutsToTerraform(struct?: NetworkManagerAdminRuleTimeouts | cdktf.IResolvable): any;
export declare function networkManagerAdminRuleTimeoutsToHclTerraform(struct?: NetworkManagerAdminRuleTimeouts | cdktf.IResolvable): any;
export declare class NetworkManagerAdminRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkManagerAdminRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkManagerAdminRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule azurerm_network_manager_admin_rule}
*/
export declare class NetworkManagerAdminRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_manager_admin_rule";
    /**
    * Generates CDKTF code for importing a NetworkManagerAdminRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetworkManagerAdminRule to import
    * @param importFromId The id of the existing NetworkManagerAdminRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetworkManagerAdminRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/network_manager_admin_rule azurerm_network_manager_admin_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkManagerAdminRuleConfig
    */
    constructor(scope: Construct, id: string, config: NetworkManagerAdminRuleConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _adminRuleCollectionId?;
    get adminRuleCollectionId(): string;
    set adminRuleCollectionId(value: string);
    get adminRuleCollectionIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destinationPortRanges?;
    get destinationPortRanges(): string[];
    set destinationPortRanges(value: string[]);
    resetDestinationPortRanges(): void;
    get destinationPortRangesInput(): string[] | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    get directionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _sourcePortRanges?;
    get sourcePortRanges(): string[];
    set sourcePortRanges(value: string[]);
    resetSourcePortRanges(): void;
    get sourcePortRangesInput(): string[] | undefined;
    private _destination;
    get destination(): NetworkManagerAdminRuleDestinationList;
    putDestination(value: NetworkManagerAdminRuleDestination[] | cdktf.IResolvable): void;
    resetDestination(): void;
    get destinationInput(): cdktf.IResolvable | NetworkManagerAdminRuleDestination[] | undefined;
    private _source;
    get source(): NetworkManagerAdminRuleSourceList;
    putSource(value: NetworkManagerAdminRuleSource[] | cdktf.IResolvable): void;
    resetSource(): void;
    get sourceInput(): cdktf.IResolvable | NetworkManagerAdminRuleSource[] | undefined;
    private _timeouts;
    get timeouts(): NetworkManagerAdminRuleTimeoutsOutputReference;
    putTimeouts(value: NetworkManagerAdminRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkManagerAdminRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
