/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrbitalContactConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/orbital_contact#contact_profile_id OrbitalContact#contact_profile_id}
    */
    readonly contactProfileId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/orbital_contact#ground_station_name OrbitalContact#ground_station_name}
    */
    readonly groundStationName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/orbital_contact#id OrbitalContact#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/orbital_contact#name OrbitalContact#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/orbital_contact#reservation_end_time OrbitalContact#reservation_end_time}
    */
    readonly reservationEndTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/orbital_contact#reservation_start_time OrbitalContact#reservation_start_time}
    */
    readonly reservationStartTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/orbital_contact#spacecraft_id OrbitalContact#spacecraft_id}
    */
    readonly spacecraftId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/orbital_contact#timeouts OrbitalContact#timeouts}
    */
    readonly timeouts?: OrbitalContactTimeouts;
}
export interface OrbitalContactTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/orbital_contact#create OrbitalContact#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/orbital_contact#delete OrbitalContact#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/orbital_contact#read OrbitalContact#read}
    */
    readonly read?: string;
}
export declare function orbitalContactTimeoutsToTerraform(struct?: OrbitalContactTimeouts | cdktf.IResolvable): any;
export declare function orbitalContactTimeoutsToHclTerraform(struct?: OrbitalContactTimeouts | cdktf.IResolvable): any;
export declare class OrbitalContactTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrbitalContactTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: OrbitalContactTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/orbital_contact azurerm_orbital_contact}
*/
export declare class OrbitalContact extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_orbital_contact";
    /**
    * Generates CDKTF code for importing a OrbitalContact resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the OrbitalContact to import
    * @param importFromId The id of the existing OrbitalContact that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/orbital_contact#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the OrbitalContact to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/orbital_contact azurerm_orbital_contact} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrbitalContactConfig
    */
    constructor(scope: Construct, id: string, config: OrbitalContactConfig);
    private _contactProfileId?;
    get contactProfileId(): string;
    set contactProfileId(value: string);
    get contactProfileIdInput(): string | undefined;
    private _groundStationName?;
    get groundStationName(): string;
    set groundStationName(value: string);
    get groundStationNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _reservationEndTime?;
    get reservationEndTime(): string;
    set reservationEndTime(value: string);
    get reservationEndTimeInput(): string | undefined;
    private _reservationStartTime?;
    get reservationStartTime(): string;
    set reservationStartTime(value: string);
    get reservationStartTimeInput(): string | undefined;
    private _spacecraftId?;
    get spacecraftId(): string;
    set spacecraftId(value: string);
    get spacecraftIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): OrbitalContactTimeoutsOutputReference;
    putTimeouts(value: OrbitalContactTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | OrbitalContactTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
