/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceGroupCostManagementExportConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#active ResourceGroupCostManagementExport#active}
    */
    readonly active?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#id ResourceGroupCostManagementExport#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#name ResourceGroupCostManagementExport#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#recurrence_period_end_date ResourceGroupCostManagementExport#recurrence_period_end_date}
    */
    readonly recurrencePeriodEndDate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#recurrence_period_start_date ResourceGroupCostManagementExport#recurrence_period_start_date}
    */
    readonly recurrencePeriodStartDate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#recurrence_type ResourceGroupCostManagementExport#recurrence_type}
    */
    readonly recurrenceType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#resource_group_id ResourceGroupCostManagementExport#resource_group_id}
    */
    readonly resourceGroupId: string;
    /**
    * export_data_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#export_data_options ResourceGroupCostManagementExport#export_data_options}
    */
    readonly exportDataOptions: ResourceGroupCostManagementExportExportDataOptions;
    /**
    * export_data_storage_location block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#export_data_storage_location ResourceGroupCostManagementExport#export_data_storage_location}
    */
    readonly exportDataStorageLocation: ResourceGroupCostManagementExportExportDataStorageLocation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#timeouts ResourceGroupCostManagementExport#timeouts}
    */
    readonly timeouts?: ResourceGroupCostManagementExportTimeouts;
}
export interface ResourceGroupCostManagementExportExportDataOptions {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#time_frame ResourceGroupCostManagementExport#time_frame}
    */
    readonly timeFrame: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#type ResourceGroupCostManagementExport#type}
    */
    readonly type: string;
}
export declare function resourceGroupCostManagementExportExportDataOptionsToTerraform(struct?: ResourceGroupCostManagementExportExportDataOptionsOutputReference | ResourceGroupCostManagementExportExportDataOptions): any;
export declare function resourceGroupCostManagementExportExportDataOptionsToHclTerraform(struct?: ResourceGroupCostManagementExportExportDataOptionsOutputReference | ResourceGroupCostManagementExportExportDataOptions): any;
export declare class ResourceGroupCostManagementExportExportDataOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceGroupCostManagementExportExportDataOptions | undefined;
    set internalValue(value: ResourceGroupCostManagementExportExportDataOptions | undefined);
    private _timeFrame?;
    get timeFrame(): string;
    set timeFrame(value: string);
    get timeFrameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ResourceGroupCostManagementExportExportDataStorageLocation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#container_id ResourceGroupCostManagementExport#container_id}
    */
    readonly containerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#root_folder_path ResourceGroupCostManagementExport#root_folder_path}
    */
    readonly rootFolderPath: string;
}
export declare function resourceGroupCostManagementExportExportDataStorageLocationToTerraform(struct?: ResourceGroupCostManagementExportExportDataStorageLocationOutputReference | ResourceGroupCostManagementExportExportDataStorageLocation): any;
export declare function resourceGroupCostManagementExportExportDataStorageLocationToHclTerraform(struct?: ResourceGroupCostManagementExportExportDataStorageLocationOutputReference | ResourceGroupCostManagementExportExportDataStorageLocation): any;
export declare class ResourceGroupCostManagementExportExportDataStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceGroupCostManagementExportExportDataStorageLocation | undefined;
    set internalValue(value: ResourceGroupCostManagementExportExportDataStorageLocation | undefined);
    private _containerId?;
    get containerId(): string;
    set containerId(value: string);
    get containerIdInput(): string | undefined;
    private _rootFolderPath?;
    get rootFolderPath(): string;
    set rootFolderPath(value: string);
    get rootFolderPathInput(): string | undefined;
}
export interface ResourceGroupCostManagementExportTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#create ResourceGroupCostManagementExport#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#delete ResourceGroupCostManagementExport#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#read ResourceGroupCostManagementExport#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#update ResourceGroupCostManagementExport#update}
    */
    readonly update?: string;
}
export declare function resourceGroupCostManagementExportTimeoutsToTerraform(struct?: ResourceGroupCostManagementExportTimeouts | cdktf.IResolvable): any;
export declare function resourceGroupCostManagementExportTimeoutsToHclTerraform(struct?: ResourceGroupCostManagementExportTimeouts | cdktf.IResolvable): any;
export declare class ResourceGroupCostManagementExportTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceGroupCostManagementExportTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceGroupCostManagementExportTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export azurerm_resource_group_cost_management_export}
*/
export declare class ResourceGroupCostManagementExport extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_resource_group_cost_management_export";
    /**
    * Generates CDKTF code for importing a ResourceGroupCostManagementExport resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ResourceGroupCostManagementExport to import
    * @param importFromId The id of the existing ResourceGroupCostManagementExport that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ResourceGroupCostManagementExport to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_group_cost_management_export azurerm_resource_group_cost_management_export} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceGroupCostManagementExportConfig
    */
    constructor(scope: Construct, id: string, config: ResourceGroupCostManagementExportConfig);
    private _active?;
    get active(): boolean | cdktf.IResolvable;
    set active(value: boolean | cdktf.IResolvable);
    resetActive(): void;
    get activeInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _recurrencePeriodEndDate?;
    get recurrencePeriodEndDate(): string;
    set recurrencePeriodEndDate(value: string);
    get recurrencePeriodEndDateInput(): string | undefined;
    private _recurrencePeriodStartDate?;
    get recurrencePeriodStartDate(): string;
    set recurrencePeriodStartDate(value: string);
    get recurrencePeriodStartDateInput(): string | undefined;
    private _recurrenceType?;
    get recurrenceType(): string;
    set recurrenceType(value: string);
    get recurrenceTypeInput(): string | undefined;
    private _resourceGroupId?;
    get resourceGroupId(): string;
    set resourceGroupId(value: string);
    get resourceGroupIdInput(): string | undefined;
    private _exportDataOptions;
    get exportDataOptions(): ResourceGroupCostManagementExportExportDataOptionsOutputReference;
    putExportDataOptions(value: ResourceGroupCostManagementExportExportDataOptions): void;
    get exportDataOptionsInput(): ResourceGroupCostManagementExportExportDataOptions | undefined;
    private _exportDataStorageLocation;
    get exportDataStorageLocation(): ResourceGroupCostManagementExportExportDataStorageLocationOutputReference;
    putExportDataStorageLocation(value: ResourceGroupCostManagementExportExportDataStorageLocation): void;
    get exportDataStorageLocationInput(): ResourceGroupCostManagementExportExportDataStorageLocation | undefined;
    private _timeouts;
    get timeouts(): ResourceGroupCostManagementExportTimeoutsOutputReference;
    putTimeouts(value: ResourceGroupCostManagementExportTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ResourceGroupCostManagementExportTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
