/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourcePolicyExemptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#description ResourcePolicyExemption#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#display_name ResourcePolicyExemption#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#exemption_category ResourcePolicyExemption#exemption_category}
    */
    readonly exemptionCategory: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#expires_on ResourcePolicyExemption#expires_on}
    */
    readonly expiresOn?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#id ResourcePolicyExemption#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#metadata ResourcePolicyExemption#metadata}
    */
    readonly metadata?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#name ResourcePolicyExemption#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#policy_assignment_id ResourcePolicyExemption#policy_assignment_id}
    */
    readonly policyAssignmentId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#policy_definition_reference_ids ResourcePolicyExemption#policy_definition_reference_ids}
    */
    readonly policyDefinitionReferenceIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#resource_id ResourcePolicyExemption#resource_id}
    */
    readonly resourceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#timeouts ResourcePolicyExemption#timeouts}
    */
    readonly timeouts?: ResourcePolicyExemptionTimeouts;
}
export interface ResourcePolicyExemptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#create ResourcePolicyExemption#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#delete ResourcePolicyExemption#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#read ResourcePolicyExemption#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#update ResourcePolicyExemption#update}
    */
    readonly update?: string;
}
export declare function resourcePolicyExemptionTimeoutsToTerraform(struct?: ResourcePolicyExemptionTimeouts | cdktf.IResolvable): any;
export declare function resourcePolicyExemptionTimeoutsToHclTerraform(struct?: ResourcePolicyExemptionTimeouts | cdktf.IResolvable): any;
export declare class ResourcePolicyExemptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourcePolicyExemptionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ResourcePolicyExemptionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption azurerm_resource_policy_exemption}
*/
export declare class ResourcePolicyExemption extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_resource_policy_exemption";
    /**
    * Generates CDKTF code for importing a ResourcePolicyExemption resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ResourcePolicyExemption to import
    * @param importFromId The id of the existing ResourcePolicyExemption that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ResourcePolicyExemption to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/resource_policy_exemption azurerm_resource_policy_exemption} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourcePolicyExemptionConfig
    */
    constructor(scope: Construct, id: string, config: ResourcePolicyExemptionConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _exemptionCategory?;
    get exemptionCategory(): string;
    set exemptionCategory(value: string);
    get exemptionCategoryInput(): string | undefined;
    private _expiresOn?;
    get expiresOn(): string;
    set expiresOn(value: string);
    resetExpiresOn(): void;
    get expiresOnInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    resetMetadata(): void;
    get metadataInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policyAssignmentId?;
    get policyAssignmentId(): string;
    set policyAssignmentId(value: string);
    get policyAssignmentIdInput(): string | undefined;
    private _policyDefinitionReferenceIds?;
    get policyDefinitionReferenceIds(): string[];
    set policyDefinitionReferenceIds(value: string[]);
    resetPolicyDefinitionReferenceIds(): void;
    get policyDefinitionReferenceIdsInput(): string[] | undefined;
    private _resourceId?;
    get resourceId(): string;
    set resourceId(value: string);
    get resourceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ResourcePolicyExemptionTimeoutsOutputReference;
    putTimeouts(value: ResourcePolicyExemptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ResourcePolicyExemptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
