/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SentinelWatchlistItemConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/sentinel_watchlist_item#id SentinelWatchlistItem#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/sentinel_watchlist_item#name SentinelWatchlistItem#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/sentinel_watchlist_item#properties SentinelWatchlistItem#properties}
    */
    readonly properties: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/sentinel_watchlist_item#watchlist_id SentinelWatchlistItem#watchlist_id}
    */
    readonly watchlistId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/sentinel_watchlist_item#timeouts SentinelWatchlistItem#timeouts}
    */
    readonly timeouts?: SentinelWatchlistItemTimeouts;
}
export interface SentinelWatchlistItemTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/sentinel_watchlist_item#create SentinelWatchlistItem#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/sentinel_watchlist_item#delete SentinelWatchlistItem#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/sentinel_watchlist_item#read SentinelWatchlistItem#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/sentinel_watchlist_item#update SentinelWatchlistItem#update}
    */
    readonly update?: string;
}
export declare function sentinelWatchlistItemTimeoutsToTerraform(struct?: SentinelWatchlistItemTimeouts | cdktf.IResolvable): any;
export declare function sentinelWatchlistItemTimeoutsToHclTerraform(struct?: SentinelWatchlistItemTimeouts | cdktf.IResolvable): any;
export declare class SentinelWatchlistItemTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SentinelWatchlistItemTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SentinelWatchlistItemTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/sentinel_watchlist_item azurerm_sentinel_watchlist_item}
*/
export declare class SentinelWatchlistItem extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_sentinel_watchlist_item";
    /**
    * Generates CDKTF code for importing a SentinelWatchlistItem resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SentinelWatchlistItem to import
    * @param importFromId The id of the existing SentinelWatchlistItem that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/sentinel_watchlist_item#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SentinelWatchlistItem to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/sentinel_watchlist_item azurerm_sentinel_watchlist_item} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SentinelWatchlistItemConfig
    */
    constructor(scope: Construct, id: string, config: SentinelWatchlistItemConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _watchlistId?;
    get watchlistId(): string;
    set watchlistId(value: string);
    get watchlistIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SentinelWatchlistItemTimeoutsOutputReference;
    putTimeouts(value: SentinelWatchlistItemTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SentinelWatchlistItemTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
