/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SignalrServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#aad_auth_enabled SignalrService#aad_auth_enabled}
    */
    readonly aadAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#connectivity_logs_enabled SignalrService#connectivity_logs_enabled}
    */
    readonly connectivityLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#http_request_logs_enabled SignalrService#http_request_logs_enabled}
    */
    readonly httpRequestLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#id SignalrService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#live_trace_enabled SignalrService#live_trace_enabled}
    */
    readonly liveTraceEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#local_auth_enabled SignalrService#local_auth_enabled}
    */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#location SignalrService#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#messaging_logs_enabled SignalrService#messaging_logs_enabled}
    */
    readonly messagingLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#name SignalrService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#public_network_access_enabled SignalrService#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#resource_group_name SignalrService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#serverless_connection_timeout_in_seconds SignalrService#serverless_connection_timeout_in_seconds}
    */
    readonly serverlessConnectionTimeoutInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#service_mode SignalrService#service_mode}
    */
    readonly serviceMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#tags SignalrService#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#tls_client_cert_enabled SignalrService#tls_client_cert_enabled}
    */
    readonly tlsClientCertEnabled?: boolean | cdktf.IResolvable;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#cors SignalrService#cors}
    */
    readonly cors?: SignalrServiceCors[] | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#identity SignalrService#identity}
    */
    readonly identity?: SignalrServiceIdentity;
    /**
    * live_trace block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#live_trace SignalrService#live_trace}
    */
    readonly liveTrace?: SignalrServiceLiveTrace;
    /**
    * sku block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#sku SignalrService#sku}
    */
    readonly sku: SignalrServiceSku;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#timeouts SignalrService#timeouts}
    */
    readonly timeouts?: SignalrServiceTimeouts;
    /**
    * upstream_endpoint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#upstream_endpoint SignalrService#upstream_endpoint}
    */
    readonly upstreamEndpoint?: SignalrServiceUpstreamEndpoint[] | cdktf.IResolvable;
}
export interface SignalrServiceCors {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#allowed_origins SignalrService#allowed_origins}
    */
    readonly allowedOrigins: string[];
}
export declare function signalrServiceCorsToTerraform(struct?: SignalrServiceCors | cdktf.IResolvable): any;
export declare function signalrServiceCorsToHclTerraform(struct?: SignalrServiceCors | cdktf.IResolvable): any;
export declare class SignalrServiceCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SignalrServiceCors | cdktf.IResolvable | undefined;
    set internalValue(value: SignalrServiceCors | cdktf.IResolvable | undefined);
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    get allowedOriginsInput(): string[] | undefined;
}
export declare class SignalrServiceCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SignalrServiceCors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SignalrServiceCorsOutputReference;
}
export interface SignalrServiceIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#identity_ids SignalrService#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#type SignalrService#type}
    */
    readonly type: string;
}
export declare function signalrServiceIdentityToTerraform(struct?: SignalrServiceIdentityOutputReference | SignalrServiceIdentity): any;
export declare function signalrServiceIdentityToHclTerraform(struct?: SignalrServiceIdentityOutputReference | SignalrServiceIdentity): any;
export declare class SignalrServiceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SignalrServiceIdentity | undefined;
    set internalValue(value: SignalrServiceIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface SignalrServiceLiveTrace {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#connectivity_logs_enabled SignalrService#connectivity_logs_enabled}
    */
    readonly connectivityLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#enabled SignalrService#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#http_request_logs_enabled SignalrService#http_request_logs_enabled}
    */
    readonly httpRequestLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#messaging_logs_enabled SignalrService#messaging_logs_enabled}
    */
    readonly messagingLogsEnabled?: boolean | cdktf.IResolvable;
}
export declare function signalrServiceLiveTraceToTerraform(struct?: SignalrServiceLiveTraceOutputReference | SignalrServiceLiveTrace): any;
export declare function signalrServiceLiveTraceToHclTerraform(struct?: SignalrServiceLiveTraceOutputReference | SignalrServiceLiveTrace): any;
export declare class SignalrServiceLiveTraceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SignalrServiceLiveTrace | undefined;
    set internalValue(value: SignalrServiceLiveTrace | undefined);
    private _connectivityLogsEnabled?;
    get connectivityLogsEnabled(): boolean | cdktf.IResolvable;
    set connectivityLogsEnabled(value: boolean | cdktf.IResolvable);
    resetConnectivityLogsEnabled(): void;
    get connectivityLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpRequestLogsEnabled?;
    get httpRequestLogsEnabled(): boolean | cdktf.IResolvable;
    set httpRequestLogsEnabled(value: boolean | cdktf.IResolvable);
    resetHttpRequestLogsEnabled(): void;
    get httpRequestLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _messagingLogsEnabled?;
    get messagingLogsEnabled(): boolean | cdktf.IResolvable;
    set messagingLogsEnabled(value: boolean | cdktf.IResolvable);
    resetMessagingLogsEnabled(): void;
    get messagingLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface SignalrServiceSku {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#capacity SignalrService#capacity}
    */
    readonly capacity: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#name SignalrService#name}
    */
    readonly name: string;
}
export declare function signalrServiceSkuToTerraform(struct?: SignalrServiceSkuOutputReference | SignalrServiceSku): any;
export declare function signalrServiceSkuToHclTerraform(struct?: SignalrServiceSkuOutputReference | SignalrServiceSku): any;
export declare class SignalrServiceSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SignalrServiceSku | undefined;
    set internalValue(value: SignalrServiceSku | undefined);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    get capacityInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export interface SignalrServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#create SignalrService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#delete SignalrService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#read SignalrService#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#update SignalrService#update}
    */
    readonly update?: string;
}
export declare function signalrServiceTimeoutsToTerraform(struct?: SignalrServiceTimeouts | cdktf.IResolvable): any;
export declare function signalrServiceTimeoutsToHclTerraform(struct?: SignalrServiceTimeouts | cdktf.IResolvable): any;
export declare class SignalrServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SignalrServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SignalrServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface SignalrServiceUpstreamEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#category_pattern SignalrService#category_pattern}
    */
    readonly categoryPattern: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#event_pattern SignalrService#event_pattern}
    */
    readonly eventPattern: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#hub_pattern SignalrService#hub_pattern}
    */
    readonly hubPattern: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#url_template SignalrService#url_template}
    */
    readonly urlTemplate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#user_assigned_identity_id SignalrService#user_assigned_identity_id}
    */
    readonly userAssignedIdentityId?: string;
}
export declare function signalrServiceUpstreamEndpointToTerraform(struct?: SignalrServiceUpstreamEndpoint | cdktf.IResolvable): any;
export declare function signalrServiceUpstreamEndpointToHclTerraform(struct?: SignalrServiceUpstreamEndpoint | cdktf.IResolvable): any;
export declare class SignalrServiceUpstreamEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SignalrServiceUpstreamEndpoint | cdktf.IResolvable | undefined;
    set internalValue(value: SignalrServiceUpstreamEndpoint | cdktf.IResolvable | undefined);
    private _categoryPattern?;
    get categoryPattern(): string[];
    set categoryPattern(value: string[]);
    get categoryPatternInput(): string[] | undefined;
    private _eventPattern?;
    get eventPattern(): string[];
    set eventPattern(value: string[]);
    get eventPatternInput(): string[] | undefined;
    private _hubPattern?;
    get hubPattern(): string[];
    set hubPattern(value: string[]);
    get hubPatternInput(): string[] | undefined;
    private _urlTemplate?;
    get urlTemplate(): string;
    set urlTemplate(value: string);
    get urlTemplateInput(): string | undefined;
    private _userAssignedIdentityId?;
    get userAssignedIdentityId(): string;
    set userAssignedIdentityId(value: string);
    resetUserAssignedIdentityId(): void;
    get userAssignedIdentityIdInput(): string | undefined;
}
export declare class SignalrServiceUpstreamEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SignalrServiceUpstreamEndpoint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SignalrServiceUpstreamEndpointOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service azurerm_signalr_service}
*/
export declare class SignalrService extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_signalr_service";
    /**
    * Generates CDKTF code for importing a SignalrService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SignalrService to import
    * @param importFromId The id of the existing SignalrService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SignalrService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/signalr_service azurerm_signalr_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SignalrServiceConfig
    */
    constructor(scope: Construct, id: string, config: SignalrServiceConfig);
    private _aadAuthEnabled?;
    get aadAuthEnabled(): boolean | cdktf.IResolvable;
    set aadAuthEnabled(value: boolean | cdktf.IResolvable);
    resetAadAuthEnabled(): void;
    get aadAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _connectivityLogsEnabled?;
    get connectivityLogsEnabled(): boolean | cdktf.IResolvable;
    set connectivityLogsEnabled(value: boolean | cdktf.IResolvable);
    resetConnectivityLogsEnabled(): void;
    get connectivityLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get hostname(): string;
    private _httpRequestLogsEnabled?;
    get httpRequestLogsEnabled(): boolean | cdktf.IResolvable;
    set httpRequestLogsEnabled(value: boolean | cdktf.IResolvable);
    resetHttpRequestLogsEnabled(): void;
    get httpRequestLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get ipAddress(): string;
    private _liveTraceEnabled?;
    get liveTraceEnabled(): boolean | cdktf.IResolvable;
    set liveTraceEnabled(value: boolean | cdktf.IResolvable);
    resetLiveTraceEnabled(): void;
    get liveTraceEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _localAuthEnabled?;
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthEnabled(): void;
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _messagingLogsEnabled?;
    get messagingLogsEnabled(): boolean | cdktf.IResolvable;
    set messagingLogsEnabled(value: boolean | cdktf.IResolvable);
    resetMessagingLogsEnabled(): void;
    get messagingLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    get primaryConnectionString(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get publicPort(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get secondaryConnectionString(): string;
    get serverPort(): number;
    private _serverlessConnectionTimeoutInSeconds?;
    get serverlessConnectionTimeoutInSeconds(): number;
    set serverlessConnectionTimeoutInSeconds(value: number);
    resetServerlessConnectionTimeoutInSeconds(): void;
    get serverlessConnectionTimeoutInSecondsInput(): number | undefined;
    private _serviceMode?;
    get serviceMode(): string;
    set serviceMode(value: string);
    resetServiceMode(): void;
    get serviceModeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tlsClientCertEnabled?;
    get tlsClientCertEnabled(): boolean | cdktf.IResolvable;
    set tlsClientCertEnabled(value: boolean | cdktf.IResolvable);
    resetTlsClientCertEnabled(): void;
    get tlsClientCertEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cors;
    get cors(): SignalrServiceCorsList;
    putCors(value: SignalrServiceCors[] | cdktf.IResolvable): void;
    resetCors(): void;
    get corsInput(): cdktf.IResolvable | SignalrServiceCors[] | undefined;
    private _identity;
    get identity(): SignalrServiceIdentityOutputReference;
    putIdentity(value: SignalrServiceIdentity): void;
    resetIdentity(): void;
    get identityInput(): SignalrServiceIdentity | undefined;
    private _liveTrace;
    get liveTrace(): SignalrServiceLiveTraceOutputReference;
    putLiveTrace(value: SignalrServiceLiveTrace): void;
    resetLiveTrace(): void;
    get liveTraceInput(): SignalrServiceLiveTrace | undefined;
    private _sku;
    get sku(): SignalrServiceSkuOutputReference;
    putSku(value: SignalrServiceSku): void;
    get skuInput(): SignalrServiceSku | undefined;
    private _timeouts;
    get timeouts(): SignalrServiceTimeoutsOutputReference;
    putTimeouts(value: SignalrServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SignalrServiceTimeouts | undefined;
    private _upstreamEndpoint;
    get upstreamEndpoint(): SignalrServiceUpstreamEndpointList;
    putUpstreamEndpoint(value: SignalrServiceUpstreamEndpoint[] | cdktf.IResolvable): void;
    resetUpstreamEndpoint(): void;
    get upstreamEndpointInput(): cdktf.IResolvable | SignalrServiceUpstreamEndpoint[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
