/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualHubConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#id VirtualHubConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#internet_security_enabled VirtualHubConnection#internet_security_enabled}
    */
    readonly internetSecurityEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#name VirtualHubConnection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#remote_virtual_network_id VirtualHubConnection#remote_virtual_network_id}
    */
    readonly remoteVirtualNetworkId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#virtual_hub_id VirtualHubConnection#virtual_hub_id}
    */
    readonly virtualHubId: string;
    /**
    * routing block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#routing VirtualHubConnection#routing}
    */
    readonly routing?: VirtualHubConnectionRouting;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#timeouts VirtualHubConnection#timeouts}
    */
    readonly timeouts?: VirtualHubConnectionTimeouts;
}
export interface VirtualHubConnectionRoutingPropagatedRouteTable {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#labels VirtualHubConnection#labels}
    */
    readonly labels?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#route_table_ids VirtualHubConnection#route_table_ids}
    */
    readonly routeTableIds?: string[];
}
export declare function virtualHubConnectionRoutingPropagatedRouteTableToTerraform(struct?: VirtualHubConnectionRoutingPropagatedRouteTableOutputReference | VirtualHubConnectionRoutingPropagatedRouteTable): any;
export declare function virtualHubConnectionRoutingPropagatedRouteTableToHclTerraform(struct?: VirtualHubConnectionRoutingPropagatedRouteTableOutputReference | VirtualHubConnectionRoutingPropagatedRouteTable): any;
export declare class VirtualHubConnectionRoutingPropagatedRouteTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualHubConnectionRoutingPropagatedRouteTable | undefined;
    set internalValue(value: VirtualHubConnectionRoutingPropagatedRouteTable | undefined);
    private _labels?;
    get labels(): string[];
    set labels(value: string[]);
    resetLabels(): void;
    get labelsInput(): string[] | undefined;
    private _routeTableIds?;
    get routeTableIds(): string[];
    set routeTableIds(value: string[]);
    resetRouteTableIds(): void;
    get routeTableIdsInput(): string[] | undefined;
}
export interface VirtualHubConnectionRoutingStaticVnetRoute {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#address_prefixes VirtualHubConnection#address_prefixes}
    */
    readonly addressPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#name VirtualHubConnection#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#next_hop_ip_address VirtualHubConnection#next_hop_ip_address}
    */
    readonly nextHopIpAddress?: string;
}
export declare function virtualHubConnectionRoutingStaticVnetRouteToTerraform(struct?: VirtualHubConnectionRoutingStaticVnetRoute | cdktf.IResolvable): any;
export declare function virtualHubConnectionRoutingStaticVnetRouteToHclTerraform(struct?: VirtualHubConnectionRoutingStaticVnetRoute | cdktf.IResolvable): any;
export declare class VirtualHubConnectionRoutingStaticVnetRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualHubConnectionRoutingStaticVnetRoute | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualHubConnectionRoutingStaticVnetRoute | cdktf.IResolvable | undefined);
    private _addressPrefixes?;
    get addressPrefixes(): string[];
    set addressPrefixes(value: string[]);
    resetAddressPrefixes(): void;
    get addressPrefixesInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _nextHopIpAddress?;
    get nextHopIpAddress(): string;
    set nextHopIpAddress(value: string);
    resetNextHopIpAddress(): void;
    get nextHopIpAddressInput(): string | undefined;
}
export declare class VirtualHubConnectionRoutingStaticVnetRouteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualHubConnectionRoutingStaticVnetRoute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualHubConnectionRoutingStaticVnetRouteOutputReference;
}
export interface VirtualHubConnectionRouting {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#associated_route_table_id VirtualHubConnection#associated_route_table_id}
    */
    readonly associatedRouteTableId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#inbound_route_map_id VirtualHubConnection#inbound_route_map_id}
    */
    readonly inboundRouteMapId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#outbound_route_map_id VirtualHubConnection#outbound_route_map_id}
    */
    readonly outboundRouteMapId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#static_vnet_local_route_override_criteria VirtualHubConnection#static_vnet_local_route_override_criteria}
    */
    readonly staticVnetLocalRouteOverrideCriteria?: string;
    /**
    * propagated_route_table block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#propagated_route_table VirtualHubConnection#propagated_route_table}
    */
    readonly propagatedRouteTable?: VirtualHubConnectionRoutingPropagatedRouteTable;
    /**
    * static_vnet_route block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#static_vnet_route VirtualHubConnection#static_vnet_route}
    */
    readonly staticVnetRoute?: VirtualHubConnectionRoutingStaticVnetRoute[] | cdktf.IResolvable;
}
export declare function virtualHubConnectionRoutingToTerraform(struct?: VirtualHubConnectionRoutingOutputReference | VirtualHubConnectionRouting): any;
export declare function virtualHubConnectionRoutingToHclTerraform(struct?: VirtualHubConnectionRoutingOutputReference | VirtualHubConnectionRouting): any;
export declare class VirtualHubConnectionRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualHubConnectionRouting | undefined;
    set internalValue(value: VirtualHubConnectionRouting | undefined);
    private _associatedRouteTableId?;
    get associatedRouteTableId(): string;
    set associatedRouteTableId(value: string);
    resetAssociatedRouteTableId(): void;
    get associatedRouteTableIdInput(): string | undefined;
    private _inboundRouteMapId?;
    get inboundRouteMapId(): string;
    set inboundRouteMapId(value: string);
    resetInboundRouteMapId(): void;
    get inboundRouteMapIdInput(): string | undefined;
    private _outboundRouteMapId?;
    get outboundRouteMapId(): string;
    set outboundRouteMapId(value: string);
    resetOutboundRouteMapId(): void;
    get outboundRouteMapIdInput(): string | undefined;
    private _staticVnetLocalRouteOverrideCriteria?;
    get staticVnetLocalRouteOverrideCriteria(): string;
    set staticVnetLocalRouteOverrideCriteria(value: string);
    resetStaticVnetLocalRouteOverrideCriteria(): void;
    get staticVnetLocalRouteOverrideCriteriaInput(): string | undefined;
    private _propagatedRouteTable;
    get propagatedRouteTable(): VirtualHubConnectionRoutingPropagatedRouteTableOutputReference;
    putPropagatedRouteTable(value: VirtualHubConnectionRoutingPropagatedRouteTable): void;
    resetPropagatedRouteTable(): void;
    get propagatedRouteTableInput(): VirtualHubConnectionRoutingPropagatedRouteTable | undefined;
    private _staticVnetRoute;
    get staticVnetRoute(): VirtualHubConnectionRoutingStaticVnetRouteList;
    putStaticVnetRoute(value: VirtualHubConnectionRoutingStaticVnetRoute[] | cdktf.IResolvable): void;
    resetStaticVnetRoute(): void;
    get staticVnetRouteInput(): cdktf.IResolvable | VirtualHubConnectionRoutingStaticVnetRoute[] | undefined;
}
export interface VirtualHubConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#create VirtualHubConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#delete VirtualHubConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#read VirtualHubConnection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#update VirtualHubConnection#update}
    */
    readonly update?: string;
}
export declare function virtualHubConnectionTimeoutsToTerraform(struct?: VirtualHubConnectionTimeouts | cdktf.IResolvable): any;
export declare function virtualHubConnectionTimeoutsToHclTerraform(struct?: VirtualHubConnectionTimeouts | cdktf.IResolvable): any;
export declare class VirtualHubConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualHubConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualHubConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection azurerm_virtual_hub_connection}
*/
export declare class VirtualHubConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_hub_connection";
    /**
    * Generates CDKTF code for importing a VirtualHubConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualHubConnection to import
    * @param importFromId The id of the existing VirtualHubConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualHubConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_hub_connection azurerm_virtual_hub_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualHubConnectionConfig
    */
    constructor(scope: Construct, id: string, config: VirtualHubConnectionConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _internetSecurityEnabled?;
    get internetSecurityEnabled(): boolean | cdktf.IResolvable;
    set internetSecurityEnabled(value: boolean | cdktf.IResolvable);
    resetInternetSecurityEnabled(): void;
    get internetSecurityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _remoteVirtualNetworkId?;
    get remoteVirtualNetworkId(): string;
    set remoteVirtualNetworkId(value: string);
    get remoteVirtualNetworkIdInput(): string | undefined;
    private _virtualHubId?;
    get virtualHubId(): string;
    set virtualHubId(value: string);
    get virtualHubIdInput(): string | undefined;
    private _routing;
    get routing(): VirtualHubConnectionRoutingOutputReference;
    putRouting(value: VirtualHubConnectionRouting): void;
    resetRouting(): void;
    get routingInput(): VirtualHubConnectionRouting | undefined;
    private _timeouts;
    get timeouts(): VirtualHubConnectionTimeoutsOutputReference;
    putTimeouts(value: VirtualHubConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualHubConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
