/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VirtualMachineScaleSetPacketCaptureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#id VirtualMachineScaleSetPacketCapture#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#maximum_bytes_per_packet VirtualMachineScaleSetPacketCapture#maximum_bytes_per_packet}
    */
    readonly maximumBytesPerPacket?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#maximum_bytes_per_session VirtualMachineScaleSetPacketCapture#maximum_bytes_per_session}
    */
    readonly maximumBytesPerSession?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#maximum_capture_duration_in_seconds VirtualMachineScaleSetPacketCapture#maximum_capture_duration_in_seconds}
    */
    readonly maximumCaptureDurationInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#name VirtualMachineScaleSetPacketCapture#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#network_watcher_id VirtualMachineScaleSetPacketCapture#network_watcher_id}
    */
    readonly networkWatcherId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#virtual_machine_scale_set_id VirtualMachineScaleSetPacketCapture#virtual_machine_scale_set_id}
    */
    readonly virtualMachineScaleSetId: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#filter VirtualMachineScaleSetPacketCapture#filter}
    */
    readonly filter?: VirtualMachineScaleSetPacketCaptureFilter[] | cdktf.IResolvable;
    /**
    * machine_scope block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#machine_scope VirtualMachineScaleSetPacketCapture#machine_scope}
    */
    readonly machineScope?: VirtualMachineScaleSetPacketCaptureMachineScope;
    /**
    * storage_location block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#storage_location VirtualMachineScaleSetPacketCapture#storage_location}
    */
    readonly storageLocation: VirtualMachineScaleSetPacketCaptureStorageLocation;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#timeouts VirtualMachineScaleSetPacketCapture#timeouts}
    */
    readonly timeouts?: VirtualMachineScaleSetPacketCaptureTimeouts;
}
export interface VirtualMachineScaleSetPacketCaptureFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#local_ip_address VirtualMachineScaleSetPacketCapture#local_ip_address}
    */
    readonly localIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#local_port VirtualMachineScaleSetPacketCapture#local_port}
    */
    readonly localPort?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#protocol VirtualMachineScaleSetPacketCapture#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#remote_ip_address VirtualMachineScaleSetPacketCapture#remote_ip_address}
    */
    readonly remoteIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#remote_port VirtualMachineScaleSetPacketCapture#remote_port}
    */
    readonly remotePort?: string;
}
export declare function virtualMachineScaleSetPacketCaptureFilterToTerraform(struct?: VirtualMachineScaleSetPacketCaptureFilter | cdktf.IResolvable): any;
export declare function virtualMachineScaleSetPacketCaptureFilterToHclTerraform(struct?: VirtualMachineScaleSetPacketCaptureFilter | cdktf.IResolvable): any;
export declare class VirtualMachineScaleSetPacketCaptureFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VirtualMachineScaleSetPacketCaptureFilter | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineScaleSetPacketCaptureFilter | cdktf.IResolvable | undefined);
    private _localIpAddress?;
    get localIpAddress(): string;
    set localIpAddress(value: string);
    resetLocalIpAddress(): void;
    get localIpAddressInput(): string | undefined;
    private _localPort?;
    get localPort(): string;
    set localPort(value: string);
    resetLocalPort(): void;
    get localPortInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _remoteIpAddress?;
    get remoteIpAddress(): string;
    set remoteIpAddress(value: string);
    resetRemoteIpAddress(): void;
    get remoteIpAddressInput(): string | undefined;
    private _remotePort?;
    get remotePort(): string;
    set remotePort(value: string);
    resetRemotePort(): void;
    get remotePortInput(): string | undefined;
}
export declare class VirtualMachineScaleSetPacketCaptureFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: VirtualMachineScaleSetPacketCaptureFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VirtualMachineScaleSetPacketCaptureFilterOutputReference;
}
export interface VirtualMachineScaleSetPacketCaptureMachineScope {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#exclude_instance_ids VirtualMachineScaleSetPacketCapture#exclude_instance_ids}
    */
    readonly excludeInstanceIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#include_instance_ids VirtualMachineScaleSetPacketCapture#include_instance_ids}
    */
    readonly includeInstanceIds?: string[];
}
export declare function virtualMachineScaleSetPacketCaptureMachineScopeToTerraform(struct?: VirtualMachineScaleSetPacketCaptureMachineScopeOutputReference | VirtualMachineScaleSetPacketCaptureMachineScope): any;
export declare function virtualMachineScaleSetPacketCaptureMachineScopeToHclTerraform(struct?: VirtualMachineScaleSetPacketCaptureMachineScopeOutputReference | VirtualMachineScaleSetPacketCaptureMachineScope): any;
export declare class VirtualMachineScaleSetPacketCaptureMachineScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineScaleSetPacketCaptureMachineScope | undefined;
    set internalValue(value: VirtualMachineScaleSetPacketCaptureMachineScope | undefined);
    private _excludeInstanceIds?;
    get excludeInstanceIds(): string[];
    set excludeInstanceIds(value: string[]);
    resetExcludeInstanceIds(): void;
    get excludeInstanceIdsInput(): string[] | undefined;
    private _includeInstanceIds?;
    get includeInstanceIds(): string[];
    set includeInstanceIds(value: string[]);
    resetIncludeInstanceIds(): void;
    get includeInstanceIdsInput(): string[] | undefined;
}
export interface VirtualMachineScaleSetPacketCaptureStorageLocation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#file_path VirtualMachineScaleSetPacketCapture#file_path}
    */
    readonly filePath?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#storage_account_id VirtualMachineScaleSetPacketCapture#storage_account_id}
    */
    readonly storageAccountId?: string;
}
export declare function virtualMachineScaleSetPacketCaptureStorageLocationToTerraform(struct?: VirtualMachineScaleSetPacketCaptureStorageLocationOutputReference | VirtualMachineScaleSetPacketCaptureStorageLocation): any;
export declare function virtualMachineScaleSetPacketCaptureStorageLocationToHclTerraform(struct?: VirtualMachineScaleSetPacketCaptureStorageLocationOutputReference | VirtualMachineScaleSetPacketCaptureStorageLocation): any;
export declare class VirtualMachineScaleSetPacketCaptureStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineScaleSetPacketCaptureStorageLocation | undefined;
    set internalValue(value: VirtualMachineScaleSetPacketCaptureStorageLocation | undefined);
    private _filePath?;
    get filePath(): string;
    set filePath(value: string);
    resetFilePath(): void;
    get filePathInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    resetStorageAccountId(): void;
    get storageAccountIdInput(): string | undefined;
    get storagePath(): string;
}
export interface VirtualMachineScaleSetPacketCaptureTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#create VirtualMachineScaleSetPacketCapture#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#delete VirtualMachineScaleSetPacketCapture#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#read VirtualMachineScaleSetPacketCapture#read}
    */
    readonly read?: string;
}
export declare function virtualMachineScaleSetPacketCaptureTimeoutsToTerraform(struct?: VirtualMachineScaleSetPacketCaptureTimeouts | cdktf.IResolvable): any;
export declare function virtualMachineScaleSetPacketCaptureTimeoutsToHclTerraform(struct?: VirtualMachineScaleSetPacketCaptureTimeouts | cdktf.IResolvable): any;
export declare class VirtualMachineScaleSetPacketCaptureTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VirtualMachineScaleSetPacketCaptureTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VirtualMachineScaleSetPacketCaptureTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture azurerm_virtual_machine_scale_set_packet_capture}
*/
export declare class VirtualMachineScaleSetPacketCapture extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_virtual_machine_scale_set_packet_capture";
    /**
    * Generates CDKTF code for importing a VirtualMachineScaleSetPacketCapture resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VirtualMachineScaleSetPacketCapture to import
    * @param importFromId The id of the existing VirtualMachineScaleSetPacketCapture that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VirtualMachineScaleSetPacketCapture to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.101.0/docs/resources/virtual_machine_scale_set_packet_capture azurerm_virtual_machine_scale_set_packet_capture} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VirtualMachineScaleSetPacketCaptureConfig
    */
    constructor(scope: Construct, id: string, config: VirtualMachineScaleSetPacketCaptureConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maximumBytesPerPacket?;
    get maximumBytesPerPacket(): number;
    set maximumBytesPerPacket(value: number);
    resetMaximumBytesPerPacket(): void;
    get maximumBytesPerPacketInput(): number | undefined;
    private _maximumBytesPerSession?;
    get maximumBytesPerSession(): number;
    set maximumBytesPerSession(value: number);
    resetMaximumBytesPerSession(): void;
    get maximumBytesPerSessionInput(): number | undefined;
    private _maximumCaptureDurationInSeconds?;
    get maximumCaptureDurationInSeconds(): number;
    set maximumCaptureDurationInSeconds(value: number);
    resetMaximumCaptureDurationInSeconds(): void;
    get maximumCaptureDurationInSecondsInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkWatcherId?;
    get networkWatcherId(): string;
    set networkWatcherId(value: string);
    get networkWatcherIdInput(): string | undefined;
    private _virtualMachineScaleSetId?;
    get virtualMachineScaleSetId(): string;
    set virtualMachineScaleSetId(value: string);
    get virtualMachineScaleSetIdInput(): string | undefined;
    private _filter;
    get filter(): VirtualMachineScaleSetPacketCaptureFilterList;
    putFilter(value: VirtualMachineScaleSetPacketCaptureFilter[] | cdktf.IResolvable): void;
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | VirtualMachineScaleSetPacketCaptureFilter[] | undefined;
    private _machineScope;
    get machineScope(): VirtualMachineScaleSetPacketCaptureMachineScopeOutputReference;
    putMachineScope(value: VirtualMachineScaleSetPacketCaptureMachineScope): void;
    resetMachineScope(): void;
    get machineScopeInput(): VirtualMachineScaleSetPacketCaptureMachineScope | undefined;
    private _storageLocation;
    get storageLocation(): VirtualMachineScaleSetPacketCaptureStorageLocationOutputReference;
    putStorageLocation(value: VirtualMachineScaleSetPacketCaptureStorageLocation): void;
    get storageLocationInput(): VirtualMachineScaleSetPacketCaptureStorageLocation | undefined;
    private _timeouts;
    get timeouts(): VirtualMachineScaleSetPacketCaptureTimeoutsOutputReference;
    putTimeouts(value: VirtualMachineScaleSetPacketCaptureTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VirtualMachineScaleSetPacketCaptureTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
