"""
The tool to check the availability or syntax of domains, IPv4, IPv6 or URL.

::


    ██████╗ ██╗   ██╗███████╗██╗   ██╗███╗   ██╗ ██████╗███████╗██████╗ ██╗     ███████╗
    ██╔══██╗╚██╗ ██╔╝██╔════╝██║   ██║████╗  ██║██╔════╝██╔════╝██╔══██╗██║     ██╔════╝
    ██████╔╝ ╚████╔╝ █████╗  ██║   ██║██╔██╗ ██║██║     █████╗  ██████╔╝██║     █████╗
    ██╔═══╝   ╚██╔╝  ██╔══╝  ██║   ██║██║╚██╗██║██║     ██╔══╝  ██╔══██╗██║     ██╔══╝
    ██║        ██║   ██║     ╚██████╔╝██║ ╚████║╚██████╗███████╗██████╔╝███████╗███████╗
    ╚═╝        ╚═╝   ╚═╝      ╚═════╝ ╚═╝  ╚═══╝ ╚═════╝╚══════╝╚═════╝ ╚══════╝╚══════╝

This project is part of the PyFunceble project and infrastructure.

Provides the base of the cores which are doing Input/Output related jobs.

Author:
    Nissar Chababy, @funilrys, contactTATAfunilrysTODTODcom

Special thanks:
    https://pyfunceble.github.io/special-thanks.html

Contributors:
    https://pyfunceble.github.io/contributors.html

Project link:
    https://github.com/funilrys/PyFunceble

Project documentation:
    https://pyfunceble.readthedocs.io/en/dev/

Project homepage:
    https://pyfunceble.github.io/

License:
::


    Copyright 2017, 2018, 2019, 2020, 2021, 2022 Nissar Chababy

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from io import TextIOWrapper
from typing import Optional

from adblock_decoder.core.base import BaseCore
from adblock_decoder.exceptions import InputNotAFileWrapper, OutputNotAFileWrapper


class IOBase(BaseCore):
    """
    Provides the base of the I/O classes.

    :param input_file:
        The input file to traverse.
    :param aggressive:
        The decoding mode.
    :param output:
        The output file to write.
    """

    def __init__(
        self,
        input_file: TextIOWrapper,
        aggressive: bool = False,
        output: Optional[TextIOWrapper] = None,
    ):
        super().__init__()

        if not isinstance(input_file, TextIOWrapper):
            raise InputNotAFileWrapper(type(input_file))

        if output is not None and not isinstance(output, TextIOWrapper):
            raise OutputNotAFileWrapper(type(output))

        self.set_aggressive(aggressive)

        self.input = input_file
        self.output = output

    def process_conversion(self) -> None:
        """
        Process the actual conversion.
        """

        raise NotImplementedError()
