# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCiscoOmpFeatureTemplateResult',
    'AwaitableGetCiscoOmpFeatureTemplateResult',
    'get_cisco_omp_feature_template',
    'get_cisco_omp_feature_template_output',
]

@pulumi.output_type
class GetCiscoOmpFeatureTemplateResult:
    """
    A collection of values returned by getCiscoOmpFeatureTemplate.
    """
    def __init__(__self__, advertise_ipv4_routes=None, advertise_ipv6_routes=None, advertisement_interval=None, advertisement_interval_variable=None, description=None, device_types=None, ecmp_limit=None, ecmp_limit_variable=None, eor_timer=None, eor_timer_variable=None, graceful_restart=None, graceful_restart_timer=None, graceful_restart_timer_variable=None, graceful_restart_variable=None, holdtime=None, holdtime_variable=None, id=None, ignore_region_path_length=None, ignore_region_path_length_variable=None, name=None, omp_admin_distance_ipv4=None, omp_admin_distance_ipv4_variable=None, omp_admin_distance_ipv6=None, omp_admin_distance_ipv6_variable=None, overlay_as=None, overlay_as_variable=None, send_path_limit=None, send_path_limit_variable=None, shutdown=None, shutdown_variable=None, template_type=None, transport_gateway=None, transport_gateway_variable=None, version=None):
        if advertise_ipv4_routes and not isinstance(advertise_ipv4_routes, list):
            raise TypeError("Expected argument 'advertise_ipv4_routes' to be a list")
        pulumi.set(__self__, "advertise_ipv4_routes", advertise_ipv4_routes)
        if advertise_ipv6_routes and not isinstance(advertise_ipv6_routes, list):
            raise TypeError("Expected argument 'advertise_ipv6_routes' to be a list")
        pulumi.set(__self__, "advertise_ipv6_routes", advertise_ipv6_routes)
        if advertisement_interval and not isinstance(advertisement_interval, int):
            raise TypeError("Expected argument 'advertisement_interval' to be a int")
        pulumi.set(__self__, "advertisement_interval", advertisement_interval)
        if advertisement_interval_variable and not isinstance(advertisement_interval_variable, str):
            raise TypeError("Expected argument 'advertisement_interval_variable' to be a str")
        pulumi.set(__self__, "advertisement_interval_variable", advertisement_interval_variable)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_types and not isinstance(device_types, list):
            raise TypeError("Expected argument 'device_types' to be a list")
        pulumi.set(__self__, "device_types", device_types)
        if ecmp_limit and not isinstance(ecmp_limit, int):
            raise TypeError("Expected argument 'ecmp_limit' to be a int")
        pulumi.set(__self__, "ecmp_limit", ecmp_limit)
        if ecmp_limit_variable and not isinstance(ecmp_limit_variable, str):
            raise TypeError("Expected argument 'ecmp_limit_variable' to be a str")
        pulumi.set(__self__, "ecmp_limit_variable", ecmp_limit_variable)
        if eor_timer and not isinstance(eor_timer, int):
            raise TypeError("Expected argument 'eor_timer' to be a int")
        pulumi.set(__self__, "eor_timer", eor_timer)
        if eor_timer_variable and not isinstance(eor_timer_variable, str):
            raise TypeError("Expected argument 'eor_timer_variable' to be a str")
        pulumi.set(__self__, "eor_timer_variable", eor_timer_variable)
        if graceful_restart and not isinstance(graceful_restart, bool):
            raise TypeError("Expected argument 'graceful_restart' to be a bool")
        pulumi.set(__self__, "graceful_restart", graceful_restart)
        if graceful_restart_timer and not isinstance(graceful_restart_timer, int):
            raise TypeError("Expected argument 'graceful_restart_timer' to be a int")
        pulumi.set(__self__, "graceful_restart_timer", graceful_restart_timer)
        if graceful_restart_timer_variable and not isinstance(graceful_restart_timer_variable, str):
            raise TypeError("Expected argument 'graceful_restart_timer_variable' to be a str")
        pulumi.set(__self__, "graceful_restart_timer_variable", graceful_restart_timer_variable)
        if graceful_restart_variable and not isinstance(graceful_restart_variable, str):
            raise TypeError("Expected argument 'graceful_restart_variable' to be a str")
        pulumi.set(__self__, "graceful_restart_variable", graceful_restart_variable)
        if holdtime and not isinstance(holdtime, int):
            raise TypeError("Expected argument 'holdtime' to be a int")
        pulumi.set(__self__, "holdtime", holdtime)
        if holdtime_variable and not isinstance(holdtime_variable, str):
            raise TypeError("Expected argument 'holdtime_variable' to be a str")
        pulumi.set(__self__, "holdtime_variable", holdtime_variable)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ignore_region_path_length and not isinstance(ignore_region_path_length, bool):
            raise TypeError("Expected argument 'ignore_region_path_length' to be a bool")
        pulumi.set(__self__, "ignore_region_path_length", ignore_region_path_length)
        if ignore_region_path_length_variable and not isinstance(ignore_region_path_length_variable, str):
            raise TypeError("Expected argument 'ignore_region_path_length_variable' to be a str")
        pulumi.set(__self__, "ignore_region_path_length_variable", ignore_region_path_length_variable)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if omp_admin_distance_ipv4 and not isinstance(omp_admin_distance_ipv4, int):
            raise TypeError("Expected argument 'omp_admin_distance_ipv4' to be a int")
        pulumi.set(__self__, "omp_admin_distance_ipv4", omp_admin_distance_ipv4)
        if omp_admin_distance_ipv4_variable and not isinstance(omp_admin_distance_ipv4_variable, str):
            raise TypeError("Expected argument 'omp_admin_distance_ipv4_variable' to be a str")
        pulumi.set(__self__, "omp_admin_distance_ipv4_variable", omp_admin_distance_ipv4_variable)
        if omp_admin_distance_ipv6 and not isinstance(omp_admin_distance_ipv6, int):
            raise TypeError("Expected argument 'omp_admin_distance_ipv6' to be a int")
        pulumi.set(__self__, "omp_admin_distance_ipv6", omp_admin_distance_ipv6)
        if omp_admin_distance_ipv6_variable and not isinstance(omp_admin_distance_ipv6_variable, str):
            raise TypeError("Expected argument 'omp_admin_distance_ipv6_variable' to be a str")
        pulumi.set(__self__, "omp_admin_distance_ipv6_variable", omp_admin_distance_ipv6_variable)
        if overlay_as and not isinstance(overlay_as, int):
            raise TypeError("Expected argument 'overlay_as' to be a int")
        pulumi.set(__self__, "overlay_as", overlay_as)
        if overlay_as_variable and not isinstance(overlay_as_variable, str):
            raise TypeError("Expected argument 'overlay_as_variable' to be a str")
        pulumi.set(__self__, "overlay_as_variable", overlay_as_variable)
        if send_path_limit and not isinstance(send_path_limit, int):
            raise TypeError("Expected argument 'send_path_limit' to be a int")
        pulumi.set(__self__, "send_path_limit", send_path_limit)
        if send_path_limit_variable and not isinstance(send_path_limit_variable, str):
            raise TypeError("Expected argument 'send_path_limit_variable' to be a str")
        pulumi.set(__self__, "send_path_limit_variable", send_path_limit_variable)
        if shutdown and not isinstance(shutdown, bool):
            raise TypeError("Expected argument 'shutdown' to be a bool")
        pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable and not isinstance(shutdown_variable, str):
            raise TypeError("Expected argument 'shutdown_variable' to be a str")
        pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if template_type and not isinstance(template_type, str):
            raise TypeError("Expected argument 'template_type' to be a str")
        pulumi.set(__self__, "template_type", template_type)
        if transport_gateway and not isinstance(transport_gateway, str):
            raise TypeError("Expected argument 'transport_gateway' to be a str")
        pulumi.set(__self__, "transport_gateway", transport_gateway)
        if transport_gateway_variable and not isinstance(transport_gateway_variable, str):
            raise TypeError("Expected argument 'transport_gateway_variable' to be a str")
        pulumi.set(__self__, "transport_gateway_variable", transport_gateway_variable)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="advertiseIpv4Routes")
    def advertise_ipv4_routes(self) -> Sequence['outputs.GetCiscoOmpFeatureTemplateAdvertiseIpv4RouteResult']:
        """
        Advertise locally learned routes to OMP
        """
        return pulumi.get(self, "advertise_ipv4_routes")

    @_builtins.property
    @pulumi.getter(name="advertiseIpv6Routes")
    def advertise_ipv6_routes(self) -> Sequence['outputs.GetCiscoOmpFeatureTemplateAdvertiseIpv6RouteResult']:
        """
        Advertise locally learned routes to OMP
        """
        return pulumi.get(self, "advertise_ipv6_routes")

    @_builtins.property
    @pulumi.getter(name="advertisementInterval")
    def advertisement_interval(self) -> _builtins.int:
        """
        Set the time between OMP Update packets
        """
        return pulumi.get(self, "advertisement_interval")

    @_builtins.property
    @pulumi.getter(name="advertisementIntervalVariable")
    def advertisement_interval_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "advertisement_interval_variable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Sequence[_builtins.str]:
        """
        List of supported device types
        """
        return pulumi.get(self, "device_types")

    @_builtins.property
    @pulumi.getter(name="ecmpLimit")
    def ecmp_limit(self) -> _builtins.int:
        """
        Set maximum number of OMP paths to install in vEdge route table
        """
        return pulumi.get(self, "ecmp_limit")

    @_builtins.property
    @pulumi.getter(name="ecmpLimitVariable")
    def ecmp_limit_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "ecmp_limit_variable")

    @_builtins.property
    @pulumi.getter(name="eorTimer")
    def eor_timer(self) -> _builtins.int:
        """
        End of RIB timer \\n\\n seconds
        """
        return pulumi.get(self, "eor_timer")

    @_builtins.property
    @pulumi.getter(name="eorTimerVariable")
    def eor_timer_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "eor_timer_variable")

    @_builtins.property
    @pulumi.getter(name="gracefulRestart")
    def graceful_restart(self) -> _builtins.bool:
        """
        Enable or disable OMP graceful restart
        """
        return pulumi.get(self, "graceful_restart")

    @_builtins.property
    @pulumi.getter(name="gracefulRestartTimer")
    def graceful_restart_timer(self) -> _builtins.int:
        """
        Set the OMP graceful restart timer
        """
        return pulumi.get(self, "graceful_restart_timer")

    @_builtins.property
    @pulumi.getter(name="gracefulRestartTimerVariable")
    def graceful_restart_timer_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "graceful_restart_timer_variable")

    @_builtins.property
    @pulumi.getter(name="gracefulRestartVariable")
    def graceful_restart_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "graceful_restart_variable")

    @_builtins.property
    @pulumi.getter
    def holdtime(self) -> _builtins.int:
        """
        Set how long to wait before closing OMP peer connection
        """
        return pulumi.get(self, "holdtime")

    @_builtins.property
    @pulumi.getter(name="holdtimeVariable")
    def holdtime_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "holdtime_variable")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The id of the feature template
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ignoreRegionPathLength")
    def ignore_region_path_length(self) -> _builtins.bool:
        """
        Ignore Region-Path Length During Best-Path Algorithm
        """
        return pulumi.get(self, "ignore_region_path_length")

    @_builtins.property
    @pulumi.getter(name="ignoreRegionPathLengthVariable")
    def ignore_region_path_length_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "ignore_region_path_length_variable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv4")
    def omp_admin_distance_ipv4(self) -> _builtins.int:
        """
        omp-admin-distance-ipv4
        """
        return pulumi.get(self, "omp_admin_distance_ipv4")

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv4Variable")
    def omp_admin_distance_ipv4_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv4_variable")

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv6")
    def omp_admin_distance_ipv6(self) -> _builtins.int:
        """
        omp-admin-distance-ipv6
        """
        return pulumi.get(self, "omp_admin_distance_ipv6")

    @_builtins.property
    @pulumi.getter(name="ompAdminDistanceIpv6Variable")
    def omp_admin_distance_ipv6_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "omp_admin_distance_ipv6_variable")

    @_builtins.property
    @pulumi.getter(name="overlayAs")
    def overlay_as(self) -> _builtins.int:
        """
        Set Overlay AS number \\n\\n or \\n\\n
        """
        return pulumi.get(self, "overlay_as")

    @_builtins.property
    @pulumi.getter(name="overlayAsVariable")
    def overlay_as_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "overlay_as_variable")

    @_builtins.property
    @pulumi.getter(name="sendPathLimit")
    def send_path_limit(self) -> _builtins.int:
        """
        Set number of TLOC routes advertised between vSmart and vEdge
        """
        return pulumi.get(self, "send_path_limit")

    @_builtins.property
    @pulumi.getter(name="sendPathLimitVariable")
    def send_path_limit_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "send_path_limit_variable")

    @_builtins.property
    @pulumi.getter
    def shutdown(self) -> _builtins.bool:
        """
        Enable or disable OMP
        """
        return pulumi.get(self, "shutdown")

    @_builtins.property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> _builtins.str:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @_builtins.property
    @pulumi.getter(name="transportGateway")
    def transport_gateway(self) -> _builtins.str:
        """
        Transport gateway path computation
        """
        return pulumi.get(self, "transport_gateway")

    @_builtins.property
    @pulumi.getter(name="transportGatewayVariable")
    def transport_gateway_variable(self) -> _builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "transport_gateway_variable")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")


class AwaitableGetCiscoOmpFeatureTemplateResult(GetCiscoOmpFeatureTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCiscoOmpFeatureTemplateResult(
            advertise_ipv4_routes=self.advertise_ipv4_routes,
            advertise_ipv6_routes=self.advertise_ipv6_routes,
            advertisement_interval=self.advertisement_interval,
            advertisement_interval_variable=self.advertisement_interval_variable,
            description=self.description,
            device_types=self.device_types,
            ecmp_limit=self.ecmp_limit,
            ecmp_limit_variable=self.ecmp_limit_variable,
            eor_timer=self.eor_timer,
            eor_timer_variable=self.eor_timer_variable,
            graceful_restart=self.graceful_restart,
            graceful_restart_timer=self.graceful_restart_timer,
            graceful_restart_timer_variable=self.graceful_restart_timer_variable,
            graceful_restart_variable=self.graceful_restart_variable,
            holdtime=self.holdtime,
            holdtime_variable=self.holdtime_variable,
            id=self.id,
            ignore_region_path_length=self.ignore_region_path_length,
            ignore_region_path_length_variable=self.ignore_region_path_length_variable,
            name=self.name,
            omp_admin_distance_ipv4=self.omp_admin_distance_ipv4,
            omp_admin_distance_ipv4_variable=self.omp_admin_distance_ipv4_variable,
            omp_admin_distance_ipv6=self.omp_admin_distance_ipv6,
            omp_admin_distance_ipv6_variable=self.omp_admin_distance_ipv6_variable,
            overlay_as=self.overlay_as,
            overlay_as_variable=self.overlay_as_variable,
            send_path_limit=self.send_path_limit,
            send_path_limit_variable=self.send_path_limit_variable,
            shutdown=self.shutdown,
            shutdown_variable=self.shutdown_variable,
            template_type=self.template_type,
            transport_gateway=self.transport_gateway,
            transport_gateway_variable=self.transport_gateway_variable,
            version=self.version)


def get_cisco_omp_feature_template(id: Optional[_builtins.str] = None,
                                   name: Optional[_builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCiscoOmpFeatureTemplateResult:
    """
    This data source can read the Cisco OMP feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_omp_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param _builtins.str id: The id of the feature template
    :param _builtins.str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getCiscoOmpFeatureTemplate:getCiscoOmpFeatureTemplate', __args__, opts=opts, typ=GetCiscoOmpFeatureTemplateResult).value

    return AwaitableGetCiscoOmpFeatureTemplateResult(
        advertise_ipv4_routes=pulumi.get(__ret__, 'advertise_ipv4_routes'),
        advertise_ipv6_routes=pulumi.get(__ret__, 'advertise_ipv6_routes'),
        advertisement_interval=pulumi.get(__ret__, 'advertisement_interval'),
        advertisement_interval_variable=pulumi.get(__ret__, 'advertisement_interval_variable'),
        description=pulumi.get(__ret__, 'description'),
        device_types=pulumi.get(__ret__, 'device_types'),
        ecmp_limit=pulumi.get(__ret__, 'ecmp_limit'),
        ecmp_limit_variable=pulumi.get(__ret__, 'ecmp_limit_variable'),
        eor_timer=pulumi.get(__ret__, 'eor_timer'),
        eor_timer_variable=pulumi.get(__ret__, 'eor_timer_variable'),
        graceful_restart=pulumi.get(__ret__, 'graceful_restart'),
        graceful_restart_timer=pulumi.get(__ret__, 'graceful_restart_timer'),
        graceful_restart_timer_variable=pulumi.get(__ret__, 'graceful_restart_timer_variable'),
        graceful_restart_variable=pulumi.get(__ret__, 'graceful_restart_variable'),
        holdtime=pulumi.get(__ret__, 'holdtime'),
        holdtime_variable=pulumi.get(__ret__, 'holdtime_variable'),
        id=pulumi.get(__ret__, 'id'),
        ignore_region_path_length=pulumi.get(__ret__, 'ignore_region_path_length'),
        ignore_region_path_length_variable=pulumi.get(__ret__, 'ignore_region_path_length_variable'),
        name=pulumi.get(__ret__, 'name'),
        omp_admin_distance_ipv4=pulumi.get(__ret__, 'omp_admin_distance_ipv4'),
        omp_admin_distance_ipv4_variable=pulumi.get(__ret__, 'omp_admin_distance_ipv4_variable'),
        omp_admin_distance_ipv6=pulumi.get(__ret__, 'omp_admin_distance_ipv6'),
        omp_admin_distance_ipv6_variable=pulumi.get(__ret__, 'omp_admin_distance_ipv6_variable'),
        overlay_as=pulumi.get(__ret__, 'overlay_as'),
        overlay_as_variable=pulumi.get(__ret__, 'overlay_as_variable'),
        send_path_limit=pulumi.get(__ret__, 'send_path_limit'),
        send_path_limit_variable=pulumi.get(__ret__, 'send_path_limit_variable'),
        shutdown=pulumi.get(__ret__, 'shutdown'),
        shutdown_variable=pulumi.get(__ret__, 'shutdown_variable'),
        template_type=pulumi.get(__ret__, 'template_type'),
        transport_gateway=pulumi.get(__ret__, 'transport_gateway'),
        transport_gateway_variable=pulumi.get(__ret__, 'transport_gateway_variable'),
        version=pulumi.get(__ret__, 'version'))
def get_cisco_omp_feature_template_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCiscoOmpFeatureTemplateResult]:
    """
    This data source can read the Cisco OMP feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_omp_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param _builtins.str id: The id of the feature template
    :param _builtins.str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getCiscoOmpFeatureTemplate:getCiscoOmpFeatureTemplate', __args__, opts=opts, typ=GetCiscoOmpFeatureTemplateResult)
    return __ret__.apply(lambda __response__: GetCiscoOmpFeatureTemplateResult(
        advertise_ipv4_routes=pulumi.get(__response__, 'advertise_ipv4_routes'),
        advertise_ipv6_routes=pulumi.get(__response__, 'advertise_ipv6_routes'),
        advertisement_interval=pulumi.get(__response__, 'advertisement_interval'),
        advertisement_interval_variable=pulumi.get(__response__, 'advertisement_interval_variable'),
        description=pulumi.get(__response__, 'description'),
        device_types=pulumi.get(__response__, 'device_types'),
        ecmp_limit=pulumi.get(__response__, 'ecmp_limit'),
        ecmp_limit_variable=pulumi.get(__response__, 'ecmp_limit_variable'),
        eor_timer=pulumi.get(__response__, 'eor_timer'),
        eor_timer_variable=pulumi.get(__response__, 'eor_timer_variable'),
        graceful_restart=pulumi.get(__response__, 'graceful_restart'),
        graceful_restart_timer=pulumi.get(__response__, 'graceful_restart_timer'),
        graceful_restart_timer_variable=pulumi.get(__response__, 'graceful_restart_timer_variable'),
        graceful_restart_variable=pulumi.get(__response__, 'graceful_restart_variable'),
        holdtime=pulumi.get(__response__, 'holdtime'),
        holdtime_variable=pulumi.get(__response__, 'holdtime_variable'),
        id=pulumi.get(__response__, 'id'),
        ignore_region_path_length=pulumi.get(__response__, 'ignore_region_path_length'),
        ignore_region_path_length_variable=pulumi.get(__response__, 'ignore_region_path_length_variable'),
        name=pulumi.get(__response__, 'name'),
        omp_admin_distance_ipv4=pulumi.get(__response__, 'omp_admin_distance_ipv4'),
        omp_admin_distance_ipv4_variable=pulumi.get(__response__, 'omp_admin_distance_ipv4_variable'),
        omp_admin_distance_ipv6=pulumi.get(__response__, 'omp_admin_distance_ipv6'),
        omp_admin_distance_ipv6_variable=pulumi.get(__response__, 'omp_admin_distance_ipv6_variable'),
        overlay_as=pulumi.get(__response__, 'overlay_as'),
        overlay_as_variable=pulumi.get(__response__, 'overlay_as_variable'),
        send_path_limit=pulumi.get(__response__, 'send_path_limit'),
        send_path_limit_variable=pulumi.get(__response__, 'send_path_limit_variable'),
        shutdown=pulumi.get(__response__, 'shutdown'),
        shutdown_variable=pulumi.get(__response__, 'shutdown_variable'),
        template_type=pulumi.get(__response__, 'template_type'),
        transport_gateway=pulumi.get(__response__, 'transport_gateway'),
        transport_gateway_variable=pulumi.get(__response__, 'transport_gateway_variable'),
        version=pulumi.get(__response__, 'version')))
