# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OtherUcseFeatureArgs', 'OtherUcseFeature']

@pulumi.input_type
class OtherUcseFeatureArgs:
    def __init__(__self__, *,
                 bay: pulumi.Input[_builtins.int],
                 feature_profile_id: pulumi.Input[_builtins.str],
                 slot: pulumi.Input[_builtins.int],
                 access_port_dedicated: Optional[pulumi.Input[_builtins.bool]] = None,
                 access_port_shared_failover_type: Optional[pulumi.Input[_builtins.str]] = None,
                 access_port_shared_type: Optional[pulumi.Input[_builtins.str]] = None,
                 assign_priority: Optional[pulumi.Input[_builtins.int]] = None,
                 assign_priority_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 default_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 default_gateway_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['OtherUcseFeatureInterfaceArgs']]]] = None,
                 ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vlan_id_variable: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OtherUcseFeature resource.
        :param pulumi.Input[_builtins.int] bay: Bay
                 - Range: `0`-`2`
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.int] slot: Slot
                 - Range: `0`-`3`
        :param pulumi.Input[_builtins.bool] access_port_dedicated: Dedicated
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] access_port_shared_failover_type: , Attribute conditional on `access_port_dedicated` being equal to `false`
                 - Choices: `ge2`, `te2`
        :param pulumi.Input[_builtins.str] access_port_shared_type: , Attribute conditional on `access_port_dedicated` being equal to `false`
                 - Choices: `ge1`, `ge2`, `ge3`, `te2`, `te3`, `console`, `failover`
        :param pulumi.Input[_builtins.int] assign_priority: Assign priority
                 - Range: `0`-`7`
        :param pulumi.Input[_builtins.str] assign_priority_variable: Variable name
        :param pulumi.Input[_builtins.str] default_gateway: Assign default gateway
        :param pulumi.Input[_builtins.str] default_gateway_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['OtherUcseFeatureInterfaceArgs']]] interfaces: Interface name: GigabitEthernet0/<>/<> when present
        :param pulumi.Input[_builtins.str] ipv4_address: Assign IPv4 address
        :param pulumi.Input[_builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.int] vlan_id: Assign Vlan Id
                 - Range: `2`-`4095`
        :param pulumi.Input[_builtins.str] vlan_id_variable: Variable name
        """
        pulumi.set(__self__, "bay", bay)
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        pulumi.set(__self__, "slot", slot)
        if access_port_dedicated is not None:
            pulumi.set(__self__, "access_port_dedicated", access_port_dedicated)
        if access_port_shared_failover_type is not None:
            pulumi.set(__self__, "access_port_shared_failover_type", access_port_shared_failover_type)
        if access_port_shared_type is not None:
            pulumi.set(__self__, "access_port_shared_type", access_port_shared_type)
        if assign_priority is not None:
            pulumi.set(__self__, "assign_priority", assign_priority)
        if assign_priority_variable is not None:
            pulumi.set(__self__, "assign_priority_variable", assign_priority_variable)
        if default_gateway is not None:
            pulumi.set(__self__, "default_gateway", default_gateway)
        if default_gateway_variable is not None:
            pulumi.set(__self__, "default_gateway_variable", default_gateway_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_address_variable is not None:
            pulumi.set(__self__, "ipv4_address_variable", ipv4_address_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vlan_id_variable is not None:
            pulumi.set(__self__, "vlan_id_variable", vlan_id_variable)

    @_builtins.property
    @pulumi.getter
    def bay(self) -> pulumi.Input[_builtins.int]:
        """
        Bay
          - Range: `0`-`2`
        """
        return pulumi.get(self, "bay")

    @bay.setter
    def bay(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "bay", value)

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @_builtins.property
    @pulumi.getter
    def slot(self) -> pulumi.Input[_builtins.int]:
        """
        Slot
          - Range: `0`-`3`
        """
        return pulumi.get(self, "slot")

    @slot.setter
    def slot(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "slot", value)

    @_builtins.property
    @pulumi.getter(name="accessPortDedicated")
    def access_port_dedicated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Dedicated
          - Default value: `true`
        """
        return pulumi.get(self, "access_port_dedicated")

    @access_port_dedicated.setter
    def access_port_dedicated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "access_port_dedicated", value)

    @_builtins.property
    @pulumi.getter(name="accessPortSharedFailoverType")
    def access_port_shared_failover_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        , Attribute conditional on `access_port_dedicated` being equal to `false`
          - Choices: `ge2`, `te2`
        """
        return pulumi.get(self, "access_port_shared_failover_type")

    @access_port_shared_failover_type.setter
    def access_port_shared_failover_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_port_shared_failover_type", value)

    @_builtins.property
    @pulumi.getter(name="accessPortSharedType")
    def access_port_shared_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        , Attribute conditional on `access_port_dedicated` being equal to `false`
          - Choices: `ge1`, `ge2`, `ge3`, `te2`, `te3`, `console`, `failover`
        """
        return pulumi.get(self, "access_port_shared_type")

    @access_port_shared_type.setter
    def access_port_shared_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_port_shared_type", value)

    @_builtins.property
    @pulumi.getter(name="assignPriority")
    def assign_priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Assign priority
          - Range: `0`-`7`
        """
        return pulumi.get(self, "assign_priority")

    @assign_priority.setter
    def assign_priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "assign_priority", value)

    @_builtins.property
    @pulumi.getter(name="assignPriorityVariable")
    def assign_priority_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "assign_priority_variable")

    @assign_priority_variable.setter
    def assign_priority_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assign_priority_variable", value)

    @_builtins.property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assign default gateway
        """
        return pulumi.get(self, "default_gateway")

    @default_gateway.setter
    def default_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_gateway", value)

    @_builtins.property
    @pulumi.getter(name="defaultGatewayVariable")
    def default_gateway_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_gateway_variable")

    @default_gateway_variable.setter
    def default_gateway_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_gateway_variable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OtherUcseFeatureInterfaceArgs']]]]:
        """
        Interface name: GigabitEthernet0/<>/<> when present
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OtherUcseFeatureInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assign IPv4 address
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="ipv4AddressVariable")
    def ipv4_address_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_address_variable")

    @ipv4_address_variable.setter
    def ipv4_address_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_address_variable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Assign Vlan Id
          - Range: `2`-`4095`
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="vlanIdVariable")
    def vlan_id_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "vlan_id_variable")

    @vlan_id_variable.setter
    def vlan_id_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vlan_id_variable", value)


@pulumi.input_type
class _OtherUcseFeatureState:
    def __init__(__self__, *,
                 access_port_dedicated: Optional[pulumi.Input[_builtins.bool]] = None,
                 access_port_shared_failover_type: Optional[pulumi.Input[_builtins.str]] = None,
                 access_port_shared_type: Optional[pulumi.Input[_builtins.str]] = None,
                 assign_priority: Optional[pulumi.Input[_builtins.int]] = None,
                 assign_priority_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 bay: Optional[pulumi.Input[_builtins.int]] = None,
                 default_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 default_gateway_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['OtherUcseFeatureInterfaceArgs']]]] = None,
                 ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 slot: Optional[pulumi.Input[_builtins.int]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vlan_id_variable: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OtherUcseFeature resources.
        :param pulumi.Input[_builtins.bool] access_port_dedicated: Dedicated
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] access_port_shared_failover_type: , Attribute conditional on `access_port_dedicated` being equal to `false`
                 - Choices: `ge2`, `te2`
        :param pulumi.Input[_builtins.str] access_port_shared_type: , Attribute conditional on `access_port_dedicated` being equal to `false`
                 - Choices: `ge1`, `ge2`, `ge3`, `te2`, `te3`, `console`, `failover`
        :param pulumi.Input[_builtins.int] assign_priority: Assign priority
                 - Range: `0`-`7`
        :param pulumi.Input[_builtins.str] assign_priority_variable: Variable name
        :param pulumi.Input[_builtins.int] bay: Bay
                 - Range: `0`-`2`
        :param pulumi.Input[_builtins.str] default_gateway: Assign default gateway
        :param pulumi.Input[_builtins.str] default_gateway_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input['OtherUcseFeatureInterfaceArgs']]] interfaces: Interface name: GigabitEthernet0/<>/<> when present
        :param pulumi.Input[_builtins.str] ipv4_address: Assign IPv4 address
        :param pulumi.Input[_builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.int] slot: Slot
                 - Range: `0`-`3`
        :param pulumi.Input[_builtins.int] version: The version of the Feature
        :param pulumi.Input[_builtins.int] vlan_id: Assign Vlan Id
                 - Range: `2`-`4095`
        :param pulumi.Input[_builtins.str] vlan_id_variable: Variable name
        """
        if access_port_dedicated is not None:
            pulumi.set(__self__, "access_port_dedicated", access_port_dedicated)
        if access_port_shared_failover_type is not None:
            pulumi.set(__self__, "access_port_shared_failover_type", access_port_shared_failover_type)
        if access_port_shared_type is not None:
            pulumi.set(__self__, "access_port_shared_type", access_port_shared_type)
        if assign_priority is not None:
            pulumi.set(__self__, "assign_priority", assign_priority)
        if assign_priority_variable is not None:
            pulumi.set(__self__, "assign_priority_variable", assign_priority_variable)
        if bay is not None:
            pulumi.set(__self__, "bay", bay)
        if default_gateway is not None:
            pulumi.set(__self__, "default_gateway", default_gateway)
        if default_gateway_variable is not None:
            pulumi.set(__self__, "default_gateway_variable", default_gateway_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_address_variable is not None:
            pulumi.set(__self__, "ipv4_address_variable", ipv4_address_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if slot is not None:
            pulumi.set(__self__, "slot", slot)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vlan_id_variable is not None:
            pulumi.set(__self__, "vlan_id_variable", vlan_id_variable)

    @_builtins.property
    @pulumi.getter(name="accessPortDedicated")
    def access_port_dedicated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Dedicated
          - Default value: `true`
        """
        return pulumi.get(self, "access_port_dedicated")

    @access_port_dedicated.setter
    def access_port_dedicated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "access_port_dedicated", value)

    @_builtins.property
    @pulumi.getter(name="accessPortSharedFailoverType")
    def access_port_shared_failover_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        , Attribute conditional on `access_port_dedicated` being equal to `false`
          - Choices: `ge2`, `te2`
        """
        return pulumi.get(self, "access_port_shared_failover_type")

    @access_port_shared_failover_type.setter
    def access_port_shared_failover_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_port_shared_failover_type", value)

    @_builtins.property
    @pulumi.getter(name="accessPortSharedType")
    def access_port_shared_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        , Attribute conditional on `access_port_dedicated` being equal to `false`
          - Choices: `ge1`, `ge2`, `ge3`, `te2`, `te3`, `console`, `failover`
        """
        return pulumi.get(self, "access_port_shared_type")

    @access_port_shared_type.setter
    def access_port_shared_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_port_shared_type", value)

    @_builtins.property
    @pulumi.getter(name="assignPriority")
    def assign_priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Assign priority
          - Range: `0`-`7`
        """
        return pulumi.get(self, "assign_priority")

    @assign_priority.setter
    def assign_priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "assign_priority", value)

    @_builtins.property
    @pulumi.getter(name="assignPriorityVariable")
    def assign_priority_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "assign_priority_variable")

    @assign_priority_variable.setter
    def assign_priority_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "assign_priority_variable", value)

    @_builtins.property
    @pulumi.getter
    def bay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Bay
          - Range: `0`-`2`
        """
        return pulumi.get(self, "bay")

    @bay.setter
    def bay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bay", value)

    @_builtins.property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assign default gateway
        """
        return pulumi.get(self, "default_gateway")

    @default_gateway.setter
    def default_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_gateway", value)

    @_builtins.property
    @pulumi.getter(name="defaultGatewayVariable")
    def default_gateway_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_gateway_variable")

    @default_gateway_variable.setter
    def default_gateway_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_gateway_variable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @_builtins.property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OtherUcseFeatureInterfaceArgs']]]]:
        """
        Interface name: GigabitEthernet0/<>/<> when present
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OtherUcseFeatureInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assign IPv4 address
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="ipv4AddressVariable")
    def ipv4_address_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_address_variable")

    @ipv4_address_variable.setter
    def ipv4_address_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_address_variable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def slot(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Slot
          - Range: `0`-`3`
        """
        return pulumi.get(self, "slot")

    @slot.setter
    def slot(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slot", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Assign Vlan Id
          - Range: `2`-`4095`
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="vlanIdVariable")
    def vlan_id_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "vlan_id_variable")

    @vlan_id_variable.setter
    def vlan_id_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vlan_id_variable", value)


@pulumi.type_token("sdwan:index/otherUcseFeature:OtherUcseFeature")
class OtherUcseFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_port_dedicated: Optional[pulumi.Input[_builtins.bool]] = None,
                 access_port_shared_failover_type: Optional[pulumi.Input[_builtins.str]] = None,
                 access_port_shared_type: Optional[pulumi.Input[_builtins.str]] = None,
                 assign_priority: Optional[pulumi.Input[_builtins.int]] = None,
                 assign_priority_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 bay: Optional[pulumi.Input[_builtins.int]] = None,
                 default_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 default_gateway_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OtherUcseFeatureInterfaceArgs', 'OtherUcseFeatureInterfaceArgsDict']]]]] = None,
                 ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 slot: Optional[pulumi.Input[_builtins.int]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vlan_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Other UCSE Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "other_ucse_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/otherUcseFeature:OtherUcseFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] access_port_dedicated: Dedicated
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] access_port_shared_failover_type: , Attribute conditional on `access_port_dedicated` being equal to `false`
                 - Choices: `ge2`, `te2`
        :param pulumi.Input[_builtins.str] access_port_shared_type: , Attribute conditional on `access_port_dedicated` being equal to `false`
                 - Choices: `ge1`, `ge2`, `ge3`, `te2`, `te3`, `console`, `failover`
        :param pulumi.Input[_builtins.int] assign_priority: Assign priority
                 - Range: `0`-`7`
        :param pulumi.Input[_builtins.str] assign_priority_variable: Variable name
        :param pulumi.Input[_builtins.int] bay: Bay
                 - Range: `0`-`2`
        :param pulumi.Input[_builtins.str] default_gateway: Assign default gateway
        :param pulumi.Input[_builtins.str] default_gateway_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['OtherUcseFeatureInterfaceArgs', 'OtherUcseFeatureInterfaceArgsDict']]]] interfaces: Interface name: GigabitEthernet0/<>/<> when present
        :param pulumi.Input[_builtins.str] ipv4_address: Assign IPv4 address
        :param pulumi.Input[_builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.int] slot: Slot
                 - Range: `0`-`3`
        :param pulumi.Input[_builtins.int] vlan_id: Assign Vlan Id
                 - Range: `2`-`4095`
        :param pulumi.Input[_builtins.str] vlan_id_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OtherUcseFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Other UCSE Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "other_ucse_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/otherUcseFeature:OtherUcseFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param OtherUcseFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OtherUcseFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_port_dedicated: Optional[pulumi.Input[_builtins.bool]] = None,
                 access_port_shared_failover_type: Optional[pulumi.Input[_builtins.str]] = None,
                 access_port_shared_type: Optional[pulumi.Input[_builtins.str]] = None,
                 assign_priority: Optional[pulumi.Input[_builtins.int]] = None,
                 assign_priority_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 bay: Optional[pulumi.Input[_builtins.int]] = None,
                 default_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 default_gateway_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OtherUcseFeatureInterfaceArgs', 'OtherUcseFeatureInterfaceArgsDict']]]]] = None,
                 ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 slot: Optional[pulumi.Input[_builtins.int]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 vlan_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OtherUcseFeatureArgs.__new__(OtherUcseFeatureArgs)

            __props__.__dict__["access_port_dedicated"] = access_port_dedicated
            __props__.__dict__["access_port_shared_failover_type"] = access_port_shared_failover_type
            __props__.__dict__["access_port_shared_type"] = access_port_shared_type
            __props__.__dict__["assign_priority"] = assign_priority
            __props__.__dict__["assign_priority_variable"] = assign_priority_variable
            if bay is None and not opts.urn:
                raise TypeError("Missing required property 'bay'")
            __props__.__dict__["bay"] = bay
            __props__.__dict__["default_gateway"] = default_gateway
            __props__.__dict__["default_gateway_variable"] = default_gateway_variable
            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["interfaces"] = interfaces
            __props__.__dict__["ipv4_address"] = ipv4_address
            __props__.__dict__["ipv4_address_variable"] = ipv4_address_variable
            __props__.__dict__["name"] = name
            if slot is None and not opts.urn:
                raise TypeError("Missing required property 'slot'")
            __props__.__dict__["slot"] = slot
            __props__.__dict__["vlan_id"] = vlan_id
            __props__.__dict__["vlan_id_variable"] = vlan_id_variable
            __props__.__dict__["version"] = None
        super(OtherUcseFeature, __self__).__init__(
            'sdwan:index/otherUcseFeature:OtherUcseFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_port_dedicated: Optional[pulumi.Input[_builtins.bool]] = None,
            access_port_shared_failover_type: Optional[pulumi.Input[_builtins.str]] = None,
            access_port_shared_type: Optional[pulumi.Input[_builtins.str]] = None,
            assign_priority: Optional[pulumi.Input[_builtins.int]] = None,
            assign_priority_variable: Optional[pulumi.Input[_builtins.str]] = None,
            bay: Optional[pulumi.Input[_builtins.int]] = None,
            default_gateway: Optional[pulumi.Input[_builtins.str]] = None,
            default_gateway_variable: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OtherUcseFeatureInterfaceArgs', 'OtherUcseFeatureInterfaceArgsDict']]]]] = None,
            ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            slot: Optional[pulumi.Input[_builtins.int]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None,
            vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
            vlan_id_variable: Optional[pulumi.Input[_builtins.str]] = None) -> 'OtherUcseFeature':
        """
        Get an existing OtherUcseFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] access_port_dedicated: Dedicated
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] access_port_shared_failover_type: , Attribute conditional on `access_port_dedicated` being equal to `false`
                 - Choices: `ge2`, `te2`
        :param pulumi.Input[_builtins.str] access_port_shared_type: , Attribute conditional on `access_port_dedicated` being equal to `false`
                 - Choices: `ge1`, `ge2`, `ge3`, `te2`, `te3`, `console`, `failover`
        :param pulumi.Input[_builtins.int] assign_priority: Assign priority
                 - Range: `0`-`7`
        :param pulumi.Input[_builtins.str] assign_priority_variable: Variable name
        :param pulumi.Input[_builtins.int] bay: Bay
                 - Range: `0`-`2`
        :param pulumi.Input[_builtins.str] default_gateway: Assign default gateway
        :param pulumi.Input[_builtins.str] default_gateway_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input[Union['OtherUcseFeatureInterfaceArgs', 'OtherUcseFeatureInterfaceArgsDict']]]] interfaces: Interface name: GigabitEthernet0/<>/<> when present
        :param pulumi.Input[_builtins.str] ipv4_address: Assign IPv4 address
        :param pulumi.Input[_builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.int] slot: Slot
                 - Range: `0`-`3`
        :param pulumi.Input[_builtins.int] version: The version of the Feature
        :param pulumi.Input[_builtins.int] vlan_id: Assign Vlan Id
                 - Range: `2`-`4095`
        :param pulumi.Input[_builtins.str] vlan_id_variable: Variable name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OtherUcseFeatureState.__new__(_OtherUcseFeatureState)

        __props__.__dict__["access_port_dedicated"] = access_port_dedicated
        __props__.__dict__["access_port_shared_failover_type"] = access_port_shared_failover_type
        __props__.__dict__["access_port_shared_type"] = access_port_shared_type
        __props__.__dict__["assign_priority"] = assign_priority
        __props__.__dict__["assign_priority_variable"] = assign_priority_variable
        __props__.__dict__["bay"] = bay
        __props__.__dict__["default_gateway"] = default_gateway
        __props__.__dict__["default_gateway_variable"] = default_gateway_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["interfaces"] = interfaces
        __props__.__dict__["ipv4_address"] = ipv4_address
        __props__.__dict__["ipv4_address_variable"] = ipv4_address_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["slot"] = slot
        __props__.__dict__["version"] = version
        __props__.__dict__["vlan_id"] = vlan_id
        __props__.__dict__["vlan_id_variable"] = vlan_id_variable
        return OtherUcseFeature(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPortDedicated")
    def access_port_dedicated(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Dedicated
          - Default value: `true`
        """
        return pulumi.get(self, "access_port_dedicated")

    @_builtins.property
    @pulumi.getter(name="accessPortSharedFailoverType")
    def access_port_shared_failover_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        , Attribute conditional on `access_port_dedicated` being equal to `false`
          - Choices: `ge2`, `te2`
        """
        return pulumi.get(self, "access_port_shared_failover_type")

    @_builtins.property
    @pulumi.getter(name="accessPortSharedType")
    def access_port_shared_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        , Attribute conditional on `access_port_dedicated` being equal to `false`
          - Choices: `ge1`, `ge2`, `ge3`, `te2`, `te3`, `console`, `failover`
        """
        return pulumi.get(self, "access_port_shared_type")

    @_builtins.property
    @pulumi.getter(name="assignPriority")
    def assign_priority(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Assign priority
          - Range: `0`-`7`
        """
        return pulumi.get(self, "assign_priority")

    @_builtins.property
    @pulumi.getter(name="assignPriorityVariable")
    def assign_priority_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "assign_priority_variable")

    @_builtins.property
    @pulumi.getter
    def bay(self) -> pulumi.Output[_builtins.int]:
        """
        Bay
          - Range: `0`-`2`
        """
        return pulumi.get(self, "bay")

    @_builtins.property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Assign default gateway
        """
        return pulumi.get(self, "default_gateway")

    @_builtins.property
    @pulumi.getter(name="defaultGatewayVariable")
    def default_gateway_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_gateway_variable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @_builtins.property
    @pulumi.getter
    def interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.OtherUcseFeatureInterface']]]:
        """
        Interface name: GigabitEthernet0/<>/<> when present
        """
        return pulumi.get(self, "interfaces")

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Assign IPv4 address
        """
        return pulumi.get(self, "ipv4_address")

    @_builtins.property
    @pulumi.getter(name="ipv4AddressVariable")
    def ipv4_address_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_address_variable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def slot(self) -> pulumi.Output[_builtins.int]:
        """
        Slot
          - Range: `0`-`3`
        """
        return pulumi.get(self, "slot")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Assign Vlan Id
          - Range: `2`-`4095`
        """
        return pulumi.get(self, "vlan_id")

    @_builtins.property
    @pulumi.getter(name="vlanIdVariable")
    def vlan_id_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "vlan_id_variable")

