# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityAppHostingFeatureTemplateArgs', 'SecurityAppHostingFeatureTemplate']

@pulumi.input_type
class SecurityAppHostingFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_applications: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAppHostingFeatureTemplateVirtualApplicationArgs']]]] = None):
        """
        The set of arguments for constructing a SecurityAppHostingFeatureTemplate resource.
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['SecurityAppHostingFeatureTemplateVirtualApplicationArgs']]] virtual_applications: Virtual application Instance
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if virtual_applications is not None:
            pulumi.set(__self__, "virtual_applications", virtual_applications)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="virtualApplications")
    def virtual_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAppHostingFeatureTemplateVirtualApplicationArgs']]]]:
        """
        Virtual application Instance
        """
        return pulumi.get(self, "virtual_applications")

    @virtual_applications.setter
    def virtual_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAppHostingFeatureTemplateVirtualApplicationArgs']]]]):
        pulumi.set(self, "virtual_applications", value)


@pulumi.input_type
class _SecurityAppHostingFeatureTemplateState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 template_type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None,
                 virtual_applications: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAppHostingFeatureTemplateVirtualApplicationArgs']]]] = None):
        """
        Input properties used for looking up and filtering SecurityAppHostingFeatureTemplate resources.
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[_builtins.str] template_type: The template type
        :param pulumi.Input[_builtins.int] version: The version of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['SecurityAppHostingFeatureTemplateVirtualApplicationArgs']]] virtual_applications: Virtual application Instance
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if virtual_applications is not None:
            pulumi.set(__self__, "virtual_applications", virtual_applications)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="virtualApplications")
    def virtual_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAppHostingFeatureTemplateVirtualApplicationArgs']]]]:
        """
        Virtual application Instance
        """
        return pulumi.get(self, "virtual_applications")

    @virtual_applications.setter
    def virtual_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityAppHostingFeatureTemplateVirtualApplicationArgs']]]]):
        pulumi.set(self, "virtual_applications", value)


@pulumi.type_token("sdwan:index/securityAppHostingFeatureTemplate:SecurityAppHostingFeatureTemplate")
class SecurityAppHostingFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityAppHostingFeatureTemplateVirtualApplicationArgs', 'SecurityAppHostingFeatureTemplateVirtualApplicationArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource can manage a Security App Hosting feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/securityAppHostingFeatureTemplate:SecurityAppHostingFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityAppHostingFeatureTemplateVirtualApplicationArgs', 'SecurityAppHostingFeatureTemplateVirtualApplicationArgsDict']]]] virtual_applications: Virtual application Instance
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityAppHostingFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Security App Hosting feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/securityAppHostingFeatureTemplate:SecurityAppHostingFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param SecurityAppHostingFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityAppHostingFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityAppHostingFeatureTemplateVirtualApplicationArgs', 'SecurityAppHostingFeatureTemplateVirtualApplicationArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityAppHostingFeatureTemplateArgs.__new__(SecurityAppHostingFeatureTemplateArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["name"] = name
            __props__.__dict__["virtual_applications"] = virtual_applications
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(SecurityAppHostingFeatureTemplate, __self__).__init__(
            'sdwan:index/securityAppHostingFeatureTemplate:SecurityAppHostingFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            template_type: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None,
            virtual_applications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityAppHostingFeatureTemplateVirtualApplicationArgs', 'SecurityAppHostingFeatureTemplateVirtualApplicationArgsDict']]]]] = None) -> 'SecurityAppHostingFeatureTemplate':
        """
        Get an existing SecurityAppHostingFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[_builtins.str] template_type: The template type
        :param pulumi.Input[_builtins.int] version: The version of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['SecurityAppHostingFeatureTemplateVirtualApplicationArgs', 'SecurityAppHostingFeatureTemplateVirtualApplicationArgsDict']]]] virtual_applications: Virtual application Instance
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityAppHostingFeatureTemplateState.__new__(_SecurityAppHostingFeatureTemplateState)

        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["name"] = name
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        __props__.__dict__["virtual_applications"] = virtual_applications
        return SecurityAppHostingFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[_builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="virtualApplications")
    def virtual_applications(self) -> pulumi.Output[Optional[Sequence['outputs.SecurityAppHostingFeatureTemplateVirtualApplication']]]:
        """
        Virtual application Instance
        """
        return pulumi.get(self, "virtual_applications")

