# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceDhcpServerFeatureArgs', 'ServiceDhcpServerFeature']

@pulumi.input_type
class ServiceDhcpServerFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[_builtins.str],
                 default_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 default_gateway_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dns_servers_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 interface_mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 interface_mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 lease_time: Optional[pulumi.Input[_builtins.int]] = None,
                 lease_time_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 option_codes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureOptionCodeArgs']]]] = None,
                 static_leases: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureStaticLeaseArgs']]]] = None,
                 subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_mask_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 tftp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tftp_servers_variable: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceDhcpServerFeature resource.
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.str] default_gateway: Set IP address of default gateway
        :param pulumi.Input[_builtins.str] default_gateway_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: Configure one or more DNS server IP addresses
        :param pulumi.Input[_builtins.str] dns_servers_variable: Variable name
        :param pulumi.Input[_builtins.str] domain_name: Set domain name client uses to resolve hostnames
        :param pulumi.Input[_builtins.str] domain_name_variable: Variable name
        :param pulumi.Input[_builtins.str] exclude_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludes: Configure IPv4 address to exclude from DHCP address pool
        :param pulumi.Input[_builtins.int] interface_mtu: Set MTU on interface to DHCP client
                 - Range: `68`-`65535`
        :param pulumi.Input[_builtins.str] interface_mtu_variable: Variable name
        :param pulumi.Input[_builtins.int] lease_time: Configure how long a DHCP-assigned IP address is valid
                 - Range: `60`-`31536000`
                 - Default value: `86400`
        :param pulumi.Input[_builtins.str] lease_time_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.str] network_address: Network Address
        :param pulumi.Input[_builtins.str] network_address_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureOptionCodeArgs']]] option_codes: Configure Options Code
        :param pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureStaticLeaseArgs']]] static_leases: Configure static IP addresses
        :param pulumi.Input[_builtins.str] subnet_mask: Subnet Mask
                 - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`, `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`, `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`, `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`, `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[_builtins.str] subnet_mask_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tftp_servers: Configure TFTP server IP addresses
        :param pulumi.Input[_builtins.str] tftp_servers_variable: Variable name
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if default_gateway is not None:
            pulumi.set(__self__, "default_gateway", default_gateway)
        if default_gateway_variable is not None:
            pulumi.set(__self__, "default_gateway_variable", default_gateway_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if dns_servers_variable is not None:
            pulumi.set(__self__, "dns_servers_variable", dns_servers_variable)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if domain_name_variable is not None:
            pulumi.set(__self__, "domain_name_variable", domain_name_variable)
        if exclude_variable is not None:
            pulumi.set(__self__, "exclude_variable", exclude_variable)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if interface_mtu is not None:
            pulumi.set(__self__, "interface_mtu", interface_mtu)
        if interface_mtu_variable is not None:
            pulumi.set(__self__, "interface_mtu_variable", interface_mtu_variable)
        if lease_time is not None:
            pulumi.set(__self__, "lease_time", lease_time)
        if lease_time_variable is not None:
            pulumi.set(__self__, "lease_time_variable", lease_time_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_address is not None:
            pulumi.set(__self__, "network_address", network_address)
        if network_address_variable is not None:
            pulumi.set(__self__, "network_address_variable", network_address_variable)
        if option_codes is not None:
            pulumi.set(__self__, "option_codes", option_codes)
        if static_leases is not None:
            pulumi.set(__self__, "static_leases", static_leases)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)
        if subnet_mask_variable is not None:
            pulumi.set(__self__, "subnet_mask_variable", subnet_mask_variable)
        if tftp_servers is not None:
            pulumi.set(__self__, "tftp_servers", tftp_servers)
        if tftp_servers_variable is not None:
            pulumi.set(__self__, "tftp_servers_variable", tftp_servers_variable)

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set IP address of default gateway
        """
        return pulumi.get(self, "default_gateway")

    @default_gateway.setter
    def default_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_gateway", value)

    @_builtins.property
    @pulumi.getter(name="defaultGatewayVariable")
    def default_gateway_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_gateway_variable")

    @default_gateway_variable.setter
    def default_gateway_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_gateway_variable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Configure one or more DNS server IP addresses
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="dnsServersVariable")
    def dns_servers_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dns_servers_variable")

    @dns_servers_variable.setter
    def dns_servers_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_servers_variable", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set domain name client uses to resolve hostnames
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="domainNameVariable")
    def domain_name_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "domain_name_variable")

    @domain_name_variable.setter
    def domain_name_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name_variable", value)

    @_builtins.property
    @pulumi.getter(name="excludeVariable")
    def exclude_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "exclude_variable")

    @exclude_variable.setter
    def exclude_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude_variable", value)

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Configure IPv4 address to exclude from DHCP address pool
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excludes", value)

    @_builtins.property
    @pulumi.getter(name="interfaceMtu")
    def interface_mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set MTU on interface to DHCP client
          - Range: `68`-`65535`
        """
        return pulumi.get(self, "interface_mtu")

    @interface_mtu.setter
    def interface_mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interface_mtu", value)

    @_builtins.property
    @pulumi.getter(name="interfaceMtuVariable")
    def interface_mtu_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_mtu_variable")

    @interface_mtu_variable.setter
    def interface_mtu_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_mtu_variable", value)

    @_builtins.property
    @pulumi.getter(name="leaseTime")
    def lease_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configure how long a DHCP-assigned IP address is valid
          - Range: `60`-`31536000`
          - Default value: `86400`
        """
        return pulumi.get(self, "lease_time")

    @lease_time.setter
    def lease_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lease_time", value)

    @_builtins.property
    @pulumi.getter(name="leaseTimeVariable")
    def lease_time_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "lease_time_variable")

    @lease_time_variable.setter
    def lease_time_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lease_time_variable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network Address
        """
        return pulumi.get(self, "network_address")

    @network_address.setter
    def network_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_address", value)

    @_builtins.property
    @pulumi.getter(name="networkAddressVariable")
    def network_address_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "network_address_variable")

    @network_address_variable.setter
    def network_address_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_address_variable", value)

    @_builtins.property
    @pulumi.getter(name="optionCodes")
    def option_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureOptionCodeArgs']]]]:
        """
        Configure Options Code
        """
        return pulumi.get(self, "option_codes")

    @option_codes.setter
    def option_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureOptionCodeArgs']]]]):
        pulumi.set(self, "option_codes", value)

    @_builtins.property
    @pulumi.getter(name="staticLeases")
    def static_leases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureStaticLeaseArgs']]]]:
        """
        Configure static IP addresses
        """
        return pulumi.get(self, "static_leases")

    @static_leases.setter
    def static_leases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureStaticLeaseArgs']]]]):
        pulumi.set(self, "static_leases", value)

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subnet Mask
          - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`, `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`, `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`, `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`, `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        """
        return pulumi.get(self, "subnet_mask")

    @subnet_mask.setter
    def subnet_mask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_mask", value)

    @_builtins.property
    @pulumi.getter(name="subnetMaskVariable")
    def subnet_mask_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "subnet_mask_variable")

    @subnet_mask_variable.setter
    def subnet_mask_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_mask_variable", value)

    @_builtins.property
    @pulumi.getter(name="tftpServers")
    def tftp_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Configure TFTP server IP addresses
        """
        return pulumi.get(self, "tftp_servers")

    @tftp_servers.setter
    def tftp_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tftp_servers", value)

    @_builtins.property
    @pulumi.getter(name="tftpServersVariable")
    def tftp_servers_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tftp_servers_variable")

    @tftp_servers_variable.setter
    def tftp_servers_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tftp_servers_variable", value)


@pulumi.input_type
class _ServiceDhcpServerFeatureState:
    def __init__(__self__, *,
                 default_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 default_gateway_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dns_servers_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 interface_mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 lease_time: Optional[pulumi.Input[_builtins.int]] = None,
                 lease_time_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 option_codes: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureOptionCodeArgs']]]] = None,
                 static_leases: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureStaticLeaseArgs']]]] = None,
                 subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_mask_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 tftp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tftp_servers_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ServiceDhcpServerFeature resources.
        :param pulumi.Input[_builtins.str] default_gateway: Set IP address of default gateway
        :param pulumi.Input[_builtins.str] default_gateway_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: Configure one or more DNS server IP addresses
        :param pulumi.Input[_builtins.str] dns_servers_variable: Variable name
        :param pulumi.Input[_builtins.str] domain_name: Set domain name client uses to resolve hostnames
        :param pulumi.Input[_builtins.str] domain_name_variable: Variable name
        :param pulumi.Input[_builtins.str] exclude_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludes: Configure IPv4 address to exclude from DHCP address pool
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.int] interface_mtu: Set MTU on interface to DHCP client
                 - Range: `68`-`65535`
        :param pulumi.Input[_builtins.str] interface_mtu_variable: Variable name
        :param pulumi.Input[_builtins.int] lease_time: Configure how long a DHCP-assigned IP address is valid
                 - Range: `60`-`31536000`
                 - Default value: `86400`
        :param pulumi.Input[_builtins.str] lease_time_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.str] network_address: Network Address
        :param pulumi.Input[_builtins.str] network_address_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureOptionCodeArgs']]] option_codes: Configure Options Code
        :param pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureStaticLeaseArgs']]] static_leases: Configure static IP addresses
        :param pulumi.Input[_builtins.str] subnet_mask: Subnet Mask
                 - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`, `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`, `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`, `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`, `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[_builtins.str] subnet_mask_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tftp_servers: Configure TFTP server IP addresses
        :param pulumi.Input[_builtins.str] tftp_servers_variable: Variable name
        :param pulumi.Input[_builtins.int] version: The version of the Feature
        """
        if default_gateway is not None:
            pulumi.set(__self__, "default_gateway", default_gateway)
        if default_gateway_variable is not None:
            pulumi.set(__self__, "default_gateway_variable", default_gateway_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if dns_servers_variable is not None:
            pulumi.set(__self__, "dns_servers_variable", dns_servers_variable)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if domain_name_variable is not None:
            pulumi.set(__self__, "domain_name_variable", domain_name_variable)
        if exclude_variable is not None:
            pulumi.set(__self__, "exclude_variable", exclude_variable)
        if excludes is not None:
            pulumi.set(__self__, "excludes", excludes)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if interface_mtu is not None:
            pulumi.set(__self__, "interface_mtu", interface_mtu)
        if interface_mtu_variable is not None:
            pulumi.set(__self__, "interface_mtu_variable", interface_mtu_variable)
        if lease_time is not None:
            pulumi.set(__self__, "lease_time", lease_time)
        if lease_time_variable is not None:
            pulumi.set(__self__, "lease_time_variable", lease_time_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_address is not None:
            pulumi.set(__self__, "network_address", network_address)
        if network_address_variable is not None:
            pulumi.set(__self__, "network_address_variable", network_address_variable)
        if option_codes is not None:
            pulumi.set(__self__, "option_codes", option_codes)
        if static_leases is not None:
            pulumi.set(__self__, "static_leases", static_leases)
        if subnet_mask is not None:
            pulumi.set(__self__, "subnet_mask", subnet_mask)
        if subnet_mask_variable is not None:
            pulumi.set(__self__, "subnet_mask_variable", subnet_mask_variable)
        if tftp_servers is not None:
            pulumi.set(__self__, "tftp_servers", tftp_servers)
        if tftp_servers_variable is not None:
            pulumi.set(__self__, "tftp_servers_variable", tftp_servers_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set IP address of default gateway
        """
        return pulumi.get(self, "default_gateway")

    @default_gateway.setter
    def default_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_gateway", value)

    @_builtins.property
    @pulumi.getter(name="defaultGatewayVariable")
    def default_gateway_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_gateway_variable")

    @default_gateway_variable.setter
    def default_gateway_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_gateway_variable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Configure one or more DNS server IP addresses
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @_builtins.property
    @pulumi.getter(name="dnsServersVariable")
    def dns_servers_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dns_servers_variable")

    @dns_servers_variable.setter
    def dns_servers_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_servers_variable", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set domain name client uses to resolve hostnames
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="domainNameVariable")
    def domain_name_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "domain_name_variable")

    @domain_name_variable.setter
    def domain_name_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name_variable", value)

    @_builtins.property
    @pulumi.getter(name="excludeVariable")
    def exclude_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "exclude_variable")

    @exclude_variable.setter
    def exclude_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "exclude_variable", value)

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Configure IPv4 address to exclude from DHCP address pool
        """
        return pulumi.get(self, "excludes")

    @excludes.setter
    def excludes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excludes", value)

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="interfaceMtu")
    def interface_mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set MTU on interface to DHCP client
          - Range: `68`-`65535`
        """
        return pulumi.get(self, "interface_mtu")

    @interface_mtu.setter
    def interface_mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interface_mtu", value)

    @_builtins.property
    @pulumi.getter(name="interfaceMtuVariable")
    def interface_mtu_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_mtu_variable")

    @interface_mtu_variable.setter
    def interface_mtu_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_mtu_variable", value)

    @_builtins.property
    @pulumi.getter(name="leaseTime")
    def lease_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Configure how long a DHCP-assigned IP address is valid
          - Range: `60`-`31536000`
          - Default value: `86400`
        """
        return pulumi.get(self, "lease_time")

    @lease_time.setter
    def lease_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lease_time", value)

    @_builtins.property
    @pulumi.getter(name="leaseTimeVariable")
    def lease_time_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "lease_time_variable")

    @lease_time_variable.setter
    def lease_time_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lease_time_variable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network Address
        """
        return pulumi.get(self, "network_address")

    @network_address.setter
    def network_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_address", value)

    @_builtins.property
    @pulumi.getter(name="networkAddressVariable")
    def network_address_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "network_address_variable")

    @network_address_variable.setter
    def network_address_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_address_variable", value)

    @_builtins.property
    @pulumi.getter(name="optionCodes")
    def option_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureOptionCodeArgs']]]]:
        """
        Configure Options Code
        """
        return pulumi.get(self, "option_codes")

    @option_codes.setter
    def option_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureOptionCodeArgs']]]]):
        pulumi.set(self, "option_codes", value)

    @_builtins.property
    @pulumi.getter(name="staticLeases")
    def static_leases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureStaticLeaseArgs']]]]:
        """
        Configure static IP addresses
        """
        return pulumi.get(self, "static_leases")

    @static_leases.setter
    def static_leases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceDhcpServerFeatureStaticLeaseArgs']]]]):
        pulumi.set(self, "static_leases", value)

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subnet Mask
          - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`, `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`, `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`, `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`, `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        """
        return pulumi.get(self, "subnet_mask")

    @subnet_mask.setter
    def subnet_mask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_mask", value)

    @_builtins.property
    @pulumi.getter(name="subnetMaskVariable")
    def subnet_mask_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "subnet_mask_variable")

    @subnet_mask_variable.setter
    def subnet_mask_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_mask_variable", value)

    @_builtins.property
    @pulumi.getter(name="tftpServers")
    def tftp_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Configure TFTP server IP addresses
        """
        return pulumi.get(self, "tftp_servers")

    @tftp_servers.setter
    def tftp_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tftp_servers", value)

    @_builtins.property
    @pulumi.getter(name="tftpServersVariable")
    def tftp_servers_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tftp_servers_variable")

    @tftp_servers_variable.setter
    def tftp_servers_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tftp_servers_variable", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/serviceDhcpServerFeature:ServiceDhcpServerFeature")
class ServiceDhcpServerFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 default_gateway_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dns_servers_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 interface_mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 lease_time: Optional[pulumi.Input[_builtins.int]] = None,
                 lease_time_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 option_codes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceDhcpServerFeatureOptionCodeArgs', 'ServiceDhcpServerFeatureOptionCodeArgsDict']]]]] = None,
                 static_leases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceDhcpServerFeatureStaticLeaseArgs', 'ServiceDhcpServerFeatureStaticLeaseArgsDict']]]]] = None,
                 subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_mask_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 tftp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tftp_servers_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Service DHCP Server Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "service_dhcp_server_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceDhcpServerFeature:ServiceDhcpServerFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_gateway: Set IP address of default gateway
        :param pulumi.Input[_builtins.str] default_gateway_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: Configure one or more DNS server IP addresses
        :param pulumi.Input[_builtins.str] dns_servers_variable: Variable name
        :param pulumi.Input[_builtins.str] domain_name: Set domain name client uses to resolve hostnames
        :param pulumi.Input[_builtins.str] domain_name_variable: Variable name
        :param pulumi.Input[_builtins.str] exclude_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludes: Configure IPv4 address to exclude from DHCP address pool
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.int] interface_mtu: Set MTU on interface to DHCP client
                 - Range: `68`-`65535`
        :param pulumi.Input[_builtins.str] interface_mtu_variable: Variable name
        :param pulumi.Input[_builtins.int] lease_time: Configure how long a DHCP-assigned IP address is valid
                 - Range: `60`-`31536000`
                 - Default value: `86400`
        :param pulumi.Input[_builtins.str] lease_time_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.str] network_address: Network Address
        :param pulumi.Input[_builtins.str] network_address_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceDhcpServerFeatureOptionCodeArgs', 'ServiceDhcpServerFeatureOptionCodeArgsDict']]]] option_codes: Configure Options Code
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceDhcpServerFeatureStaticLeaseArgs', 'ServiceDhcpServerFeatureStaticLeaseArgsDict']]]] static_leases: Configure static IP addresses
        :param pulumi.Input[_builtins.str] subnet_mask: Subnet Mask
                 - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`, `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`, `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`, `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`, `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[_builtins.str] subnet_mask_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tftp_servers: Configure TFTP server IP addresses
        :param pulumi.Input[_builtins.str] tftp_servers_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceDhcpServerFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Service DHCP Server Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "service_dhcp_server_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceDhcpServerFeature:ServiceDhcpServerFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceDhcpServerFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceDhcpServerFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 default_gateway_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 dns_servers_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 exclude_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 interface_mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 lease_time: Optional[pulumi.Input[_builtins.int]] = None,
                 lease_time_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_address: Optional[pulumi.Input[_builtins.str]] = None,
                 network_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 option_codes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceDhcpServerFeatureOptionCodeArgs', 'ServiceDhcpServerFeatureOptionCodeArgsDict']]]]] = None,
                 static_leases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceDhcpServerFeatureStaticLeaseArgs', 'ServiceDhcpServerFeatureStaticLeaseArgsDict']]]]] = None,
                 subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_mask_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 tftp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tftp_servers_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceDhcpServerFeatureArgs.__new__(ServiceDhcpServerFeatureArgs)

            __props__.__dict__["default_gateway"] = default_gateway
            __props__.__dict__["default_gateway_variable"] = default_gateway_variable
            __props__.__dict__["description"] = description
            __props__.__dict__["dns_servers"] = dns_servers
            __props__.__dict__["dns_servers_variable"] = dns_servers_variable
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["domain_name_variable"] = domain_name_variable
            __props__.__dict__["exclude_variable"] = exclude_variable
            __props__.__dict__["excludes"] = excludes
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["interface_mtu"] = interface_mtu
            __props__.__dict__["interface_mtu_variable"] = interface_mtu_variable
            __props__.__dict__["lease_time"] = lease_time
            __props__.__dict__["lease_time_variable"] = lease_time_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["network_address"] = network_address
            __props__.__dict__["network_address_variable"] = network_address_variable
            __props__.__dict__["option_codes"] = option_codes
            __props__.__dict__["static_leases"] = static_leases
            __props__.__dict__["subnet_mask"] = subnet_mask
            __props__.__dict__["subnet_mask_variable"] = subnet_mask_variable
            __props__.__dict__["tftp_servers"] = tftp_servers
            __props__.__dict__["tftp_servers_variable"] = tftp_servers_variable
            __props__.__dict__["version"] = None
        super(ServiceDhcpServerFeature, __self__).__init__(
            'sdwan:index/serviceDhcpServerFeature:ServiceDhcpServerFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_gateway: Optional[pulumi.Input[_builtins.str]] = None,
            default_gateway_variable: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            dns_servers_variable: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
            exclude_variable: Optional[pulumi.Input[_builtins.str]] = None,
            excludes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            interface_mtu: Optional[pulumi.Input[_builtins.int]] = None,
            interface_mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
            lease_time: Optional[pulumi.Input[_builtins.int]] = None,
            lease_time_variable: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_address: Optional[pulumi.Input[_builtins.str]] = None,
            network_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
            option_codes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceDhcpServerFeatureOptionCodeArgs', 'ServiceDhcpServerFeatureOptionCodeArgsDict']]]]] = None,
            static_leases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceDhcpServerFeatureStaticLeaseArgs', 'ServiceDhcpServerFeatureStaticLeaseArgsDict']]]]] = None,
            subnet_mask: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_mask_variable: Optional[pulumi.Input[_builtins.str]] = None,
            tftp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tftp_servers_variable: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'ServiceDhcpServerFeature':
        """
        Get an existing ServiceDhcpServerFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] default_gateway: Set IP address of default gateway
        :param pulumi.Input[_builtins.str] default_gateway_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] dns_servers: Configure one or more DNS server IP addresses
        :param pulumi.Input[_builtins.str] dns_servers_variable: Variable name
        :param pulumi.Input[_builtins.str] domain_name: Set domain name client uses to resolve hostnames
        :param pulumi.Input[_builtins.str] domain_name_variable: Variable name
        :param pulumi.Input[_builtins.str] exclude_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excludes: Configure IPv4 address to exclude from DHCP address pool
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.int] interface_mtu: Set MTU on interface to DHCP client
                 - Range: `68`-`65535`
        :param pulumi.Input[_builtins.str] interface_mtu_variable: Variable name
        :param pulumi.Input[_builtins.int] lease_time: Configure how long a DHCP-assigned IP address is valid
                 - Range: `60`-`31536000`
                 - Default value: `86400`
        :param pulumi.Input[_builtins.str] lease_time_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.str] network_address: Network Address
        :param pulumi.Input[_builtins.str] network_address_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceDhcpServerFeatureOptionCodeArgs', 'ServiceDhcpServerFeatureOptionCodeArgsDict']]]] option_codes: Configure Options Code
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceDhcpServerFeatureStaticLeaseArgs', 'ServiceDhcpServerFeatureStaticLeaseArgsDict']]]] static_leases: Configure static IP addresses
        :param pulumi.Input[_builtins.str] subnet_mask: Subnet Mask
                 - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`, `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`, `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`, `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`, `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[_builtins.str] subnet_mask_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tftp_servers: Configure TFTP server IP addresses
        :param pulumi.Input[_builtins.str] tftp_servers_variable: Variable name
        :param pulumi.Input[_builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceDhcpServerFeatureState.__new__(_ServiceDhcpServerFeatureState)

        __props__.__dict__["default_gateway"] = default_gateway
        __props__.__dict__["default_gateway_variable"] = default_gateway_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["dns_servers"] = dns_servers
        __props__.__dict__["dns_servers_variable"] = dns_servers_variable
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["domain_name_variable"] = domain_name_variable
        __props__.__dict__["exclude_variable"] = exclude_variable
        __props__.__dict__["excludes"] = excludes
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["interface_mtu"] = interface_mtu
        __props__.__dict__["interface_mtu_variable"] = interface_mtu_variable
        __props__.__dict__["lease_time"] = lease_time
        __props__.__dict__["lease_time_variable"] = lease_time_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["network_address"] = network_address
        __props__.__dict__["network_address_variable"] = network_address_variable
        __props__.__dict__["option_codes"] = option_codes
        __props__.__dict__["static_leases"] = static_leases
        __props__.__dict__["subnet_mask"] = subnet_mask
        __props__.__dict__["subnet_mask_variable"] = subnet_mask_variable
        __props__.__dict__["tftp_servers"] = tftp_servers
        __props__.__dict__["tftp_servers_variable"] = tftp_servers_variable
        __props__.__dict__["version"] = version
        return ServiceDhcpServerFeature(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set IP address of default gateway
        """
        return pulumi.get(self, "default_gateway")

    @_builtins.property
    @pulumi.getter(name="defaultGatewayVariable")
    def default_gateway_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_gateway_variable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Configure one or more DNS server IP addresses
        """
        return pulumi.get(self, "dns_servers")

    @_builtins.property
    @pulumi.getter(name="dnsServersVariable")
    def dns_servers_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dns_servers_variable")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set domain name client uses to resolve hostnames
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="domainNameVariable")
    def domain_name_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "domain_name_variable")

    @_builtins.property
    @pulumi.getter(name="excludeVariable")
    def exclude_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "exclude_variable")

    @_builtins.property
    @pulumi.getter
    def excludes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Configure IPv4 address to exclude from DHCP address pool
        """
        return pulumi.get(self, "excludes")

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @_builtins.property
    @pulumi.getter(name="interfaceMtu")
    def interface_mtu(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Set MTU on interface to DHCP client
          - Range: `68`-`65535`
        """
        return pulumi.get(self, "interface_mtu")

    @_builtins.property
    @pulumi.getter(name="interfaceMtuVariable")
    def interface_mtu_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_mtu_variable")

    @_builtins.property
    @pulumi.getter(name="leaseTime")
    def lease_time(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Configure how long a DHCP-assigned IP address is valid
          - Range: `60`-`31536000`
          - Default value: `86400`
        """
        return pulumi.get(self, "lease_time")

    @_builtins.property
    @pulumi.getter(name="leaseTimeVariable")
    def lease_time_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "lease_time_variable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Network Address
        """
        return pulumi.get(self, "network_address")

    @_builtins.property
    @pulumi.getter(name="networkAddressVariable")
    def network_address_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "network_address_variable")

    @_builtins.property
    @pulumi.getter(name="optionCodes")
    def option_codes(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceDhcpServerFeatureOptionCode']]]:
        """
        Configure Options Code
        """
        return pulumi.get(self, "option_codes")

    @_builtins.property
    @pulumi.getter(name="staticLeases")
    def static_leases(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceDhcpServerFeatureStaticLease']]]:
        """
        Configure static IP addresses
        """
        return pulumi.get(self, "static_leases")

    @_builtins.property
    @pulumi.getter(name="subnetMask")
    def subnet_mask(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Subnet Mask
          - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`, `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`, `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`, `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`, `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        """
        return pulumi.get(self, "subnet_mask")

    @_builtins.property
    @pulumi.getter(name="subnetMaskVariable")
    def subnet_mask_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "subnet_mask_variable")

    @_builtins.property
    @pulumi.getter(name="tftpServers")
    def tftp_servers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Configure TFTP server IP addresses
        """
        return pulumi.get(self, "tftp_servers")

    @_builtins.property
    @pulumi.getter(name="tftpServersVariable")
    def tftp_servers_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tftp_servers_variable")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

