# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TransportCellularProfileFeatureArgs', 'TransportCellularProfileFeature']

@pulumi.input_type
class TransportCellularProfileFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[_builtins.str],
                 access_point_name: Optional[pulumi.Input[_builtins.str]] = None,
                 access_point_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 no_overwrite: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_overwrite_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 packet_data_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 packet_data_network_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.int]] = None,
                 profile_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_password: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_password_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_username: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_username_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 requires_authentication: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a TransportCellularProfileFeature resource.
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.str] access_point_name: Set access point name
        :param pulumi.Input[_builtins.str] access_point_name_variable: Variable name
        :param pulumi.Input[_builtins.str] authentication_type: Set authentication type, Attribute conditional on `requires_authentication` being equal to `true`
                 - Choices: `pap`, `chap`, `pap_chap`
        :param pulumi.Input[_builtins.str] authentication_type_variable: Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.bool] no_overwrite: No Overwrite
        :param pulumi.Input[_builtins.str] no_overwrite_variable: Variable name
        :param pulumi.Input[_builtins.str] packet_data_network_type: Set packet data network type
                 - Choices: `ipv4`, `ipv4v6`, `ipv6`
                 - Default value: `ipv4`
        :param pulumi.Input[_builtins.str] packet_data_network_type_variable: Variable name
        :param pulumi.Input[_builtins.int] profile_id: Set Profile ID
                 - Range: `1`-`16`
        :param pulumi.Input[_builtins.str] profile_id_variable: Variable name
        :param pulumi.Input[_builtins.str] profile_password: Set the profile password, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] profile_password_variable: Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] profile_username: Set the profile username, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] profile_username_variable: Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.bool] requires_authentication: Require authentication type
                 - Default value: `false`
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if access_point_name is not None:
            pulumi.set(__self__, "access_point_name", access_point_name)
        if access_point_name_variable is not None:
            pulumi.set(__self__, "access_point_name_variable", access_point_name_variable)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if authentication_type_variable is not None:
            pulumi.set(__self__, "authentication_type_variable", authentication_type_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_overwrite is not None:
            pulumi.set(__self__, "no_overwrite", no_overwrite)
        if no_overwrite_variable is not None:
            pulumi.set(__self__, "no_overwrite_variable", no_overwrite_variable)
        if packet_data_network_type is not None:
            pulumi.set(__self__, "packet_data_network_type", packet_data_network_type)
        if packet_data_network_type_variable is not None:
            pulumi.set(__self__, "packet_data_network_type_variable", packet_data_network_type_variable)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if profile_id_variable is not None:
            pulumi.set(__self__, "profile_id_variable", profile_id_variable)
        if profile_password is not None:
            pulumi.set(__self__, "profile_password", profile_password)
        if profile_password_variable is not None:
            pulumi.set(__self__, "profile_password_variable", profile_password_variable)
        if profile_username is not None:
            pulumi.set(__self__, "profile_username", profile_username)
        if profile_username_variable is not None:
            pulumi.set(__self__, "profile_username_variable", profile_username_variable)
        if requires_authentication is not None:
            pulumi.set(__self__, "requires_authentication", requires_authentication)

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[_builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @_builtins.property
    @pulumi.getter(name="accessPointName")
    def access_point_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set access point name
        """
        return pulumi.get(self, "access_point_name")

    @access_point_name.setter
    def access_point_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_point_name", value)

    @_builtins.property
    @pulumi.getter(name="accessPointNameVariable")
    def access_point_name_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "access_point_name_variable")

    @access_point_name_variable.setter
    def access_point_name_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_point_name_variable", value)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set authentication type, Attribute conditional on `requires_authentication` being equal to `true`
          - Choices: `pap`, `chap`, `pap_chap`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "authentication_type_variable")

    @authentication_type_variable.setter
    def authentication_type_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type_variable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="noOverwrite")
    def no_overwrite(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        No Overwrite
        """
        return pulumi.get(self, "no_overwrite")

    @no_overwrite.setter
    def no_overwrite(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_overwrite", value)

    @_builtins.property
    @pulumi.getter(name="noOverwriteVariable")
    def no_overwrite_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "no_overwrite_variable")

    @no_overwrite_variable.setter
    def no_overwrite_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "no_overwrite_variable", value)

    @_builtins.property
    @pulumi.getter(name="packetDataNetworkType")
    def packet_data_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set packet data network type
          - Choices: `ipv4`, `ipv4v6`, `ipv6`
          - Default value: `ipv4`
        """
        return pulumi.get(self, "packet_data_network_type")

    @packet_data_network_type.setter
    def packet_data_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "packet_data_network_type", value)

    @_builtins.property
    @pulumi.getter(name="packetDataNetworkTypeVariable")
    def packet_data_network_type_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "packet_data_network_type_variable")

    @packet_data_network_type_variable.setter
    def packet_data_network_type_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "packet_data_network_type_variable", value)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set Profile ID
          - Range: `1`-`16`
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "profile_id", value)

    @_builtins.property
    @pulumi.getter(name="profileIdVariable")
    def profile_id_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_id_variable")

    @profile_id_variable.setter
    def profile_id_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_id_variable", value)

    @_builtins.property
    @pulumi.getter(name="profilePassword")
    def profile_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the profile password, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "profile_password")

    @profile_password.setter
    def profile_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_password", value)

    @_builtins.property
    @pulumi.getter(name="profilePasswordVariable")
    def profile_password_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "profile_password_variable")

    @profile_password_variable.setter
    def profile_password_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_password_variable", value)

    @_builtins.property
    @pulumi.getter(name="profileUsername")
    def profile_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the profile username, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "profile_username")

    @profile_username.setter
    def profile_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_username", value)

    @_builtins.property
    @pulumi.getter(name="profileUsernameVariable")
    def profile_username_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "profile_username_variable")

    @profile_username_variable.setter
    def profile_username_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_username_variable", value)

    @_builtins.property
    @pulumi.getter(name="requiresAuthentication")
    def requires_authentication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Require authentication type
          - Default value: `false`
        """
        return pulumi.get(self, "requires_authentication")

    @requires_authentication.setter
    def requires_authentication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "requires_authentication", value)


@pulumi.input_type
class _TransportCellularProfileFeatureState:
    def __init__(__self__, *,
                 access_point_name: Optional[pulumi.Input[_builtins.str]] = None,
                 access_point_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 no_overwrite: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_overwrite_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 packet_data_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 packet_data_network_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.int]] = None,
                 profile_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_password: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_password_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_username: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_username_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 requires_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering TransportCellularProfileFeature resources.
        :param pulumi.Input[_builtins.str] access_point_name: Set access point name
        :param pulumi.Input[_builtins.str] access_point_name_variable: Variable name
        :param pulumi.Input[_builtins.str] authentication_type: Set authentication type, Attribute conditional on `requires_authentication` being equal to `true`
                 - Choices: `pap`, `chap`, `pap_chap`
        :param pulumi.Input[_builtins.str] authentication_type_variable: Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.bool] no_overwrite: No Overwrite
        :param pulumi.Input[_builtins.str] no_overwrite_variable: Variable name
        :param pulumi.Input[_builtins.str] packet_data_network_type: Set packet data network type
                 - Choices: `ipv4`, `ipv4v6`, `ipv6`
                 - Default value: `ipv4`
        :param pulumi.Input[_builtins.str] packet_data_network_type_variable: Variable name
        :param pulumi.Input[_builtins.int] profile_id: Set Profile ID
                 - Range: `1`-`16`
        :param pulumi.Input[_builtins.str] profile_id_variable: Variable name
        :param pulumi.Input[_builtins.str] profile_password: Set the profile password, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] profile_password_variable: Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] profile_username: Set the profile username, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] profile_username_variable: Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.bool] requires_authentication: Require authentication type
                 - Default value: `false`
        :param pulumi.Input[_builtins.int] version: The version of the Feature
        """
        if access_point_name is not None:
            pulumi.set(__self__, "access_point_name", access_point_name)
        if access_point_name_variable is not None:
            pulumi.set(__self__, "access_point_name_variable", access_point_name_variable)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if authentication_type_variable is not None:
            pulumi.set(__self__, "authentication_type_variable", authentication_type_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_overwrite is not None:
            pulumi.set(__self__, "no_overwrite", no_overwrite)
        if no_overwrite_variable is not None:
            pulumi.set(__self__, "no_overwrite_variable", no_overwrite_variable)
        if packet_data_network_type is not None:
            pulumi.set(__self__, "packet_data_network_type", packet_data_network_type)
        if packet_data_network_type_variable is not None:
            pulumi.set(__self__, "packet_data_network_type_variable", packet_data_network_type_variable)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if profile_id_variable is not None:
            pulumi.set(__self__, "profile_id_variable", profile_id_variable)
        if profile_password is not None:
            pulumi.set(__self__, "profile_password", profile_password)
        if profile_password_variable is not None:
            pulumi.set(__self__, "profile_password_variable", profile_password_variable)
        if profile_username is not None:
            pulumi.set(__self__, "profile_username", profile_username)
        if profile_username_variable is not None:
            pulumi.set(__self__, "profile_username_variable", profile_username_variable)
        if requires_authentication is not None:
            pulumi.set(__self__, "requires_authentication", requires_authentication)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="accessPointName")
    def access_point_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set access point name
        """
        return pulumi.get(self, "access_point_name")

    @access_point_name.setter
    def access_point_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_point_name", value)

    @_builtins.property
    @pulumi.getter(name="accessPointNameVariable")
    def access_point_name_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "access_point_name_variable")

    @access_point_name_variable.setter
    def access_point_name_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_point_name_variable", value)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set authentication type, Attribute conditional on `requires_authentication` being equal to `true`
          - Choices: `pap`, `chap`, `pap_chap`
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "authentication_type_variable")

    @authentication_type_variable.setter
    def authentication_type_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type_variable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="noOverwrite")
    def no_overwrite(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        No Overwrite
        """
        return pulumi.get(self, "no_overwrite")

    @no_overwrite.setter
    def no_overwrite(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "no_overwrite", value)

    @_builtins.property
    @pulumi.getter(name="noOverwriteVariable")
    def no_overwrite_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "no_overwrite_variable")

    @no_overwrite_variable.setter
    def no_overwrite_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "no_overwrite_variable", value)

    @_builtins.property
    @pulumi.getter(name="packetDataNetworkType")
    def packet_data_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set packet data network type
          - Choices: `ipv4`, `ipv4v6`, `ipv6`
          - Default value: `ipv4`
        """
        return pulumi.get(self, "packet_data_network_type")

    @packet_data_network_type.setter
    def packet_data_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "packet_data_network_type", value)

    @_builtins.property
    @pulumi.getter(name="packetDataNetworkTypeVariable")
    def packet_data_network_type_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "packet_data_network_type_variable")

    @packet_data_network_type_variable.setter
    def packet_data_network_type_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "packet_data_network_type_variable", value)

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set Profile ID
          - Range: `1`-`16`
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "profile_id", value)

    @_builtins.property
    @pulumi.getter(name="profileIdVariable")
    def profile_id_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_id_variable")

    @profile_id_variable.setter
    def profile_id_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_id_variable", value)

    @_builtins.property
    @pulumi.getter(name="profilePassword")
    def profile_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the profile password, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "profile_password")

    @profile_password.setter
    def profile_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_password", value)

    @_builtins.property
    @pulumi.getter(name="profilePasswordVariable")
    def profile_password_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "profile_password_variable")

    @profile_password_variable.setter
    def profile_password_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_password_variable", value)

    @_builtins.property
    @pulumi.getter(name="profileUsername")
    def profile_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Set the profile username, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "profile_username")

    @profile_username.setter
    def profile_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_username", value)

    @_builtins.property
    @pulumi.getter(name="profileUsernameVariable")
    def profile_username_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "profile_username_variable")

    @profile_username_variable.setter
    def profile_username_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile_username_variable", value)

    @_builtins.property
    @pulumi.getter(name="requiresAuthentication")
    def requires_authentication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Require authentication type
          - Default value: `false`
        """
        return pulumi.get(self, "requires_authentication")

    @requires_authentication.setter
    def requires_authentication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "requires_authentication", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/transportCellularProfileFeature:TransportCellularProfileFeature")
class TransportCellularProfileFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_name: Optional[pulumi.Input[_builtins.str]] = None,
                 access_point_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 no_overwrite: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_overwrite_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 packet_data_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 packet_data_network_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.int]] = None,
                 profile_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_password: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_password_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_username: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_username_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 requires_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        This resource can manage a Transport Cellular Profile Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.TransportCellularProfileFeature("example",
            name="Example",
            description="My Example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            profile_id=1,
            access_point_name="apn1",
            requires_authentication=True,
            authentication_type="pap",
            profile_username="example",
            profile_password="example123!",
            packet_data_network_type="ipv4",
            no_overwrite=False)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "transport_cellular_profile_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/transportCellularProfileFeature:TransportCellularProfileFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_point_name: Set access point name
        :param pulumi.Input[_builtins.str] access_point_name_variable: Variable name
        :param pulumi.Input[_builtins.str] authentication_type: Set authentication type, Attribute conditional on `requires_authentication` being equal to `true`
                 - Choices: `pap`, `chap`, `pap_chap`
        :param pulumi.Input[_builtins.str] authentication_type_variable: Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.bool] no_overwrite: No Overwrite
        :param pulumi.Input[_builtins.str] no_overwrite_variable: Variable name
        :param pulumi.Input[_builtins.str] packet_data_network_type: Set packet data network type
                 - Choices: `ipv4`, `ipv4v6`, `ipv6`
                 - Default value: `ipv4`
        :param pulumi.Input[_builtins.str] packet_data_network_type_variable: Variable name
        :param pulumi.Input[_builtins.int] profile_id: Set Profile ID
                 - Range: `1`-`16`
        :param pulumi.Input[_builtins.str] profile_id_variable: Variable name
        :param pulumi.Input[_builtins.str] profile_password: Set the profile password, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] profile_password_variable: Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] profile_username: Set the profile username, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] profile_username_variable: Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.bool] requires_authentication: Require authentication type
                 - Default value: `false`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransportCellularProfileFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Transport Cellular Profile Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.TransportCellularProfileFeature("example",
            name="Example",
            description="My Example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            profile_id=1,
            access_point_name="apn1",
            requires_authentication=True,
            authentication_type="pap",
            profile_username="example",
            profile_password="example123!",
            packet_data_network_type="ipv4",
            no_overwrite=False)
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Expected import identifier with the format: "transport_cellular_profile_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/transportCellularProfileFeature:TransportCellularProfileFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param TransportCellularProfileFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransportCellularProfileFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_name: Optional[pulumi.Input[_builtins.str]] = None,
                 access_point_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 authentication_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 no_overwrite: Optional[pulumi.Input[_builtins.bool]] = None,
                 no_overwrite_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 packet_data_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 packet_data_network_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_id: Optional[pulumi.Input[_builtins.int]] = None,
                 profile_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_password: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_password_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_username: Optional[pulumi.Input[_builtins.str]] = None,
                 profile_username_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 requires_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransportCellularProfileFeatureArgs.__new__(TransportCellularProfileFeatureArgs)

            __props__.__dict__["access_point_name"] = access_point_name
            __props__.__dict__["access_point_name_variable"] = access_point_name_variable
            __props__.__dict__["authentication_type"] = authentication_type
            __props__.__dict__["authentication_type_variable"] = authentication_type_variable
            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["name"] = name
            __props__.__dict__["no_overwrite"] = no_overwrite
            __props__.__dict__["no_overwrite_variable"] = no_overwrite_variable
            __props__.__dict__["packet_data_network_type"] = packet_data_network_type
            __props__.__dict__["packet_data_network_type_variable"] = packet_data_network_type_variable
            __props__.__dict__["profile_id"] = profile_id
            __props__.__dict__["profile_id_variable"] = profile_id_variable
            __props__.__dict__["profile_password"] = profile_password
            __props__.__dict__["profile_password_variable"] = profile_password_variable
            __props__.__dict__["profile_username"] = profile_username
            __props__.__dict__["profile_username_variable"] = profile_username_variable
            __props__.__dict__["requires_authentication"] = requires_authentication
            __props__.__dict__["version"] = None
        super(TransportCellularProfileFeature, __self__).__init__(
            'sdwan:index/transportCellularProfileFeature:TransportCellularProfileFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_point_name: Optional[pulumi.Input[_builtins.str]] = None,
            access_point_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
            authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
            authentication_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            no_overwrite: Optional[pulumi.Input[_builtins.bool]] = None,
            no_overwrite_variable: Optional[pulumi.Input[_builtins.str]] = None,
            packet_data_network_type: Optional[pulumi.Input[_builtins.str]] = None,
            packet_data_network_type_variable: Optional[pulumi.Input[_builtins.str]] = None,
            profile_id: Optional[pulumi.Input[_builtins.int]] = None,
            profile_id_variable: Optional[pulumi.Input[_builtins.str]] = None,
            profile_password: Optional[pulumi.Input[_builtins.str]] = None,
            profile_password_variable: Optional[pulumi.Input[_builtins.str]] = None,
            profile_username: Optional[pulumi.Input[_builtins.str]] = None,
            profile_username_variable: Optional[pulumi.Input[_builtins.str]] = None,
            requires_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'TransportCellularProfileFeature':
        """
        Get an existing TransportCellularProfileFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_point_name: Set access point name
        :param pulumi.Input[_builtins.str] access_point_name_variable: Variable name
        :param pulumi.Input[_builtins.str] authentication_type: Set authentication type, Attribute conditional on `requires_authentication` being equal to `true`
                 - Choices: `pap`, `chap`, `pap_chap`
        :param pulumi.Input[_builtins.str] authentication_type_variable: Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] description: The description of the Feature
        :param pulumi.Input[_builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[_builtins.str] name: The name of the Feature
        :param pulumi.Input[_builtins.bool] no_overwrite: No Overwrite
        :param pulumi.Input[_builtins.str] no_overwrite_variable: Variable name
        :param pulumi.Input[_builtins.str] packet_data_network_type: Set packet data network type
                 - Choices: `ipv4`, `ipv4v6`, `ipv6`
                 - Default value: `ipv4`
        :param pulumi.Input[_builtins.str] packet_data_network_type_variable: Variable name
        :param pulumi.Input[_builtins.int] profile_id: Set Profile ID
                 - Range: `1`-`16`
        :param pulumi.Input[_builtins.str] profile_id_variable: Variable name
        :param pulumi.Input[_builtins.str] profile_password: Set the profile password, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] profile_password_variable: Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] profile_username: Set the profile username, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.str] profile_username_variable: Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        :param pulumi.Input[_builtins.bool] requires_authentication: Require authentication type
                 - Default value: `false`
        :param pulumi.Input[_builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransportCellularProfileFeatureState.__new__(_TransportCellularProfileFeatureState)

        __props__.__dict__["access_point_name"] = access_point_name
        __props__.__dict__["access_point_name_variable"] = access_point_name_variable
        __props__.__dict__["authentication_type"] = authentication_type
        __props__.__dict__["authentication_type_variable"] = authentication_type_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["name"] = name
        __props__.__dict__["no_overwrite"] = no_overwrite
        __props__.__dict__["no_overwrite_variable"] = no_overwrite_variable
        __props__.__dict__["packet_data_network_type"] = packet_data_network_type
        __props__.__dict__["packet_data_network_type_variable"] = packet_data_network_type_variable
        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["profile_id_variable"] = profile_id_variable
        __props__.__dict__["profile_password"] = profile_password
        __props__.__dict__["profile_password_variable"] = profile_password_variable
        __props__.__dict__["profile_username"] = profile_username
        __props__.__dict__["profile_username_variable"] = profile_username_variable
        __props__.__dict__["requires_authentication"] = requires_authentication
        __props__.__dict__["version"] = version
        return TransportCellularProfileFeature(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPointName")
    def access_point_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set access point name
        """
        return pulumi.get(self, "access_point_name")

    @_builtins.property
    @pulumi.getter(name="accessPointNameVariable")
    def access_point_name_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "access_point_name_variable")

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set authentication type, Attribute conditional on `requires_authentication` being equal to `true`
          - Choices: `pap`, `chap`, `pap_chap`
        """
        return pulumi.get(self, "authentication_type")

    @_builtins.property
    @pulumi.getter(name="authenticationTypeVariable")
    def authentication_type_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "authentication_type_variable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[_builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="noOverwrite")
    def no_overwrite(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        No Overwrite
        """
        return pulumi.get(self, "no_overwrite")

    @_builtins.property
    @pulumi.getter(name="noOverwriteVariable")
    def no_overwrite_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "no_overwrite_variable")

    @_builtins.property
    @pulumi.getter(name="packetDataNetworkType")
    def packet_data_network_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set packet data network type
          - Choices: `ipv4`, `ipv4v6`, `ipv6`
          - Default value: `ipv4`
        """
        return pulumi.get(self, "packet_data_network_type")

    @_builtins.property
    @pulumi.getter(name="packetDataNetworkTypeVariable")
    def packet_data_network_type_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "packet_data_network_type_variable")

    @_builtins.property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Set Profile ID
          - Range: `1`-`16`
        """
        return pulumi.get(self, "profile_id")

    @_builtins.property
    @pulumi.getter(name="profileIdVariable")
    def profile_id_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "profile_id_variable")

    @_builtins.property
    @pulumi.getter(name="profilePassword")
    def profile_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set the profile password, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "profile_password")

    @_builtins.property
    @pulumi.getter(name="profilePasswordVariable")
    def profile_password_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "profile_password_variable")

    @_builtins.property
    @pulumi.getter(name="profileUsername")
    def profile_username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Set the profile username, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "profile_username")

    @_builtins.property
    @pulumi.getter(name="profileUsernameVariable")
    def profile_username_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name, Attribute conditional on `requires_authentication` being equal to `true`
        """
        return pulumi.get(self, "profile_username_variable")

    @_builtins.property
    @pulumi.getter(name="requiresAuthentication")
    def requires_authentication(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Require authentication type
          - Default value: `false`
        """
        return pulumi.get(self, "requires_authentication")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

