# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpnInterfaceSviFeatureTemplateArgs', 'VpnInterfaceSviFeatureTemplate']

@pulumi.input_type
class VpnInterfaceSviFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 arp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 arp_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 if_name: Optional[pulumi.Input[_builtins.str]] = None,
                 if_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_description: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_directed_broadcast: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_directed_broadcast_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_access_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4AccessListArgs']]]] = None,
                 ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_dhcp_helper_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv4_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgs']]]] = None,
                 ipv4_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4VrrpArgs']]]] = None,
                 ipv6_access_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6AccessListArgs']]]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_dhcp_client: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_dhcp_client_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_dhcp_distance: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_dhcp_distance_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgs']]]] = None,
                 ipv6_dhcp_rapid_commit: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_dhcp_rapid_commit_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgs']]]] = None,
                 ipv6_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6VrrpArgs']]]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policers: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplatePolicerArgs']]]] = None,
                 shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 static_arp_entries: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateStaticArpEntryArgs']]]] = None,
                 tcp_mss_adjust: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_mss_adjust_variable: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VpnInterfaceSviFeatureTemplate resource.
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.int] arp_timeout: Timeout value for dynamically learned ARP entries, <0..2678400> seconds
                 - Range: `0`-`2678400`
                 - Default value: `1200`
        :param pulumi.Input[_builtins.str] arp_timeout_variable: Variable name
        :param pulumi.Input[_builtins.str] if_name: Interface name: VLAN 1 - VLAN 4094 when present
        :param pulumi.Input[_builtins.str] if_name_variable: Variable name
        :param pulumi.Input[_builtins.str] interface_description: Interface description
        :param pulumi.Input[_builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[_builtins.bool] ip_directed_broadcast: IP Directed-Broadcast
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] ip_directed_broadcast_variable: Variable name
        :param pulumi.Input[_builtins.int] ip_mtu: IP MTU <576..Interface MTU>, in bytes
                 - Range: `576`-`9216`
                 - Default value: `1500`
        :param pulumi.Input[_builtins.str] ip_mtu_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4AccessListArgs']]] ipv4_access_lists: Apply ACL
        :param pulumi.Input[_builtins.str] ipv4_address: Assign IPv4 address
        :param pulumi.Input[_builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[_builtins.str] ipv4_dhcp_helper_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_dhcp_helpers: List of DHCP helper addresses
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgs']]] ipv4_secondary_addresses: Assign secondary IP addresses
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4VrrpArgs']]] ipv4_vrrps: Enable VRRP
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6AccessListArgs']]] ipv6_access_lists: Apply ACL
        :param pulumi.Input[_builtins.str] ipv6_address: Assign IPv6 address
        :param pulumi.Input[_builtins.str] ipv6_address_variable: Variable name
        :param pulumi.Input[_builtins.bool] ipv6_dhcp_client: Enable DHCPv6
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] ipv6_dhcp_client_variable: Variable name
        :param pulumi.Input[_builtins.int] ipv6_dhcp_distance: Set administrative distance for DHCP default route
                 - Range: `1`-`65536`
                 - Default value: `1`
        :param pulumi.Input[_builtins.str] ipv6_dhcp_distance_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgs']]] ipv6_dhcp_helpers: DHCPv6 Helper
        :param pulumi.Input[_builtins.bool] ipv6_dhcp_rapid_commit: Enable DHCPv6 rapid commit
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] ipv6_dhcp_rapid_commit_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgs']]] ipv6_secondary_addresses: Assign secondary IPv6 addresses
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6VrrpArgs']]] ipv6_vrrps: Enable VRRP
        :param pulumi.Input[_builtins.int] mtu: Interface MTU <1500..9216> in bytes
                 - Range: `1500`-`9216`
                 - Default value: `1500`
        :param pulumi.Input[_builtins.str] mtu_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplatePolicerArgs']]] policers: Enable policer
        :param pulumi.Input[_builtins.bool] shutdown: Administrative state
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateStaticArpEntryArgs']]] static_arp_entries: Configure static ARP entries
        :param pulumi.Input[_builtins.int] tcp_mss_adjust: TCP MSS on SYN packets, in bytes
                 - Range: `552`-`1960`
        :param pulumi.Input[_builtins.str] tcp_mss_adjust_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if arp_timeout is not None:
            pulumi.set(__self__, "arp_timeout", arp_timeout)
        if arp_timeout_variable is not None:
            pulumi.set(__self__, "arp_timeout_variable", arp_timeout_variable)
        if if_name is not None:
            pulumi.set(__self__, "if_name", if_name)
        if if_name_variable is not None:
            pulumi.set(__self__, "if_name_variable", if_name_variable)
        if interface_description is not None:
            pulumi.set(__self__, "interface_description", interface_description)
        if interface_description_variable is not None:
            pulumi.set(__self__, "interface_description_variable", interface_description_variable)
        if ip_directed_broadcast is not None:
            pulumi.set(__self__, "ip_directed_broadcast", ip_directed_broadcast)
        if ip_directed_broadcast_variable is not None:
            pulumi.set(__self__, "ip_directed_broadcast_variable", ip_directed_broadcast_variable)
        if ip_mtu is not None:
            pulumi.set(__self__, "ip_mtu", ip_mtu)
        if ip_mtu_variable is not None:
            pulumi.set(__self__, "ip_mtu_variable", ip_mtu_variable)
        if ipv4_access_lists is not None:
            pulumi.set(__self__, "ipv4_access_lists", ipv4_access_lists)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_address_variable is not None:
            pulumi.set(__self__, "ipv4_address_variable", ipv4_address_variable)
        if ipv4_dhcp_helper_variable is not None:
            pulumi.set(__self__, "ipv4_dhcp_helper_variable", ipv4_dhcp_helper_variable)
        if ipv4_dhcp_helpers is not None:
            pulumi.set(__self__, "ipv4_dhcp_helpers", ipv4_dhcp_helpers)
        if ipv4_secondary_addresses is not None:
            pulumi.set(__self__, "ipv4_secondary_addresses", ipv4_secondary_addresses)
        if ipv4_vrrps is not None:
            pulumi.set(__self__, "ipv4_vrrps", ipv4_vrrps)
        if ipv6_access_lists is not None:
            pulumi.set(__self__, "ipv6_access_lists", ipv6_access_lists)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_address_variable is not None:
            pulumi.set(__self__, "ipv6_address_variable", ipv6_address_variable)
        if ipv6_dhcp_client is not None:
            pulumi.set(__self__, "ipv6_dhcp_client", ipv6_dhcp_client)
        if ipv6_dhcp_client_variable is not None:
            pulumi.set(__self__, "ipv6_dhcp_client_variable", ipv6_dhcp_client_variable)
        if ipv6_dhcp_distance is not None:
            pulumi.set(__self__, "ipv6_dhcp_distance", ipv6_dhcp_distance)
        if ipv6_dhcp_distance_variable is not None:
            pulumi.set(__self__, "ipv6_dhcp_distance_variable", ipv6_dhcp_distance_variable)
        if ipv6_dhcp_helpers is not None:
            pulumi.set(__self__, "ipv6_dhcp_helpers", ipv6_dhcp_helpers)
        if ipv6_dhcp_rapid_commit is not None:
            pulumi.set(__self__, "ipv6_dhcp_rapid_commit", ipv6_dhcp_rapid_commit)
        if ipv6_dhcp_rapid_commit_variable is not None:
            pulumi.set(__self__, "ipv6_dhcp_rapid_commit_variable", ipv6_dhcp_rapid_commit_variable)
        if ipv6_secondary_addresses is not None:
            pulumi.set(__self__, "ipv6_secondary_addresses", ipv6_secondary_addresses)
        if ipv6_vrrps is not None:
            pulumi.set(__self__, "ipv6_vrrps", ipv6_vrrps)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if mtu_variable is not None:
            pulumi.set(__self__, "mtu_variable", mtu_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policers is not None:
            pulumi.set(__self__, "policers", policers)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if static_arp_entries is not None:
            pulumi.set(__self__, "static_arp_entries", static_arp_entries)
        if tcp_mss_adjust is not None:
            pulumi.set(__self__, "tcp_mss_adjust", tcp_mss_adjust)
        if tcp_mss_adjust_variable is not None:
            pulumi.set(__self__, "tcp_mss_adjust_variable", tcp_mss_adjust_variable)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @_builtins.property
    @pulumi.getter(name="arpTimeout")
    def arp_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout value for dynamically learned ARP entries, <0..2678400> seconds
          - Range: `0`-`2678400`
          - Default value: `1200`
        """
        return pulumi.get(self, "arp_timeout")

    @arp_timeout.setter
    def arp_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "arp_timeout", value)

    @_builtins.property
    @pulumi.getter(name="arpTimeoutVariable")
    def arp_timeout_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "arp_timeout_variable")

    @arp_timeout_variable.setter
    def arp_timeout_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arp_timeout_variable", value)

    @_builtins.property
    @pulumi.getter(name="ifName")
    def if_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface name: VLAN 1 - VLAN 4094 when present
        """
        return pulumi.get(self, "if_name")

    @if_name.setter
    def if_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "if_name", value)

    @_builtins.property
    @pulumi.getter(name="ifNameVariable")
    def if_name_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "if_name_variable")

    @if_name_variable.setter
    def if_name_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "if_name_variable", value)

    @_builtins.property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @interface_description.setter
    def interface_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_description", value)

    @_builtins.property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @interface_description_variable.setter
    def interface_description_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_description_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipDirectedBroadcast")
    def ip_directed_broadcast(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        IP Directed-Broadcast
          - Default value: `false`
        """
        return pulumi.get(self, "ip_directed_broadcast")

    @ip_directed_broadcast.setter
    def ip_directed_broadcast(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_directed_broadcast", value)

    @_builtins.property
    @pulumi.getter(name="ipDirectedBroadcastVariable")
    def ip_directed_broadcast_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_directed_broadcast_variable")

    @ip_directed_broadcast_variable.setter
    def ip_directed_broadcast_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_directed_broadcast_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        IP MTU <576..Interface MTU>, in bytes
          - Range: `576`-`9216`
          - Default value: `1500`
        """
        return pulumi.get(self, "ip_mtu")

    @ip_mtu.setter
    def ip_mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_mtu", value)

    @_builtins.property
    @pulumi.getter(name="ipMtuVariable")
    def ip_mtu_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_mtu_variable")

    @ip_mtu_variable.setter
    def ip_mtu_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_mtu_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv4AccessLists")
    def ipv4_access_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4AccessListArgs']]]]:
        """
        Apply ACL
        """
        return pulumi.get(self, "ipv4_access_lists")

    @ipv4_access_lists.setter
    def ipv4_access_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4AccessListArgs']]]]):
        pulumi.set(self, "ipv4_access_lists", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assign IPv4 address
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="ipv4AddressVariable")
    def ipv4_address_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_address_variable")

    @ipv4_address_variable.setter
    def ipv4_address_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_address_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv4DhcpHelperVariable")
    def ipv4_dhcp_helper_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_dhcp_helper_variable")

    @ipv4_dhcp_helper_variable.setter
    def ipv4_dhcp_helper_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_dhcp_helper_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv4DhcpHelpers")
    def ipv4_dhcp_helpers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of DHCP helper addresses
        """
        return pulumi.get(self, "ipv4_dhcp_helpers")

    @ipv4_dhcp_helpers.setter
    def ipv4_dhcp_helpers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv4_dhcp_helpers", value)

    @_builtins.property
    @pulumi.getter(name="ipv4SecondaryAddresses")
    def ipv4_secondary_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgs']]]]:
        """
        Assign secondary IP addresses
        """
        return pulumi.get(self, "ipv4_secondary_addresses")

    @ipv4_secondary_addresses.setter
    def ipv4_secondary_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgs']]]]):
        pulumi.set(self, "ipv4_secondary_addresses", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Vrrps")
    def ipv4_vrrps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4VrrpArgs']]]]:
        """
        Enable VRRP
        """
        return pulumi.get(self, "ipv4_vrrps")

    @ipv4_vrrps.setter
    def ipv4_vrrps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4VrrpArgs']]]]):
        pulumi.set(self, "ipv4_vrrps", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AccessLists")
    def ipv6_access_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6AccessListArgs']]]]:
        """
        Apply ACL
        """
        return pulumi.get(self, "ipv6_access_lists")

    @ipv6_access_lists.setter
    def ipv6_access_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6AccessListArgs']]]]):
        pulumi.set(self, "ipv6_access_lists", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assign IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressVariable")
    def ipv6_address_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_address_variable")

    @ipv6_address_variable.setter
    def ipv6_address_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpClient")
    def ipv6_dhcp_client(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable DHCPv6
          - Default value: `false`
        """
        return pulumi.get(self, "ipv6_dhcp_client")

    @ipv6_dhcp_client.setter
    def ipv6_dhcp_client(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_dhcp_client", value)

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpClientVariable")
    def ipv6_dhcp_client_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_dhcp_client_variable")

    @ipv6_dhcp_client_variable.setter
    def ipv6_dhcp_client_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_dhcp_client_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpDistance")
    def ipv6_dhcp_distance(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set administrative distance for DHCP default route
          - Range: `1`-`65536`
          - Default value: `1`
        """
        return pulumi.get(self, "ipv6_dhcp_distance")

    @ipv6_dhcp_distance.setter
    def ipv6_dhcp_distance(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_dhcp_distance", value)

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpDistanceVariable")
    def ipv6_dhcp_distance_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_dhcp_distance_variable")

    @ipv6_dhcp_distance_variable.setter
    def ipv6_dhcp_distance_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_dhcp_distance_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpHelpers")
    def ipv6_dhcp_helpers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgs']]]]:
        """
        DHCPv6 Helper
        """
        return pulumi.get(self, "ipv6_dhcp_helpers")

    @ipv6_dhcp_helpers.setter
    def ipv6_dhcp_helpers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgs']]]]):
        pulumi.set(self, "ipv6_dhcp_helpers", value)

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpRapidCommit")
    def ipv6_dhcp_rapid_commit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable DHCPv6 rapid commit
          - Default value: `false`
        """
        return pulumi.get(self, "ipv6_dhcp_rapid_commit")

    @ipv6_dhcp_rapid_commit.setter
    def ipv6_dhcp_rapid_commit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_dhcp_rapid_commit", value)

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpRapidCommitVariable")
    def ipv6_dhcp_rapid_commit_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_dhcp_rapid_commit_variable")

    @ipv6_dhcp_rapid_commit_variable.setter
    def ipv6_dhcp_rapid_commit_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_dhcp_rapid_commit_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv6SecondaryAddresses")
    def ipv6_secondary_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgs']]]]:
        """
        Assign secondary IPv6 addresses
        """
        return pulumi.get(self, "ipv6_secondary_addresses")

    @ipv6_secondary_addresses.setter
    def ipv6_secondary_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgs']]]]):
        pulumi.set(self, "ipv6_secondary_addresses", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Vrrps")
    def ipv6_vrrps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6VrrpArgs']]]]:
        """
        Enable VRRP
        """
        return pulumi.get(self, "ipv6_vrrps")

    @ipv6_vrrps.setter
    def ipv6_vrrps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6VrrpArgs']]]]):
        pulumi.set(self, "ipv6_vrrps", value)

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Interface MTU <1500..9216> in bytes
          - Range: `1500`-`9216`
          - Default value: `1500`
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mtu", value)

    @_builtins.property
    @pulumi.getter(name="mtuVariable")
    def mtu_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "mtu_variable")

    @mtu_variable.setter
    def mtu_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mtu_variable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def policers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplatePolicerArgs']]]]:
        """
        Enable policer
        """
        return pulumi.get(self, "policers")

    @policers.setter
    def policers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplatePolicerArgs']]]]):
        pulumi.set(self, "policers", value)

    @_builtins.property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Administrative state
          - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "shutdown", value)

    @_builtins.property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shutdown_variable", value)

    @_builtins.property
    @pulumi.getter(name="staticArpEntries")
    def static_arp_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateStaticArpEntryArgs']]]]:
        """
        Configure static ARP entries
        """
        return pulumi.get(self, "static_arp_entries")

    @static_arp_entries.setter
    def static_arp_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateStaticArpEntryArgs']]]]):
        pulumi.set(self, "static_arp_entries", value)

    @_builtins.property
    @pulumi.getter(name="tcpMssAdjust")
    def tcp_mss_adjust(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        TCP MSS on SYN packets, in bytes
          - Range: `552`-`1960`
        """
        return pulumi.get(self, "tcp_mss_adjust")

    @tcp_mss_adjust.setter
    def tcp_mss_adjust(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_mss_adjust", value)

    @_builtins.property
    @pulumi.getter(name="tcpMssAdjustVariable")
    def tcp_mss_adjust_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_adjust_variable")

    @tcp_mss_adjust_variable.setter
    def tcp_mss_adjust_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tcp_mss_adjust_variable", value)


@pulumi.input_type
class _VpnInterfaceSviFeatureTemplateState:
    def __init__(__self__, *,
                 arp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 arp_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 if_name: Optional[pulumi.Input[_builtins.str]] = None,
                 if_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_description: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_directed_broadcast: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_directed_broadcast_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_access_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4AccessListArgs']]]] = None,
                 ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_dhcp_helper_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv4_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgs']]]] = None,
                 ipv4_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4VrrpArgs']]]] = None,
                 ipv6_access_lists: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6AccessListArgs']]]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_dhcp_client: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_dhcp_client_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_dhcp_distance: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_dhcp_distance_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgs']]]] = None,
                 ipv6_dhcp_rapid_commit: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_dhcp_rapid_commit_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgs']]]] = None,
                 ipv6_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6VrrpArgs']]]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policers: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplatePolicerArgs']]]] = None,
                 shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 static_arp_entries: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateStaticArpEntryArgs']]]] = None,
                 tcp_mss_adjust: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_mss_adjust_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 template_type: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering VpnInterfaceSviFeatureTemplate resources.
        :param pulumi.Input[_builtins.int] arp_timeout: Timeout value for dynamically learned ARP entries, <0..2678400> seconds
                 - Range: `0`-`2678400`
                 - Default value: `1200`
        :param pulumi.Input[_builtins.str] arp_timeout_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.str] if_name: Interface name: VLAN 1 - VLAN 4094 when present
        :param pulumi.Input[_builtins.str] if_name_variable: Variable name
        :param pulumi.Input[_builtins.str] interface_description: Interface description
        :param pulumi.Input[_builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[_builtins.bool] ip_directed_broadcast: IP Directed-Broadcast
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] ip_directed_broadcast_variable: Variable name
        :param pulumi.Input[_builtins.int] ip_mtu: IP MTU <576..Interface MTU>, in bytes
                 - Range: `576`-`9216`
                 - Default value: `1500`
        :param pulumi.Input[_builtins.str] ip_mtu_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4AccessListArgs']]] ipv4_access_lists: Apply ACL
        :param pulumi.Input[_builtins.str] ipv4_address: Assign IPv4 address
        :param pulumi.Input[_builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[_builtins.str] ipv4_dhcp_helper_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_dhcp_helpers: List of DHCP helper addresses
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgs']]] ipv4_secondary_addresses: Assign secondary IP addresses
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4VrrpArgs']]] ipv4_vrrps: Enable VRRP
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6AccessListArgs']]] ipv6_access_lists: Apply ACL
        :param pulumi.Input[_builtins.str] ipv6_address: Assign IPv6 address
        :param pulumi.Input[_builtins.str] ipv6_address_variable: Variable name
        :param pulumi.Input[_builtins.bool] ipv6_dhcp_client: Enable DHCPv6
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] ipv6_dhcp_client_variable: Variable name
        :param pulumi.Input[_builtins.int] ipv6_dhcp_distance: Set administrative distance for DHCP default route
                 - Range: `1`-`65536`
                 - Default value: `1`
        :param pulumi.Input[_builtins.str] ipv6_dhcp_distance_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgs']]] ipv6_dhcp_helpers: DHCPv6 Helper
        :param pulumi.Input[_builtins.bool] ipv6_dhcp_rapid_commit: Enable DHCPv6 rapid commit
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] ipv6_dhcp_rapid_commit_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgs']]] ipv6_secondary_addresses: Assign secondary IPv6 addresses
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6VrrpArgs']]] ipv6_vrrps: Enable VRRP
        :param pulumi.Input[_builtins.int] mtu: Interface MTU <1500..9216> in bytes
                 - Range: `1500`-`9216`
                 - Default value: `1500`
        :param pulumi.Input[_builtins.str] mtu_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplatePolicerArgs']]] policers: Enable policer
        :param pulumi.Input[_builtins.bool] shutdown: Administrative state
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateStaticArpEntryArgs']]] static_arp_entries: Configure static ARP entries
        :param pulumi.Input[_builtins.int] tcp_mss_adjust: TCP MSS on SYN packets, in bytes
                 - Range: `552`-`1960`
        :param pulumi.Input[_builtins.str] tcp_mss_adjust_variable: Variable name
        :param pulumi.Input[_builtins.str] template_type: The template type
        :param pulumi.Input[_builtins.int] version: The version of the feature template
        """
        if arp_timeout is not None:
            pulumi.set(__self__, "arp_timeout", arp_timeout)
        if arp_timeout_variable is not None:
            pulumi.set(__self__, "arp_timeout_variable", arp_timeout_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if if_name is not None:
            pulumi.set(__self__, "if_name", if_name)
        if if_name_variable is not None:
            pulumi.set(__self__, "if_name_variable", if_name_variable)
        if interface_description is not None:
            pulumi.set(__self__, "interface_description", interface_description)
        if interface_description_variable is not None:
            pulumi.set(__self__, "interface_description_variable", interface_description_variable)
        if ip_directed_broadcast is not None:
            pulumi.set(__self__, "ip_directed_broadcast", ip_directed_broadcast)
        if ip_directed_broadcast_variable is not None:
            pulumi.set(__self__, "ip_directed_broadcast_variable", ip_directed_broadcast_variable)
        if ip_mtu is not None:
            pulumi.set(__self__, "ip_mtu", ip_mtu)
        if ip_mtu_variable is not None:
            pulumi.set(__self__, "ip_mtu_variable", ip_mtu_variable)
        if ipv4_access_lists is not None:
            pulumi.set(__self__, "ipv4_access_lists", ipv4_access_lists)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_address_variable is not None:
            pulumi.set(__self__, "ipv4_address_variable", ipv4_address_variable)
        if ipv4_dhcp_helper_variable is not None:
            pulumi.set(__self__, "ipv4_dhcp_helper_variable", ipv4_dhcp_helper_variable)
        if ipv4_dhcp_helpers is not None:
            pulumi.set(__self__, "ipv4_dhcp_helpers", ipv4_dhcp_helpers)
        if ipv4_secondary_addresses is not None:
            pulumi.set(__self__, "ipv4_secondary_addresses", ipv4_secondary_addresses)
        if ipv4_vrrps is not None:
            pulumi.set(__self__, "ipv4_vrrps", ipv4_vrrps)
        if ipv6_access_lists is not None:
            pulumi.set(__self__, "ipv6_access_lists", ipv6_access_lists)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_address_variable is not None:
            pulumi.set(__self__, "ipv6_address_variable", ipv6_address_variable)
        if ipv6_dhcp_client is not None:
            pulumi.set(__self__, "ipv6_dhcp_client", ipv6_dhcp_client)
        if ipv6_dhcp_client_variable is not None:
            pulumi.set(__self__, "ipv6_dhcp_client_variable", ipv6_dhcp_client_variable)
        if ipv6_dhcp_distance is not None:
            pulumi.set(__self__, "ipv6_dhcp_distance", ipv6_dhcp_distance)
        if ipv6_dhcp_distance_variable is not None:
            pulumi.set(__self__, "ipv6_dhcp_distance_variable", ipv6_dhcp_distance_variable)
        if ipv6_dhcp_helpers is not None:
            pulumi.set(__self__, "ipv6_dhcp_helpers", ipv6_dhcp_helpers)
        if ipv6_dhcp_rapid_commit is not None:
            pulumi.set(__self__, "ipv6_dhcp_rapid_commit", ipv6_dhcp_rapid_commit)
        if ipv6_dhcp_rapid_commit_variable is not None:
            pulumi.set(__self__, "ipv6_dhcp_rapid_commit_variable", ipv6_dhcp_rapid_commit_variable)
        if ipv6_secondary_addresses is not None:
            pulumi.set(__self__, "ipv6_secondary_addresses", ipv6_secondary_addresses)
        if ipv6_vrrps is not None:
            pulumi.set(__self__, "ipv6_vrrps", ipv6_vrrps)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if mtu_variable is not None:
            pulumi.set(__self__, "mtu_variable", mtu_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policers is not None:
            pulumi.set(__self__, "policers", policers)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if static_arp_entries is not None:
            pulumi.set(__self__, "static_arp_entries", static_arp_entries)
        if tcp_mss_adjust is not None:
            pulumi.set(__self__, "tcp_mss_adjust", tcp_mss_adjust)
        if tcp_mss_adjust_variable is not None:
            pulumi.set(__self__, "tcp_mss_adjust_variable", tcp_mss_adjust_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="arpTimeout")
    def arp_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timeout value for dynamically learned ARP entries, <0..2678400> seconds
          - Range: `0`-`2678400`
          - Default value: `1200`
        """
        return pulumi.get(self, "arp_timeout")

    @arp_timeout.setter
    def arp_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "arp_timeout", value)

    @_builtins.property
    @pulumi.getter(name="arpTimeoutVariable")
    def arp_timeout_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "arp_timeout_variable")

    @arp_timeout_variable.setter
    def arp_timeout_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arp_timeout_variable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @_builtins.property
    @pulumi.getter(name="ifName")
    def if_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface name: VLAN 1 - VLAN 4094 when present
        """
        return pulumi.get(self, "if_name")

    @if_name.setter
    def if_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "if_name", value)

    @_builtins.property
    @pulumi.getter(name="ifNameVariable")
    def if_name_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "if_name_variable")

    @if_name_variable.setter
    def if_name_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "if_name_variable", value)

    @_builtins.property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @interface_description.setter
    def interface_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_description", value)

    @_builtins.property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @interface_description_variable.setter
    def interface_description_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interface_description_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipDirectedBroadcast")
    def ip_directed_broadcast(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        IP Directed-Broadcast
          - Default value: `false`
        """
        return pulumi.get(self, "ip_directed_broadcast")

    @ip_directed_broadcast.setter
    def ip_directed_broadcast(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_directed_broadcast", value)

    @_builtins.property
    @pulumi.getter(name="ipDirectedBroadcastVariable")
    def ip_directed_broadcast_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_directed_broadcast_variable")

    @ip_directed_broadcast_variable.setter
    def ip_directed_broadcast_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_directed_broadcast_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        IP MTU <576..Interface MTU>, in bytes
          - Range: `576`-`9216`
          - Default value: `1500`
        """
        return pulumi.get(self, "ip_mtu")

    @ip_mtu.setter
    def ip_mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_mtu", value)

    @_builtins.property
    @pulumi.getter(name="ipMtuVariable")
    def ip_mtu_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_mtu_variable")

    @ip_mtu_variable.setter
    def ip_mtu_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_mtu_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv4AccessLists")
    def ipv4_access_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4AccessListArgs']]]]:
        """
        Apply ACL
        """
        return pulumi.get(self, "ipv4_access_lists")

    @ipv4_access_lists.setter
    def ipv4_access_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4AccessListArgs']]]]):
        pulumi.set(self, "ipv4_access_lists", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assign IPv4 address
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="ipv4AddressVariable")
    def ipv4_address_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_address_variable")

    @ipv4_address_variable.setter
    def ipv4_address_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_address_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv4DhcpHelperVariable")
    def ipv4_dhcp_helper_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_dhcp_helper_variable")

    @ipv4_dhcp_helper_variable.setter
    def ipv4_dhcp_helper_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv4_dhcp_helper_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv4DhcpHelpers")
    def ipv4_dhcp_helpers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of DHCP helper addresses
        """
        return pulumi.get(self, "ipv4_dhcp_helpers")

    @ipv4_dhcp_helpers.setter
    def ipv4_dhcp_helpers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv4_dhcp_helpers", value)

    @_builtins.property
    @pulumi.getter(name="ipv4SecondaryAddresses")
    def ipv4_secondary_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgs']]]]:
        """
        Assign secondary IP addresses
        """
        return pulumi.get(self, "ipv4_secondary_addresses")

    @ipv4_secondary_addresses.setter
    def ipv4_secondary_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgs']]]]):
        pulumi.set(self, "ipv4_secondary_addresses", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Vrrps")
    def ipv4_vrrps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4VrrpArgs']]]]:
        """
        Enable VRRP
        """
        return pulumi.get(self, "ipv4_vrrps")

    @ipv4_vrrps.setter
    def ipv4_vrrps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv4VrrpArgs']]]]):
        pulumi.set(self, "ipv4_vrrps", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AccessLists")
    def ipv6_access_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6AccessListArgs']]]]:
        """
        Apply ACL
        """
        return pulumi.get(self, "ipv6_access_lists")

    @ipv6_access_lists.setter
    def ipv6_access_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6AccessListArgs']]]]):
        pulumi.set(self, "ipv6_access_lists", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Assign IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressVariable")
    def ipv6_address_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_address_variable")

    @ipv6_address_variable.setter
    def ipv6_address_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpClient")
    def ipv6_dhcp_client(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable DHCPv6
          - Default value: `false`
        """
        return pulumi.get(self, "ipv6_dhcp_client")

    @ipv6_dhcp_client.setter
    def ipv6_dhcp_client(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_dhcp_client", value)

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpClientVariable")
    def ipv6_dhcp_client_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_dhcp_client_variable")

    @ipv6_dhcp_client_variable.setter
    def ipv6_dhcp_client_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_dhcp_client_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpDistance")
    def ipv6_dhcp_distance(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Set administrative distance for DHCP default route
          - Range: `1`-`65536`
          - Default value: `1`
        """
        return pulumi.get(self, "ipv6_dhcp_distance")

    @ipv6_dhcp_distance.setter
    def ipv6_dhcp_distance(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ipv6_dhcp_distance", value)

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpDistanceVariable")
    def ipv6_dhcp_distance_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_dhcp_distance_variable")

    @ipv6_dhcp_distance_variable.setter
    def ipv6_dhcp_distance_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_dhcp_distance_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpHelpers")
    def ipv6_dhcp_helpers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgs']]]]:
        """
        DHCPv6 Helper
        """
        return pulumi.get(self, "ipv6_dhcp_helpers")

    @ipv6_dhcp_helpers.setter
    def ipv6_dhcp_helpers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgs']]]]):
        pulumi.set(self, "ipv6_dhcp_helpers", value)

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpRapidCommit")
    def ipv6_dhcp_rapid_commit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable DHCPv6 rapid commit
          - Default value: `false`
        """
        return pulumi.get(self, "ipv6_dhcp_rapid_commit")

    @ipv6_dhcp_rapid_commit.setter
    def ipv6_dhcp_rapid_commit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_dhcp_rapid_commit", value)

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpRapidCommitVariable")
    def ipv6_dhcp_rapid_commit_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_dhcp_rapid_commit_variable")

    @ipv6_dhcp_rapid_commit_variable.setter
    def ipv6_dhcp_rapid_commit_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_dhcp_rapid_commit_variable", value)

    @_builtins.property
    @pulumi.getter(name="ipv6SecondaryAddresses")
    def ipv6_secondary_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgs']]]]:
        """
        Assign secondary IPv6 addresses
        """
        return pulumi.get(self, "ipv6_secondary_addresses")

    @ipv6_secondary_addresses.setter
    def ipv6_secondary_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgs']]]]):
        pulumi.set(self, "ipv6_secondary_addresses", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Vrrps")
    def ipv6_vrrps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6VrrpArgs']]]]:
        """
        Enable VRRP
        """
        return pulumi.get(self, "ipv6_vrrps")

    @ipv6_vrrps.setter
    def ipv6_vrrps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateIpv6VrrpArgs']]]]):
        pulumi.set(self, "ipv6_vrrps", value)

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Interface MTU <1500..9216> in bytes
          - Range: `1500`-`9216`
          - Default value: `1500`
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "mtu", value)

    @_builtins.property
    @pulumi.getter(name="mtuVariable")
    def mtu_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "mtu_variable")

    @mtu_variable.setter
    def mtu_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mtu_variable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def policers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplatePolicerArgs']]]]:
        """
        Enable policer
        """
        return pulumi.get(self, "policers")

    @policers.setter
    def policers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplatePolicerArgs']]]]):
        pulumi.set(self, "policers", value)

    @_builtins.property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Administrative state
          - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "shutdown", value)

    @_builtins.property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shutdown_variable", value)

    @_builtins.property
    @pulumi.getter(name="staticArpEntries")
    def static_arp_entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateStaticArpEntryArgs']]]]:
        """
        Configure static ARP entries
        """
        return pulumi.get(self, "static_arp_entries")

    @static_arp_entries.setter
    def static_arp_entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VpnInterfaceSviFeatureTemplateStaticArpEntryArgs']]]]):
        pulumi.set(self, "static_arp_entries", value)

    @_builtins.property
    @pulumi.getter(name="tcpMssAdjust")
    def tcp_mss_adjust(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        TCP MSS on SYN packets, in bytes
          - Range: `552`-`1960`
        """
        return pulumi.get(self, "tcp_mss_adjust")

    @tcp_mss_adjust.setter
    def tcp_mss_adjust(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_mss_adjust", value)

    @_builtins.property
    @pulumi.getter(name="tcpMssAdjustVariable")
    def tcp_mss_adjust_variable(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_adjust_variable")

    @tcp_mss_adjust_variable.setter
    def tcp_mss_adjust_variable(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tcp_mss_adjust_variable", value)

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "template_type", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/vpnInterfaceSviFeatureTemplate:VpnInterfaceSviFeatureTemplate")
class VpnInterfaceSviFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 arp_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 if_name: Optional[pulumi.Input[_builtins.str]] = None,
                 if_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_description: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_directed_broadcast: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_directed_broadcast_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_access_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4AccessListArgs', 'VpnInterfaceSviFeatureTemplateIpv4AccessListArgsDict']]]]] = None,
                 ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_dhcp_helper_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv4_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgs', 'VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgsDict']]]]] = None,
                 ipv4_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4VrrpArgs', 'VpnInterfaceSviFeatureTemplateIpv4VrrpArgsDict']]]]] = None,
                 ipv6_access_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6AccessListArgs', 'VpnInterfaceSviFeatureTemplateIpv6AccessListArgsDict']]]]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_dhcp_client: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_dhcp_client_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_dhcp_distance: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_dhcp_distance_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgs', 'VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgsDict']]]]] = None,
                 ipv6_dhcp_rapid_commit: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_dhcp_rapid_commit_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgs', 'VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgsDict']]]]] = None,
                 ipv6_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6VrrpArgs', 'VpnInterfaceSviFeatureTemplateIpv6VrrpArgsDict']]]]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplatePolicerArgs', 'VpnInterfaceSviFeatureTemplatePolicerArgsDict']]]]] = None,
                 shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 static_arp_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateStaticArpEntryArgs', 'VpnInterfaceSviFeatureTemplateStaticArpEntryArgsDict']]]]] = None,
                 tcp_mss_adjust: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_mss_adjust_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a VPN Interface SVI feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/vpnInterfaceSviFeatureTemplate:VpnInterfaceSviFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] arp_timeout: Timeout value for dynamically learned ARP entries, <0..2678400> seconds
                 - Range: `0`-`2678400`
                 - Default value: `1200`
        :param pulumi.Input[_builtins.str] arp_timeout_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.str] if_name: Interface name: VLAN 1 - VLAN 4094 when present
        :param pulumi.Input[_builtins.str] if_name_variable: Variable name
        :param pulumi.Input[_builtins.str] interface_description: Interface description
        :param pulumi.Input[_builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[_builtins.bool] ip_directed_broadcast: IP Directed-Broadcast
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] ip_directed_broadcast_variable: Variable name
        :param pulumi.Input[_builtins.int] ip_mtu: IP MTU <576..Interface MTU>, in bytes
                 - Range: `576`-`9216`
                 - Default value: `1500`
        :param pulumi.Input[_builtins.str] ip_mtu_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4AccessListArgs', 'VpnInterfaceSviFeatureTemplateIpv4AccessListArgsDict']]]] ipv4_access_lists: Apply ACL
        :param pulumi.Input[_builtins.str] ipv4_address: Assign IPv4 address
        :param pulumi.Input[_builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[_builtins.str] ipv4_dhcp_helper_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_dhcp_helpers: List of DHCP helper addresses
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgs', 'VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgsDict']]]] ipv4_secondary_addresses: Assign secondary IP addresses
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4VrrpArgs', 'VpnInterfaceSviFeatureTemplateIpv4VrrpArgsDict']]]] ipv4_vrrps: Enable VRRP
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6AccessListArgs', 'VpnInterfaceSviFeatureTemplateIpv6AccessListArgsDict']]]] ipv6_access_lists: Apply ACL
        :param pulumi.Input[_builtins.str] ipv6_address: Assign IPv6 address
        :param pulumi.Input[_builtins.str] ipv6_address_variable: Variable name
        :param pulumi.Input[_builtins.bool] ipv6_dhcp_client: Enable DHCPv6
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] ipv6_dhcp_client_variable: Variable name
        :param pulumi.Input[_builtins.int] ipv6_dhcp_distance: Set administrative distance for DHCP default route
                 - Range: `1`-`65536`
                 - Default value: `1`
        :param pulumi.Input[_builtins.str] ipv6_dhcp_distance_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgs', 'VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgsDict']]]] ipv6_dhcp_helpers: DHCPv6 Helper
        :param pulumi.Input[_builtins.bool] ipv6_dhcp_rapid_commit: Enable DHCPv6 rapid commit
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] ipv6_dhcp_rapid_commit_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgs', 'VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgsDict']]]] ipv6_secondary_addresses: Assign secondary IPv6 addresses
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6VrrpArgs', 'VpnInterfaceSviFeatureTemplateIpv6VrrpArgsDict']]]] ipv6_vrrps: Enable VRRP
        :param pulumi.Input[_builtins.int] mtu: Interface MTU <1500..9216> in bytes
                 - Range: `1500`-`9216`
                 - Default value: `1500`
        :param pulumi.Input[_builtins.str] mtu_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplatePolicerArgs', 'VpnInterfaceSviFeatureTemplatePolicerArgsDict']]]] policers: Enable policer
        :param pulumi.Input[_builtins.bool] shutdown: Administrative state
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateStaticArpEntryArgs', 'VpnInterfaceSviFeatureTemplateStaticArpEntryArgsDict']]]] static_arp_entries: Configure static ARP entries
        :param pulumi.Input[_builtins.int] tcp_mss_adjust: TCP MSS on SYN packets, in bytes
                 - Range: `552`-`1960`
        :param pulumi.Input[_builtins.str] tcp_mss_adjust_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpnInterfaceSviFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a VPN Interface SVI feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/vpnInterfaceSviFeatureTemplate:VpnInterfaceSviFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param VpnInterfaceSviFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpnInterfaceSviFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 arp_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 if_name: Optional[pulumi.Input[_builtins.str]] = None,
                 if_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_description: Optional[pulumi.Input[_builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_directed_broadcast: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_directed_broadcast_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_access_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4AccessListArgs', 'VpnInterfaceSviFeatureTemplateIpv4AccessListArgsDict']]]]] = None,
                 ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_dhcp_helper_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv4_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgs', 'VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgsDict']]]]] = None,
                 ipv4_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4VrrpArgs', 'VpnInterfaceSviFeatureTemplateIpv4VrrpArgsDict']]]]] = None,
                 ipv6_access_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6AccessListArgs', 'VpnInterfaceSviFeatureTemplateIpv6AccessListArgsDict']]]]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_dhcp_client: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_dhcp_client_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_dhcp_distance: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_dhcp_distance_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgs', 'VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgsDict']]]]] = None,
                 ipv6_dhcp_rapid_commit: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6_dhcp_rapid_commit_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgs', 'VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgsDict']]]]] = None,
                 ipv6_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6VrrpArgs', 'VpnInterfaceSviFeatureTemplateIpv6VrrpArgsDict']]]]] = None,
                 mtu: Optional[pulumi.Input[_builtins.int]] = None,
                 mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplatePolicerArgs', 'VpnInterfaceSviFeatureTemplatePolicerArgsDict']]]]] = None,
                 shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 static_arp_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateStaticArpEntryArgs', 'VpnInterfaceSviFeatureTemplateStaticArpEntryArgsDict']]]]] = None,
                 tcp_mss_adjust: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_mss_adjust_variable: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpnInterfaceSviFeatureTemplateArgs.__new__(VpnInterfaceSviFeatureTemplateArgs)

            __props__.__dict__["arp_timeout"] = arp_timeout
            __props__.__dict__["arp_timeout_variable"] = arp_timeout_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["if_name"] = if_name
            __props__.__dict__["if_name_variable"] = if_name_variable
            __props__.__dict__["interface_description"] = interface_description
            __props__.__dict__["interface_description_variable"] = interface_description_variable
            __props__.__dict__["ip_directed_broadcast"] = ip_directed_broadcast
            __props__.__dict__["ip_directed_broadcast_variable"] = ip_directed_broadcast_variable
            __props__.__dict__["ip_mtu"] = ip_mtu
            __props__.__dict__["ip_mtu_variable"] = ip_mtu_variable
            __props__.__dict__["ipv4_access_lists"] = ipv4_access_lists
            __props__.__dict__["ipv4_address"] = ipv4_address
            __props__.__dict__["ipv4_address_variable"] = ipv4_address_variable
            __props__.__dict__["ipv4_dhcp_helper_variable"] = ipv4_dhcp_helper_variable
            __props__.__dict__["ipv4_dhcp_helpers"] = ipv4_dhcp_helpers
            __props__.__dict__["ipv4_secondary_addresses"] = ipv4_secondary_addresses
            __props__.__dict__["ipv4_vrrps"] = ipv4_vrrps
            __props__.__dict__["ipv6_access_lists"] = ipv6_access_lists
            __props__.__dict__["ipv6_address"] = ipv6_address
            __props__.__dict__["ipv6_address_variable"] = ipv6_address_variable
            __props__.__dict__["ipv6_dhcp_client"] = ipv6_dhcp_client
            __props__.__dict__["ipv6_dhcp_client_variable"] = ipv6_dhcp_client_variable
            __props__.__dict__["ipv6_dhcp_distance"] = ipv6_dhcp_distance
            __props__.__dict__["ipv6_dhcp_distance_variable"] = ipv6_dhcp_distance_variable
            __props__.__dict__["ipv6_dhcp_helpers"] = ipv6_dhcp_helpers
            __props__.__dict__["ipv6_dhcp_rapid_commit"] = ipv6_dhcp_rapid_commit
            __props__.__dict__["ipv6_dhcp_rapid_commit_variable"] = ipv6_dhcp_rapid_commit_variable
            __props__.__dict__["ipv6_secondary_addresses"] = ipv6_secondary_addresses
            __props__.__dict__["ipv6_vrrps"] = ipv6_vrrps
            __props__.__dict__["mtu"] = mtu
            __props__.__dict__["mtu_variable"] = mtu_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["policers"] = policers
            __props__.__dict__["shutdown"] = shutdown
            __props__.__dict__["shutdown_variable"] = shutdown_variable
            __props__.__dict__["static_arp_entries"] = static_arp_entries
            __props__.__dict__["tcp_mss_adjust"] = tcp_mss_adjust
            __props__.__dict__["tcp_mss_adjust_variable"] = tcp_mss_adjust_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(VpnInterfaceSviFeatureTemplate, __self__).__init__(
            'sdwan:index/vpnInterfaceSviFeatureTemplate:VpnInterfaceSviFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arp_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            arp_timeout_variable: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            if_name: Optional[pulumi.Input[_builtins.str]] = None,
            if_name_variable: Optional[pulumi.Input[_builtins.str]] = None,
            interface_description: Optional[pulumi.Input[_builtins.str]] = None,
            interface_description_variable: Optional[pulumi.Input[_builtins.str]] = None,
            ip_directed_broadcast: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_directed_broadcast_variable: Optional[pulumi.Input[_builtins.str]] = None,
            ip_mtu: Optional[pulumi.Input[_builtins.int]] = None,
            ip_mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_access_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4AccessListArgs', 'VpnInterfaceSviFeatureTemplateIpv4AccessListArgsDict']]]]] = None,
            ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_dhcp_helper_variable: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ipv4_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgs', 'VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgsDict']]]]] = None,
            ipv4_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4VrrpArgs', 'VpnInterfaceSviFeatureTemplateIpv4VrrpArgsDict']]]]] = None,
            ipv6_access_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6AccessListArgs', 'VpnInterfaceSviFeatureTemplateIpv6AccessListArgsDict']]]]] = None,
            ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_address_variable: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_dhcp_client: Optional[pulumi.Input[_builtins.bool]] = None,
            ipv6_dhcp_client_variable: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_dhcp_distance: Optional[pulumi.Input[_builtins.int]] = None,
            ipv6_dhcp_distance_variable: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgs', 'VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgsDict']]]]] = None,
            ipv6_dhcp_rapid_commit: Optional[pulumi.Input[_builtins.bool]] = None,
            ipv6_dhcp_rapid_commit_variable: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgs', 'VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgsDict']]]]] = None,
            ipv6_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6VrrpArgs', 'VpnInterfaceSviFeatureTemplateIpv6VrrpArgsDict']]]]] = None,
            mtu: Optional[pulumi.Input[_builtins.int]] = None,
            mtu_variable: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplatePolicerArgs', 'VpnInterfaceSviFeatureTemplatePolicerArgsDict']]]]] = None,
            shutdown: Optional[pulumi.Input[_builtins.bool]] = None,
            shutdown_variable: Optional[pulumi.Input[_builtins.str]] = None,
            static_arp_entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateStaticArpEntryArgs', 'VpnInterfaceSviFeatureTemplateStaticArpEntryArgsDict']]]]] = None,
            tcp_mss_adjust: Optional[pulumi.Input[_builtins.int]] = None,
            tcp_mss_adjust_variable: Optional[pulumi.Input[_builtins.str]] = None,
            template_type: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'VpnInterfaceSviFeatureTemplate':
        """
        Get an existing VpnInterfaceSviFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] arp_timeout: Timeout value for dynamically learned ARP entries, <0..2678400> seconds
                 - Range: `0`-`2678400`
                 - Default value: `1200`
        :param pulumi.Input[_builtins.str] arp_timeout_variable: Variable name
        :param pulumi.Input[_builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] device_types: List of supported device types
                 - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[_builtins.str] if_name: Interface name: VLAN 1 - VLAN 4094 when present
        :param pulumi.Input[_builtins.str] if_name_variable: Variable name
        :param pulumi.Input[_builtins.str] interface_description: Interface description
        :param pulumi.Input[_builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[_builtins.bool] ip_directed_broadcast: IP Directed-Broadcast
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] ip_directed_broadcast_variable: Variable name
        :param pulumi.Input[_builtins.int] ip_mtu: IP MTU <576..Interface MTU>, in bytes
                 - Range: `576`-`9216`
                 - Default value: `1500`
        :param pulumi.Input[_builtins.str] ip_mtu_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4AccessListArgs', 'VpnInterfaceSviFeatureTemplateIpv4AccessListArgsDict']]]] ipv4_access_lists: Apply ACL
        :param pulumi.Input[_builtins.str] ipv4_address: Assign IPv4 address
        :param pulumi.Input[_builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[_builtins.str] ipv4_dhcp_helper_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ipv4_dhcp_helpers: List of DHCP helper addresses
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgs', 'VpnInterfaceSviFeatureTemplateIpv4SecondaryAddressArgsDict']]]] ipv4_secondary_addresses: Assign secondary IP addresses
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv4VrrpArgs', 'VpnInterfaceSviFeatureTemplateIpv4VrrpArgsDict']]]] ipv4_vrrps: Enable VRRP
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6AccessListArgs', 'VpnInterfaceSviFeatureTemplateIpv6AccessListArgsDict']]]] ipv6_access_lists: Apply ACL
        :param pulumi.Input[_builtins.str] ipv6_address: Assign IPv6 address
        :param pulumi.Input[_builtins.str] ipv6_address_variable: Variable name
        :param pulumi.Input[_builtins.bool] ipv6_dhcp_client: Enable DHCPv6
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] ipv6_dhcp_client_variable: Variable name
        :param pulumi.Input[_builtins.int] ipv6_dhcp_distance: Set administrative distance for DHCP default route
                 - Range: `1`-`65536`
                 - Default value: `1`
        :param pulumi.Input[_builtins.str] ipv6_dhcp_distance_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgs', 'VpnInterfaceSviFeatureTemplateIpv6DhcpHelperArgsDict']]]] ipv6_dhcp_helpers: DHCPv6 Helper
        :param pulumi.Input[_builtins.bool] ipv6_dhcp_rapid_commit: Enable DHCPv6 rapid commit
                 - Default value: `false`
        :param pulumi.Input[_builtins.str] ipv6_dhcp_rapid_commit_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgs', 'VpnInterfaceSviFeatureTemplateIpv6SecondaryAddressArgsDict']]]] ipv6_secondary_addresses: Assign secondary IPv6 addresses
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateIpv6VrrpArgs', 'VpnInterfaceSviFeatureTemplateIpv6VrrpArgsDict']]]] ipv6_vrrps: Enable VRRP
        :param pulumi.Input[_builtins.int] mtu: Interface MTU <1500..9216> in bytes
                 - Range: `1500`-`9216`
                 - Default value: `1500`
        :param pulumi.Input[_builtins.str] mtu_variable: Variable name
        :param pulumi.Input[_builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplatePolicerArgs', 'VpnInterfaceSviFeatureTemplatePolicerArgsDict']]]] policers: Enable policer
        :param pulumi.Input[_builtins.bool] shutdown: Administrative state
                 - Default value: `true`
        :param pulumi.Input[_builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['VpnInterfaceSviFeatureTemplateStaticArpEntryArgs', 'VpnInterfaceSviFeatureTemplateStaticArpEntryArgsDict']]]] static_arp_entries: Configure static ARP entries
        :param pulumi.Input[_builtins.int] tcp_mss_adjust: TCP MSS on SYN packets, in bytes
                 - Range: `552`-`1960`
        :param pulumi.Input[_builtins.str] tcp_mss_adjust_variable: Variable name
        :param pulumi.Input[_builtins.str] template_type: The template type
        :param pulumi.Input[_builtins.int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpnInterfaceSviFeatureTemplateState.__new__(_VpnInterfaceSviFeatureTemplateState)

        __props__.__dict__["arp_timeout"] = arp_timeout
        __props__.__dict__["arp_timeout_variable"] = arp_timeout_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["if_name"] = if_name
        __props__.__dict__["if_name_variable"] = if_name_variable
        __props__.__dict__["interface_description"] = interface_description
        __props__.__dict__["interface_description_variable"] = interface_description_variable
        __props__.__dict__["ip_directed_broadcast"] = ip_directed_broadcast
        __props__.__dict__["ip_directed_broadcast_variable"] = ip_directed_broadcast_variable
        __props__.__dict__["ip_mtu"] = ip_mtu
        __props__.__dict__["ip_mtu_variable"] = ip_mtu_variable
        __props__.__dict__["ipv4_access_lists"] = ipv4_access_lists
        __props__.__dict__["ipv4_address"] = ipv4_address
        __props__.__dict__["ipv4_address_variable"] = ipv4_address_variable
        __props__.__dict__["ipv4_dhcp_helper_variable"] = ipv4_dhcp_helper_variable
        __props__.__dict__["ipv4_dhcp_helpers"] = ipv4_dhcp_helpers
        __props__.__dict__["ipv4_secondary_addresses"] = ipv4_secondary_addresses
        __props__.__dict__["ipv4_vrrps"] = ipv4_vrrps
        __props__.__dict__["ipv6_access_lists"] = ipv6_access_lists
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["ipv6_address_variable"] = ipv6_address_variable
        __props__.__dict__["ipv6_dhcp_client"] = ipv6_dhcp_client
        __props__.__dict__["ipv6_dhcp_client_variable"] = ipv6_dhcp_client_variable
        __props__.__dict__["ipv6_dhcp_distance"] = ipv6_dhcp_distance
        __props__.__dict__["ipv6_dhcp_distance_variable"] = ipv6_dhcp_distance_variable
        __props__.__dict__["ipv6_dhcp_helpers"] = ipv6_dhcp_helpers
        __props__.__dict__["ipv6_dhcp_rapid_commit"] = ipv6_dhcp_rapid_commit
        __props__.__dict__["ipv6_dhcp_rapid_commit_variable"] = ipv6_dhcp_rapid_commit_variable
        __props__.__dict__["ipv6_secondary_addresses"] = ipv6_secondary_addresses
        __props__.__dict__["ipv6_vrrps"] = ipv6_vrrps
        __props__.__dict__["mtu"] = mtu
        __props__.__dict__["mtu_variable"] = mtu_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["policers"] = policers
        __props__.__dict__["shutdown"] = shutdown
        __props__.__dict__["shutdown_variable"] = shutdown_variable
        __props__.__dict__["static_arp_entries"] = static_arp_entries
        __props__.__dict__["tcp_mss_adjust"] = tcp_mss_adjust
        __props__.__dict__["tcp_mss_adjust_variable"] = tcp_mss_adjust_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        return VpnInterfaceSviFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="arpTimeout")
    def arp_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Timeout value for dynamically learned ARP entries, <0..2678400> seconds
          - Range: `0`-`2678400`
          - Default value: `1200`
        """
        return pulumi.get(self, "arp_timeout")

    @_builtins.property
    @pulumi.getter(name="arpTimeoutVariable")
    def arp_timeout_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "arp_timeout_variable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of supported device types
          - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`, `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`, `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @_builtins.property
    @pulumi.getter(name="ifName")
    def if_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Interface name: VLAN 1 - VLAN 4094 when present
        """
        return pulumi.get(self, "if_name")

    @_builtins.property
    @pulumi.getter(name="ifNameVariable")
    def if_name_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "if_name_variable")

    @_builtins.property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @_builtins.property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @_builtins.property
    @pulumi.getter(name="ipDirectedBroadcast")
    def ip_directed_broadcast(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        IP Directed-Broadcast
          - Default value: `false`
        """
        return pulumi.get(self, "ip_directed_broadcast")

    @_builtins.property
    @pulumi.getter(name="ipDirectedBroadcastVariable")
    def ip_directed_broadcast_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_directed_broadcast_variable")

    @_builtins.property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        IP MTU <576..Interface MTU>, in bytes
          - Range: `576`-`9216`
          - Default value: `1500`
        """
        return pulumi.get(self, "ip_mtu")

    @_builtins.property
    @pulumi.getter(name="ipMtuVariable")
    def ip_mtu_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_mtu_variable")

    @_builtins.property
    @pulumi.getter(name="ipv4AccessLists")
    def ipv4_access_lists(self) -> pulumi.Output[Optional[Sequence['outputs.VpnInterfaceSviFeatureTemplateIpv4AccessList']]]:
        """
        Apply ACL
        """
        return pulumi.get(self, "ipv4_access_lists")

    @_builtins.property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Assign IPv4 address
        """
        return pulumi.get(self, "ipv4_address")

    @_builtins.property
    @pulumi.getter(name="ipv4AddressVariable")
    def ipv4_address_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_address_variable")

    @_builtins.property
    @pulumi.getter(name="ipv4DhcpHelperVariable")
    def ipv4_dhcp_helper_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_dhcp_helper_variable")

    @_builtins.property
    @pulumi.getter(name="ipv4DhcpHelpers")
    def ipv4_dhcp_helpers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of DHCP helper addresses
        """
        return pulumi.get(self, "ipv4_dhcp_helpers")

    @_builtins.property
    @pulumi.getter(name="ipv4SecondaryAddresses")
    def ipv4_secondary_addresses(self) -> pulumi.Output[Optional[Sequence['outputs.VpnInterfaceSviFeatureTemplateIpv4SecondaryAddress']]]:
        """
        Assign secondary IP addresses
        """
        return pulumi.get(self, "ipv4_secondary_addresses")

    @_builtins.property
    @pulumi.getter(name="ipv4Vrrps")
    def ipv4_vrrps(self) -> pulumi.Output[Optional[Sequence['outputs.VpnInterfaceSviFeatureTemplateIpv4Vrrp']]]:
        """
        Enable VRRP
        """
        return pulumi.get(self, "ipv4_vrrps")

    @_builtins.property
    @pulumi.getter(name="ipv6AccessLists")
    def ipv6_access_lists(self) -> pulumi.Output[Optional[Sequence['outputs.VpnInterfaceSviFeatureTemplateIpv6AccessList']]]:
        """
        Apply ACL
        """
        return pulumi.get(self, "ipv6_access_lists")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Assign IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressVariable")
    def ipv6_address_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_address_variable")

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpClient")
    def ipv6_dhcp_client(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable DHCPv6
          - Default value: `false`
        """
        return pulumi.get(self, "ipv6_dhcp_client")

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpClientVariable")
    def ipv6_dhcp_client_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_dhcp_client_variable")

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpDistance")
    def ipv6_dhcp_distance(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Set administrative distance for DHCP default route
          - Range: `1`-`65536`
          - Default value: `1`
        """
        return pulumi.get(self, "ipv6_dhcp_distance")

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpDistanceVariable")
    def ipv6_dhcp_distance_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_dhcp_distance_variable")

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpHelpers")
    def ipv6_dhcp_helpers(self) -> pulumi.Output[Optional[Sequence['outputs.VpnInterfaceSviFeatureTemplateIpv6DhcpHelper']]]:
        """
        DHCPv6 Helper
        """
        return pulumi.get(self, "ipv6_dhcp_helpers")

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpRapidCommit")
    def ipv6_dhcp_rapid_commit(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable DHCPv6 rapid commit
          - Default value: `false`
        """
        return pulumi.get(self, "ipv6_dhcp_rapid_commit")

    @_builtins.property
    @pulumi.getter(name="ipv6DhcpRapidCommitVariable")
    def ipv6_dhcp_rapid_commit_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_dhcp_rapid_commit_variable")

    @_builtins.property
    @pulumi.getter(name="ipv6SecondaryAddresses")
    def ipv6_secondary_addresses(self) -> pulumi.Output[Optional[Sequence['outputs.VpnInterfaceSviFeatureTemplateIpv6SecondaryAddress']]]:
        """
        Assign secondary IPv6 addresses
        """
        return pulumi.get(self, "ipv6_secondary_addresses")

    @_builtins.property
    @pulumi.getter(name="ipv6Vrrps")
    def ipv6_vrrps(self) -> pulumi.Output[Optional[Sequence['outputs.VpnInterfaceSviFeatureTemplateIpv6Vrrp']]]:
        """
        Enable VRRP
        """
        return pulumi.get(self, "ipv6_vrrps")

    @_builtins.property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Interface MTU <1500..9216> in bytes
          - Range: `1500`-`9216`
          - Default value: `1500`
        """
        return pulumi.get(self, "mtu")

    @_builtins.property
    @pulumi.getter(name="mtuVariable")
    def mtu_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "mtu_variable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policers(self) -> pulumi.Output[Optional[Sequence['outputs.VpnInterfaceSviFeatureTemplatePolicer']]]:
        """
        Enable policer
        """
        return pulumi.get(self, "policers")

    @_builtins.property
    @pulumi.getter
    def shutdown(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Administrative state
          - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @_builtins.property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @_builtins.property
    @pulumi.getter(name="staticArpEntries")
    def static_arp_entries(self) -> pulumi.Output[Optional[Sequence['outputs.VpnInterfaceSviFeatureTemplateStaticArpEntry']]]:
        """
        Configure static ARP entries
        """
        return pulumi.get(self, "static_arp_entries")

    @_builtins.property
    @pulumi.getter(name="tcpMssAdjust")
    def tcp_mss_adjust(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        TCP MSS on SYN packets, in bytes
          - Range: `552`-`1960`
        """
        return pulumi.get(self, "tcp_mss_adjust")

    @_builtins.property
    @pulumi.getter(name="tcpMssAdjustVariable")
    def tcp_mss_adjust_variable(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_adjust_variable")

    @_builtins.property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[_builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

