"""Implementations of 'EnumWithSelectedValue' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""
from __future__ import annotations

from enum import Enum
from typing import TYPE_CHECKING

from mastapy._private.bearings import _1923
from mastapy._private._internal import mixins
from mastapy._private._internal.python_net import python_net_import

_ARRAY = python_net_import("System", "Array")
_ENUM_WITH_SELECTED_VALUE = python_net_import(
    "SMT.MastaAPI.Utility.Property", "EnumWithSelectedValue"
)

if TYPE_CHECKING:
    from typing import List, Type, Any, TypeVar

    Self = TypeVar(
        "Self", bound="EnumWithSelectedValue_BasicDynamicLoadRatingCalculationMethod"
    )


__docformat__ = "restructuredtext en"
__all__ = ("EnumWithSelectedValue_BasicDynamicLoadRatingCalculationMethod",)


class EnumWithSelectedValue_BasicDynamicLoadRatingCalculationMethod(
    mixins.EnumWithSelectedValueMixin, Enum
):
    """EnumWithSelectedValue_BasicDynamicLoadRatingCalculationMethod

    A specific implementation of 'EnumWithSelectedValue' for 'BasicDynamicLoadRatingCalculationMethod' types.
    """

    __qualname__ = "BasicDynamicLoadRatingCalculationMethod"

    @classmethod
    def wrapper_type(
        cls: "Type[EnumWithSelectedValue_BasicDynamicLoadRatingCalculationMethod]",
    ) -> "Any":
        """Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _ENUM_WITH_SELECTED_VALUE

    @classmethod
    def wrapped_type(
        cls: "Type[EnumWithSelectedValue_BasicDynamicLoadRatingCalculationMethod]",
    ) -> "_1923.BasicDynamicLoadRatingCalculationMethod":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly

        Returns:
            _1923.BasicDynamicLoadRatingCalculationMethod
        """
        return _1923.BasicDynamicLoadRatingCalculationMethod

    @classmethod
    def implicit_type(
        cls: "Type[EnumWithSelectedValue_BasicDynamicLoadRatingCalculationMethod]",
    ) -> "Any":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _1923.BasicDynamicLoadRatingCalculationMethod.type_()

    @property
    def selected_value(self: "Self") -> "_1923.BasicDynamicLoadRatingCalculationMethod":
        """mastapy._private.bearings.BasicDynamicLoadRatingCalculationMethod

        Note:
            This property is readonly.
        """
        return None

    @property
    def available_values(
        self: "Self",
    ) -> "List[_1923.BasicDynamicLoadRatingCalculationMethod]":
        """List[mastapy._private.bearings.BasicDynamicLoadRatingCalculationMethod]

        Note:
            This property is readonly.
        """
        return None
