"""Implementations of 'EnumWithSelectedValue' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""
from __future__ import annotations

from enum import Enum
from typing import TYPE_CHECKING

from mastapy._private.bearings import _1944
from mastapy._private._internal import mixins
from mastapy._private._internal.python_net import python_net_import

_ARRAY = python_net_import("System", "Array")
_ENUM_WITH_SELECTED_VALUE = python_net_import(
    "SMT.MastaAPI.Utility.Property", "EnumWithSelectedValue"
)

if TYPE_CHECKING:
    from typing import List, Type, Any, TypeVar

    Self = TypeVar("Self", bound="EnumWithSelectedValue_RollerBearingProfileTypes")


__docformat__ = "restructuredtext en"
__all__ = ("EnumWithSelectedValue_RollerBearingProfileTypes",)


class EnumWithSelectedValue_RollerBearingProfileTypes(
    mixins.EnumWithSelectedValueMixin, Enum
):
    """EnumWithSelectedValue_RollerBearingProfileTypes

    A specific implementation of 'EnumWithSelectedValue' for 'RollerBearingProfileTypes' types.
    """

    __qualname__ = "RollerBearingProfileTypes"

    @classmethod
    def wrapper_type(
        cls: "Type[EnumWithSelectedValue_RollerBearingProfileTypes]",
    ) -> "Any":
        """Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _ENUM_WITH_SELECTED_VALUE

    @classmethod
    def wrapped_type(
        cls: "Type[EnumWithSelectedValue_RollerBearingProfileTypes]",
    ) -> "_1944.RollerBearingProfileTypes":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly

        Returns:
            _1944.RollerBearingProfileTypes
        """
        return _1944.RollerBearingProfileTypes

    @classmethod
    def implicit_type(
        cls: "Type[EnumWithSelectedValue_RollerBearingProfileTypes]",
    ) -> "Any":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _1944.RollerBearingProfileTypes.type_()

    @property
    def selected_value(self: "Self") -> "_1944.RollerBearingProfileTypes":
        """mastapy._private.bearings.RollerBearingProfileTypes

        Note:
            This property is readonly.
        """
        return None

    @property
    def available_values(self: "Self") -> "List[_1944.RollerBearingProfileTypes]":
        """List[mastapy._private.bearings.RollerBearingProfileTypes]

        Note:
            This property is readonly.
        """
        return None
