"""Implementations of 'Overridable' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""
from __future__ import annotations

from enum import Enum
from typing import TYPE_CHECKING

from mastapy._private.materials import _264
from mastapy._private._internal import mixins
from mastapy._private._internal.python_net import python_net_import

_OVERRIDABLE = python_net_import("SMT.MastaAPI.Utility.Property", "Overridable")

if TYPE_CHECKING:
    from typing import Type, Any, TypeVar

    Self = TypeVar("Self", bound="Overridable_CylindricalGearRatingMethods")


__docformat__ = "restructuredtext en"
__all__ = ("Overridable_CylindricalGearRatingMethods",)


class Overridable_CylindricalGearRatingMethods(mixins.OverridableMixin, Enum):
    """Overridable_CylindricalGearRatingMethods

    A specific implementation of 'Overridable' for 'CylindricalGearRatingMethods' types.
    """

    __qualname__ = "CylindricalGearRatingMethods"

    @classmethod
    def wrapper_type(cls: "Type[Overridable_CylindricalGearRatingMethods]") -> "Any":
        """Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _OVERRIDABLE

    @classmethod
    def wrapped_type(
        cls: "Type[Overridable_CylindricalGearRatingMethods]",
    ) -> "_264.CylindricalGearRatingMethods":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly

        Returns:
            _264.CylindricalGearRatingMethods
        """
        return _264.CylindricalGearRatingMethods

    @classmethod
    def implicit_type(cls: "Type[Overridable_CylindricalGearRatingMethods]") -> "Any":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.

        Returns:
            Any
        """
        return _264.CylindricalGearRatingMethods.type_()

    @property
    def value(self: "Self") -> "_264.CylindricalGearRatingMethods":
        """mastapy._private.materials.CylindricalGearRatingMethods

        Note:
            This property is readonly.
        """
        return None

    @property
    def overridden(self: "Self") -> "bool":
        """bool

        Note:
            This property is readonly.
        """
        return None

    @property
    def override_value(self: "Self") -> "_264.CylindricalGearRatingMethods":
        """mastapy._private.materials.CylindricalGearRatingMethods

        Note:
            This property is readonly.
        """
        return None

    @property
    def calculated_value(self: "Self") -> "_264.CylindricalGearRatingMethods":
        """mastapy._private.materials.CylindricalGearRatingMethods

        Note:
            This property is readonly.
        """
        return None
