"""DummyRollingBearing"""
from __future__ import annotations

from typing import TYPE_CHECKING, ClassVar

from mastapy._private._internal.dataclasses import extended_dataclass
from mastapy._private._internal.type_enforcement import enforce_parameter_types
from mastapy._private._internal.python_net import (
    pythonnet_property_get,
    pythonnet_property_set,
    python_net_import,
)
from mastapy._private._internal import utility
from mastapy._private.bearings.bearing_designs import _2184
from mastapy._private._internal.cast_exception import CastException

_DUMMY_ROLLING_BEARING = python_net_import(
    "SMT.MastaAPI.Bearings.BearingDesigns", "DummyRollingBearing"
)

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="DummyRollingBearing")
    CastSelf = TypeVar(
        "CastSelf", bound="DummyRollingBearing._Cast_DummyRollingBearing"
    )


__docformat__ = "restructuredtext en"
__all__ = ("DummyRollingBearing",)


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class _Cast_DummyRollingBearing:
    """Special nested class for casting DummyRollingBearing to subclasses."""

    __parent__: "DummyRollingBearing"

    @property
    def bearing_design(self: "CastSelf") -> "_2184.BearingDesign":
        return self.__parent__._cast(_2184.BearingDesign)

    @property
    def dummy_rolling_bearing(self: "CastSelf") -> "DummyRollingBearing":
        return self.__parent__

    def __getattr__(self: "CastSelf", name: str) -> "Any":
        try:
            return self.__getattribute__(name)
        except AttributeError:
            class_name = utility.camel(name)
            raise CastException(
                f'Detected an invalid cast. Cannot cast to type "{class_name}"'
            ) from None


@extended_dataclass(frozen=True, slots=True, weakref_slot=True)
class DummyRollingBearing(_2184.BearingDesign):
    """DummyRollingBearing

    This is a mastapy class.
    """

    TYPE: ClassVar["Type"] = _DUMMY_ROLLING_BEARING

    wrapped: "Any"

    def __post_init__(self: "Self") -> None:
        """Override of the post initialisation magic method."""
        if not hasattr(self.wrapped, "reference_count"):
            self.wrapped.reference_count = 0

        self.wrapped.reference_count += 1

    @property
    def bore(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "Bore")

        if temp is None:
            return 0.0

        return temp

    @bore.setter
    @enforce_parameter_types
    def bore(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped, "Bore", float(value) if value is not None else 0.0
        )

    @property
    def outer_diameter(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "OuterDiameter")

        if temp is None:
            return 0.0

        return temp

    @outer_diameter.setter
    @enforce_parameter_types
    def outer_diameter(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped, "OuterDiameter", float(value) if value is not None else 0.0
        )

    @property
    def width(self: "Self") -> "float":
        """float"""
        temp = pythonnet_property_get(self.wrapped, "Width")

        if temp is None:
            return 0.0

        return temp

    @width.setter
    @enforce_parameter_types
    def width(self: "Self", value: "float") -> None:
        pythonnet_property_set(
            self.wrapped, "Width", float(value) if value is not None else 0.0
        )

    @property
    def cast_to(self: "Self") -> "_Cast_DummyRollingBearing":
        """Cast to another type.

        Returns:
            _Cast_DummyRollingBearing
        """
        return _Cast_DummyRollingBearing(self)
