"""QualityGradeTypes"""
from __future__ import annotations

from typing import TYPE_CHECKING
from enum import Enum

from mastapy._private._internal.python_net import python_net_import

_QUALITY_GRADE_TYPES = python_net_import("SMT.MastaAPI.Gears", "QualityGradeTypes")

if TYPE_CHECKING:
    from typing import Any, Type, TypeVar

    Self = TypeVar("Self", bound="QualityGradeTypes")
    CastSelf = TypeVar("CastSelf", bound="QualityGradeTypes._Cast_QualityGradeTypes")


__docformat__ = "restructuredtext en"
__all__ = ("QualityGradeTypes",)


class QualityGradeTypes(Enum):
    """QualityGradeTypes

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls) -> "Type":
        return _QUALITY_GRADE_TYPES

    AGMA_NEW = 0
    AGMA_OLD = 1


def __enum_setattr(self: "Self", attr: str, value: "Any") -> None:
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: "Self", attr: str) -> None:
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


QualityGradeTypes.__setattr__ = __enum_setattr
QualityGradeTypes.__delattr__ = __enum_delattr
